      *****************************************************************         
      **   CPD00077                                                  **         
      *****************************************************************         
      *****************************************************************         
      ** THIS COPYBOOK IS USED BY ON-LINE AND BATCH, AND IN          **         
      ** ORDER TO USE IT, YOUR PROGRAM MUST USE A SPECIAL ABEND      **         
      ** ROUTINE, INCLUDE CERTAIN DB2 TABLES AND HAVE SPECIFIC FIELDS**         
      ** POPULATED PRIOR TO PERFORMING THIS ROUTINE.  SEE THE SECTION**         
      ** LABELED REQUIRED FIELDS AND TABLES.                         **         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **              --------------------------                     **         
      **    DATE    INITIALS   REASON                                **         
      **  --------  --------   ------                                **         
      **  10/21/13  MC95456  COPYBOOK ORIGINALLY WRITTEN.            **         
ACT083**  04/08/15  MC95456  PROGRAM TO HIT DB2 FOR RESP AREA WHEN   **         
ACT083**   APPL5136-ACT083   NOT FOUND IN BATCH CALL.                **         
      *****************************************************************         
      *                                                                         
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE CURSORS FOR RETRIEVING USER      **        
      **  TABLES DATA.                                                **        
      ******************************************************************        
           EXEC SQL                                                     
                DECLARE AREA_LOC_OFF CURSOR WITH ROWSET POSITIONING FOR 
                 SELECT AO.COMPANY_NO                                   
                       ,AO.RESP_AREA_ID                                 
                       ,AO.LOCAL_OFFICE                                 
                       ,AC.CATEGORY_ID                                  
                   FROM CSS_AREA_LOC_OFF AO WITH(READUNCOMMITTED)               
                       ,CSS_WQ_AREA_CAT  AC WITH(READUNCOMMITTED)               
                  WHERE AO.RESP_AREA_ID = AC.RESP_AREA_ID               
                    AND AO.COMPANY_NO   = AC.COMPANY_NO                 
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE AREA_LOC_OFF CURSOR WITH ROWSET POSITIONING FOR         
MFA-TR*          SELECT AO.COMPANY_NO                                           
MFA-TR*                ,AO.RESP_AREA_ID                                         
MFA-TR*                ,AO.LOCAL_OFFICE                                         
MFA-TR*                ,AC.CATEGORY_ID                                          
MFA-TR*            FROM CSS_AREA_LOC_OFF AO                                     
MFA-TR*                ,CSS_WQ_AREA_CAT  AC                                     
MFA-TR*           WHERE AO.RESP_AREA_ID = AC.RESP_AREA_ID                       
MFA-TR*             AND AO.COMPANY_NO   = AC.COMPANY_NO                         
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
                DECLARE WQ_AREA_CAT CURSOR WITH ROWSET POSITIONING FOR  
                 SELECT AC.COMPANY_NO                                   
                       ,AC.CATEGORY_ID                                  
                       ,AC.RESP_AREA_ID                                 
                   FROM CSS_WQ_AREA_CAT AC WITH(READUNCOMMITTED)                
                       ,CSS_RESP_AREA   RA WITH(READUNCOMMITTED)                
                  WHERE AC.RESP_AREA_ID = RA.RESP_AREA_ID               
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE WQ_AREA_CAT CURSOR WITH ROWSET POSITIONING FOR          
MFA-TR*          SELECT AC.COMPANY_NO                                           
MFA-TR*                ,AC.CATEGORY_ID                                          
MFA-TR*                ,AC.RESP_AREA_ID                                         
MFA-TR*            FROM CSS_WQ_AREA_CAT AC                                      
MFA-TR*                ,CSS_RESP_AREA   RA                                      
MFA-TR*           WHERE AC.RESP_AREA_ID = RA.RESP_AREA_ID                       
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
                DECLARE WQ_CATEGORY CURSOR WITH ROWSET POSITIONING FOR  
                 SELECT WQ.CATEGORY_ID                                  
                       ,WQ.ROUTING_CATEGORY                             
                   FROM CSS_WQ_CATEGORY WQ WITH(READUNCOMMITTED)                
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE WQ_CATEGORY CURSOR WITH ROWSET POSITIONING FOR          
MFA-TR*          SELECT WQ.CATEGORY_ID                                          
MFA-TR*                ,WQ.ROUTING_CATEGORY                                     
MFA-TR*            FROM CSS_WQ_CATEGORY WQ                                      
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  0100-MAIN-PROCESS.                                          **        
      ******************************************************************        
      *                                                                         
       0100-MAIN-PROCESS.                                               
      *                                                                         
           IF BATCH-CALL AND FIRST-CALL                                 
              PERFORM 0500-LOAD-USER-TABLES  THRU 0500-EXIT             
              MOVE    'N'                    TO   WS-FIRST-CALL         
           END-IF.                                                      
                                                                        
           PERFORM 1000-PROCESS-INPUT        THRU 1000-EXIT.            
                                                                        
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
      *                                                                         
       0100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03270000
      * 0500-LOAD-USER-TABLES.                                         *03280000
      ******************************************************************03320000
       0500-LOAD-USER-TABLES.                                           
      *                                                                         
            MOVE '0500'                      TO ACTIVE-PARAGRAPH.       
      *                                                                         
            PERFORM 7000-OPEN-AREA-LOC-OFF   THRU 7000-EXIT.            
            PERFORM 7010-FETCH-AREA-LOC-OFF  THRU 7010-EXIT.            
            PERFORM 7020-CLOSE-AREA-LOC-OFF  THRU 7020-EXIT.            
      *                                                                         
            PERFORM 7100-OPEN-WQ-AREA-CAT    THRU 7100-EXIT.            
            PERFORM 7110-FETCH-WQ-AREA-CAT   THRU 7110-EXIT.            
            PERFORM 7120-CLOSE-WQ-AREA-CAT   THRU 7120-EXIT.            
      *                                                                         
            PERFORM 7200-OPEN-WQ-CATEGORY    THRU 7200-EXIT.            
            PERFORM 7210-FETCH-WQ-CATEGORY   THRU 7210-EXIT.            
            PERFORM 7220-CLOSE-WQ-CATEGORY   THRU 7220-EXIT.            
      *                                                                         
       0500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************03320000
      * 1000-PROCESS-INPUT.                                            *03280000
      *     1. VALIDATES AND PROCESS THE INPUTS.                       *03300000
      ******************************************************************03320000
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                        TO ACTIVE-PARAGRAPH.      
      *                                                                         
           INITIALIZE LS-CWS077-RETURN-FIELDS.                          
           INITIALIZE WS-CUSTOMER-NO                                    
                      WS-COMPANY-NO.                                    
           INITIALIZE WS-DATE-REQ-LEN.                                  
                                                                        
           IF WS-77-CATEGORY-ID   < 0                                   
              MOVE 0                          TO WS-CATEGORY-ID         
           ELSE                                                         
              MOVE WS-77-CATEGORY-ID          TO WS-CATEGORY-ID         
           END-IF.                                                      
           IF WS-77-SERV-ORDER-NO NOT NUMERIC                           
              MOVE 0                          TO WS-77-SERV-ORDER-NO    
           END-IF.                                                      
           IF WS-77-CUSTOMER-NO   NOT NUMERIC                           
              MOVE 0                          TO WS-77-CUSTOMER-NO      
           END-IF.                                                      
           IF WS-77-PREMISE-NO    NOT NUMERIC                           
              MOVE 0                          TO WS-77-PREMISE-NO       
           END-IF.                                                      
           IF WS-77-ACCOUNT-NO    NOT NUMERIC                           
              MOVE 0                          TO WS-77-ACCOUNT-NO       
           END-IF.                                                      
           IF WS-77-USER-ID-ORIG  EQUAL SPACES                          
              MOVE 'SYSTEM'                   TO WS-77-USER-ID-ORIG     
           END-IF.                                                      
                                                                        
           PERFORM 7300-GET-TIMESTAMP         THRU 7300-EXIT.           
      *                                                                         
           PERFORM 1100-CONVERT-TIMESTAMP-REQ THRU 1100-EXIT.           
                                                                        
      *                                                                         
           IF WS-77-DATE-CREATED <= SPACES                              
              MOVE WS-CURR-TIMESTAMP          TO WS-77-DATE-CREATED     
           END-IF.                                                      
      *                                                                         
           IF WS-77-ACCOUNT-NO > 0                                      
              MOVE  WS-77-ACCOUNT-NO             TO AT-ACCOUNT-NO       
              PERFORM 7500-SELECT-ACCOUNT        THRU 7500-EXIT         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE AT-CUSTOMER-NO             TO WS-CUSTOMER-NO      
                 MOVE AT-PREMISE-NO              TO WS-77-PREMISE-NO    
                 MOVE AT-COMPANY-NO              TO WS-COMPANY-NO       
                 MOVE AT-LOCAL-OFFICE            TO WS-77-LOCAL-OFFICE  
              ELSE                                                      
                 MOVE WS-77-ACCOUNT-NO           TO HA-ACCOUNT-NO       
                 PERFORM 7550-SELECT-HST-ACCOUNT THRU 7550-EXIT         
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE HA-CUSTOMER-NO          TO WS-CUSTOMER-NO      
                    MOVE HA-PREMISE-NO           TO WS-77-PREMISE-NO    
                    MOVE HA-COMPANY-NO           TO WS-COMPANY-NO       
                    MOVE HA-LOCAL-OFFICE         TO WS-77-LOCAL-OFFICE  
                 END-IF                                                 
              END-IF                                                    
              IF WS-77-CUSTOMER-NO > 0 AND                              
                 WS-77-CUSTOMER-NO NOT EQUAL WS-CUSTOMER-NO             
                 MOVE PROGRAM-NAME               TO ABEND-PROGRAM       
                 MOVE 'INPUT VALIDATION'         TO ABEND-FUNCTION      
                 MOVE 'RECEIVED CUSTOMER-NO'     TO TABLE-ELEMENT-1     
                 MOVE WS-77-CUSTOMER-NO          TO HOSTVAR-ELEMENT-1   
                 MOVE 'CORRECT CUSTOMER NO'      TO TABLE-ELEMENT-2     
                 MOVE WS-CUSTOMER-NO             TO HOSTVAR-ELEMENT-2   
                 PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
              ELSE                                                      
                 MOVE WS-CUSTOMER-NO             TO WS-77-CUSTOMER-NO   
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-COMPANY-NO = SPACES  AND WS-77-CUSTOMER-NO > 0         
              MOVE WS-77-CUSTOMER-NO             TO HT-CUSTOMER-NO      
              PERFORM 7560-SELECT-COMPANY-NO     THRU 7560-EXIT         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE HT-COMPANY-NO              TO WS-COMPANY-NO       
              END-IF                                                    
           END-IF.                                                      
           IF WS-COMPANY-NO = SPACES  AND WS-77-PREMISE-NO > 0          
              MOVE WS-77-PREMISE-NO              TO PR-PREMISE-NO       
              PERFORM 7565-SELECT-COMPANY-NO     THRU 7565-EXIT         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE    PR-COMPANY-NO           TO WS-COMPANY-NO       
              END-IF                                                    
           END-IF.                                                      
           IF WS-COMPANY-NO = SPACES                                    
              MOVE WS-77-USER-ID-ORIG            TO PF-USER-ID          
              PERFORM 7570-SELECT-COMPANY-NO     THRU 7570-EXIT         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE PF-COMPANY-NO              TO WS-COMPANY-NO       
              ELSE                                                      
                 MOVE '01'                       TO WS-COMPANY-NO       
              END-IF                                                    
           END-IF.                                                      
                                                                        
      *                                                                         
           EVALUATE WS-77-ROUTE-CATEGORY                                
            WHEN '2'                                                    
            WHEN '3'                                                    
                 CONTINUE                                               
            WHEN OTHER                                                  
                 IF BATCH-CALL                                          
                    PERFORM 1200-SEARCH-ROUTE-CAT THRU 1200-EXIT        
                 ELSE                                                   
                    MOVE WS-CATEGORY-ID           TO C3-CATEGORY-ID     
                    PERFORM 7600-SELECT-ROUTE-CAT THRU 7600-EXIT        
                    MOVE C3-ROUTING-CATEGORY   TO WS-ROUTE-CATEGORY     
                 END-IF                                                 
                 IF WS-ROUTE-CATEGORY > SPACES                          
                    MOVE WS-ROUTE-CATEGORY     TO WS-77-ROUTE-CATEGORY  
                 END-IF                                                 
                 IF WS-77-ROUTE-CATEGORY = SPACES                       
                    MOVE '3'                   TO WS-77-ROUTE-CATEGORY  
                 END-IF                                                 
           END-EVALUATE.                                                
      *                                                                         
           EVALUATE WS-77-ROUTE-CATEGORY                                
            WHEN '1'                                                    
              PERFORM 1300-GET-RESP-AREA-ID   THRU 1300-EXIT            
            WHEN '2'                                                    
              MOVE    WS-77-RESP-AREA-ID      TO WS-RESP-AREA-ID        
            WHEN '3'                                                    
              MOVE    SPACES                  TO PF-WQ-RECIPIENT-IND    
              PERFORM 7700-GET-RESP-AREA-ID   THRU 7700-EXIT            
            WHEN '4'                                                    
              PERFORM 1400-GET-RESP-AREA-ID   THRU 1400-EXIT            
            WHEN '5'                                                    
              PERFORM 1500-GET-RESP-AREA-ID   THRU 1500-EXIT            
            WHEN OTHER                                                  
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'EVALUATE ROUTE_CAT'       TO ABEND-FUNCTION         
              MOVE 'ACCOUNT-NO'               TO TABLE-ELEMENT-1        
              MOVE WS-77-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1      
              MOVE 'ROUTE_CATEGORY'           TO TABLE-ELEMENT-2        
              MOVE WS-77-ROUTE-CATEGORY       TO HOSTVAR-ELEMENT-2      
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-EVALUATE.                                                
      *                                                                         
           IF WS-RESP-AREA-ID = SPACES                                  
              MOVE 'WQ1'                      TO WS-77-RESP-AREA-ID     
           ELSE                                                         
              MOVE WS-RESP-AREA-ID            TO WS-77-RESP-AREA-ID     
           END-IF.                                                      
      *                                                                         
           IF WS-77-USER-ID-ASGN = SPACES                               
              PERFORM 7750-GET-USER-ID-ASGN   THRU 7750-EXIT            
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE WS-77-RESP-AREA-ID          TO C1-RESP-AREA-ID    
                 PERFORM 7760-SELECT-USER-ID-ASGN THRU 7760-EXIT        
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    MOVE 'WQ09999'                TO WS-77-USER-ID-ASGN 
                 ELSE                                                   
                    MOVE C1-USER-ID               TO WS-77-USER-ID-ASGN 
                 END-IF                                                 
              ELSE                                                      
                 MOVE WS-USER-ID-ASGN             TO WS-77-USER-ID-ASGN 
              END-IF                                                    
           ELSE                                                         
              IF WS-77-ROUTE-CATEGORY = '3' AND                         
                 PF-WQ-RECIPIENT-IND  = 'N'                             
                 MOVE WS-77-RESP-AREA-ID          TO C1-RESP-AREA-ID    
                 PERFORM 7760-SELECT-USER-ID-ASGN THRU 7760-EXIT        
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    MOVE 'WQ09999'                TO WS-77-USER-ID-ASGN 
                 ELSE                                                   
                    MOVE C1-USER-ID               TO WS-77-USER-ID-ASGN 
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-CATEGORY-ID EQUAL 0167 OR 0205 OR 0206                 
              OR (WS-CATEGORY-ID EQUAL 0122 AND                         
                                               WS-COMPANY-NO = '26')    
              MOVE 'C'                            TO WS-STATUS          
              MOVE 'SYSTEM'                       TO WS-77-USER-ID-ASGN 
              MOVE WS-CURR-TIMESTAMP              TO WS-COMPLETE-DATE   
           ELSE                                                         
              MOVE 'A'                            TO WS-STATUS          
              MOVE ' '                            TO WS-COMPLETE-DATE   
           END-IF.                                                      
      *                                                                         
           PERFORM 7800-GET-NEW-ITEM-ID           THRU 7800-EXIT.       
      *                                                                         
       1000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************04890000
      * 1100-CONVERT-TIMESTAMP-REQ.                                    *04900000
      ******************************************************************04890000
        1100-CONVERT-TIMESTAMP-REQ.                                     
      *                                                                         
           MOVE '1100'                          TO ACTIVE-PARAGRAPH.    
      *                                                                         
                                                                        
           IF WS-77-DATE-REQUIRED > SPACES                              
              INSPECT WS-77-DATE-REQUIRED TALLYING WS-DATE-REQ-LEN      
                      FOR CHARACTERS BEFORE INITIAL ' '                 
              IF WS-DATE-REQ-LEN < 26                                   
                 MOVE WS-77-DATE-REQUIRED(1:10) TO WS-DATE-REQUIRED     
                 PERFORM 7350-SET-TIMESTAMP-REQ THRU 7350-EXIT          
                 MOVE WS-FORMAT-TIMESTAMP       TO WS-77-DATE-REQUIRED  
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-77-DATE-REQUIRED = SPACES OR                           
                    WS-77-DATE-REQUIRED < WS-CURR-TIMESTAMP             
              MOVE WS-CATEGORY-ID               TO C3-CATEGORY-ID       
              PERFORM 7400-SELECT-TS-REQ        THRU 7400-EXIT          
              MOVE WS-FORMAT-TIMESTAMP          TO WS-77-DATE-REQUIRED  
           END-IF.                                                      
      *                                                                         
       1100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************04890000
      * 1200-SEARCH-ROUTE-CAT.                                         *04900000
      ******************************************************************04890000
        1200-SEARCH-ROUTE-CAT.                                          
      *                                                                         
           MOVE '1200'                         TO ACTIVE-PARAGRAPH.     
      *                                                                         
           MOVE SPACES                         TO WS-ROUTE-CATEGORY     
           MOVE 'N'                            TO WS-MATCH-FOUND.       
           PERFORM VARYING WS-ROUTE-SUB FROM 1 BY 1                     
              UNTIL WS-ROUTE-SUB IS GREATER THAN WS-WQ-ROUTE-COUNT      
                 OR MATCH-IS-FOUND                                      
               IF WS-WR-CATEGORY-ID(WS-ROUTE-SUB)  = WS-CATEGORY-ID     
                  MOVE 'Y'                     TO WS-MATCH-FOUND        
                  MOVE WS-WR-ROUTING-CAT(WS-ROUTE-SUB)                  
                                               TO WS-ROUTE-CATEGORY     
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
ACT083     IF WS-MATCH-FOUND = 'N'  AND WS-WQ-ROUTE-COUNT = 600         
ACT083        MOVE WS-CATEGORY-ID              TO C3-CATEGORY-ID        
ACT083        PERFORM 7600-SELECT-ROUTE-CAT    THRU 7600-EXIT           
ACT083        MOVE C3-ROUTING-CATEGORY         TO WS-ROUTE-CATEGORY     
ACT083     END-IF.                                                      
      *                                                                         
        1200-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
      ******************************************************************04890000
      * 1300-GET-RESP-AREA-ID.                                         *04900000
      ******************************************************************04890000
        1300-GET-RESP-AREA-ID.                                          
      *                                                                         
                                                                        
           MOVE '1300'                            TO ACTIVE-PARAGRAPH.  
                                                                        
           IF BATCH-CALL                                                
              PERFORM 1310-SEARCH-RESP-AREA-ID    THRU 1310-EXIT        
           ELSE                                                         
              PERFORM 7710-GET-RESP-AREA-ID       THRU 7710-EXIT        
           END-IF.                                                      
      *                                                                         
        1300-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
      ******************************************************************04890000
      * 1310-SEARCH-RESP-AREA-ID.                                      *04900000
      ******************************************************************04890000
        1310-SEARCH-RESP-AREA-ID.                                       
      *                                                                         
           MOVE '1310'                         TO ACTIVE-PARAGRAPH.     
      *                                                                         
           MOVE SPACES                         TO WS-RESP-AREA-ID.      
           MOVE 'N'                            TO WS-MATCH-FOUND.       
           PERFORM VARYING WS-LOC-SUB FROM 1 BY 1                       
              UNTIL WS-LOC-SUB IS GREATER THAN WS-AREA-LOC-COUNT        
                 OR MATCH-IS-FOUND                                      
               IF WS-AO-COMPANY-NO(WS-LOC-SUB)   = WS-COMPANY-NO AND    
                  WS-AO-LOCAL-OFFICE(WS-LOC-SUB) =                      
                                              WS-77-LOCAL-OFFICE AND    
                  WS-AO-CATEGORY-ID(WS-LOC-SUB)  = WS-CATEGORY-ID       
                  MOVE 'Y'                     TO WS-MATCH-FOUND        
                  MOVE WS-AO-RESP-AREA-ID(WS-LOC-SUB)                   
                                               TO WS-RESP-AREA-ID       
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
ACT083     IF WS-MATCH-FOUND = 'N' AND WS-AREA-LOC-COUNT = 15000        
ACT083        PERFORM 7710-GET-RESP-AREA-ID       THRU 7710-EXIT        
ACT083     END-IF.                                                      
      *                                                                         
        1310-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
      ******************************************************************04890000
      * 1400-GET-RESP-AREA-ID.                                         *04900000
      ******************************************************************04890000
        1400-GET-RESP-AREA-ID.                                          
      *                                                                         
           MOVE '1400'                            TO ACTIVE-PARAGRAPH.  
      *                                                                         
                                                                        
           IF BATCH-CALL                                                
              PERFORM 1410-SEARCH-RESP-AREA-ID    THRU 1410-EXIT        
           ELSE                                                         
              PERFORM 7720-GET-RESP-AREA-ID       THRU 7720-EXIT        
           END-IF.                                                      
      *                                                                         
        1400-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
      ******************************************************************04890000
      * 1410-SEARCH-RESP-AREA-ID.                                      *04900000
      ******************************************************************04890000
        1410-SEARCH-RESP-AREA-ID.                                       
      *                                                                         
           MOVE '1410'                            TO ACTIVE-PARAGRAPH.  
      *                                                                         
           MOVE SPACES                            TO WS-RESP-AREA-ID.   
           MOVE 'N'                               TO WS-MATCH-FOUND.    
           PERFORM VARYING WS-AREA-SUB FROM 1 BY 1                      
              UNTIL WS-AREA-SUB IS GREATER THAN WS-WQ-AREA-COUNT        
                 OR MATCH-IS-FOUND                                      
               IF WS-WA-CATEGORY-ID(WS-AREA-SUB)  = WS-CATEGORY-ID      
                  MOVE 'Y'                        TO WS-MATCH-FOUND     
                  MOVE WS-WA-RESP-AREA-ID(WS-AREA-SUB)                  
                                                  TO WS-RESP-AREA-ID    
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
ACT083     IF WS-MATCH-FOUND = 'N' AND WS-WQ-AREA-COUNT = 2000          
ACT083        PERFORM 7720-GET-RESP-AREA-ID       THRU 7720-EXIT        
ACT083     END-IF.                                                      
      *                                                                         
        1410-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
      ******************************************************************04890000
      * 1500-GET-RESP-AREA-ID.                                         *04900000
      ******************************************************************04890000
        1500-GET-RESP-AREA-ID.                                          
      *                                                                         
           MOVE '1500'                            TO ACTIVE-PARAGRAPH.  
      *                                                                         
                                                                        
           IF BATCH-CALL                                                
              PERFORM 1510-SEARCH-RESP-AREA-ID    THRU 1510-EXIT        
           ELSE                                                         
              PERFORM 7730-GET-RESP-AREA-ID       THRU 7730-EXIT        
           END-IF.                                                      
      *                                                                         
        1500-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
      ******************************************************************04890000
      * 1510-SEARCH-RESP-AREA-ID.                                      *04900000
      ******************************************************************04890000
        1510-SEARCH-RESP-AREA-ID.                                       
      *                                                                         
           MOVE '1510'                            TO ACTIVE-PARAGRAPH.  
      *                                                                         
           MOVE SPACES                            TO WS-RESP-AREA-ID.   
           MOVE 'N'                               TO WS-MATCH-FOUND.    
           PERFORM VARYING WS-AREA-SUB FROM 1 BY 1                      
              UNTIL WS-AREA-SUB IS GREATER THAN WS-WQ-AREA-COUNT        
                 OR MATCH-IS-FOUND                                      
               IF WS-WA-CATEGORY-ID(WS-AREA-SUB)  = WS-CATEGORY-ID AND  
                  WS-WA-COMPANY-NO(WS-AREA-SUB)   = WS-COMPANY-NO       
                  MOVE 'Y'                        TO WS-MATCH-FOUND     
                  MOVE WS-WA-RESP-AREA-ID(WS-AREA-SUB)                  
                                                  TO WS-RESP-AREA-ID    
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
ACT083     IF WS-MATCH-FOUND = 'N' AND WS-WQ-AREA-COUNT = 2000          
ACT083        PERFORM 7730-GET-RESP-AREA-ID       THRU 7730-EXIT        
ACT083     END-IF.                                                      
      *                                                                         
        1510-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
      ******************************************************************04890000
      * 2000-PROCESS-OUTPUT.                                           *04900000
      ******************************************************************04950000
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                         TO ACTIVE-PARAGRAPH.     
      *                                                                         
           MOVE WQ-ITEM-ID                     TO WS-77-WQ-ITEM-ID.     
           MOVE WS-77-ACCOUNT-NO               TO WQ-ACCOUNT-NO.        
           MOVE WS-77-PREMISE-NO               TO WQ-PREMISE-NO.        
           MOVE WS-77-CUSTOMER-NO              TO WQ-CUSTOMER-NO.       
           MOVE WS-COMPANY-NO                  TO WQ-COMPANY-NO.        
           MOVE WS-77-SERV-ORDER-NO            TO WQ-SERV-ORDER-NO.     
           MOVE WS-STATUS                      TO WQ-STATUS.            
           MOVE WS-77-USER-ID-ORIG             TO WQ-USER-ID-ORIG.      
           MOVE WS-77-USER-ID-ASGN             TO WQ-USER-ID-ASGN.      
           MOVE WS-77-RESP-AREA-ID             TO WQ-RESP-AREA-ID.      
           IF WS-COMPLETE-DATE > SPACES                                 
              MOVE  0                          TO WS-COMP-DATE-NULL     
           ELSE                                                         
              MOVE -1                          TO WS-COMP-DATE-NULL     
           END-IF.                                                      
           MOVE WS-COMPLETE-DATE               TO WQ-COMPLETE-DATE.     
           MOVE WS-CATEGORY-ID                 TO WQ-CATEGORY-ID.       
           MOVE WS-77-COMMENTS                 TO WQ-COMMENTS.          
           MOVE WS-77-DATE-REQUIRED            TO WQ-DATE-REQUIRED.     
           MOVE WS-77-DATE-CREATED             TO WQ-DATE-CREATED       
           MOVE WS-77-PRIORITY                 TO WQ-PRIORITY.          
           MOVE WS-77-FREE-FORM-AREA           TO WQ-FREE-FORM-AREA.    
           MOVE WS-77-CREATED-BY               TO WQ-CREATED-BY.        
      *                                                                 05370000
           PERFORM 8000-INSERT-WQ-ITEMS        THRU 8000-EXIT.          
      *                                                                 05370000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05370000
      ****************************************************************  12942500
      * 7000-OPEN-AREA-LOC-OFF.                                     **  12942200
      ****************************************************************  12942500
        7000-OPEN-AREA-LOC-OFF.                                         
      *                                                                 12942700
                                                                        
           EXEC SQL                                                     
                OPEN AREA_LOC_OFF                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12943300
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 12943500
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7000'                      TO ACTIVE-PARAGRAPH      
              MOVE 'OPEN'                      TO ABEND-FUNCTION        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 12944400
       7000-EXIT.                                                       
            EXIT.                                                       
      *                                                                 12944400
      ****************************************************************  12942500
      * 7010-FETCH-AREA-LOC-OFF.                                    **  12942200
      ****************************************************************  12942500
        7010-FETCH-AREA-LOC-OFF.                                        

MSQ008     MOVE 15000 TO MSQ008-AREA-LOC-OFF
      *                                                                 12942700
                                                                        
           EXEC SQL                                                     
                FOR :MSQ008-AREA-LOC-OFF
              FETCH 
              FROM AREA_LOC_OFF       
                INTO  :WS-AO-COMPANY-NO                                 
                     ,:WS-AO-RESP-AREA-ID                               
                     ,:WS-AO-LOCAL-OFFICE                               
                     ,:WS-AO-CATEGORY-ID                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                     12943000
MFA-TR*         FETCH NEXT ROWSET FROM AREA_LOC_OFF FOR 15000 ROWS      12943100
MFA-TR*         INTO  :WS-AO-COMPANY-NO                                         
MFA-TR*              ,:WS-AO-RESP-AREA-ID                                       
MFA-TR*              ,:WS-AO-LOCAL-OFFICE                                       
MFA-TR*              ,:WS-AO-CATEGORY-ID                                        
MFA-TR*    END-EXEC.                                                    12943200

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-AREA-LOC-OFF
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12943300
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 12943500
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SQLERRD(3)                  TO WS-AREA-LOC-COUNT     
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7010'                      TO ACTIVE-PARAGRAPH      
              MOVE 'FETCH'                     TO ABEND-FUNCTION        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 12944400
       7010-EXIT.                                                       
            EXIT.                                                       
      *                                                                 12942700
      ****************************************************************  12942500
      * 7020-CLOSE-AREA-LOC-OFF.                                    **  12942200
      ****************************************************************  12942500
        7020-CLOSE-AREA-LOC-OFF.                                        
      *                                                                 12942700
                                                                        
           EXEC SQL                                                     
                CLOSE AREA_LOC_OFF                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12943300
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 12943500
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7020'                      TO ACTIVE-PARAGRAPH      
              MOVE 'CLOSE'                     TO ABEND-FUNCTION        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 12944400
       7020-EXIT.                                                       
            EXIT.                                                       
      *                                                                 12942700
      ****************************************************************  12942500
      * 7100-OPEN-WQ-AREA-CAT.                                      **  12942200
      ****************************************************************  12942500
        7100-OPEN-WQ-AREA-CAT.                                          
      *                                                                 12942700
           EXEC SQL                                                     
                OPEN WQ_AREA_CAT                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12943300
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 12943500
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7100'                      TO ACTIVE-PARAGRAPH      
              MOVE 'OPEN'                      TO ABEND-FUNCTION        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 12944400
       7100-EXIT.                                                       
            EXIT.                                                       
      *                                                                 12942700
      ****************************************************************  12942500
      * 7110-FETCH-WQ-AREA-CAT.                                     **  12942200
      ****************************************************************  12942500
      *                                                                 12942700
        7110-FETCH-WQ-AREA-CAT.                                         

MSQ008     MOVE 2000 TO MSQ008-WQ-AREA-CAT
           EXEC SQL                                                     
                FOR :MSQ008-WQ-AREA-CAT
              FETCH 
              FROM WQ_AREA_CAT         
                INTO  :WS-WA-COMPANY-NO                                 
                     ,:WS-WA-CATEGORY-ID                                
                     ,:WS-WA-RESP-AREA-ID                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                     12943000
MFA-TR*         FETCH NEXT ROWSET FROM WQ_AREA_CAT FOR 2000 ROWS        12943100
MFA-TR*         INTO  :WS-WA-COMPANY-NO                                         
MFA-TR*              ,:WS-WA-CATEGORY-ID                                        
MFA-TR*              ,:WS-WA-RESP-AREA-ID                                       
MFA-TR*    END-EXEC.                                                    12943200

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-WQ-AREA-CAT
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12943300
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 12943500
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SQLERRD(3)                  TO WS-WQ-AREA-COUNT      
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7110'                      TO ACTIVE-PARAGRAPH      
              MOVE 'FETCH'                     TO ABEND-FUNCTION        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 12944400
       7110-EXIT.                                                       
            EXIT.                                                       
      *                                                                 12942700
      ****************************************************************  12942500
      * 7120-CLOSE-WQ-AREA-CAT.                                     **  12942200
      ****************************************************************  12942500
        7120-CLOSE-WQ-AREA-CAT.                                         
      *                                                                 12942700
           EXEC SQL                                                     
                CLOSE WQ_AREA_CAT                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12943300
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 12943500
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7120'                      TO ACTIVE-PARAGRAPH      
              MOVE 'CLOSE'                     TO ABEND-FUNCTION        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 12944400
       7120-EXIT.                                                       
            EXIT.                                                       
      *                                                                 12942700
      ****************************************************************  12942500
      * 7200-OPEN-WQ-CATEGORY.                                      **  12942200
      ****************************************************************  12942500
        7200-OPEN-WQ-CATEGORY.                                          
      *                                                                 12942700
                                                                        
           EXEC SQL                                                     
                OPEN WQ_CATEGORY                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12943300
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 12943500
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7200'                      TO ACTIVE-PARAGRAPH      
              MOVE 'OPEN'                      TO ABEND-FUNCTION        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 12944400
       7200-EXIT.                                                       
            EXIT.                                                       
      *                                                                 12942700
      ****************************************************************  12942500
      * 7210-FETCH-WQ-CATEGORY.                                     **  12942200
      ****************************************************************  12942500
        7210-FETCH-WQ-CATEGORY.                                         

MSQ008     MOVE 600 TO MSQ008-WQ-CATEGORY
      *                                                                 12942700
                                                                        
           EXEC SQL                                                     
                FOR :MSQ008-WQ-CATEGORY
              FETCH 
              FROM WQ_CATEGORY         
                INTO  :WS-WR-CATEGORY-ID                                
                     ,:WS-WR-ROUTING-CAT                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                     12943000
MFA-TR*         FETCH NEXT ROWSET FROM WQ_CATEGORY FOR 600  ROWS        12943100
MFA-TR*         INTO  :WS-WR-CATEGORY-ID                                        
MFA-TR*              ,:WS-WR-ROUTING-CAT                                        
MFA-TR*    END-EXEC.                                                    12943200

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-WQ-CATEGORY
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12943300
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 12943500
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SQLERRD(3)                  TO WS-WQ-ROUTE-COUNT     
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7210'                      TO ACTIVE-PARAGRAPH      
              MOVE 'FETCH'                     TO ABEND-FUNCTION        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 12944400
       7210-EXIT.                                                       
            EXIT.                                                       
      *                                                                 12942700
      ****************************************************************  12942500
      * 7220-CLOSE-WQ-CATEGORY.                                     **  12942200
      ****************************************************************  12942500
        7220-CLOSE-WQ-CATEGORY.                                         
      *                                                                 12942700
           EXEC SQL                                                     
                CLOSE WQ_CATEGORY                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12943300
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 12943500
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7220'                      TO ACTIVE-PARAGRAPH      
              MOVE 'CLOSE'                     TO ABEND-FUNCTION        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 12944400
       7220-EXIT.                                                       
            EXIT.                                                       
      *                                                                 12942700
      ****************************************************************  12942500
      *   7300-GET-TIMESTAMP.                                       **  12942200
      ****************************************************************  12942500
       7300-GET-TIMESTAMP.                                              
      *                                                                 12942700
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURR-TIMESTAMP              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     12943000
MFA-TR*         SET :WS-CURR-TIMESTAMP = CURRENT TIMESTAMP              12943100
MFA-TR*    END-EXEC.                                                    12943200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 12943300
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 12943500
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7300'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SET'                       TO ABEND-FUNCTION        
              MOVE 'WS-CURR-TIMESTAMP'         TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 12944400
       7300-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      * 7350-SET-TIMESTAMP-REQ.                                       *         
      *****************************************************************         
       7350-SET-TIMESTAMP-REQ.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CHAR2TIMESTAMP(
                                                     :WS-DATE-REQUIRED)
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-FORMAT-TIMESTAMP  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*        SET :WS-FORMAT-TIMESTAMP = TIMESTAMP(:WS-DATE-REQUIRED)  07458000
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7350'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SET'                       TO TABLE-1               
              MOVE 'WS-DATE-REQUIRED'          TO TABLE-ELEMENT-1       
              MOVE WS-DATE-REQUIRED            TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7400-SELECT-TS-REQ.                                           *         
      *****************************************************************         
       7400-SELECT-TS-REQ.                                              
      *                                                                         
           EXEC SQL                                                     
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( DAY, (
           WQ_TASK_EST_HOURS / 8), CIS.CURRENT$TIMESTAMP() ), 121), 
           ' ', '-'), ':', '.')  
                 INTO :WS-FORMAT-TIMESTAMP                              
                 FROM CSS_WQ_CATEGORY WITH(READUNCOMMITTED)                     
                WHERE CATEGORY_ID =  :C3-CATEGORY-ID                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*        SELECT (WQ_TASK_EST_HOURS / 8) DAYS + CURRENT TIMESTAMP  07458000
MFA-TR*          INTO :WS-FORMAT-TIMESTAMP                              07459000
MFA-TR*          FROM CSS_WQ_CATEGORY                                   07460000
MFA-TR*         WHERE CATEGORY_ID =  :C3-CATEGORY-ID                            
MFA-TR*       WITH UR                                                   07463100
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7400'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_WQ_CATEGORY'           TO TABLE-1               
              MOVE 'C3-CATEGORY-ID'            TO TABLE-ELEMENT-1       
              MOVE C3-CATEGORY-ID              TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7500-SELECT-ACCOUNT.                                          *         
      *****************************************************************         
       7500-SELECT-ACCOUNT.                                             
      *                                                                         
           EXEC SQL                                                     
               SELECT AT.CUSTOMER_NO                                    
                     ,AT.PREMISE_NO                                     
                     ,AT.COMPANY_NO                                     
                     ,AT.LOCAL_OFFICE                                   
                 INTO :AT-CUSTOMER-NO                                   
                     ,:AT-PREMISE-NO                                    
                     ,:AT-COMPANY-NO                                    
                     ,:AT-LOCAL-OFFICE                                  
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*        SELECT AT.CUSTOMER_NO                                    07458000
MFA-TR*              ,AT.PREMISE_NO                                             
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.LOCAL_OFFICE                                           
MFA-TR*          INTO :AT-CUSTOMER-NO                                   07459000
MFA-TR*              ,:AT-PREMISE-NO                                            
MFA-TR*              ,:AT-COMPANY-NO                                            
MFA-TR*              ,:AT-LOCAL-OFFICE                                          
MFA-TR*          FROM CSS_ACCOUNT AT                                    07460000
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       07461000
MFA-TR*       WITH UR                                                   07463100
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7500'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_ACCOUNT'               TO TABLE-1               
              MOVE 'AT-ACCOUNT-NO'             TO TABLE-ELEMENT-1       
              MOVE AT-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7550-SELECT-HST-ACCOUNT.                                      *         
      *****************************************************************         
       7550-SELECT-HST-ACCOUNT.                                         
      *                                                                         
           EXEC SQL                                                     
               SELECT HA.CUSTOMER_NO                                    
                     ,HA.PREMISE_NO                                     
                     ,HA.COMPANY_NO                                     
                     ,HA.LOCAL_OFFICE                                   
                 INTO :HA-CUSTOMER-NO                                   
                     ,:HA-PREMISE-NO                                    
                     ,:HA-COMPANY-NO                                    
                     ,:HA-LOCAL-OFFICE                                  
                 FROM HST_ACCOUNT HA WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO = :HA-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*        SELECT HA.CUSTOMER_NO                                    07458000
MFA-TR*              ,HA.PREMISE_NO                                             
MFA-TR*              ,HA.COMPANY_NO                                             
MFA-TR*              ,HA.LOCAL_OFFICE                                           
MFA-TR*          INTO :HA-CUSTOMER-NO                                   07459000
MFA-TR*              ,:HA-PREMISE-NO                                            
MFA-TR*              ,:HA-COMPANY-NO                                            
MFA-TR*              ,:HA-LOCAL-OFFICE                                          
MFA-TR*          FROM HST_ACCOUNT HA                                    07460000
MFA-TR*         WHERE ACCOUNT_NO = :HA-ACCOUNT-NO                       07461000
MFA-TR*       WITH UR                                                   07463100
MFA-TR*       QUERYNO 7550                                                      
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7550'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'HST_ACCOUNT'               TO TABLE-1               
              MOVE 'HA-ACCOUNT-NO'             TO TABLE-ELEMENT-1       
              MOVE HA-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7560-SELECT-COMPANY-NO.                                       *         
      *****************************************************************         
       7560-SELECT-COMPANY-NO.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) HT.COMPANY_NO                                     
                 INTO :HT-COMPANY-NO                                    
                 FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE HT.CUSTOMER_NO = :HT-CUSTOMER-NO                  
                  AND HT.CUSTOMER_ROLE_CD = ' '                         
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*        SELECT HT.COMPANY_NO                                     07458000
MFA-TR*          INTO :HT-COMPANY-NO                                    07459000
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT                             07460000
MFA-TR*         WHERE HT.CUSTOMER_NO = :HT-CUSTOMER-NO                  07461000
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       WITH UR                                                   07463100
MFA-TR*       QUERYNO 7560                                                      
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7560'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_NAME_ACCT_XREF'        TO TABLE-1               
              MOVE 'HT-CUSTOMER-NO'            TO TABLE-ELEMENT-1       
              MOVE HT-CUSTOMER-NO              TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
      *                                                                         
       7560-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7565-SELECT-COMPANY-NO.                                       *         
      *****************************************************************         
       7565-SELECT-COMPANY-NO.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT PR.COMPANY_NO                                     
                 INTO :PR-COMPANY-NO                                    
                 FROM CSS_PREMISE PR WITH(READUNCOMMITTED)                      
                WHERE PR.PREMISE_NO  = :PR-PREMISE-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*        SELECT PR.COMPANY_NO                                     07458000
MFA-TR*          INTO :PR-COMPANY-NO                                    07459000
MFA-TR*          FROM CSS_PREMISE PR                                    07460000
MFA-TR*         WHERE PR.PREMISE_NO  = :PR-PREMISE-NO                   07461000
MFA-TR*       WITH UR                                                   07463100
MFA-TR*       QUERYNO 7565                                                      
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7565'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_PREMISE'               TO TABLE-1               
              MOVE 'PR-PREMISE-NO'             TO TABLE-ELEMENT-1       
              MOVE PR-PREMISE-NO               TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
      *                                                                         
       7565-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7570-SELECT-COMPANY-NO.                                       *         
      *****************************************************************         
       7570-SELECT-COMPANY-NO.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT PF.COMPANY_NO                                     
                 INTO :PF-COMPANY-NO                                    
                 FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                 
                WHERE PF.USER_ID = :PF-USER-ID                          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*        SELECT PF.COMPANY_NO                                     07458000
MFA-TR*          INTO :PF-COMPANY-NO                                    07459000
MFA-TR*          FROM CSS_USER_PROFILE PF                               07460000
MFA-TR*         WHERE PF.USER_ID = :PF-USER-ID                          07461000
MFA-TR*       WITH UR                                                   07463100
MFA-TR*       QUERYNO 7570                                                      
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7570'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_USER_PROFILE'          TO TABLE-1               
              MOVE 'PF-USER-ID'                TO TABLE-ELEMENT-1       
              MOVE PF-USER-ID                  TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
      *                                                                         
       7570-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7600-SELECT-ROUTE-CAT.                                        *         
      *****************************************************************         
       7600-SELECT-ROUTE-CAT.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT ROUTING_CATEGORY                                  
                 INTO :C3-ROUTING-CATEGORY                              
                 FROM CSS_WQ_CATEGORY WITH(READUNCOMMITTED)                     
                WHERE CATEGORY_ID = :C3-CATEGORY-ID                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*        SELECT ROUTING_CATEGORY                                  07458000
MFA-TR*          INTO :C3-ROUTING-CATEGORY                              07459000
MFA-TR*          FROM CSS_WQ_CATEGORY                                   07460000
MFA-TR*         WHERE CATEGORY_ID = :C3-CATEGORY-ID                     07461000
MFA-TR*       WITH UR                                                   07463100
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7600'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_WQ_CATEGORY'           TO TABLE-1               
              MOVE 'C3-CATEGORY-ID'            TO TABLE-ELEMENT-1       
              MOVE C3-CATEGORY-ID              TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12950000
      *****************************************************************         
      * 7700-GET-RESP-AREA-ID.                                        *         
      *****************************************************************         
       7700-GET-RESP-AREA-ID.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT PF.RESP_AREA_ID                                   
                     ,PF.WQ_RECIPIENT_IND                               
                 INTO :WS-RESP-AREA-ID                                  
                     ,:PF-WQ-RECIPIENT-IND                              
                 FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                 
                WHERE PF.USER_ID = :WS-77-USER-ID-ASGN                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*        SELECT PF.RESP_AREA_ID                                   07458000
MFA-TR*              ,PF.WQ_RECIPIENT_IND                                       
MFA-TR*          INTO :WS-RESP-AREA-ID                                          
MFA-TR*              ,:PF-WQ-RECIPIENT-IND                                      
MFA-TR*          FROM CSS_USER_PROFILE PF                                       
MFA-TR*         WHERE PF.USER_ID = :WS-77-USER-ID-ASGN                  07461000
MFA-TR*       WITH UR                                                   07463100
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'WQ1'                       TO WS-RESP-AREA-ID    
                 MOVE 'WQ09999'                   TO WS-77-USER-ID-ASGN 
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE     
                 MOVE PROGRAM-NAME                TO ABEND-PROGRAM      
                 MOVE '7700'                      TO ACTIVE-PARAGRAPH   
                 MOVE 'SELECT'                    TO ABEND-FUNCTION     
                 MOVE 'CSS_USER_PROFILE'          TO TABLE-1            
                 MOVE 'USER-ID-ASGN'              TO TABLE-ELEMENT-1    
                 MOVE WS-77-USER-ID-ASGN          TO HOSTVAR-ELEMENT-1  
                 PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT        
           END-IF
           END-IF.                                                      
                                                                        
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12950000
      *****************************************************************         
      * 7710-GET-RESP-AREA-ID.                                        *         
      *****************************************************************         
       7710-GET-RESP-AREA-ID.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) AC.RESP_AREA_ID                                   
                 INTO :WS-RESP-AREA-ID                                  
                 FROM CSS_WQ_AREA_CAT  AC WITH(READUNCOMMITTED)                 
                     ,CSS_AREA_LOC_OFF AO WITH(READUNCOMMITTED)                 
                WHERE AC.RESP_AREA_ID = AO.RESP_AREA_ID                 
                  AND AC.CATEGORY_ID  = :WS-CATEGORY-ID                 
                  AND AO.LOCAL_OFFICE = :WS-77-LOCAL-OFFICE             
                  AND AC.COMPANY_NO   = AO.COMPANY_NO                   
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*        SELECT AC.RESP_AREA_ID                                   07458000
MFA-TR*          INTO :WS-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_WQ_AREA_CAT  AC                               07460000
MFA-TR*              ,CSS_AREA_LOC_OFF AO                                       
MFA-TR*         WHERE AC.RESP_AREA_ID = AO.RESP_AREA_ID                 07461000
MFA-TR*           AND AC.CATEGORY_ID  = :WS-CATEGORY-ID                         
MFA-TR*           AND AO.LOCAL_OFFICE = :WS-77-LOCAL-OFFICE                     
MFA-TR*           AND AC.COMPANY_NO   = AO.COMPANY_NO                           
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*       WITH UR                                                   07463100
MFA-TR*       QUERYNO 7710                                                      
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7710'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_WQ_AREA_CAT'           TO TABLE-1               
              MOVE 'CATEGORY_ID'               TO TABLE-ELEMENT-1       
              MOVE WS-CATEGORY-ID              TO HOSTVAR-ELEMENT-1     
              MOVE 'LOCAL OFFICE'              TO TABLE-ELEMENT-2       
              MOVE WS-77-LOCAL-OFFICE          TO HOSTVAR-ELEMENT-2     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
      *                                                                         
       7710-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12950000
      *****************************************************************         
      * 7720-GET-RESP-AREA-ID.                                        *         
      *****************************************************************         
       7720-GET-RESP-AREA-ID.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) AC.RESP_AREA_ID                                   
                 INTO :WS-RESP-AREA-ID                                  
                 FROM CSS_RESP_AREA C1 WITH(READUNCOMMITTED)                    
                     ,CSS_WQ_AREA_CAT AC WITH(READUNCOMMITTED)                  
                WHERE AC.CATEGORY_ID  = :WS-CATEGORY-ID                 
                  AND AC.RESP_AREA_ID = C1.RESP_AREA_ID                 
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*        SELECT AC.RESP_AREA_ID                                   07458000
MFA-TR*          INTO :WS-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_RESP_AREA C1                                  07460000
MFA-TR*              ,CSS_WQ_AREA_CAT AC                                07460000
MFA-TR*         WHERE AC.CATEGORY_ID  = :WS-CATEGORY-ID                         
MFA-TR*           AND AC.RESP_AREA_ID = C1.RESP_AREA_ID                         
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*       WITH UR                                                   07463100
MFA-TR*       QUERYNO 7720                                                      
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7720'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_WQ_AREA_CAT'           TO TABLE-1               
              MOVE 'CATEGORY_ID'               TO TABLE-ELEMENT-1       
              MOVE WS-CATEGORY-ID              TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
      *                                                                         
       7720-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12950000
      *****************************************************************         
      * 7730-GET-RESP-AREA-ID.                                        *         
      *****************************************************************         
       7730-GET-RESP-AREA-ID.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) AC.RESP_AREA_ID                                   
                 INTO :WS-RESP-AREA-ID                                  
                 FROM CSS_RESP_AREA C1 WITH(READUNCOMMITTED)                    
                     ,CSS_WQ_AREA_CAT AC WITH(READUNCOMMITTED)                  
                WHERE AC.CATEGORY_ID  = :WS-CATEGORY-ID                 
                  AND AC.RESP_AREA_ID = C1.RESP_AREA_ID                 
                  AND AC.COMPANY_NO   = :WS-COMPANY-NO                  
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*        SELECT AC.RESP_AREA_ID                                   07458000
MFA-TR*          INTO :WS-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_RESP_AREA C1                                  07460000
MFA-TR*              ,CSS_WQ_AREA_CAT AC                                07460000
MFA-TR*         WHERE AC.CATEGORY_ID  = :WS-CATEGORY-ID                         
MFA-TR*           AND AC.RESP_AREA_ID = C1.RESP_AREA_ID                         
MFA-TR*           AND AC.COMPANY_NO   = :WS-COMPANY-NO                          
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*       WITH UR                                                   07463100
MFA-TR*       QUERYNO 7730                                                      
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7730'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_WQ_AREA_CAT'           TO TABLE-1               
              MOVE 'CATEGORY_ID'               TO TABLE-ELEMENT-1       
              MOVE WS-CATEGORY-ID              TO HOSTVAR-ELEMENT-1     
              MOVE 'COMPANY_NO'                TO TABLE-ELEMENT-2       
              MOVE WS-COMPANY-NO               TO HOSTVAR-ELEMENT-2     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
      *                                                                         
       7730-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12950000
      *****************************************************************         
      * 7750-GET-USER-ID-ASGN.                                        *         
      *****************************************************************         
       7750-GET-USER-ID-ASGN.                                           
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) WC.USER_ID                                        
                 INTO :WS-USER-ID-ASGN                                  
                 FROM CSS_WQ_U_CATEGORY WC WITH(READUNCOMMITTED)                
                      LEFT OUTER JOIN CSS_WQ_ITEMS WQ
                           WITH(READUNCOMMITTED)                   
                   ON WC.USER_ID = WQ.USER_ID_ASGN                      
                  AND WQ.STATUS IN ('A', 'I')                           
                     ,CSS_WQ_CATEGORY C3 WITH(READUNCOMMITTED)                  
                     ,CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                 
                WHERE PF.WQ_RECIPIENT_IND = 'Y'                         
                  AND WC.CATEGORY_ID      = :WS-CATEGORY-ID             
                  AND PF.RESP_AREA_ID     = :WS-77-RESP-AREA-ID         
                  AND WC.USER_ID          = PF.USER_ID                  
                  AND WC.CATEGORY_ID      = C3.CATEGORY_ID              
                GROUP BY WC.USER_ID                                     
                ORDER BY SUM(C3.WQ_TASK_EST_HOURS)                      
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*        SELECT WC.USER_ID                                        07458000
MFA-TR*          INTO :WS-USER-ID-ASGN                                          
MFA-TR*          FROM CSS_WQ_U_CATEGORY WC                              07460000
MFA-TR*               LEFT OUTER JOIN CSS_WQ_ITEMS WQ                   07460000
MFA-TR*            ON WC.USER_ID = WQ.USER_ID_ASGN                              
MFA-TR*           AND WQ.STATUS IN ('A', 'I')                                   
MFA-TR*              ,CSS_WQ_CATEGORY C3                                        
MFA-TR*              ,CSS_USER_PROFILE PF                                       
MFA-TR*         WHERE PF.WQ_RECIPIENT_IND = 'Y'                                 
MFA-TR*           AND WC.CATEGORY_ID      = :WS-CATEGORY-ID                     
MFA-TR*           AND PF.RESP_AREA_ID     = :WS-77-RESP-AREA-ID                 
MFA-TR*           AND WC.USER_ID          = PF.USER_ID                          
MFA-TR*           AND WC.CATEGORY_ID      = C3.CATEGORY_ID                      
MFA-TR*         GROUP BY WC.USER_ID                                             
MFA-TR*         ORDER BY SUM(C3.WQ_TASK_EST_HOURS)                              
MFA-TR*         FETCH FIRST ROW ONLY                                    07463100
MFA-TR*          WITH UR                                                07463100
MFA-TR*       QUERYNO 7750                                                      
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7750'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_WQ_AREA_CAT'           TO TABLE-1               
              MOVE 'CATEGORY_ID'               TO TABLE-ELEMENT-1       
              MOVE WS-CATEGORY-ID              TO HOSTVAR-ELEMENT-1     
              MOVE 'RESP_AREA_ID'              TO TABLE-ELEMENT-2       
              MOVE WS-77-RESP-AREA-ID          TO HOSTVAR-ELEMENT-2     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
      *                                                                         
       7750-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12950000
      *****************************************************************         
      * 7760-SELECT-USER-ID-ASGN.                                     *         
      *****************************************************************         
       7760-SELECT-USER-ID-ASGN.                                        
      *                                                                         
           EXEC SQL                                                     
               SELECT USER_ID                                           
                 INTO :C1-USER-ID                                       
                 FROM CSS_RESP_AREA C1 WITH(READUNCOMMITTED)                    
                WHERE RESP_AREA_ID     = :C1-RESP-AREA-ID               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*        SELECT USER_ID                                           07458000
MFA-TR*          INTO :C1-USER-ID                                               
MFA-TR*          FROM CSS_RESP_AREA C1                                  07460000
MFA-TR*         WHERE RESP_AREA_ID     = :C1-RESP-AREA-ID                       
MFA-TR*       WITH UR                                                   07463100
MFA-TR*       QUERYNO 7760                                                      
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7760'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE 'CSS_RESP_AREA'             TO TABLE-1               
              MOVE 'RESP_AREA_ID'              TO TABLE-ELEMENT-1       
              MOVE C1-RESP-AREA-ID             TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
      *                                                                         
       7760-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12950000
      *****************************************************************         
      * 7800-GET-NEW-ITEM-ID.                                         *         
      *****************************************************************         
       7800-GET-NEW-ITEM-ID.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT
              NEXT VALUE FOR SEQ_WQ_ITEM_ID
            INTO
              :WQ-ITEM-ID              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ048
MFA-TR*    EXEC SQL                                                     07457000
MFA-TR*       SET :WQ-ITEM-ID = NEXTVAL FOR SEQ_WQ_ITEM_ID              07458000
MFA-TR*    END-EXEC.                                                    07464000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7800'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SET'                       TO ABEND-FUNCTION        
              MOVE 'CSS_WQ_ITEMS'              TO TABLE-1               
              MOVE 'WQ-ITEM-ID'                TO TABLE-ELEMENT-1       
              MOVE WQ-ITEM-ID                  TO HOSTVAR-ELEMENT-1     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12950000
      *****************************************************************         
      * 8000-INSERT-WQ-ITEMS.                                         *         
      *****************************************************************         
      *                                                                 12950000
       8000-INSERT-WQ-ITEMS.                                            
                                                                        
           EXEC SQL INSERT INTO CSS_WQ_ITEMS                            
                       ( ITEM_ID                                        
                       , ACCOUNT_NO                                     
                       , PREMISE_NO                                     
                       , CUSTOMER_NO                                    
                       , COMPANY_NO                                     
                       , SERV_ORDER_NO                                  
                       , STATUS                                         
                       , USER_ID_ORIG                                   
                       , USER_ID_ASGN                                   
                       , RESP_AREA_ID                                   
                       , COMPLETE_DATE                                  
                       , CATEGORY_ID                                    
                       , COMMENTS                                       
                       , DATE_REQUIRED                                  
                       , DATE_CREATED                                   
                       , PRIORITY                                       
                       , FREE_FORM_AREA                                 
                       , CREATED_BY)                                    
               VALUES ( :WQ-ITEM-ID                                     
                      , :WQ-ACCOUNT-NO                                  
                      , :WQ-PREMISE-NO                                  
                      , :WQ-CUSTOMER-NO                                 
                      , :WQ-COMPANY-NO                                  
                      , :WQ-SERV-ORDER-NO                               
                      , :WQ-STATUS                                      
                      , :WQ-USER-ID-ORIG                                
                      , :WQ-USER-ID-ASGN                                
                      , :WQ-RESP-AREA-ID                                
                      , CIS.CHAR2TIMESTAMP(:WQ-COMPLETE-DATE 
                                           :WS-COMP-DATE-NULL)             
                      , :WQ-CATEGORY-ID                                 
                      , :WQ-COMMENTS                                    
                      , CIS.CHAR2TIMESTAMP(:WQ-DATE-REQUIRED)                   
                      , CIS.CHAR2TIMESTAMP(:WQ-DATE-CREATED)                    
                      , :WQ-PRIORITY                                    
                      , :WQ-FREE-FORM-AREA                              
                      , :WQ-CREATED-BY)                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL INSERT INTO CSS_WQ_ITEMS                                    
MFA-TR*                ( ITEM_ID                                                
MFA-TR*                , ACCOUNT_NO                                             
MFA-TR*                , PREMISE_NO                                             
MFA-TR*                , CUSTOMER_NO                                            
MFA-TR*                , COMPANY_NO                                             
MFA-TR*                , SERV_ORDER_NO                                          
MFA-TR*                , STATUS                                                 
MFA-TR*                , USER_ID_ORIG                                           
MFA-TR*                , USER_ID_ASGN                                           
MFA-TR*                , RESP_AREA_ID                                           
MFA-TR*                , COMPLETE_DATE                                          
MFA-TR*                , CATEGORY_ID                                            
MFA-TR*                , COMMENTS                                               
MFA-TR*                , DATE_REQUIRED                                          
MFA-TR*                , DATE_CREATED                                           
MFA-TR*                , PRIORITY                                               
MFA-TR*                , FREE_FORM_AREA                                         
MFA-TR*                , CREATED_BY)                                            
MFA-TR*        VALUES ( :WQ-ITEM-ID                                             
MFA-TR*               , :WQ-ACCOUNT-NO                                          
MFA-TR*               , :WQ-PREMISE-NO                                          
MFA-TR*               , :WQ-CUSTOMER-NO                                         
MFA-TR*               , :WQ-COMPANY-NO                                          
MFA-TR*               , :WQ-SERV-ORDER-NO                                       
MFA-TR*               , :WQ-STATUS                                              
MFA-TR*               , :WQ-USER-ID-ORIG                                        
MFA-TR*               , :WQ-USER-ID-ASGN                                        
MFA-TR*               , :WQ-RESP-AREA-ID                                        
MFA-TR*               , :WQ-COMPLETE-DATE:WS-COMP-DATE-NULL                     
MFA-TR*               , :WQ-CATEGORY-ID                                         
MFA-TR*               , :WQ-COMMENTS                                            
MFA-TR*               , :WQ-DATE-REQUIRED                                       
MFA-TR*               , :WQ-DATE-CREATED                                        
MFA-TR*               , :WQ-PRIORITY                                            
MFA-TR*               , :WQ-FREE-FORM-AREA                                      
MFA-TR*               , :WQ-CREATED-BY)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'INSERT'                   TO ABEND-FUNCTION        
               MOVE 'CSS_WQ_ITEMS_MF'          TO TABLE-1               
               MOVE 'ACCOUNT NO'               TO TABLE-ELEMENT-1       
               MOVE WQ-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               MOVE 'SERV ORDER NO'            TO TABLE-ELEMENT-2       
               MOVE WQ-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-2     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
