      *                                                                 00010000
      ****************************************************************  00010100
      * CPDTP166    EXTRACT DATA TO LOAD THE TRANSPORTATION PAGES FOR*  00010200
      *             CIG CUSTOMERS.                                   *  00010300
      ****************************************************************  00010400
      *           MODIFICATION LOG                                   *  00010800
      *   DATE     INITIALS          REASON                          *  00010900
      *  ______    ________    ____________________________________  *  00011000
      *                                                              *  00011100
      *   11/02      SV        TPR 27232 DESIGN BILLPINT FOR CIG     *  00011200
      *                         CUSTOMERS.                           *  00011300
T34097*   12/07      MR97640   REPLACED MODEL_SQL WITH SET COMMAND   *  00011400
T34097*                        AND ADDED WITH UR TO AVOID -911.      *  00011500
T34097*                                                              *  00011600
      ****************************************************************  00013700
      * THIS COPYBOOK SHOULD BE USED TO EXTRACT ALL THE INFORMATION  *  00013800
      * THAT NEEDS TO BE PRINTED FOR CIG CUSTOMERS.                  *  00013900
      * THE DATA THAT ARE LOADED ARE THE DAILY VOLUME BLOCKS, METER  *  00014000
      * INFORMATION, METER TOTALS.                                   *  00014100
      ****************************************************************  00014300
      * BE SURE TO INCLUDE THE FOLLOWING COPYBOOKS:                  *  00015000
      *    1. CWSTP166  WORK AREAS FOR ALL THE NEW FIELDS THAT IS    *  00015100
      *                 USED IN THIS COPYBOOK.                       *  00015200
      * BE SURE TO INCLUDE THE FOLLOWING TABLES:                     *  00015400
      *    1. TBVOLDLY   VOLUME DAILY.                               *  00015500
      *    2. TBVOLTYP   VOLUME TYPE.                                *  00015600
      *    3. TBSVCCAT   SERVICE CATEGORY.                           *  00015700
      **************************************************************    00024500
           EXEC SQL                                                     
               DECLARE VOL_TYPE CURSOR FOR                              
                SELECT X8.VOL_GROUP_CD                                  
                     , X8.VOL_TYPE_CD                                   
                     , X8.ENERGY_UNIT_CD                                
                     , X8.CMPNT_ID_CD                                   
                     , X8.MANUAL_ENTRY_FL                               
                     , X8.ACCUM_TOTAL_FL                                
                     , X8.COLUMN_HEADER1                                
                     , X8.COLUMN_HEADER2                                
                     , X8.COLUMN_HEADER3                                
                     , X8.COLUMN_HEADER4                                
                     , X8.STATUS_CD                                     
                     , X8.STATUS_CHANGE_DT                              
                 FROM CSS_VOL_TYPE X8 WITH(READUNCOMMITTED)                     
                WHERE X8.VOL_GROUP_CD       = :X8-VOL-GROUP-CD          
                  AND X8.COMPANY_NO         = :X8-COMPANY-NO            
                  AND X8.CODE_UTIL_TYPE     = :X8-CODE-UTIL-TYPE        
                  AND X8.BILL_PRINT_FL      = 'Y'                       
                ORDER BY X8.VOL_GROUP_SEQ ASC                           
T34097            FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00024600
MFA-TR*        DECLARE VOL_TYPE CURSOR FOR                              00025000
MFA-TR*         SELECT X8.VOL_GROUP_CD                                  00030000
MFA-TR*              , X8.VOL_TYPE_CD                                   00040000
MFA-TR*              , X8.ENERGY_UNIT_CD                                00050000
MFA-TR*              , X8.CMPNT_ID_CD                                   00060000
MFA-TR*              , X8.MANUAL_ENTRY_FL                               00070000
MFA-TR*              , X8.ACCUM_TOTAL_FL                                00080000
MFA-TR*              , X8.COLUMN_HEADER1                                00090000
MFA-TR*              , X8.COLUMN_HEADER2                                00100000
MFA-TR*              , X8.COLUMN_HEADER3                                00110000
MFA-TR*              , X8.COLUMN_HEADER4                                00120000
MFA-TR*              , X8.STATUS_CD                                     00130000
MFA-TR*              , X8.STATUS_CHANGE_DT                              00140000
MFA-TR*          FROM CSS_VOL_TYPE X8                                   00150000
MFA-TR*         WHERE X8.VOL_GROUP_CD       = :X8-VOL-GROUP-CD          00160000
MFA-TR*           AND X8.COMPANY_NO         = :X8-COMPANY-NO            00170000
MFA-TR*           AND X8.CODE_UTIL_TYPE     = :X8-CODE-UTIL-TYPE        00180000
MFA-TR*           AND X8.BILL_PRINT_FL      = 'Y'                       00190000
MFA-TR*         ORDER BY X8.VOL_GROUP_SEQ ASC                           00200000
MFA-TR*           FOR FETCH ONLY WITH UR                                00201000
MFA-TR*    END-EXEC.                                                    00210000
      *                                                                 00220000
           EXEC SQL                                                     
               DECLARE VOL_DAILY CURSOR FOR                             
                SELECT ND.NO_UNITS                                      
                     , ND.DATE_READ                                     
                     , ND.FIXED_FCTR_SEQ_NO                             
                  FROM CSS_VOL_DAILY ND WITH(READUNCOMMITTED)                   
                 WHERE ND.ACCOUNT_NO         = :ND-ACCOUNT-NO           
                   AND ND.BILL_NO            = :ND-BILL-NO              
                   AND ND.CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE       
                   AND ND.IC_NO              = :ND-IC-NO                
                   AND ND.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :ND-BILL-ITEM-TIMESTMP
              )   
                   AND ND.VOL_TYPE_CD        = :ND-VOL-TYPE-CD          
                   AND ND.ENERGY_UNIT_CD     = :ND-ENERGY-UNIT-CD       
                 ORDER BY ND.DATE_READ                                  
T34097             FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00230000
MFA-TR*        DECLARE VOL_DAILY CURSOR FOR                             00240000
MFA-TR*         SELECT ND.NO_UNITS                                      00250000
MFA-TR*              , ND.DATE_READ                                     00260000
MFA-TR*              , ND.FIXED_FCTR_SEQ_NO                             00270000
MFA-TR*           FROM CSS_VOL_DAILY ND                                 00280000
MFA-TR*          WHERE ND.ACCOUNT_NO         = :ND-ACCOUNT-NO           00290000
MFA-TR*            AND ND.BILL_NO            = :ND-BILL-NO              00300000
MFA-TR*            AND ND.CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE       00310000
MFA-TR*            AND ND.IC_NO              = :ND-IC-NO                00311000
MFA-TR*            AND ND.BILL_ITEM_TIMESTMP = :ND-BILL-ITEM-TIMESTMP   00320000
MFA-TR*            AND ND.VOL_TYPE_CD        = :ND-VOL-TYPE-CD          00330000
MFA-TR*            AND ND.ENERGY_UNIT_CD     = :ND-ENERGY-UNIT-CD       00340000
MFA-TR*          ORDER BY ND.DATE_READ                                  00350000
MFA-TR*            FOR FETCH ONLY WITH UR                               00350100
MFA-TR*    END-EXEC.                                                    00351000
      *                                                                 00360000
           EXEC SQL                                                     
               DECLARE DAILY_METERS CURSOR FOR                          
                SELECT CX.METER_NO                                      
                 FROM CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                 
                    , CSS_BILLING_DET BG WITH(READUNCOMMITTED)                  
                WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO            
                  AND CX.BILL_NO            = :CX-BILL-NO               
                  AND CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE        
                  AND CX.IC_NO              = :CX-IC-NO                 
      *           AND CX.BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP    00460000
                ORDER BY CX.MTR_REF_NO, CX.ITEM_SEQ_NO                  
T34097            FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00370000
MFA-TR*        DECLARE DAILY_METERS CURSOR FOR                          00380000
MFA-TR*         SELECT CX.METER_NO                                      00390000
MFA-TR*          FROM CSS_CNSMPTN_HIST CX                               00400000
MFA-TR*             , CSS_BILLING_DET BG                                00410000
MFA-TR*         WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO            00420000
MFA-TR*           AND CX.BILL_NO            = :CX-BILL-NO               00430000
MFA-TR*           AND CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE        00440000
MFA-TR*           AND CX.IC_NO              = :CX-IC-NO                 00450000
MFA-TR*           AND CX.BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP    00460000
MFA-TR*         ORDER BY CX.MTR_REF_NO, CX.ITEM_SEQ_NO                  00470000
MFA-TR*           FOR FETCH ONLY WITH UR                                00471000
MFA-TR*    END-EXEC.                                                    00480000
                                                                        
           EXEC SQL                                                     
               DECLARE DAILY_METER_VOLUME CURSOR FOR                    
                SELECT CX.NO_UNITS                                      
                     , CX.DATE_READ                                     
                     , CX.CODE_DEBIT_CREDIT                             
                 FROM CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                 
                WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO            
                  AND CX.BILL_NO            = :CX-BILL-NO               
                  AND CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE        
                  AND CX.IC_NO              = :CX-IC-NO                 
                  AND CX.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )    
                  AND CX.METER_NO           = :CX-METER-NO              
                ORDER BY CX.MTR_REF_NO, CX.DATE_READ, CX.ITEM_SEQ_NO    
T34097            FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00500000
MFA-TR*        DECLARE DAILY_METER_VOLUME CURSOR FOR                    00510000
MFA-TR*         SELECT CX.NO_UNITS                                      00520000
MFA-TR*              , CX.DATE_READ                                     00530000
MFA-TR*              , CX.CODE_DEBIT_CREDIT                             00531000
MFA-TR*          FROM CSS_CNSMPTN_HIST CX                               00540000
MFA-TR*         WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO            00550000
MFA-TR*           AND CX.BILL_NO            = :CX-BILL-NO               00560000
MFA-TR*           AND CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE        00570000
MFA-TR*           AND CX.IC_NO              = :CX-IC-NO                 00580000
MFA-TR*           AND CX.BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP    00590000
MFA-TR*           AND CX.METER_NO           = :CX-METER-NO              00600000
MFA-TR*         ORDER BY CX.MTR_REF_NO, CX.DATE_READ, CX.ITEM_SEQ_NO    00610000
MFA-TR*           FOR FETCH ONLY WITH UR                                00611000
MFA-TR*    END-EXEC.                                                    00620000
                                                                        
           EXEC SQL                                                     
               DECLARE DAILY_METER_TOTALS CURSOR FOR                    
                SELECT ND.NO_UNITS                                      
                     , ND.FIXED_FCTR_SEQ_NO                             
                     , X8.VOL_GROUP_CD                                  
                     , X8.VOL_TYPE_CD                                   
                     , X8.ENERGY_UNIT_CD                                
                     , X8.CMPNT_ID_CD                                   
                     , X8.MANUAL_ENTRY_FL                               
                     , X8.ACCUM_TOTAL_FL                                
                     , X8.COLUMN_HEADER1                                
                     , X8.COLUMN_HEADER2                                
                     , X8.COLUMN_HEADER3                                
                     , X8.COLUMN_HEADER4                                
                     , X8.STATUS_CD                                     
                     , X8.STATUS_CHANGE_DT                              
                 FROM CSS_VOL_DAILY ND WITH(READUNCOMMITTED)                    
                    , CSS_VOL_TYPE X8 WITH(READUNCOMMITTED)                     
                WHERE ND.ACCOUNT_NO         = :ND-ACCOUNT-NO            
                  AND ND.BILL_NO            = :ND-BILL-NO               
                  AND ND.CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE        
                  AND X8.VOL_GROUP_CD       = :X8-VOL-GROUP-CD          
                  AND ND.VOL_TYPE_CD        = X8.VOL_TYPE_CD            
                  AND X8.BILL_PRINT_FL      = 'Y'                       
                  AND ND.ENERGY_UNIT_CD     = X8.ENERGY_UNIT_CD         
                ORDER BY X8.VOL_GROUP_SEQ ASC, ND.DATE_READ             
T34097            FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00640000
MFA-TR*        DECLARE DAILY_METER_TOTALS CURSOR FOR                    00650000
MFA-TR*         SELECT ND.NO_UNITS                                      00660000
MFA-TR*              , ND.FIXED_FCTR_SEQ_NO                             00670000
MFA-TR*              , X8.VOL_GROUP_CD                                  00680000
MFA-TR*              , X8.VOL_TYPE_CD                                   00690000
MFA-TR*              , X8.ENERGY_UNIT_CD                                00700000
MFA-TR*              , X8.CMPNT_ID_CD                                   00710000
MFA-TR*              , X8.MANUAL_ENTRY_FL                               00720000
MFA-TR*              , X8.ACCUM_TOTAL_FL                                00730000
MFA-TR*              , X8.COLUMN_HEADER1                                00740000
MFA-TR*              , X8.COLUMN_HEADER2                                00750000
MFA-TR*              , X8.COLUMN_HEADER3                                00760000
MFA-TR*              , X8.COLUMN_HEADER4                                00770000
MFA-TR*              , X8.STATUS_CD                                     00780000
MFA-TR*              , X8.STATUS_CHANGE_DT                              00790000
MFA-TR*          FROM CSS_VOL_DAILY ND                                  00800000
MFA-TR*             , CSS_VOL_TYPE X8                                   00810000
MFA-TR*         WHERE ND.ACCOUNT_NO         = :ND-ACCOUNT-NO            00820000
MFA-TR*           AND ND.BILL_NO            = :ND-BILL-NO               00830000
MFA-TR*           AND ND.CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE        00840000
MFA-TR*           AND X8.VOL_GROUP_CD       = :X8-VOL-GROUP-CD          00850000
MFA-TR*           AND ND.VOL_TYPE_CD        = X8.VOL_TYPE_CD            00860000
MFA-TR*           AND X8.BILL_PRINT_FL      = 'Y'                       00870000
MFA-TR*           AND ND.ENERGY_UNIT_CD     = X8.ENERGY_UNIT_CD         00880000
MFA-TR*         ORDER BY X8.VOL_GROUP_SEQ ASC, ND.DATE_READ             00890000
MFA-TR*           FOR FETCH ONLY WITH UR                                00891000
MFA-TR*    END-EXEC.                                                    00900000
                                                                        
           EXEC SQL                                                     
               DECLARE DAILY_VOLUME_BLKS  CURSOR FOR                    
                SELECT ND.NO_UNITS                                      
                     , ND.FIXED_FCTR_SEQ_NO                             
                     , X8.VOL_GROUP_CD                                  
                     , X8.VOL_TYPE_CD                                   
                     , X8.ENERGY_UNIT_CD                                
                     , X8.CMPNT_ID_CD                                   
                     , X8.MANUAL_ENTRY_FL                               
                     , X8.ACCUM_TOTAL_FL                                
                     , X8.COLUMN_HEADER1                                
                     , X8.COLUMN_HEADER2                                
                     , X8.COLUMN_HEADER3                                
                     , X8.COLUMN_HEADER4                                
                     , X8.STATUS_CD                                     
                     , X8.STATUS_CHANGE_DT                              
                 FROM CSS_VOL_DAILY ND WITH(READUNCOMMITTED)                    
                    , CSS_VOL_TYPE X8 WITH(READUNCOMMITTED)                     
                WHERE ND.ACCOUNT_NO         = :ND-ACCOUNT-NO            
                  AND ND.BILL_NO            = :ND-BILL-NO               
                  AND ND.CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE        
                  AND X8.VOL_GROUP_CD       = :X8-VOL-GROUP-CD          
                  AND ND.VOL_TYPE_CD        = X8.VOL_TYPE_CD            
                  AND X8.BILL_PRINT_FL      = 'Y'                       
                  AND ND.ENERGY_UNIT_CD     = X8.ENERGY_UNIT_CD         
                ORDER BY X8.VOL_GROUP_SEQ ASC, ND.DATE_READ             
T34097            FOR READ ONLY                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00920000
MFA-TR*        DECLARE DAILY_VOLUME_BLKS  CURSOR FOR                    00930000
MFA-TR*         SELECT ND.NO_UNITS                                      00940000
MFA-TR*              , ND.FIXED_FCTR_SEQ_NO                             00950000
MFA-TR*              , X8.VOL_GROUP_CD                                  00960000
MFA-TR*              , X8.VOL_TYPE_CD                                   00970000
MFA-TR*              , X8.ENERGY_UNIT_CD                                00980000
MFA-TR*              , X8.CMPNT_ID_CD                                   00990000
MFA-TR*              , X8.MANUAL_ENTRY_FL                               01000000
MFA-TR*              , X8.ACCUM_TOTAL_FL                                01010000
MFA-TR*              , X8.COLUMN_HEADER1                                01020000
MFA-TR*              , X8.COLUMN_HEADER2                                01030000
MFA-TR*              , X8.COLUMN_HEADER3                                01040000
MFA-TR*              , X8.COLUMN_HEADER4                                01050000
MFA-TR*              , X8.STATUS_CD                                     01060000
MFA-TR*              , X8.STATUS_CHANGE_DT                              01070000
MFA-TR*          FROM CSS_VOL_DAILY ND                                  01080000
MFA-TR*             , CSS_VOL_TYPE X8                                   01090000
MFA-TR*         WHERE ND.ACCOUNT_NO         = :ND-ACCOUNT-NO            01100000
MFA-TR*           AND ND.BILL_NO            = :ND-BILL-NO               01110000
MFA-TR*           AND ND.CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE        01120000
MFA-TR*           AND X8.VOL_GROUP_CD       = :X8-VOL-GROUP-CD          01130000
MFA-TR*           AND ND.VOL_TYPE_CD        = X8.VOL_TYPE_CD            01140000
MFA-TR*           AND X8.BILL_PRINT_FL      = 'Y'                       01150000
MFA-TR*           AND ND.ENERGY_UNIT_CD     = X8.ENERGY_UNIT_CD         01160000
MFA-TR*         ORDER BY X8.VOL_GROUP_SEQ ASC, ND.DATE_READ             01170000
MFA-TR*           FOR FETCH ONLY WITH UR                                01171000
MFA-TR*    END-EXEC.                                                    01180000
      *****************************************************             01190000
      *THE LOGIC TO GET THE TRANSPORATATION DAILY VOLUMES,*             01200000
      * METER BLOCKS AND VOLUME BLOCKS.                   *             01210000
      *****************************************************             01220000
      *                                                                 01230000
       4860-GAS-INDUS.                                                  
      * LOAD THE TRANSPORTATION DATA.                                   01250000
           MOVE 'N'                        TO WS-TRANSP-RECS-SW.        
           INITIALIZE WS-VOL-SUB1                                       
                      WS-VOL-SUB                                        
                      WS-DAILY-VOLUME.                                  
           PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1 UNTIL            
SCA006       WS-TRANSP-RECS-SW = 'Y' OR 
             WS-BILLING-INDX > 30 OR 
             WS-ACCOUNT-NO-BG(WS-BILLING-INDX) = 0                              
             IF WS-CODE-REVENUE-CLASS-BG(WS-BILLING-INDX) = '000'       
                AND WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX) = 'C'     
T28984          AND (WS-DATE-ORIG-BILL-BG(WS-BILLING-INDX) <= SPACES    
T28984          OR  (WS-DATE-ORIG-BILL-BG(WS-BILLING-INDX) > SPACES     
T28984          AND WS-FUTURE-FLAG = 'N'))                              
                PERFORM 4865-DAILY-VOL THRU 4865-EXIT                   
             END-IF                                                     
           END-PERFORM.                                                 
      * LOAD THE METER DETAILS, METER TOTALS FOLLOWED BY VOLUME BLOCKS. 01370000
           PERFORM VARYING WS-BILLING-INDX FROM 1 BY 1 UNTIL            
             WS-BILLING-INDX > 30                                       
             OR WS-ACCOUNT-NO-BG(WS-BILLING-INDX) = 0                   
             IF WS-CODE-REVENUE-CLASS-BG(WS-BILLING-INDX) NOT = '000'   
                AND WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX) = 'C'     
                AND WS-CIG-CUSTOMER-IND-BG(WS-BILLING-INDX) = 'Y'       
                AND (WS-DATE-ORIG-BILL-BG(WS-BILLING-INDX) <= SPACES    
                OR  (WS-DATE-ORIG-BILL-BG(WS-BILLING-INDX) > SPACES     
                AND WS-FUTURE-FLAG = 'N'))                              
                PERFORM 4869-MTR-VOL-BLK THRU 4869-EXIT                 
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                 01460000
       4860-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01490000
       4865-DAILY-VOL.                                                  
      *                                                                 01510000
           MOVE WS-COMPANY-NO-AT                TO X8-COMPANY-NO.       
           MOVE WS-ACCOUNT-NO-BG(WS-BILLING-INDX)                       
                                                TO UZ-ACCOUNT-NO.       
           MOVE WS-BILL-NO-BG(WS-BILLING-INDX)  TO UZ-BILL-NO.          
           MOVE WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX)                   
                                                TO X8-CODE-UTIL-TYPE    
                                                   UZ-CODE-UTIL-TYPE.   
           MOVE  10                             TO X8-VOL-GROUP-CD.     
           PERFORM VARYING WS-BILLING-INDX2 FROM 1 BY 1 UNTIL           
SCA006       WS-BASE-RATE-RECS-SW = 'Y' OR 
             WS-BILLING-INDX2 > 30 OR 
             WS-ACCOUNT-NO-BG(WS-BILLING-INDX2) = 0                             
             IF WS-CODE-REVENUE-CLASS-BG(WS-BILLING-INDX2) NOT = '000'  
                AND WS-CODE-BILL-ITM-TYPE-BG(WS-BILLING-INDX) = 'C'     
                MOVE WS-BILL-ITEM-TIMESTMP-BG(WS-BILLING-INDX2)         
                                             TO UZ-BILL-ITEM-TIMESTMP   
                PERFORM 7310-GET-PRIMARY-IC  THRU 7310-EXIT             
             END-IF                                                     
           END-PERFORM.                                                 
           PERFORM 7000-OPEN-VOL-HDR        THRU 7000-EXIT.             
           PERFORM 7010-FETCH-VOL-HDR       THRU 7010-EXIT.             
           PERFORM UNTIL  WS-ACTIVE-RETURN-CODE = NOT-FOUND             
              MOVE 'Y'                       TO WS-TRANSP-RECS-SW       
              PERFORM 4866-LOAD-VOL-HEADING THRU 4866-EXIT              
              MOVE 'N'                      TO WS-VOL-DLY-DATA-SW       
              PERFORM 4867-GET-VOLUME-DLY   THRU 4867-EXIT              
              IF WS-VOL-DLY-DATA-SW = 'N' AND WS-VOL-SUB > 0            
                 MOVE ' '                   TO                          
                                       WS-LOAD-VOL-DATA(WS-VOL-SUB)     
                 COMPUTE WS-VOL-SUB = WS-VOL-SUB - 1                    
              END-IF                                                    
              PERFORM 7010-FETCH-VOL-HDR    THRU 7010-EXIT              
           END-PERFORM.                                                 
           PERFORM 7020-CLOSE-VOL-HDR       THRU 7020-EXIT.             
      *                                                                 01650000
       4865-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01680000
       4866-LOAD-VOL-HEADING.                                           
           ADD 1                             TO WS-VOL-SUB.             
           MOVE 'Y'                          TO                         
                              WS-LOAD-VOL-DATA(WS-VOL-SUB).             
           MOVE X8-COLUMN-HEADER1            TO                         
                              WS-TRANSPORT-CHRGS-DESC1(WS-VOL-SUB).     
           IF X8-COLUMN-HEADER2 = '&SHRINK'                             
              MOVE X8-COLUMN-HEADER2         TO WS-HOLD-HEADER          
              PERFORM 4866A-GET-SHRINK-PCT   THRU 4866A-EXIT            
              MOVE WS-HOLD-HEADER            TO                         
                              WS-TRANSPORT-CHRGS-DESC2(WS-VOL-SUB)      
           ELSE                                                         
           MOVE X8-COLUMN-HEADER2            TO                         
                              WS-TRANSPORT-CHRGS-DESC2(WS-VOL-SUB)      
           END-IF.                                                      
           MOVE X8-COLUMN-HEADER3            TO                         
                              WS-TRANSPORT-CHRGS-DESC3(WS-VOL-SUB).     
           MOVE X8-COLUMN-HEADER4            TO                         
                              WS-TRANSPORT-CHRGS-DESC4(WS-VOL-SUB).     
       4866-EXIT.                                                       
           EXIT.                                                        
      *                                                                 01810000
       4866A-GET-SHRINK-PCT.                                            
           PERFORM VARYING WS-BK-SUB FROM 1 BY 1 UNTIL WS-BK-SUB > 20   
            OR WS-ACCOUNT-NO-BK (WS-BK-SUB) = ZERO                      
             IF WS-ACCOUNT-NO-BK (WS-BK-SUB) =                          
                              WS-ACCOUNT-NO-BG (WS-BILLING-INDX) AND    
                WS-CODE-UTIL-TYPE-BK (WS-BK-SUB) =                      
                          WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) AND    
                WS-IC-NO-BK (WS-BK-SUB) =                               
                          WS-IC-NO-BG (WS-BILLING-INDX)                 
                 MOVE WS-TRNSP-SHRINK-PCT-BK(WS-BK-SUB)                 
                                               TO WS-COMPUTE-PCT        
                 MOVE WS-COMPUTE-PCT           TO WS-DISPLAY-PCT        
                 MOVE SPACES                   TO WS-EMB-INPUT          
                                                  WS-CMP-TABLE          
                 STRING WS-DISPLAY-PCT                                  
                        '%'                                             
                   DELIMITED BY SIZE                                    
                   INTO WS-EMB-INPUT                                    
                 MOVE 8                        TO WS-EMB-LENG           
                 PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT     
                 MOVE WS-CMP-TABLE             TO WS-HOLD-HEADER        
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                 01812600
       4866A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 01813000
       4867-GET-VOLUME-DLY.                                             
           MOVE WS-ACCOUNT-NO-BG(WS-BILLING-INDX)                       
                                             TO ND-ACCOUNT-NO.          
           MOVE WS-BILL-NO-BG(WS-BILLING-INDX)                          
                                             TO ND-BILL-NO.             
           MOVE WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX)                   
                                             TO ND-CODE-UTIL-TYPE.      
           MOVE WS-BILL-ITEM-TIMESTMP-BG(WS-BILLING-INDX)               
                                             TO ND-BILL-ITEM-TIMESTMP.  
           IF X8-VOL-GROUP-CD = 30 AND X8-VOL-TYPE-CD = 'VT'            
              PERFORM 7300-GET-TIME-STAMP    THRU 7300-EXIT             
           END-IF.                                                      
           MOVE 'N'                          TO WS-BASE-RATE-RECS-SW.   
      * GET THE PRIMARY_IC_NO FROM CSS_TRNSP_VOL_HIST & THE PRIMARY IC  01881700
      * IS TAKEN ONLY WHEN X8-VOL-GROUP-CD IS 10.                       01881800
           IF X8-VOL-GROUP-CD = 10                                      
              MOVE UZ-PRIMARY-IC-NO             TO ND-IC-NO             
           ELSE                                                         
              MOVE WS-IC-NO-BG(WS-BILLING-INDX) TO ND-IC-NO             
           END-IF.                                                      
           MOVE X8-VOL-TYPE-CD               TO ND-VOL-TYPE-CD.         
           MOVE X8-ENERGY-UNIT-CD            TO ND-ENERGY-UNIT-CD.      
      *                                                                 01930000
           PERFORM 7050-OPEN-TRANS-TOT       THRU 7050-EXIT.            
           PERFORM 7060-FETCH-TRANS-TOT      THRU 7060-EXIT.            
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE 'Y'                       TO WS-TRANSP-RECS-SW       
              PERFORM 4868-LOAD-VOLUME-DLY THRU 4868-EXIT               
              PERFORM 7060-FETCH-TRANS-TOT THRU 7060-EXIT               
           END-PERFORM.                                                 
           PERFORM 7070-CLOSE-TRANS-TOT THRU 7070-EXIT.                 
      *                                                                 02020000
       4867-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02050000
      *                                                                 02061500
       4868-LOAD-VOLUME-DLY.                                            
      *                                                                 02070000
           IF WS-VOL-DLY-DATA-SW = 'N'                                  
              MOVE 'Y'                      TO WS-VOL-DLY-DATA-SW       
           END-IF.                                                      
           MOVE ND-DATE-READ                TO WS-TP-DATE-READ.         
           MOVE WS-TP-DATE-READ-DD          TO WS-VOL-SUB1.             
           MOVE ND-NO-UNITS                 TO WS-ND-NO-UNITS.          
           IF X8-ACCUM-TOTAL-FL = 'Y'                                   
              ADD ND-NO-UNITS               TO                          
                WS-TRANSPORT-CHRG-TOT-AMT(WS-VOL-SUB)                   
           END-IF.                                                      
           MOVE WS-ND-NO-UNITS              TO                          
                WS-TRANSPORT-CHRG-DAY(WS-VOL-SUB, WS-VOL-SUB1).         
      *                                                                 02150000
       4868-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02180000
       4869-MTR-VOL-BLK.                                                
      *                                                                 02200000
           PERFORM 4870-DAILY-METER-VOLUME  THRU 4870-EXIT.             
           PERFORM 4871-METER-TOTALS        THRU 4871-EXIT.             
           PERFORM 4872-VOLUME-BLK          THRU 4872-EXIT.             
      *                                                                 02240000
       4869-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02270000
       4870-DAILY-METER-VOLUME.                                         
      *                                                                 02290000
      *CHECK IF THE METER NO & NO UNITS INFO CAN BE LOADED FROM THE FILE02300000
      *WHAT WE HAVE FROM BILLING!!!!!!!!!                               02310000
      *                                                                 02320000
           INITIALIZE WS-TP-METER-NO.                                   
           PERFORM VARYING WS-CX-SUB FROM 1 BY 1 UNTIL WS-CX-SUB > 200  
              OR WS-ACCOUNT-NO-CX (WS-CX-SUB) = ZERO                    
             IF WS-ACCOUNT-NO-CX (WS-CX-SUB) =                          
                              WS-ACCOUNT-NO-BG (WS-BILLING-INDX) AND    
                WS-BILL-NO-CX (WS-CX-SUB) =                             
                                 WS-BILL-NO-BG (WS-BILLING-INDX) AND    
                WS-CODE-UTIL-TYPE-CX (WS-CX-SUB) =                      
                          WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) AND    
                WS-IC-NO-CX (WS-CX-SUB) =                               
                                   WS-IC-NO-BG (WS-BILLING-INDX) AND    
                WS-BILL-ITEM-TIMESTMP-CX (WS-CX-SUB) =                  
                      WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX)        
                IF WS-METER-NO-CX(WS-CX-SUB) NOT = WS-TP-METER-NO       
                 IF WS-METER-NO-CX(WS-CX-SUB) NOT = '0CIGDUMMY'         
                   MOVE WS-ACCOUNT-NO-BG(WS-BILLING-INDX)               
                                              TO CX-ACCOUNT-NO          
                   MOVE WS-BILL-NO-BG(WS-BILLING-INDX)                  
                                              TO CX-BILL-NO             
                   MOVE WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX)           
                                              TO CX-CODE-UTIL-TYPE      
                   MOVE WS-IC-NO-BG(WS-BILLING-INDX)     TO CX-IC-NO    
                   MOVE WS-BILL-ITEM-TIMESTMP-BG(WS-BILLING-INDX)       
                                              TO CX-BILL-ITEM-TIMESTMP  
                   MOVE WS-METER-NO-CX(WS-CX-SUB)  TO WS-TP-METER-NO    
                                                      CX-METER-NO       
                   PERFORM 4870A-LOAD-METER-HDR    THRU 4870A-EXIT      
                   PERFORM 4870B-GET-METER-DATA    THRU 4870B-EXIT      
                 END-IF                                                 
                END-IF                                                  
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
      *    PERFORM 7100-OPEN-METER-HDR        THRU 7100-EXIT.           02580000
      *    PERFORM 7110-FETCH-METER-HDR       THRU 7110-EXIT.           02590000
      *    PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              02600000
      *       PERFORM 4870A-LOAD-METER-HDR    THRU 4870A-EXIT           02610000
      *       PERFORM 4870B-GET-METER-DATA    THRU 4870B-EXIT           02620000
      *       PERFORM 7110-FETCH-METER-HDR    THRU 7110-EXIT            02630000
      *    END-PERFORM.                                                 02640000
      *    PERFORM 7120-CLOSE-METER-HDR       THRU 7120-EXIT.           02650000
      *                                                                 02660000
       4870-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02690000
       4870A-LOAD-METER-HDR.                                            
      *                                                                 02710000
           ADD 1                             TO WS-VOL-SUB.             
           MOVE 'Y'                          TO                         
                                      WS-LOAD-VOL-DATA(WS-VOL-SUB).     
           MOVE SPACES                       TO                         
                              WS-TRANSPORT-CHRGS-DESC1(WS-VOL-SUB).     
           MOVE 'METER'                      TO                         
                              WS-TRANSPORT-CHRGS-DESC2(WS-VOL-SUB).     
           MOVE WS-METER-NO-CX(WS-CX-SUB)    TO                         
                              WS-TRANSPORT-CHRGS-DESC3(WS-VOL-SUB).     
           MOVE 'MCF'                        TO                         
                              WS-TRANSPORT-CHRGS-DESC4(WS-VOL-SUB).     
      *                                                                 02810000
       4870A-EXIT.                                                      
           EXIT.                                                        
      *                                                                 02840000
       4870B-GET-METER-DATA.                                            
      *                                                                 02860000
           PERFORM 7150-OPEN-DAILY-METER-VOLUME     THRU 7150-EXIT.     
           PERFORM 7160-FETCH-DAILY-METER-VOLUME    THRU 7160-EXIT.     
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 4870C-LOAD-METER-DETAILS      THRU 4870C-EXIT     
              PERFORM 7160-FETCH-DAILY-METER-VOLUME THRU 7160-EXIT      
           END-PERFORM.                                                 
           PERFORM 7170-CLOSE-DAILY-METER-VOLUME    THRU 7170-EXIT.     
      *                                                                 02940000
       4870B-EXIT.                                                      
           EXIT.                                                        
      *                                                                 02970000
       4870C-LOAD-METER-DETAILS.                                        
      *                                                                 02990000
      *    MOVE WS-DATE-READ-CX(WS-CX-SUB1) TO WS-TP-DATE-READ.         03000000
      *    MOVE WS-TP-DATE-READ-DD          TO WS-VOL-SUB1.             03001000
           MOVE CX-DATE-READ                TO WS-TP-DATE-READ.         
           MOVE WS-TP-DATE-READ-DD          TO WS-VOL-SUB1.             
      * THE UNITS ARE IN CCF AND CONVERT THEM TO MCF BEFORE LOADING     03010000
      * THE DATA.                                                       03020000
           MOVE CX-NO-UNITS                 TO WS-TP-NO-UNITS.          
           IF CX-CODE-DEBIT-CREDIT = 'C'                                
              COMPUTE WS-TP-NO-UNITS = WS-TP-NO-UNITS * -1              
           END-IF.                                                      
           COMPUTE  WS-TP-NO-UNITS ROUNDED = WS-TP-NO-UNITS / 10.       
           MOVE WS-TP-NO-UNITS              TO WS-DISPLAY-UNITS.        
           ADD  WS-TP-NO-UNITS              TO                          
                WS-TRANSPORT-CHRG-TOT-AMT(WS-VOL-SUB).                  
           MOVE WS-DISPLAY-UNITS            TO                          
                WS-TRANSPORT-CHRG-DAY(WS-VOL-SUB, WS-VOL-SUB1).         
      *    MOVE WS-NO-UNITS-CX(WS-CX-SUB1)  TO WS-TP-NO-UNITS.          03060000
      *    COMPUTE  WS-TP-NO-UNITS  = WS-TP-NO-UNITS / 10.              03070000
      *    MOVE WS-TP-NO-UNITS              TO WS-DISPLAY-UNITS.        03071000
      *    ADD  WS-TP-NO-UNITS              TO                          03072000
      *         WS-TRANSPORT-CHRG-TOT-AMT(WS-VOL-SUB).                  03073000
      *    MOVE WS-DISPLAY-UNITS            TO                          03074000
      *         WS-TRANSPORT-CHRG-DAY(WS-VOL-SUB, WS-VOL-SUB1).         03075000
      *                                                                 03080000
       4870C-EXIT.                                                      
           EXIT.                                                        
      *                                                                 03110000
       4871-METER-TOTALS.                                               
      *                                                                 03130000
           MOVE WS-COMPANY-NO-AT                TO X8-COMPANY-NO.       
           MOVE WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX)                   
                                                TO X8-CODE-UTIL-TYPE.   
           MOVE  20                             TO X8-VOL-GROUP-CD.     
           PERFORM 7000-OPEN-VOL-HDR THRU 7000-EXIT.                    
           PERFORM 7010-FETCH-VOL-HDR THRU 7010-EXIT.                   
           PERFORM UNTIL  WS-ACTIVE-RETURN-CODE = NOT-FOUND             
              PERFORM 4866-LOAD-VOL-HEADING THRU 4866-EXIT              
              MOVE 'N'                      TO WS-VOL-DLY-DATA-SW       
              PERFORM 4867-GET-VOLUME-DLY   THRU 4867-EXIT              
              IF WS-VOL-DLY-DATA-SW = 'N' AND WS-VOL-SUB > 0            
                 MOVE ' '                   TO                          
                                       WS-LOAD-VOL-DATA(WS-VOL-SUB)     
                 COMPUTE WS-VOL-SUB = WS-VOL-SUB - 1                    
              END-IF                                                    
              PERFORM 7010-FETCH-VOL-HDR    THRU 7010-EXIT              
           END-PERFORM.                                                 
           PERFORM 7020-CLOSE-VOL-HDR       THRU 7020-EXIT.             
      *                                                                 03260000
       4871-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03290000
       4872-VOLUME-BLK.                                                 
           MOVE WS-COMPANY-NO-AT                TO X8-COMPANY-NO.       
           MOVE WS-CODE-UTIL-TYPE-BG(WS-BILLING-INDX)                   
                                                TO X8-CODE-UTIL-TYPE.   
           MOVE  30                             TO X8-VOL-GROUP-CD.     
           PERFORM 7000-OPEN-VOL-HDR THRU 7000-EXIT.                    
           PERFORM 7010-FETCH-VOL-HDR THRU 7010-EXIT.                   
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE 'N'                          TO WS-DAILY-COMP-SW     
              PERFORM 4873-LOAD-VOL-HEADING THRU 4873-EXIT              
              PERFORM 4866-LOAD-VOL-HEADING      THRU 4866-EXIT         
              MOVE 'N'                          TO WS-VOL-DLY-DATA-SW   
              IF WS-DAILY-COMP-SW  = 'Y'                                
                 COMPUTE WS-VOL-SUB = WS-VOL-SUB - 1                    
                 PERFORM 4873E-DAILY-COMP      THRU 4873E-EXIT          
              ELSE                                                      
                 PERFORM 4867-GET-VOLUME-DLY        THRU 4867-EXIT      
                 IF WS-VOL-DLY-DATA-SW = 'N' AND WS-VOL-SUB > 0         
                    MOVE ' '                TO                          
                                       WS-LOAD-VOL-DATA(WS-VOL-SUB)     
                    COMPUTE WS-VOL-SUB = WS-VOL-SUB - 1                 
                 END-IF                                                 
              END-IF                                                    
              PERFORM 7010-FETCH-VOL-HDR          THRU 7010-EXIT        
           END-PERFORM.                                                 
           PERFORM 7020-CLOSE-VOL-HDR             THRU 7020-EXIT.       
      *                                                                 03430000
       4872-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03460000
       4873-LOAD-VOL-HEADING.                                           
      *                                                                 03480000
           MOVE X8-COLUMN-HEADER1           TO WS-HOLD-HEADER.          
           PERFORM 4873A-CHECK-FOR-RATE-CAT-PRICE THRU 4873A-EXIT.      
           MOVE WS-HOLD-HEADER              TO X8-COLUMN-HEADER1.       
           MOVE X8-COLUMN-HEADER2           TO WS-HOLD-HEADER           
           PERFORM 4873A-CHECK-FOR-RATE-CAT-PRICE THRU 4873A-EXIT.      
           MOVE WS-HOLD-HEADER              TO X8-COLUMN-HEADER2.       
           MOVE X8-COLUMN-HEADER3           TO WS-HOLD-HEADER           
           PERFORM 4873A-CHECK-FOR-RATE-CAT-PRICE THRU 4873A-EXIT.      
           MOVE WS-HOLD-HEADER              TO X8-COLUMN-HEADER3.       
           MOVE X8-COLUMN-HEADER4           TO WS-HOLD-HEADER           
           PERFORM 4873A-CHECK-FOR-RATE-CAT-PRICE THRU 4873A-EXIT.      
           MOVE WS-HOLD-HEADER              TO X8-COLUMN-HEADER4.       
      *                                                                 03610000
       4873-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03640000
       4873A-CHECK-FOR-RATE-CAT-PRICE.                                  
      *                                                                 03660000
           EVALUATE WS-HOLD-HEADER                                      
               WHEN WS-RATE                                             
                    PERFORM 4873B-GET-RATE         THRU 4873B-EXIT      
               WHEN WS-CAT                                              
                    PERFORM 4873C-GET-CAT          THRU 4873C-EXIT      
               WHEN WS-PRICE                                            
                    PERFORM 4873D-GET-PRICE        THRU 4873D-EXIT      
           END-EVALUATE.                                                
      *                                                                 03750000
       4873A-EXIT.                                                      
            EXIT.                                                       
      *                                                                 03780000
       4873B-GET-RATE.                                                  
      *                                                                 03800000
            MOVE SPACES                        TO WS-EMB-INPUT          
                                                  WS-CMP-TABLE.         
            STRING 'RATE '                                              
                   WS-RATE-PLAN-NO-BG(WS-BILLING-INDX)                  
              DELIMITED BY SIZE                                         
              INTO WS-EMB-INPUT.                                        
            MOVE 8                         TO WS-EMB-LENG.              
            PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT.         
            MOVE WS-CMP-TABLE              TO WS-HOLD-HEADER.           
      *                                                                 03820000
       4873B-EXIT.                                                      
            EXIT.                                                       
      *                                                                 03850000
       4873C-GET-CAT.                                                   
      *                                                                 03870000
            IF WS-CODE-CURTAIL-PRTY-BG(WS-BILLING-INDX) > 0             
               MOVE WS-CODE-CURTAIL-PRTY-BG(WS-BILLING-INDX)            
                                           TO Z4-CODE-CURTAIL-PRTY      
               MOVE WS-COMPANY-NO-AT       TO Z4-COMPANY-NO             
               PERFORM 7200-GET-SVC-CAT    THRU 7200-EXIT               
               MOVE SPACES                 TO WS-EMB-INPUT              
                                              WS-CMP-TABLE              
               STRING 'CATEGORY '                                       
                      Z4-PRTY-SVC-CAT-CD                                
                 DELIMITED BY SIZE                                      
                 INTO WS-EMB-INPUT                                      
               MOVE 11                     TO WS-EMB-LENG               
               PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT       
               MOVE WS-CMP-TABLE           TO WS-HOLD-HEADER            
            ELSE                                                        
               MOVE SPACES                 TO WS-HOLD-HEADER            
            END-IF.                                                     
      *                                                                 03930000
       4873C-EXIT.                                                      
            EXIT.                                                       
      *                                                                 03960000
       4873D-GET-PRICE.                                                 
      *                                                                 03980000
           PERFORM VARYING WS-FH-HIST-INDX FROM 1 BY 1 UNTIL            
              WS-FH-HIST-INDX > 200 OR                                  
             WS-ACCOUNT-NO-FH (WS-FH-HIST-INDX) = ZERO                  
             IF WS-ACCOUNT-NO-FH (WS-FH-HIST-INDX) =                    
                              WS-ACCOUNT-NO-BG (WS-BILLING-INDX) AND    
                WS-BILL-NO-FH (WS-FH-HIST-INDX) =                       
                                 WS-BILL-NO-BG (WS-BILLING-INDX) AND    
                WS-CODE-UTIL-TYPE-FH (WS-FH-HIST-INDX) =                
                          WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) AND    
                WS-IC-NO-FH (WS-FH-HIST-INDX) =                         
                                   WS-IC-NO-BG (WS-BILLING-INDX) AND    
                WS-BILL-ITEM-TIMESTMP-FH (WS-FH-HIST-INDX) =            
                      WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX) AND    
                WS-FACTOR-ID-FH (WS-FH-HIST-INDX) = 'COMPPRICE'         
                   MOVE WS-FACTOR-FH(WS-FH-HIST-INDX)                   
                                                   TO WS-TP-FACTOR      
                   MOVE WS-TP-FACTOR               TO WS-DISP-FCT       
                   MOVE SPACES                     TO WS-EMB-INPUT      
                                                      WS-CMP-TABLE      
                   STRING '$'                                           
                          WS-DISP-FCT                                   
                     DELIMITED BY SIZE                                  
                     INTO WS-EMB-INPUT                                  
                   MOVE 16                         TO WS-EMB-LENG       
                   PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT   
                   MOVE WS-CMP-TABLE               TO WS-HOLD-HEADER    
                   IF WS-EFF-DATE-FROM-FH(WS-FH-HIST-INDX) =            
                      WS-EFF-DATE-TO-FH(WS-FH-HIST-INDX)                
                      MOVE 'Y'                     TO WS-DAILY-COMP-SW  
                   ELSE                                                 
                      MOVE 'N'                     TO WS-DAILY-COMP-SW  
                      GO TO 4873D-EXIT                                  
                   END-IF                                               
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                 03991600
       4873D-EXIT.                                                      
            EXIT.                                                       
      *                                                                 04010000
       4873E-DAILY-COMP.                                                
      *                                                                 04010200
           PERFORM VARYING WS-FH-HIST-INDX FROM 1 BY 1 UNTIL            
              WS-FH-HIST-INDX > 200 OR                                  
             WS-ACCOUNT-NO-FH (WS-FH-HIST-INDX) = ZERO                  
             IF WS-ACCOUNT-NO-FH (WS-FH-HIST-INDX) =                    
                              WS-ACCOUNT-NO-BG (WS-BILLING-INDX) AND    
                WS-BILL-NO-FH (WS-FH-HIST-INDX) =                       
                                 WS-BILL-NO-BG (WS-BILLING-INDX) AND    
                WS-CODE-UTIL-TYPE-FH (WS-FH-HIST-INDX) =                
                          WS-CODE-UTIL-TYPE-BG (WS-BILLING-INDX) AND    
                WS-IC-NO-FH (WS-FH-HIST-INDX) =                         
                                   WS-IC-NO-BG (WS-BILLING-INDX) AND    
                WS-BILL-ITEM-TIMESTMP-FH (WS-FH-HIST-INDX) =            
                      WS-BILL-ITEM-TIMESTMP-BG (WS-BILLING-INDX) AND    
                WS-FACTOR-ID-FH (WS-FH-HIST-INDX) = 'COMPPRICE'         
                   MOVE WS-FACTOR-FH(WS-FH-HIST-INDX)                   
                                                   TO WS-TP-FACTOR      
                   MOVE WS-TP-FACTOR               TO WS-DISP-FCT       
                   MOVE SPACES                     TO WS-EMB-INPUT      
                                                      WS-CMP-TABLE      
                   STRING '$'                                           
                          WS-DISP-FCT                                   
                     DELIMITED BY SIZE                                  
                     INTO WS-EMB-INPUT                                  
                   MOVE 16                         TO WS-EMB-LENG       
                   PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6011-EXIT   
                   MOVE WS-CMP-TABLE               TO WS-HOLD-HEADER    
                                                   X8-COLUMN-HEADER4    
                   PERFORM 4866-LOAD-VOL-HEADING   THRU 4866-EXIT       
                   PERFORM 4873F-LOAD-DAILY-COMP   THRU 4873F-EXIT      
             END-IF                                                     
           END-PERFORM.                                                 
      *                                                                 04013500
       4873E-EXIT.                                                      
           EXIT.                                                        
      *                                                                 04014000
       4873F-LOAD-DAILY-COMP.                                           
      *                                                                 04016000
           MOVE WS-EFF-DATE-FROM-FH(WS-FH-HIST-INDX)                    
                                            TO WS-TP-DATE-READ.         
           MOVE WS-TP-DATE-READ-DD          TO WS-VOL-SUB1.             
           MOVE WS-BILL-UNITS-FH(WS-FH-HIST-INDX)                       
                                            TO WS-ND-NO-UNITS.          
           IF X8-ACCUM-TOTAL-FL = 'Y'                                   
              ADD WS-BILL-UNITS-FH(WS-FH-HIST-INDX)  TO                 
                WS-TRANSPORT-CHRG-TOT-AMT(WS-VOL-SUB)                   
           END-IF.                                                      
           MOVE WS-ND-NO-UNITS              TO                          
                WS-TRANSPORT-CHRG-DAY(WS-VOL-SUB, WS-VOL-SUB1).         
      *                                                                 04020200
       4873F-EXIT.                                                      
           EXIT.                                                        
      *                                                                 04020500
       7000-OPEN-VOL-HDR.                                               
      *                                                                 04030000
           EXEC SQL                                                     
               OPEN VOL_TYPE                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04070000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-DISPLAY-SQLCODE.    
      *                                                                 04100000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' ** ERROR IN 7000-OPEN-VOL-HDR'                  
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON OPEN   '                            
              DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE             
              DISPLAY ' ** TABLE   -  CSS_VOL_TYPE '                    
              DISPLAY ' ** KEY IS  '                                    
              DISPLAY ' ** X8.VOL_GROUP_CD   'X8-VOL-GROUP-CD           
              DISPLAY ' ** X8.COMPANY_NO     'X8-COMPANY-NO             
              DISPLAY ' ** X8.CODE_UTIL_TYPE 'X8-CODE-UTIL-TYPE         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 04250000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04280000
       7010-FETCH-VOL-HDR.                                              
      *                                                                 04300000
           EXEC SQL                                                     
               FETCH VOL_TYPE                                           
                INTO :X8-VOL-GROUP-CD                                   
                    ,:X8-VOL-TYPE-CD                                    
                    ,:X8-ENERGY-UNIT-CD                                 
                    ,:X8-CMPNT-ID-CD                                    
                    ,:X8-MANUAL-ENTRY-FL                                
                    ,:X8-ACCUM-TOTAL-FL                                 
                    ,:X8-COLUMN-HEADER1                                 
                    ,:X8-COLUMN-HEADER2                                 
                    ,:X8-COLUMN-HEADER3                                 
                    ,:X8-COLUMN-HEADER4                                 
                    ,:X8-STATUS-CD                                      
                    ,:X8-STATUS-CHANGE-DT                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04460000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-DISPLAY-SQLCODE.    
      *                                                                 04490000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' ** ERROR IN 7010-FETCH-VOL-HDR'                 
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON FETCH  '                            
              DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE             
              DISPLAY ' ** TABLE   -  CSS_VOL_TYPE '                    
              DISPLAY ' ** KEY IS  '                                    
              DISPLAY ' ** X8.VOL_GROUP_CD   'X8-VOL-GROUP-CD           
              DISPLAY ' ** X8.COMPANY_NO     'X8-COMPANY-NO             
              DISPLAY ' ** X8.CODE_UTIL_TYPE 'X8-CODE-UTIL-TYPE         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 04640000
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04670000
       7020-CLOSE-VOL-HDR.                                              
      *                                                                 04690000
           EXEC SQL                                                     
               CLOSE VOL_TYPE                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04730000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-DISPLAY-SQLCODE.    
      *                                                                 04760000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' ** ERROR IN 7020-CLOSE-VOL-HDR'                 
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON CLOSE  '                            
              DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE             
              DISPLAY ' ** TABLE   -  CSS_VOL_TYPE '                    
              DISPLAY ' ** KEY IS  '                                    
              DISPLAY ' ** X8.VOL_GROUP_CD   'X8-VOL-GROUP-CD           
              DISPLAY ' ** X8.COMPANY_NO     'X8-COMPANY-NO             
              DISPLAY ' ** X8.CODE_UTIL_TYPE 'X8-CODE-UTIL-TYPE         
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 04910000
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04940000
       7050-OPEN-TRANS-TOT.                                             
      *                                                                 04960000
           EXEC SQL                                                     
               OPEN VOL_DAILY                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05000000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-DISPLAY-SQLCODE.    
      *                                                                 05030000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' ** ERROR IN 7050-OPEN-TRANS-TOT'                
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON OPEN   '                            
              DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE             
              DISPLAY ' ** TABLE   -  CSS_VOL_DAILY '                   
              DISPLAY ' ** KEY IS  '                                    
              DISPLAY ' ** ND.ACCOUNT_NO         'ND-ACCOUNT-NO         
              DISPLAY ' ** ND.BILL_NO            'ND-BILL-NO            
              DISPLAY ' ** ND.CODE_UTIL_TYPE     'ND-CODE-UTIL-TYPE     
              DISPLAY ' ** ND.BILL_ITEM_TIMESTMP '                      
                                              ND-BILL-ITEM-TIMESTMP     
              DISPLAY ' ** ND.VOL_TYPE_CD        'ND-VOL-TYPE-CD        
              DISPLAY ' ** ND.ENERGY_UNIT_CD     'ND-ENERGY-UNIT-CD     
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 05220000
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05250000
       7060-FETCH-TRANS-TOT.                                            
      *                                                                 05270000
           EXEC SQL                                                     
               FETCH VOL_DAILY                                          
                INTO :ND-NO-UNITS                                       
                    ,:ND-DATE-READ                                      
                    ,:ND-FIXED-FCTR-SEQ-NO                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05340000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-DISPLAY-SQLCODE.    
      *                                                                 05370000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' ** ERROR IN 7060-FETCH-TRANS-TOT'               
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON FETCH  '                            
              DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE             
              DISPLAY ' ** TABLE   -  CSS_VOL_DAILY '                   
              DISPLAY ' ** KEY IS  '                                    
              DISPLAY ' ** ND.ACCOUNT_NO         'ND-ACCOUNT-NO         
              DISPLAY ' ** ND.BILL_NO            'ND-BILL-NO            
              DISPLAY ' ** ND.CODE_UTIL_TYPE     'ND-CODE-UTIL-TYPE     
              DISPLAY ' ** ND.BILL_ITEM_TIMESTMP '                      
                                              ND-BILL-ITEM-TIMESTMP     
              DISPLAY ' ** ND.VOL_TYPE_CD        'ND-VOL-TYPE-CD        
              DISPLAY ' ** ND.ENERGY_UNIT_CD     'ND-ENERGY-UNIT-CD     
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 05560000
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05590000
       7070-CLOSE-TRANS-TOT.                                            
      *                                                                 05610000
           EXEC SQL                                                     
               CLOSE VOL_DAILY                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05650000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-DISPLAY-SQLCODE.    
      *                                                                 05680000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' ** ERROR IN 7070-CLOSE-TRANS-TOT'               
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON CLOSE  '                            
              DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE             
              DISPLAY ' ** TABLE   -  CSS_VOL_DAILY '                   
              DISPLAY ' ** KEY IS  '                                    
              DISPLAY ' ** ND.ACCOUNT_NO         'ND-ACCOUNT-NO         
              DISPLAY ' ** ND.BILL_NO            'ND-BILL-NO            
              DISPLAY ' ** ND.CODE_UTIL_TYPE     'ND-CODE-UTIL-TYPE     
              DISPLAY ' ** ND.BILL_ITEM_TIMESTMP '                      
                                              ND-BILL-ITEM-TIMESTMP     
              DISPLAY ' ** ND.VOL_TYPE_CD        'ND-VOL-TYPE-CD        
              DISPLAY ' ** ND.ENERGY_UNIT_CD     'ND-ENERGY-UNIT-CD     
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 05870000
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05900000
       7100-OPEN-METER-HDR.                                             
      *                                                                 05920000
           EXEC SQL                                                     
               OPEN DAILY_METERS                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05960000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-DISPLAY-SQLCODE.    
      *                                                                 05990000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' ** ERROR IN 7100-OPEN-METER-HDR'                
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON OPEN   '                            
              DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE             
              DISPLAY ' ** TABLE   -  CSS_CNSMPTN_HIST '                
              DISPLAY ' ** KEY IS  '                                    
              DISPLAY ' ** ACCOUNT_NO         'CX-ACCOUNT-NO            
              DISPLAY ' ** BILL_NO            'CX-BILL-NO               
              DISPLAY ' ** CODE_UTIL_TYPE     'CX-CODE-UTIL-TYPE        
              DISPLAY ' ** IC_NO              'CX-IC-NO                 
      *       DISPLAY ' ** BILL_ITEM_TIMESTMP 'CX-BILL-ITEM-TIMESTMP    06130000
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 06160000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06190000
       7110-FETCH-METER-HDR.                                            
      *                                                                 06210000
           EXEC SQL                                                     
               FETCH DAILY_METERS                                       
                INTO :CX-METER-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 06260000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-DISPLAY-SQLCODE.    
      *                                                                 06290000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' ** ERROR IN 7110-FETCH-METER-HDR'               
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON FETCH  '                            
              DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE             
              DISPLAY ' ** TABLE   -  CSS_CNSMPTN_HIST '                
              DISPLAY ' ** KEY IS  '                                    
              DISPLAY ' ** ACCOUNT_NO         'CX-ACCOUNT-NO            
              DISPLAY ' ** BILL_NO            'CX-BILL-NO               
              DISPLAY ' ** CODE_UTIL_TYPE     'CX-CODE-UTIL-TYPE        
              DISPLAY ' ** IC_NO              'CX-IC-NO                 
      *       DISPLAY ' ** BILL_ITEM_TIMESTMP 'CX-BILL-ITEM-TIMESTMP    06430000
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 06460000
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06490000
       7120-CLOSE-METER-HDR.                                            
      *                                                                 06510000
           EXEC SQL                                                     
               CLOSE DAILY_METERS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 06550000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-DISPLAY-SQLCODE.    
      *                                                                 06580000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' ** ERROR IN 7120-CLOSE-METER-HDR'               
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON CLOSE  '                            
              DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE             
              DISPLAY ' ** TABLE   -  CSS_CNSMPTN_HIST '                
              DISPLAY ' ** KEY IS  '                                    
              DISPLAY ' ** ACCOUNT_NO         'CX-ACCOUNT-NO            
              DISPLAY ' ** BILL_NO            'CX-BILL-NO               
              DISPLAY ' ** CODE_UTIL_TYPE     'CX-CODE-UTIL-TYPE        
              DISPLAY ' ** IC_NO              'CX-IC-NO                 
      *       DISPLAY ' ** BILL_ITEM_TIMESTMP 'CX-BILL-ITEM-TIMESTMP    06720000
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 06750000
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06780000
       7150-OPEN-DAILY-METER-VOLUME.                                    
      *                                                                 06800000
           EXEC SQL                                                     
               OPEN DAILY_METER_VOLUME                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 06840000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-DISPLAY-SQLCODE.    
      *                                                                 06870000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' ** ERROR IN 7150-OPEN-DAILY-METER-VOLUME'       
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON OPEN   '                            
              DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE             
              DISPLAY ' ** TABLE   -  CSS_CNSMPTN_HIST '                
              DISPLAY ' ** KEY IS  '                                    
              DISPLAY ' ** ACCOUNT_NO         'CX-ACCOUNT-NO            
              DISPLAY ' ** BILL_NO            'CX-BILL-NO               
              DISPLAY ' ** CODE_UTIL_TYPE     'CX-CODE-UTIL-TYPE        
              DISPLAY ' ** IC_NO              'CX-IC-NO                 
              DISPLAY ' ** BILL_ITEM_TIMESTMP 'CX-BILL-ITEM-TIMESTMP    
              DISPLAY ' ** METER_NO           'CX-METER-NO              
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 07050000
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07080000
       7160-FETCH-DAILY-METER-VOLUME.                                   
      *                                                                 07100000
           EXEC SQL                                                     
               FETCH DAILY_METER_VOLUME                                 
                INTO :CX-NO-UNITS                                       
                   , :CX-DATE-READ                                      
                   , :CX-CODE-DEBIT-CREDIT                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07160000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-DISPLAY-SQLCODE.    
      *                                                                 07190000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' ** ERROR IN 7160-FETCH-DAILY-METER-VOLUME'      
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON FETCH  '                            
              DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE             
              DISPLAY ' ** TABLE   -  CSS_CNSMPTN_HIST '                
              DISPLAY ' ** KEY IS  '                                    
              DISPLAY ' ** ACCOUNT_NO         'CX-ACCOUNT-NO            
              DISPLAY ' ** BILL_NO            'CX-BILL-NO               
              DISPLAY ' ** CODE_UTIL_TYPE     'CX-CODE-UTIL-TYPE        
              DISPLAY ' ** IC_NO              'CX-IC-NO                 
              DISPLAY ' ** BILL_ITEM_TIMESTMP 'CX-BILL-ITEM-TIMESTMP    
              DISPLAY ' ** METER_NO           'CX-METER-NO              
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 07370000
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07400000
       7170-CLOSE-DAILY-METER-VOLUME.                                   
      *                                                                 07420000
           EXEC SQL                                                     
               CLOSE DAILY_METER_VOLUME                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07460000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-DISPLAY-SQLCODE.    
      *                                                                 07490000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' ** ERROR IN 7170-CLOSE-DAILY-METER-VOLUME'      
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON CLOSE  '                            
              DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE             
              DISPLAY ' ** TABLE   -  CSS_CNSMPTN_HIST '                
              DISPLAY ' ** KEY IS  '                                    
              DISPLAY ' ** ACCOUNT_NO         'CX-ACCOUNT-NO            
              DISPLAY ' ** BILL_NO            'CX-BILL-NO               
              DISPLAY ' ** CODE_UTIL_TYPE     'CX-CODE-UTIL-TYPE        
              DISPLAY ' ** IC_NO              'CX-IC-NO                 
              DISPLAY ' ** BILL_ITEM_TIMESTMP 'CX-BILL-ITEM-TIMESTMP    
              DISPLAY ' ** METER_NO           'CX-METER-NO              
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 07670000
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07700000
       7200-GET-SVC-CAT.                                                
      *                                                                 07720000
            EXEC SQL                                                    
                SELECT PRTY_SVC_CAT_CD                                  
                  INTO :Z4-PRTY-SVC-CAT-CD                              
                  FROM CSS_PRTY_SVC_CAT Z4 WITH(READUNCOMMITTED)                
                 WHERE Z4.COMPANY_NO        = :Z4-COMPANY-NO            
                   AND Z4.CODE_CURTAIL_PRTY = :Z4-CODE-CURTAIL-PRTY     
T34097                                                           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    07730000
MFA-TR*         SELECT PRTY_SVC_CAT_CD                                  07740000
MFA-TR*           INTO :Z4-PRTY-SVC-CAT-CD                              07750000
MFA-TR*           FROM CSS_PRTY_SVC_CAT Z4                              07760000
MFA-TR*          WHERE Z4.COMPANY_NO        = :Z4-COMPANY-NO            07770000
MFA-TR*            AND Z4.CODE_CURTAIL_PRTY = :Z4-CODE-CURTAIL-PRTY     07780000
MFA-TR*           WITH UR                                               07781000
MFA-TR*     END-EXEC.                                                   07790000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07800000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-DISPLAY-SQLCODE.    
      *                                                                 07830000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE SPACES               TO Z4-PRTY-SVC-CAT-CD     
               WHEN OTHER                                               
                    DISPLAY ' ** ERROR IN 7200-GET-SVC-CAT'             
                    DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'      
                    DISPLAY ' ** ERROR ON SELECT '                      
                    DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE       
                    DISPLAY ' ** TABLE   -  CSS_PRTY_SVC_CAT '          
                    DISPLAY ' ** KEY IS  '                              
                    DISPLAY ' ** COMPANY_NO        'Z4-COMPANY-NO       
                    DISPLAY ' ** CODE_CURTAIL_PRTY 'Z4-CODE-CURTAIL-PRTY
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
      *                                                                 07970000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07991000
       7300-GET-TIME-STAMP.                                             
      *                                                                 08001000
            EXEC SQL                                                    
T34097        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MICROSECOND, 
              1, CIS.CHAR2TIMESTAMP(:ND-BILL-ITEM-TIMESTMP) ), 121), 
           ' ', '-'), ':', '.')
            INTO
              :ND-BILL-ITEM-TIMESTMP    
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                    08002000
MFA-TR*       SET :ND-BILL-ITEM-TIMESTMP  =                             08002100
MFA-TR*            TIMESTAMP(:ND-BILL-ITEM-TIMESTMP) + 1 MICROSECOND    08002200
MFA-TR*     END-EXEC.                                                   08007000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08007100
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-DISPLAY-SQLCODE.    
      *                                                                 08007400
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              DISPLAY ' ** ERROR IN 7300-GET-TIME-STAMP '               
              DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'            
              DISPLAY ' ** ERROR ON SET'                                
              DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE             
              DISPLAY ' ** KEY IS  '                                    
              PERFORM 9900-ABEND THRU 9900-EXIT                         
           END-IF.                                                      
      *                                                                 08008800
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08030000
       7310-GET-PRIMARY-IC.                                             
      *                                                                 08050000
           EXEC SQL                                                     
               SELECT DISTINCT PRIMARY_IC_NO                            
                 INTO :UZ-PRIMARY-IC-NO                                 
                 FROM CSS_TRNSP_VOL_HIST WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO          = :UZ-ACCOUNT-NO              
                  AND BILL_NO             = :UZ-BILL-NO                 
                  AND CODE_UTIL_TYPE      = :UZ-CODE-UTIL-TYPE          
                  AND BILL_ITEM_TIMESTMP  = CIS.CHAR2TIMESTAMP(
                                                 :UZ-BILL-ITEM-TIMESTMP
              )      
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08060000
MFA-TR*        SELECT DISTINCT PRIMARY_IC_NO                            08070000
MFA-TR*          INTO :UZ-PRIMARY-IC-NO                                 08080000
MFA-TR*          FROM CSS_TRNSP_VOL_HIST                                08090000
MFA-TR*         WHERE ACCOUNT_NO          = :UZ-ACCOUNT-NO              08100000
MFA-TR*           AND BILL_NO             = :UZ-BILL-NO                 08110000
MFA-TR*           AND CODE_UTIL_TYPE      = :UZ-CODE-UTIL-TYPE          08120000
MFA-TR*           AND BILL_ITEM_TIMESTMP  = :UZ-BILL-ITEM-TIMESTMP      08130000
MFA-TR*          WITH UR                                                08131000
MFA-TR*    END-EXEC.                                                    08140000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08150000
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-DISPLAY-SQLCODE.    
      *                                                                 08180000
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE 'Y'                  TO WS-BASE-RATE-RECS-SW   
               WHEN NOT-FOUND                                           
                    MOVE 'N'                  TO WS-BASE-RATE-RECS-SW   
               WHEN OTHER                                               
                    DISPLAY ' ** ERROR IN 7310-GET-PRIMARY-IC'          
                    DISPLAY ' ** ' WS-PGRMNAME ' PROCESSING ERROR'      
                    DISPLAY ' ** ERROR ON SELECT '                      
                    DISPLAY ' ** RETURN CODE ' WS-DISPLAY-SQLCODE       
                    DISPLAY ' ** TABLE   -  CSS_TRNSP_VOL_HIST'         
                    DISPLAY ' ** KEY IS  '                              
                    DISPLAY ' ** ACCOUNT_NO         'UZ-ACCOUNT-NO      
                    DISPLAY ' ** BILL_NO            'UZ-BILL-NO         
                    DISPLAY ' ** CODE_UTIL_TYPE     'UZ-CODE-UTIL-TYPE  
                    DISPLAY ' ** IC_NO              'UZ-IC-NO           
                    DISPLAY ' ** BILL_ITEM_TIMESTMP '                   
                                                UZ-BILL-ITEM-TIMESTMP   
                    PERFORM 9900-ABEND THRU 9900-EXIT                   
           END-EVALUATE.                                                
      *                                                                 08330000
       7310-EXIT.                                                       
           EXIT.                                                        
