      *****************************************************************         
      ** CPD00065                                                    **         
      ** THIS COPY STATEMENT CONTAINS THE PROCEDURE DIVISION         **         
      ** STATEMENTS NECESSARY TO CREATE A NEW FACTOR ID.             **         
      **.............................................................**         
      ** WS-REFERENCE : CWS00065                                     **         
      **                                                             **         
      ** PREREQUISITES: THE WORKING STORAGE VARIABLES SHOULD BE      **         
      **                POPULATED PRIOR TO INVOKING THIS ROUTINE     **         
      *****************************************************************         
      ** INPUT : WS-CPD65-ACCOUNT-NO                                 **         
      **         WS-CPD65-CODE-UTIL-TYPE                             **         
      **         WS-CPD65-IC-NO                                      **         
      **         WS-CPD65-FACTOR-ID                                  **         
      **         WS-CPD65-CALLING-PGM   <---- OPTIONAL               **         
      **         WS-CPD65-FACTOR        <---- OPTIONAL               **         
      **         WS-CPD65-DUR-REMAIN-NO <---- OPTIONAL               **         
PRJ738**         WS-CPD65-USER-ID       <---- OPTIONAL               **         
      **                                                             **         
      ** OUTPUT: INSERTS A ROW IN THE FIXED FACTOR TABLE             **         
      *****************************************************************         
      **                                                             **         
      **              COPYBOOK MODIFICATION  LOG                     **         
      **              --------------------------                     **         
      **    DATE    INITIALS   REASON                                **         
      **  --------  --------   ------                                **         
      **  03/19/09  SS95855    COPYBOOK ORIGINALLY WRITTEN.          **         
      **  08/26/10  GOKUL      DSM RIDER CHANGES.                    **         
PRJ430**  10/22/10  SB93596    CSR04262 CHGS FOR INSERTING THE ROW   **         
PRJ430**                       INTO CSS_ACCT_ATTRIBUTE WHEN DSM      **         
PRJ430**                       EXEMPT LISTBOX IS MADE ENABLED/DISABLED*         
P00473**  05/17/11  SB93596    CHGS INCLUDED TO PULL APPROVED        **         
P00473**                       OPTION ATTR INCTV RECORDS.            **         
P680PN**  05/13/13  SS97726    INSERT/UPDATE DDC FACTOR TO MATCH THE **         
P680PN**                       BBP AMOUNT QUOTED ON CRM AND BPA.     **         
P00738**  11/04/13  SS97726 1. ADD SPCL GROUP CD 'DR' FOR REDUCED    **         
P00738**                       DSM RIDER DEBIT FACTOR.               **         
P00738**                    2. COMMENT ACCT ATTRIBUTE LOGIC FOR DSM. **         
P00805**  03/27/14  SS97726    ALLOW DUP FACTOR INSERT WHEN CALLED   **         
P00805**                       FROM RATE SELECTION FOR EXIT CRED.    **         
PRJ738**  06/17/14  SS97726    ACCEPT USER ID AS ADDITIONAL INPUT.   **         
P00836**  04/30/15  SS97726    ALLOW DUP FACTOR INSERT WHEN CALLED   **         
P00836**                       FROM WEB FOR EXIT FEE CREDIT.         **         
ACT074**  02/29/16  SS7F226    ADD LOGIC TO SKIP THE EXIT FEE IF THE **         
ACT074**            A05460     CUSTOMER IS IN 120DAYS GRACE PERIOD   **         
ACT074**                       AND DELETED THE COMMENTED CODE.       **         
OTPOOL**  08/01/16  SS45239    DO NOT CHARGE EXIT FEE FOR OUTER POOL **         
OTPOOL**            P00805     CUSTOMERS FOR MKSW/SONP IN RENEWAL.   **         
      *****************************************************************         
       0100-MAIN-PROCESS.                                               
                                                                        
           PERFORM 1000-INITIALIZE-PROCEDURE THRU 1000-EXIT.            
           PERFORM 1200-VALIDATE-INPUTS      THRU 1200-EXIT.            
           PERFORM 2000-BUILD-FACTOR         THRU 2000-EXIT.            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 1000-INITIALIZE-PROCEDURE.                                 **          
      ****************************************************************          
       1000-INITIALIZE-PROCEDURE.                                       
                                                                        
           INITIALIZE LS-CPD65-RETURN-FIELDS,                           
                      WS-WORK-AREA,                                     
                      WS-SWITCHES,                                      
                      ABEND-FILE,                                       
                      DCLCSS-FIXED-FCTR,                                
                      DCLCRM-OPT-ATTR-INCTV,                            
                      DCLCSS-ACCT-RTPK-AGR,                             
                      DCLCSS-UTIL-ENVRNMT,                              
                      DCLCSS-SPCL-FCTR,                                 
                      DCLCSS-SPCL-FCTR-APPL,                            
                      DCLCSS-BILL-WINDOW,                               
                      DCLCSS-JOB-PARM,                                  
                      DCLCSS-MNT-TRANS-HIST,                            
                      DCLCSS-MT-TRN-HST-DET,                            
                      DCLCSS-DELINQUENCY.                               
                                                                        
           MOVE WS-DATABASE                 TO C8-DELINQ-CD.            
           MOVE WS-COMPANY-NO               TO C8-COMPANY-NO.           
           PERFORM 7999-GET-DELINQ-VALUE    THRU 7999-EXIT.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE C8-DELINQ-VALUE          TO WS-DATABASE-FL           
           END-IF.                                                      
                                                                        
ACT074     MOVE 90-DAY-GRACE-PERIOD         TO C8-DELINQ-CD.            
ACT074     MOVE '01'                        TO C8-COMPANY-NO.           
ACT074     PERFORM 7999-GET-DELINQ-VALUE    THRU 7999-EXIT.             
ACT074     MOVE C8-DELINQ-VALUE             TO WS-120DAY-GRACE-PERIOD.  
ACT074                                                                  
           PERFORM 7000-GET-CURR-DATE       THRU 7000-EXIT.             
                                                                        
           MOVE WS-COMMON                   TO G6-PROGRAM-NAME.         
           MOVE WS-COMPANY-NO               TO G6-COMPANY-NO.           
           MOVE WS-DATE                     TO G6-CMND-CODE.            
           MOVE WS-10                       TO G6-SEQ-NO.               
           PERFORM 7100-GET-COMMON-DATE     THRU 7100-EXIT.             
           MOVE G6-PARM-DATA(10:10)         TO WS-COMMON-DATE.          
           MOVE WS-COMMON-DATE              TO BN-DATE-EXTRACT.         
                                                                        
           PERFORM 7200-GET-MIN-REV-MTH     THRU 7200-EXIT.             
           MOVE BN-REVENUE-MONTH            TO WS-REVENUE-MONTH.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 1200-VALIDATE-INPUTS.                                      **          
      **   VALIDATE REQUIRED INPUTS AND SET APPROPRIATE FLAGS FOR   **          
      **   OPTIONAL INPUT PARMS.                                    **          
      ****************************************************************          
       1200-VALIDATE-INPUTS.                                            
                                                                        
           IF WS-CPD65-ACCOUNT-NO > 0                                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-PROGRAM               TO ABEND-PROGRAM            
              MOVE '1200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'RECEIVE'                TO ABEND-FUNCTION           
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE WS-CPD65-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
              MOVE +1000                    TO WS-CPD65-RETURN-CODE     
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
           IF WS-CPD65-CODE-UTIL-TYPE > SPACES                          
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-PROGRAM               TO ABEND-PROGRAM            
              MOVE '1210'                   TO ACTIVE-PARAGRAPH         
              MOVE 'RECEIVE'                TO ABEND-FUNCTION           
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE WS-CPD65-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
              MOVE WS-CPD65-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-2        
              MOVE +1000                    TO WS-CPD65-RETURN-CODE     
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
           IF WS-CPD65-IC-NO > ZEROES                                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-PROGRAM               TO ABEND-PROGRAM            
              MOVE '1220'                   TO ACTIVE-PARAGRAPH         
              MOVE 'RECEIVE'                TO ABEND-FUNCTION           
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-2          
              MOVE WS-CPD65-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
              MOVE WS-CPD65-IC-NO           TO HOSTVAR-ELEMENT-2        
              MOVE +1000                    TO WS-CPD65-RETURN-CODE     
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
           IF WS-CPD65-FACTOR-ID > SPACES                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-PROGRAM               TO ABEND-PROGRAM            
              MOVE '1230'                   TO ACTIVE-PARAGRAPH         
              MOVE 'RECEIVE'                TO ABEND-FUNCTION           
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-2          
              MOVE WS-CPD65-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
              MOVE WS-CPD65-FACTOR-ID       TO HOSTVAR-ELEMENT-2        
              MOVE +1000                    TO WS-CPD65-RETURN-CODE     
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
           IF WS-CPD65-FACTOR > ZEROES                                  
              MOVE WS-CPD65-FACTOR          TO FF-FACTOR                
              SET FACTOR-PASSED             TO TRUE                     
           ELSE                                                         
              SET FACTOR-NOT-PASSED         TO TRUE                     
           END-IF.                                                      
                                                                        
           IF WS-CPD65-DUR-REMAIN-NO > ZEROES                           
              MOVE WS-CPD65-DUR-REMAIN-NO   TO FF-DURATION-REMAIN-NO    
              MOVE +0                       TO WS-NULL-IND-1            
              SET DUR-REMAIN-NO-PASSED      TO TRUE                     
           ELSE                                                         
              SET DUR-REMAIN-NO-NOT-PASSED  TO TRUE                     
           END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 2000-BUILD-FACTOR.                                         **          
      **   BUILD FIXED FACTOR ROW WITH PARM VALUES AND SOME CONSTANT**          
      **   VALUES LIKE CMPNT_ID_CD, COD_SEASON AND INSTR_USE_TYPE_CD**          
      **   FACTOR START DATE IS TAKEN AS THE FIRST DAY OF THE MIN   **          
      **   OPEN REVENUE MONTH AND END DATE IS 2999-12-31.           **          
      ****************************************************************          
       2000-BUILD-FACTOR.                                               
                                                                        
           MOVE WS-CPD65-ACCOUNT-NO         TO FF-ACCOUNT-NO.           
           MOVE WS-CPD65-CODE-UTIL-TYPE     TO FF-CODE-UTIL-TYPE.       
           MOVE WS-CPD65-IC-NO              TO FF-IC-NO.                
           MOVE WS-CPD65-FACTOR-ID          TO FF-FACTOR-ID             
P00430                                         SF-FACTOR-ID.            
                                                                        
P00430     PERFORM 7900-GET-SPCL-FCTR       THRU 7900-EXIT.             
           MOVE WS-CMPNT-ID-CD              TO FF-CMPNT-ID-CD.          
           MOVE WS-CODE-SEASON              TO FF-CODE-SEASON.          
           MOVE WS-INSTR-USE-TYPE-CD        TO FF-INSTR-USE-TYPE-CD.    
           MOVE WS-FIXED-FCTR-TYP-CD        TO FF-FIXED-FCTR-TYP-CD.    
           MOVE WS-CODE-TIME-PERIOD         TO FF-CODE-TIME-PERIOD.     
           MOVE WS-FAC-CHRG-BASE-AM         TO FF-FAC-CHRG-BASE-AM.     
                                                                        
           MOVE WS-REVENUE-MONTH(1:4)       TO WS-FCTR-START-CCYY.      
           MOVE WS-REVENUE-MONTH(5:2)       TO WS-FCTR-START-MM.        
           MOVE WS-DD-01                    TO WS-FCTR-START-DD.        
           MOVE WS-SEPARATOR                TO WS-FCTR-START-SEP1,      
                                               WS-FCTR-START-SEP2.      
           MOVE WS-FCTR-START-DT            TO WS-FCTR-START-DATE.      
           MOVE WS-FCTR-START-DATE          TO FF-EFF-DATE-FROM         
                                               FF-EFF-DATE-TO.          
                                                                        
P00738     IF SF-SPCL-GROUP-CD = 'DS' OR 'DR'                           
P00430        SET FACTOR-PASSED             TO TRUE                     
P00430        MOVE WS-COMMON-DATE           TO FF-EFF-DATE-TO           
P00430     END-IF                                                       
                                                                        
                                                                        
      ** CHECK IF THE FACTOR ALREADY EXISTS                                     
           MOVE 'N'                         TO WS-FACTOR-EXISTS-FLAG.   
           PERFORM 7250-CHK-FACTOR          THRU 7250-EXIT.             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'Y'                      TO WS-FACTOR-EXISTS-FLAG    
           ELSE                                                         
              MOVE 'N'                      TO WS-FACTOR-EXISTS-FLAG    
           END-IF.                                                      
                                                                        
P00430     MOVE WS-EFF-DATE-TO              TO FF-EFF-DATE-TO.          
      ** GET THE NEXT AVAILABLE SEQUENCE NO FOR THE NEW FIXED FCTR              
           IF WS-FACTOR-EXISTS-FLAG = 'N'                               
P00805           OR WS-CPD65-CALLING-PGM = 'CSR039SR'                   
P00836           OR WS-CPD65-CALLING-PGM = 'CSR0398W'                   
              MOVE ZEROS                       TO FF-FIXED-FCTR-SEQ-NO  
              PERFORM 7300-SELECT-MAX-SEQ-NO   THRU 7300-EXIT           
              ADD +1                           TO FF-FIXED-FCTR-SEQ-NO  
                                                                        
              IF SEB-DATABASE                                           
                 PERFORM 2100-SEB-PROCESS      THRU 2100-EXIT           
              ELSE                                                      
                 PERFORM 2200-CSR-PROCESS      THRU 2200-EXIT           
              END-IF                                                    
                                                                        
P00738        IF SF-SPCL-GROUP-CD = 'DS' OR 'DR'                        
PRJ430           MOVE WS-CPD65-CODE-UTIL-TYPE                           
PRJ430                                      TO J1-CODE-UTIL-TYPE        
PRJ430           PERFORM 7910-GET-COMP-ID-CD-J1                         
PRJ430                                         THRU 7910-EXIT           
PRJ430           MOVE WS-RATE-CMPNT-ID-CD   TO FF-CMPNT-ID-CD           
P00430        END-IF                                                    
                                                                        
ACT074**** SKIP THE EXIT FEE FOR                                                
ACT074        IF SEB-DATABASE AND                                       
OTPOOL           WS-CPD65-FACTOR-ID EQUAL WS-EXIT-FEE AND               
OTPOOL**** 1. 120 GRACE PERIOD CUSTOMERS - AUTO RENEWED                         
ACT074          ( WS-RESULT-DATE > WS-CURRENT-DATE    OR                
OTPOOL**** 2. OUTER POOL DEREGULATED RESIDENTIAL CUSTOMERS IN RENEWAL           
OTPOOL            ( B1-DIVISION-NO         EQUAL 'OUT'               AND
OTPOOL              ( DD-TIER-ACCT-TYPE-CD EQUAL 'D' OR 'A' OR 'B' ) AND
OTPOOL                 ( DF-STATUS-CD      EQUAL 'O' OR 'R' ) ) )       
ACT074           CONTINUE                                               
ACT074        ELSE                                                      
ACT074           PERFORM 8000-INSERT-FACTOR    THRU 8000-EXIT           
                 PERFORM 5000-WRITE-TRAN-HIST-DET                       
                                               THRU 5000-EXIT           
ACT074        END-IF                                                    
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 2100-SEB-PROCESS.                                          **          
      ****************************************************************          
       2100-SEB-PROCESS.                                                
                                                                        
           MOVE WS-CPD65-ACCOUNT-NO         TO DF-ACCOUNT-NO            
OTPOOL                                         AT-ACCOUNT-NO            
OTPOOL                                         DD-ACCOUNT-NO.           
           MOVE WS-CPD65-CODE-UTIL-TYPE     TO DF-CODE-UTIL-TYPE        
OTPOOL                                         UT-CODE-UTIL-TYPE.       
           MOVE WS-CPD65-IC-NO              TO DF-IC-NO                 
OTPOOL                                         UT-IC-NO.                
                                                                        
OTPOOL     PERFORM 7400-GET-ACCT-DETAILS    THRU 7400-EXIT.             
OTPOOL     PERFORM 7450-GET-ACCT-MKT-TIER   THRU 7450-EXIT.             
                                                                        
           MOVE UT-RATE-PLAN-NO             TO SA-RATE-PLAN-NO          
PRJ430                                         J1-RATE-PLAN-NO.         
           MOVE WS-ACTIVE                   TO SA-CODE-STATUS.          
                                                                        
P680PN** CRM CALLS THIS ROUTINE TO INSERT DDC FACTOR FOR AN ACCOUNT FOR         
P680PN** RATE PACKAGE SEQUENCE NUMBER IS NOT NEEDED AS FACTOR IS NOT            
P680PN** ATTACHED TO THE RATE PACKAGE OPTION CODE.                              
                                                                        
P680PN     IF WS-CPD65-CALLING-PGM = 'CRM'                              
P680PN        MOVE ZEROS                    TO FF-RT-PKG-OPT-SEQ-NO     
P680PN     ELSE                                                         
              MOVE DF-RT-PKG-OPT-SEQ-NO     TO FF-RT-PKG-OPT-SEQ-NO     
P680PN     END-IF.                                                      
                                                                        
      ** BEFORE INSERTING EXIT FEE FACTOR, CHECK FOR DURATION REMAINING         
      ** > 0 FOR FP% FACTOR ID, WHICH WOULD ENSURE THAT ACCOUNT IS              
      ** CURRENTLY ON A FIXED RATE PLAN.                                        
ACT074** AND ADD GRACE PERIOD TO OPT-AGRMT-EFF-DT.                              
           IF WS-CPD65-FACTOR-ID = WS-EXIT-FEE                          
              PERFORM 7500-GET-FP-DURATION-REM THRU 7500-EXIT           
ACT074        MOVE SPACES                   TO WS-RESULT-DATE           
ACT074        PERFORM 2150-PROCESS-FOR-GRACE-DAYS                       
ACT074                                         THRU 2150-EXIT           
           END-IF.                                                      
                                                                        
      ** PERFORM THIS LOGIC ONLY IF EITHER OF THE FACTOR OR DURATION            
      ** REMAINING IS NOT PASSED FROM THE CALLING PROGRAM. FACTOR VALUE         
      ** IS RETREIVED FROM CRM_OPT_ATTR_INCTV OR CSS_SPCL_FCTR_APPL             
      ** TABLES, IN THAT ORDER. DURATION REMAINING VALUE IS RETREIVED           
      ** FROM CRM_OPT_ATTR_INCTV OR CSS_SPCL_FCTR, IN THAT ORDER. IF            
      ** DURATION REMAINING VALUE IS NOT FOUND, IT IS MADE NULL.                
           IF FACTOR-NOT-PASSED OR DUR-REMAIN-NO-NOT-PASSED             
              MOVE WS-COMPANY-NO            TO HQ-COMPANY-NO            
              MOVE WS-CPD65-FACTOR-ID       TO HQ-FACTOR-ID             
              MOVE DF-OPTION-CD             TO HQ-OPTION-CD             
                                                                        
              IF WS-CPD65-FACTOR-ID = WS-EXIT-FEE                       
                 MOVE DF-OPT-AGRMT-EFF-DT   TO HQ-ATTR-INCTV-STRT-DT    
              ELSE                                                      
                 MOVE WS-COMMON-DATE        TO HQ-ATTR-INCTV-STRT-DT    
              END-IF                                                    
                                                                        
              PERFORM 7600-GET-HQ-FACTOR    THRU 7600-EXIT              
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF FACTOR-NOT-PASSED                                   
                    MOVE HQ-ATTR-INCTV-VALUE TO FF-FACTOR               
                 END-IF                                                 
                                                                        
                 IF DUR-REMAIN-NO-NOT-PASSED                            
                    IF HQ-DURATION-NO > 0                               
                       MOVE HQ-DURATION-NO  TO FF-DURATION-REMAIN-NO    
                       MOVE +0              TO WS-NULL-IND-1            
                    ELSE                                                
                       PERFORM 2500-SPCL-FCTR-PROCESS THRU 2500-EXIT    
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 IF FACTOR-NOT-PASSED                                   
                    MOVE WS-CPD65-FACTOR-ID      TO SA-FACTOR-ID        
                    MOVE WS-CPD65-CODE-UTIL-TYPE TO SA-CODE-UTIL-TYPE   
                    MOVE WS-COMMON-DATE          TO SA-DATE-FROM        
                    PERFORM 7700-GET-SPCL-FCT-APPL THRU 7700-EXIT       
                    MOVE SA-FACTOR               TO FF-FACTOR           
                 END-IF                                                 
                                                                        
                 IF DUR-REMAIN-NO-NOT-PASSED                            
                    PERFORM 2500-SPCL-FCTR-PROCESS THRU 2500-EXIT       
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT074****************************************************************          
ACT074** 2150-PROCESS-FOR-GRACE-DAYS.                               **          
ACT074****************************************************************          
ACT074 2150-PROCESS-FOR-GRACE-DAYS.                                     
ACT074                                                                  
ACT074**** GET OPT-AGRMT-EFF-DT TO CALCULATE ROR DATE.                          
ACT074     PERFORM 7510-GET-OPT-AGRMT-EFF-DT     THRU 7510-EXIT.        
ACT074                                                                  
ACT074****   I - OPTED-IN FOR AUTO RENEWAL, FAR - AUTORENEWED                   
ACT074     IF DF-AUTO-REN-OPT-IN-FL  = 'I' AND                          
ACT074        DF-AGREEMNT-SOURCE-CD  = 'FAR'                            
ACT074        PERFORM 7520-ADD-DAYS-GRACE-PERIOD THRU 7520-EXIT         
ACT074     END-IF.                                                      
ACT074                                                                  
ACT074 2150-EXIT.                                                       
ACT074     EXIT.                                                        
ACT074                                                                  
      ****************************************************************          
      ** 2200-CSR-PROCESS.                                          **          
      ****************************************************************          
       2200-CSR-PROCESS.                                                
                                                                        
      ** FOR CSR DATABASE, WHEN FACTOR VALUE IS NOT PASSED, ALWAYS GET          
      ** IT FROM THE SPCL_FCTR_APPL TABLE.                                      
           MOVE 0                            TO FF-RT-PKG-OPT-SEQ-NO.   
                                                                        
           IF FACTOR-NOT-PASSED                                         
              MOVE WS-CPD65-ACCOUNT-NO       TO UT-ACCOUNT-NO           
              MOVE WS-CPD65-CODE-UTIL-TYPE   TO UT-CODE-UTIL-TYPE       
              MOVE WS-CPD65-IC-NO            TO UT-IC-NO                
              PERFORM 7750-GET-RATE-PLAN     THRU 7750-EXIT             
              MOVE UT-RATE-PLAN-NO           TO SA-RATE-PLAN-NO         
PRJ430                                          J1-RATE-PLAN-NO         
              MOVE WS-CPD65-FACTOR-ID        TO SA-FACTOR-ID            
              MOVE WS-CPD65-CODE-UTIL-TYPE   TO SA-CODE-UTIL-TYPE       
              MOVE WS-COMMON-DATE            TO SA-DATE-FROM            
              MOVE WS-ACTIVE                 TO SA-CODE-STATUS          
              PERFORM 7700-GET-SPCL-FCT-APPL    THRU 7700-EXIT          
              MOVE SA-FACTOR                 TO FF-FACTOR               
           ELSE                                                         
              MOVE 0                         TO FF-FACTOR               
P00738        IF SF-SPCL-GROUP-CD  = 'DS' OR 'DR'                       
PRJ430           MOVE WS-CPD65-ACCOUNT-NO    TO UT-ACCOUNT-NO           
PRJ430           MOVE WS-CPD65-CODE-UTIL-TYPE                           
PRJ430                                       TO UT-CODE-UTIL-TYPE       
PRJ430           MOVE WS-CPD65-IC-NO         TO UT-IC-NO                
PRJ430           PERFORM 7750-GET-RATE-PLAN     THRU 7750-EXIT          
PRJ430           MOVE UT-RATE-PLAN-NO        TO J1-RATE-PLAN-NO         
PRJ430        END-IF                                                    
           END-IF.                                                      
                                                                        
      ** FOR CSR DATABASE, WHEN DURATION REMAINING IS NOT PASSED GET            
      ** IT FROM THE SPCL_FCTR TABLE.                                           
           IF DUR-REMAIN-NO-NOT-PASSED                                  
              PERFORM 2500-SPCL-FCTR-PROCESS THRU 2500-EXIT             
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 2500-SPCL-FCTR-PROCESS.                                    **          
      ****************************************************************          
       2500-SPCL-FCTR-PROCESS.                                          
                                                                        
           MOVE WS-CPD65-FACTOR-ID          TO SF-FACTOR-ID.            
                                                                        
           PERFORM 7900-GET-SPCL-FCTR       THRU 7900-EXIT.             
                                                                        
           IF WS-NULL-IND-2 = ZERO                                      
              MOVE SF-DEFLT-DURATION-NO     TO FF-DURATION-REMAIN-NO    
              MOVE +0                       TO WS-NULL-IND-1            
           ELSE                                                         
              MOVE -1                       TO WS-NULL-IND-1            
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 5000-WRITE-TRAN-HIST-DET.                                  **          
      ****************************************************************          
       5000-WRITE-TRAN-HIST-DET.                                        
                                                                        
           ADD  +1                          TO WS-TRAN-APPL-NO.         
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE WS-FACTOR-ID-TEXT           TO MI-COLUMN-DESC.          
           MOVE WS-NEW                      TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE FF-FACTOR-ID                TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE SPACES                      TO MI-TABLE-ID.             
           PERFORM 5100-LOAD-MNT-TRANS-HIST THRU 5100-EXIT.             
                                                                        
           ADD  +1                          TO WS-TRAN-APPL-NO.         
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE WS-FACTOR-TEXT              TO MI-COLUMN-DESC.          
           MOVE WS-NEW                      TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE FF-FACTOR                   TO WS-FACTOR-DISP.          
           MOVE WS-FACTOR-DISP              TO WS-FACT-VAL-Z.           
           MOVE WS-FACT-VAL-Z               TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE SPACES                      TO MI-TABLE-ID.             
           PERFORM 5100-LOAD-MNT-TRANS-HIST THRU 5100-EXIT.             
                                                                        
           ADD  +1                          TO WS-TRAN-APPL-NO.         
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE WS-DATE-FROM-TEXT           TO MI-COLUMN-DESC.          
           MOVE WS-NEW                      TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE FF-EFF-DATE-FROM            TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           PERFORM 5100-LOAD-MNT-TRANS-HIST THRU 5100-EXIT.             
                                                                        
           ADD  +1                          TO WS-TRAN-APPL-NO.         
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE WS-DATE-TO-TEXT             TO MI-COLUMN-DESC.          
           MOVE WS-NEW                      TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                      
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE FF-EFF-DATE-TO              TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
           PERFORM 5100-LOAD-MNT-TRANS-HIST THRU 5100-EXIT.             
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 5100-LOAD-MNT-TRANS-HIST.                                  **          
      ****************************************************************          
       5100-LOAD-MNT-TRANS-HIST.                                        
                                                                        
           IF MI-TRAN-APPL-NO EQUAL 1                                   
              PERFORM 5200-MOVE-TRANS-HDR-DETAILS THRU 5200-EXIT        
              PERFORM 8100-INSERT-MNT-TRANS-HIST  THRU 8100-EXIT        
              PERFORM 8200-INSERT-MT-TRN-HST-DET  THRU 8200-EXIT        
           ELSE                                                         
              PERFORM 8200-INSERT-MT-TRN-HST-DET  THRU 8200-EXIT        
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 5200-MOVE-TRANS-HDR-DETAILS.                               **          
      ****************************************************************          
       5200-MOVE-TRANS-HDR-DETAILS.                                     
                                                                        
           PERFORM 7800-GET-CURR-TIMESTAMP  THRU 7800-EXIT.             
                                                                        
           MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO,    
                                               MI-TRANS-HIST-SEQ-NO.    
           MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
                                                                        
           MOVE WS-F                        TO MH-CODE-TRAN-TYPE.       
           MOVE FF-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
           MOVE SPACES                      TO MH-RESP-AREA-ID.         
           MOVE 0                           TO MH-CUSTOMER-NO,          
                                               MH-PREMISE-NO.           
PRJ738     IF WS-CPD65-USER-ID NOT = LOW-VALUES AND                     
PRJ738        WS-CPD65-USER-ID > SPACES                                 
PRJ738        MOVE WS-CPD65-USER-ID         TO MH-USER-ID               
PRJ738     ELSE                                                         
              MOVE WS-SYSTEM                TO MH-USER-ID               
PRJ738     END-IF.                                                      
                                                                        
           IF WS-CPD65-CALLING-PGM NOT = LOW-VALUES AND                 
              WS-CPD65-CALLING-PGM > SPACES                             
              MOVE WS-CPD65-CALLING-PGM     TO MH-APPL-PROGRAM-ID       
           ELSE                                                         
              MOVE WS-SYSTEM                TO MH-APPL-PROGRAM-ID       
           END-IF.                                                      
                                                                        
           MOVE WS-CPD65-FACTOR-ID          TO SF-FACTOR-ID.            
           PERFORM 7900-GET-SPCL-FCTR       THRU 7900-EXIT.             
P00430     IF SF-SPCL-GROUP-CD = 'DS'                                   
P00430        MOVE 'DSM EXEMPTION APPLIED.' TO MH-TRAN-COMMENT-TEXT     
P00738     ELSE                                                         
P00738        IF SF-SPCL-GROUP-CD = 'DR'                                
P00738           MOVE 'REDUCED DSM RIDER APPLIED.'                      
P00738                                      TO MH-TRAN-COMMENT-TEXT     
P00430        ELSE                                                      
P00430           MOVE SF-FACTOR-TEXT        TO MH-TRAN-COMMENT-TEXT     
P00430        END-IF                                                    
P00738     END-IF.                                                      
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT TO MH-TRAN-COMMENT-LEN.  
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 7000-GET-CURR-DATE.                                        **          
      ****************************************************************          
       7000-GET-CURR-DATE.                                              
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD65-RETURN-CODE     
              MOVE WS-PROGRAM               TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE SPACES                   TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CURRENT DATE'           TO TABLE-ELEMENT-2          
              MOVE WS-CPD65-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
              MOVE WS-CURRENT-DATE          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 7100-GET-COMMON-DATE.                                      **          
      ****************************************************************          
       7100-GET-COMMON-DATE.                                            
                                                                        
           EXEC SQL                                                     
                SELECT G6.PARM_DATA                                     
                 INTO :G6-PARM-DATA                                     
                FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                      
                WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                
                AND G6.COMPANY_NO     = :G6-COMPANY-NO                  
                AND G6.CMND_CODE      = :G6-CMND-CODE                   
                AND G6.SEQ_NO         = :G6-SEQ-NO                      
                AND G6.STATUS         = 'A'                             
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT G6.PARM_DATA                                             
MFA-TR*          INTO :G6-PARM-DATA                                             
MFA-TR*         FROM CSS_JOB_PARM G6                                            
MFA-TR*         WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                        
MFA-TR*         AND G6.COMPANY_NO     = :G6-COMPANY-NO                          
MFA-TR*         AND G6.CMND_CODE      = :G6-CMND-CODE                           
MFA-TR*         AND G6.SEQ_NO         = :G6-SEQ-NO                              
MFA-TR*         AND G6.STATUS         = 'A'                                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD65-RETURN-CODE     
              MOVE WS-PROGRAM               TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_JOB_PARM'           TO TABLE-1                  
              MOVE 'PROGRAM_NAME'           TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE 'SEQ_NO'                 TO TABLE-ELEMENT-3          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-4          
              MOVE G6-PROGRAM-NAME          TO HOSTVAR-ELEMENT-1        
              MOVE G6-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              MOVE G6-SEQ-NO                TO HOSTVAR-ELEMENT-3        
              MOVE WS-CPD65-ACCOUNT-NO      TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 7200-GET-MIN-REV-MTH.                                      **          
      ****************************************************************          
       7200-GET-MIN-REV-MTH.                                            
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) BN.REVENUE_MONTH                                 
                 INTO :BN-REVENUE-MONTH                                 
                FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                   
                WHERE BN.DATE_EXTRACT <= IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )               
                ORDER BY BN.DATE_EXTRACT DESC,                          
                         BN.REVENUE_MONTH ASC                           
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT BN.REVENUE_MONTH                                         
MFA-TR*          INTO :BN-REVENUE-MONTH                                         
MFA-TR*         FROM CSS_BILL_WINDOW BN                                         
MFA-TR*         WHERE BN.DATE_EXTRACT <= :BN-DATE-EXTRACT                       
MFA-TR*         ORDER BY BN.DATE_EXTRACT DESC,                                  
MFA-TR*                  BN.REVENUE_MONTH ASC                                   
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD65-RETURN-CODE     
              MOVE WS-PROGRAM               TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_BILL_WINDOW'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'DATE_EXTRACT'           TO TABLE-ELEMENT-2          
              MOVE WS-CPD65-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
              MOVE BN-DATE-EXTRACT          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      ** 7250-CHK-FACTOR.                                           **          
      ****************************************************************          
       7250-CHK-FACTOR.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
               INTO :WS-FACTOR-EXISTS-FLAG                              
               FROM CSS_FIXED_FCTR WITH(READUNCOMMITTED)                        
              WHERE ACCOUNT_NO           = :FF-ACCOUNT-NO               
                AND CODE_UTIL_TYPE       = :FF-CODE-UTIL-TYPE           
                AND IC_NO                = :FF-IC-NO                    
                AND FACTOR_ID            = :FF-FACTOR-ID                
                AND ((EFF_DATE_FROM     <= IIF(TRY_CONVERT(DATE, 
                                                      :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) ) AND        
                      EFF_DATE_TO       >= IIF(TRY_CONVERT(DATE, 
                                                        :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )  ) OR        
                      DURATION_REMAIN_NO > 0)                           
              ORDER BY EFF_DATE_FROM                                    
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*        INTO :WS-FACTOR-EXISTS-FLAG                                      
MFA-TR*        FROM CSS_FIXED_FCTR                                              
MFA-TR*       WHERE ACCOUNT_NO           = :FF-ACCOUNT-NO                       
MFA-TR*         AND CODE_UTIL_TYPE       = :FF-CODE-UTIL-TYPE                   
MFA-TR*         AND IC_NO                = :FF-IC-NO                            
MFA-TR*         AND FACTOR_ID            = :FF-FACTOR-ID                        
MFA-TR*         AND ((EFF_DATE_FROM     <= :FF-EFF-DATE-FROM AND                
MFA-TR*               EFF_DATE_TO       >= :FF-EFF-DATE-TO  ) OR                
MFA-TR*               DURATION_REMAIN_NO > 0)                                   
MFA-TR*       ORDER BY EFF_DATE_FROM                                            
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD65-RETURN-CODE     
              MOVE WS-PROGRAM               TO ABEND-PROGRAM            
              MOVE '7250'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_FIXED_FCTR'         TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE FF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE FF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 7300-SELECT-MAX-SEQ-NO.                                    **          
      ****************************************************************          
       7300-SELECT-MAX-SEQ-NO.                                          
                                                                        
           EXEC SQL                                                     
                SELECT COALESCE(MAX(FIXED_FCTR_SEQ_NO),0)                 
                  INTO :FF-FIXED-FCTR-SEQ-NO                            
                FROM CSS_FIXED_FCTR WITH(READUNCOMMITTED)                       
                WHERE ACCOUNT_NO    = :FF-ACCOUNT-NO                    
                AND CODE_UTIL_TYPE  = :FF-CODE-UTIL-TYPE                
                AND IC_NO           = :FF-IC-NO                         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT IFNULL(MAX(FIXED_FCTR_SEQ_NO),0)                         
MFA-TR*           INTO :FF-FIXED-FCTR-SEQ-NO                                    
MFA-TR*         FROM CSS_FIXED_FCTR                                             
MFA-TR*         WHERE ACCOUNT_NO    = :FF-ACCOUNT-NO                            
MFA-TR*         AND CODE_UTIL_TYPE  = :FF-CODE-UTIL-TYPE                        
MFA-TR*         AND IC_NO           = :FF-IC-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD65-RETURN-CODE     
              MOVE WS-PROGRAM               TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_FIXED_FCTR'         TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE FF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE FF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
OTPOOL** 7400-GET-ACCT-DETAILS.                                     **          
      ****************************************************************          
OTPOOL 7400-GET-ACCT-DETAILS.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DF.OPTION_CD,
              DF.RT_PKG_OPT_SEQ_NO,
              DF.OPT_AGRMT_EFF_DT,
              DF.STATUS_CD,
              UT.RATE_PLAN_NO,
              COALESCE(B1.DIVISION_NO,'   ')                     
                 INTO :DF-OPTION-CD                                     
                     ,:DF-RT-PKG-OPT-SEQ-NO                             
                     ,:DF-OPT-AGRMT-EFF-DT                              
OTPOOL               ,:DF-STATUS-CD                                     
                     ,:UT-RATE-PLAN-NO                                  
OTPOOL               ,:B1-DIVISION-NO                                   
OTPOOL           FROM  CSS_ACCOUNT          AT WITH(READUNCOMMITTED)            
OTPOOL               , CSS_LOCAL_OFFICE     B1 WITH(READUNCOMMITTED)            
                     , CSS_UTIL_ENVRNMT     UT WITH(READUNCOMMITTED)            
                     , CSS_ACCT_RTPK_AGR    DF WITH(READUNCOMMITTED)            
OTPOOL          WHERE  AT.ACCOUNT_NO        = :AT-ACCOUNT-NO            
OTPOOL            AND  B1.LOCAL_OFFICE      =  AT.LOCAL_OFFICE          
OTPOOL            AND  B1.COMPANY_NO        =  AT.COMPANY_NO            
OTPOOL            AND  UT.ACCOUNT_NO        =  AT.ACCOUNT_NO            
                  AND  UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE        
                  AND  UT.IC_NO             = :UT-IC-NO                 
                  AND  DF.ACCOUNT_NO        =  UT.ACCOUNT_NO            
                  AND  DF.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE        
                  AND  DF.IC_NO             =  UT.IC_NO                 
                  AND  DF.RT_PKG_OPT_SEQ_NO =  UT.RT_PKG_OPT_SEQ_NO     
OTPOOL                                              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  DF.OPTION_CD                                             
MFA-TR*              , DF.RT_PKG_OPT_SEQ_NO                                     
MFA-TR*              , DF.OPT_AGRMT_EFF_DT                                      
MFA-TR*              , DF.STATUS_CD                                             
MFA-TR*              , UT.RATE_PLAN_NO                                          
MFA-TR*              , IFNULL(B1.DIVISION_NO,'   ')                             
MFA-TR*          INTO :DF-OPTION-CD                                             
MFA-TR*              ,:DF-RT-PKG-OPT-SEQ-NO                                     
MFA-TR*              ,:DF-OPT-AGRMT-EFF-DT                                      
MFA-TR*              ,:DF-STATUS-CD                                             
MFA-TR*              ,:UT-RATE-PLAN-NO                                          
MFA-TR*              ,:B1-DIVISION-NO                                           
MFA-TR*          FROM  CSS_ACCOUNT          AT                                  
MFA-TR*              , CSS_LOCAL_OFFICE     B1                                  
MFA-TR*              , CSS_UTIL_ENVRNMT     UT                                  
MFA-TR*              , CSS_ACCT_RTPK_AGR    DF                                  
MFA-TR*         WHERE  AT.ACCOUNT_NO        = :AT-ACCOUNT-NO                    
MFA-TR*           AND  B1.LOCAL_OFFICE      =  AT.LOCAL_OFFICE                  
MFA-TR*           AND  B1.COMPANY_NO        =  AT.COMPANY_NO                    
MFA-TR*           AND  UT.ACCOUNT_NO        =  AT.ACCOUNT_NO                    
MFA-TR*           AND  UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE                
MFA-TR*           AND  UT.IC_NO             = :UT-IC-NO                         
MFA-TR*           AND  DF.ACCOUNT_NO        =  UT.ACCOUNT_NO                    
MFA-TR*           AND  DF.CODE_UTIL_TYPE    =  UT.CODE_UTIL_TYPE                
MFA-TR*           AND  DF.IC_NO             =  UT.IC_NO                         
MFA-TR*           AND  DF.RT_PKG_OPT_SEQ_NO =  UT.RT_PKG_OPT_SEQ_NO             
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD65-RETURN-CODE     
              MOVE WS-PROGRAM               TO ABEND-PROGRAM            
              MOVE '7400'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_ACCT_RTPK_AGR'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE UT-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
OTPOOL****************************************************************          
OTPOOL** 7450-GET-ACCT-MKT-TIER.                                    **          
OTPOOL****************************************************************          
OTPOOL 7450-GET-ACCT-MKT-TIER.                                          
OTPOOL                                                                  
OTPOOL     EXEC SQL                                                     
OTPOOL         SELECT TOP(1) DD.TIER_ACCT_TYPE_CD                             
OTPOOL           INTO :DD-TIER-ACCT-TYPE-CD                             
OTPOOL           FROM  CSS_ACCT_MKT_TIER DD WITH(READUNCOMMITTED)               
OTPOOL          WHERE  DD.ACCOUNT_NO     =  :DD-ACCOUNT-NO              
OTPOOL            AND  DD.EFF_START_DT   =                              
OTPOOL                      ( SELECT MAX(ZZ.EFF_START_DT)               
OTPOOL                          FROM CSS_ACCT_MKT_TIER ZZ
                           WITH(READUNCOMMITTED)               
OTPOOL                         WHERE ZZ.ACCOUNT_NO = DD.ACCOUNT_NO )    
OTPOOL                                              
OTPOOL                                                           
OTPOOL     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  DD.TIER_ACCT_TYPE_CD                                     
MFA-TR*          INTO :DD-TIER-ACCT-TYPE-CD                                     
MFA-TR*          FROM  CSS_ACCT_MKT_TIER DD                                     
MFA-TR*         WHERE  DD.ACCOUNT_NO     =  :DD-ACCOUNT-NO                      
MFA-TR*           AND  DD.EFF_START_DT   =                              04610000
MFA-TR*                     ( SELECT MAX(ZZ.EFF_START_DT)               04620000
MFA-TR*                         FROM CSS_ACCT_MKT_TIER ZZ               04630000
MFA-TR*                        WHERE ZZ.ACCOUNT_NO = DD.ACCOUNT_NO )    04640000
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

OTPOOL                                                                  
OTPOOL     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
OTPOOL                                                                  
OTPOOL     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
OTPOOL        NEXT SENTENCE                                             
OTPOOL     ELSE                                                         
OTPOOL        MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD65-RETURN-CODE     
OTPOOL        MOVE WS-PROGRAM               TO ABEND-PROGRAM            
OTPOOL        MOVE '7400'                   TO ACTIVE-PARAGRAPH         
OTPOOL        MOVE 'SELECT'                 TO ABEND-FUNCTION           
OTPOOL        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
OTPOOL                                         ABEND-TABLES             
OTPOOL        MOVE 'CSS_ACCT_MKT_TIER'      TO TABLE-1                  
OTPOOL        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
OTPOOL        MOVE DD-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
OTPOOL        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
OTPOOL     END-IF.                                                      
OTPOOL                                                                  
OTPOOL 7450-EXIT.                                                       
OTPOOL     EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 7500-GET-FP-DURATION-REM.                                  **          
      ****************************************************************          
       7500-GET-FP-DURATION-REM.                                        
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                INTO :WS-FP-DURATION-REM-FLAG                           
                FROM CSS_FIXED_FCTR     FF WITH(READUNCOMMITTED)                
                    ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)                
                    ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)                
                WHERE FF.ACCOUNT_NO          = :FF-ACCOUNT-NO           
                AND   FF.CODE_UTIL_TYPE      = :FF-CODE-UTIL-TYPE       
                AND   FF.IC_NO               = :FF-IC-NO                
                AND   FF.FACTOR_ID           = SF.FACTOR_ID             
                AND   SF.OVR_RT_CALC_TYP_CD  = '02'                     
                AND   FF.FACTOR_ID           = HQ.FACTOR_ID             
                AND   HQ.OPTION_CD           = :DF-OPTION-CD            
                AND   HQ.ATTR_INCTV_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                        :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) )          
                AND   HQ.ATTR_INCTV_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                        :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) )          
P00473          AND   HQ.PROC_STATUS_CD      = 'AC'                     
P00473          AND   HQ.OPT_ATTR_VSTART_TS = (                         
P00473                 SELECT MAX(H1.OPT_ATTR_VSTART_TS)                
P00473                   FROM CRM_OPT_ATTR_INCTV H1
                           WITH(READUNCOMMITTED)                     
P00473                  WHERE H1.OPTION_CD    = HQ.OPTION_CD            
P00473                    AND H1.RT_ATTR_INCTV_TYPE                     
P00473                                      = HQ.RT_ATTR_INCTV_TYPE     
P00473                    AND H1.ATTR_INCTV_STRT_DT                     
P00473                                     <= IIF(TRY_CONVERT(DATE, 
                                                        :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) )           
P00473                    AND H1.ATTR_INCTV_END_DT                      
P00473                                     >= IIF(TRY_CONVERT(DATE, 
                                                        :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) )           
P00473                    AND CAST(H1.OPT_ATTR_VSTART_TS AS DATE)               
P00473                                     <= IIF(TRY_CONVERT(DATE, 
                                                        :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) )           
P00473                    AND CAST(H1.OPT_ATTR_VEND_TS AS DATE)                 
P00473                                     >= IIF(TRY_CONVERT(DATE, 
                                                        :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) )           
P00473                    AND H1.PROC_STATUS_CD      = 'AC')            
                AND   FF.RT_PKG_OPT_SEQ_NO   = :DF-RT-PKG-OPT-SEQ-NO    
                AND   FF.DURATION_REMAIN_NO  > 1                        
                ORDER BY HQ.ATTR_INCTV_STRT_DT                          
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*         INTO :WS-FP-DURATION-REM-FLAG                                   
MFA-TR*         FROM CSS_FIXED_FCTR     FF                                      
MFA-TR*             ,CSS_SPCL_FCTR      SF                                      
MFA-TR*             ,CRM_OPT_ATTR_INCTV HQ                                      
MFA-TR*         WHERE FF.ACCOUNT_NO          = :FF-ACCOUNT-NO                   
MFA-TR*         AND   FF.CODE_UTIL_TYPE      = :FF-CODE-UTIL-TYPE               
MFA-TR*         AND   FF.IC_NO               = :FF-IC-NO                        
MFA-TR*         AND   FF.FACTOR_ID           = SF.FACTOR_ID                     
MFA-TR*         AND   SF.OVR_RT_CALC_TYP_CD  = '02'                             
MFA-TR*         AND   FF.FACTOR_ID           = HQ.FACTOR_ID                     
MFA-TR*         AND   HQ.OPTION_CD           = :DF-OPTION-CD                    
MFA-TR*         AND   HQ.ATTR_INCTV_STRT_DT <= :WS-COMMON-DATE                  
MFA-TR*         AND   HQ.ATTR_INCTV_END_DT  >= :WS-COMMON-DATE                  
MFA-TR*         AND   HQ.PROC_STATUS_CD      = 'AC'                             
MFA-TR*         AND   HQ.OPT_ATTR_VSTART_TS = (                                 
MFA-TR*                SELECT MAX(H1.OPT_ATTR_VSTART_TS)                        
MFA-TR*                  FROM CRM_OPT_ATTR_INCTV H1                             
MFA-TR*                 WHERE H1.OPTION_CD    = HQ.OPTION_CD                    
MFA-TR*                   AND H1.RT_ATTR_INCTV_TYPE                             
MFA-TR*                                     = HQ.RT_ATTR_INCTV_TYPE             
MFA-TR*                   AND H1.ATTR_INCTV_STRT_DT                             
MFA-TR*                                    <= :WS-COMMON-DATE                   
MFA-TR*                   AND H1.ATTR_INCTV_END_DT                              
MFA-TR*                                    >= :WS-COMMON-DATE                   
MFA-TR*                   AND DATE(H1.OPT_ATTR_VSTART_TS)                       
MFA-TR*                                    <= :WS-COMMON-DATE                   
MFA-TR*                   AND DATE(H1.OPT_ATTR_VEND_TS)                         
MFA-TR*                                    >= :WS-COMMON-DATE                   
MFA-TR*                   AND H1.PROC_STATUS_CD      = 'AC')                    
MFA-TR*         AND   FF.RT_PKG_OPT_SEQ_NO   = :DF-RT-PKG-OPT-SEQ-NO            
MFA-TR*         AND   FF.DURATION_REMAIN_NO  > 1                                
MFA-TR*         ORDER BY HQ.ATTR_INCTV_STRT_DT                                  
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD65-RETURN-CODE     
              MOVE WS-PROGRAM               TO ABEND-PROGRAM            
              MOVE '7500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_FIXED_FCTR'         TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'OPTION CODE'            TO TABLE-ELEMENT-2          
              MOVE 'DATE RANGE'             TO TABLE-ELEMENT-3          
              MOVE FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE DF-OPTION-CD             TO HOSTVAR-ELEMENT-2        
              MOVE WS-COMMON-DATE           TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT074****************************************************************          
ACT074** 7510-GET-OPT-AGRMT-EFF-DT.                                 **          
ACT074****************************************************************          
ACT074 7510-GET-OPT-AGRMT-EFF-DT.                                       
ACT074                                                                  
ACT074     EXEC SQL                                                     
ACT074          SELECT TOP(1) DF.AUTO_REN_OPT_IN_FL,
              DF.AGREEMNT_SOURCE_CD,
              DF.OPT_AGRMT_EFF_DT                             
ACT074            INTO :DF-AUTO-REN-OPT-IN-FL                           
ACT074                ,:DF-AGREEMNT-SOURCE-CD                           
ACT074                ,:WS-OPT-AGRMT-EFF-DT                             
ACT074            FROM  CSS_ACCT_RTPK_AGR  DF WITH(READUNCOMMITTED)             
ACT074           WHERE  DF.ACCOUNT_NO       = :DF-ACCOUNT-NO            
ACT074             AND  DF.CODE_UTIL_TYPE   = :DF-CODE-UTIL-TYPE        
ACT074             AND  DF.IC_NO            = :DF-IC-NO                 
ACT074           ORDER  BY DF.RT_PKG_OPT_SEQ_NO DESC                    
ACT074                                              
ACT074                                                           
ACT074                                                      
ACT074     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  DF.AUTO_REN_OPT_IN_FL                                   
MFA-TR*               , DF.AGREEMNT_SOURCE_CD                                   
MFA-TR*               , DF.OPT_AGRMT_EFF_DT                                     
MFA-TR*           INTO :DF-AUTO-REN-OPT-IN-FL                                   
MFA-TR*               ,:DF-AGREEMNT-SOURCE-CD                                   
MFA-TR*               ,:WS-OPT-AGRMT-EFF-DT                                     
MFA-TR*           FROM  CSS_ACCT_RTPK_AGR  DF                                   
MFA-TR*          WHERE  DF.ACCOUNT_NO       = :DF-ACCOUNT-NO                    
MFA-TR*            AND  DF.CODE_UTIL_TYPE   = :DF-CODE-UTIL-TYPE                
MFA-TR*            AND  DF.IC_NO            = :DF-IC-NO                         
MFA-TR*          ORDER  BY DF.RT_PKG_OPT_SEQ_NO DESC                            
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7510                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT074                                                                  
ACT074     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
ACT074                                                                  
ACT074     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT074        CONTINUE                                                  
ACT074     ELSE                                                         
ACT074        MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD65-RETURN-CODE     
ACT074        MOVE WS-PROGRAM               TO ABEND-PROGRAM            
ACT074        MOVE '7510'                   TO ACTIVE-PARAGRAPH         
ACT074        MOVE 'SELECT'                 TO ABEND-FUNCTION           
ACT074        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
ACT074                                         ABEND-TABLES             
ACT074        MOVE 'CSS_ACCT_RTPK_AGR'      TO TABLE-1                  
ACT074        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
ACT074        MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
ACT074        MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
ACT074        MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
ACT074        MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
ACT074        MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
ACT074        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
ACT074     END-IF.                                                      
ACT074                                                                  
ACT074 7510-EXIT.                                                       
ACT074     EXIT.                                                        
ACT074                                                                  
ACT074****************************************************************          
ACT074** 7520-ADD-DAYS-GRACE-PERIOD.                                **          
ACT074****************************************************************          
ACT074 7520-ADD-DAYS-GRACE-PERIOD.                                      
ACT074                                                                  
ACT074     EXEC SQL                                                     
ACT074         SELECT
              DATEADD( DAY, :WS-120DAY-GRACE-PERIOD, 
              IIF(TRY_CONVERT(DATE, :WS-OPT-AGRMT-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-OPT-AGRMT-EFF-DT
              ) <> 0) OR (LEN(:WS-OPT-AGRMT-EFF-DT
              ) <> 10), CIS.CHAR2DATE(:WS-OPT-AGRMT-EFF-DT
              ), CONVERT(DATE, :WS-OPT-AGRMT-EFF-DT) ) )
            INTO
              :WS-RESULT-DATE 
ACT074     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-RESULT-DATE =  DATE(DATE(:WS-OPT-AGRMT-EFF-DT)           
MFA-TR*                               + (:WS-120DAY-GRACE-PERIOD DAYS))         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT074                                                                  
ACT074     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
ACT074                                                                  
ACT074     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT074        CONTINUE                                                  
ACT074     ELSE                                                         
ACT074        MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD65-RETURN-CODE     
ACT074        MOVE WS-PROGRAM               TO ABEND-PROGRAM            
ACT074        MOVE '7520'                   TO ACTIVE-PARAGRAPH         
ACT074        MOVE 'SELECT'                 TO ABEND-FUNCTION           
ACT074        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
ACT074                                         ABEND-TABLES             
ACT074        MOVE 'SET '                   TO TABLE-1                  
ACT074        MOVE 'OPTION EFF_DT'          TO TABLE-ELEMENT-1          
ACT074        MOVE '120 DAY GRACE'          TO TABLE-ELEMENT-2          
ACT074        MOVE WS-OPT-AGRMT-EFF-DT      TO HOSTVAR-ELEMENT-1        
ACT074        MOVE WS-120DAY-GRACE-PERIOD   TO HOSTVAR-ELEMENT-2        
ACT074        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
ACT074     END-IF.                                                      
ACT074 7520-EXIT.                                                       
ACT074     EXIT.                                                        
ACT074                                                                  
      ****************************************************************          
      ** 7600-GET-HQ-FACTOR.                                        **          
      ****************************************************************          
       7600-GET-HQ-FACTOR.                                              
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) HQ.ATTR_INCTV_VALUE,
              HQ.DURATION_NO                                   
                 INTO :HQ-ATTR-INCTV-VALUE                              
                     ,:HQ-DURATION-NO                                   
                FROM   CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)              
                WHERE HQ.COMPANY_NO          = :HQ-COMPANY-NO           
                AND   HQ.OPTION_CD           = :HQ-OPTION-CD            
                AND   HQ.FACTOR_ID           = :HQ-FACTOR-ID            
                AND   HQ.ATTR_INCTV_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )   
                AND   HQ.ATTR_INCTV_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )   
P00473          AND   HQ.PROC_STATUS_CD      = 'AC'                     
P00473          AND   HQ.OPT_ATTR_VSTART_TS = (                         
P00473                 SELECT MAX(H1.OPT_ATTR_VSTART_TS)                
P00473                   FROM CRM_OPT_ATTR_INCTV H1
                           WITH(READUNCOMMITTED)                     
P00473                  WHERE H1.OPTION_CD    = HQ.OPTION_CD            
P00473                    AND H1.RT_ATTR_INCTV_TYPE                     
P00473                                      = HQ.RT_ATTR_INCTV_TYPE     
P00473                    AND H1.ATTR_INCTV_STRT_DT                     
P00473                                     <= IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )    
P00473                    AND H1.ATTR_INCTV_END_DT                      
P00473                                     >= IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )    
P00473                    AND CAST(H1.OPT_ATTR_VSTART_TS AS DATE)               
P00473                                     <= IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )    
P00473                    AND CAST(H1.OPT_ATTR_VEND_TS AS DATE)                 
P00473                                     >= IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )    
P00473                    AND H1.PROC_STATUS_CD      = 'AC')            
                ORDER BY HQ.ATTR_INCTV_STRT_DT                          
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT HQ.ATTR_INCTV_VALUE                                      
MFA-TR*               ,HQ.DURATION_NO                                           
MFA-TR*          INTO :HQ-ATTR-INCTV-VALUE                                      
MFA-TR*              ,:HQ-DURATION-NO                                           
MFA-TR*         FROM   CRM_OPT_ATTR_INCTV HQ                                    
MFA-TR*         WHERE HQ.COMPANY_NO          = :HQ-COMPANY-NO                   
MFA-TR*         AND   HQ.OPTION_CD           = :HQ-OPTION-CD                    
MFA-TR*         AND   HQ.FACTOR_ID           = :HQ-FACTOR-ID                    
MFA-TR*         AND   HQ.ATTR_INCTV_STRT_DT <= :HQ-ATTR-INCTV-STRT-DT           
MFA-TR*         AND   HQ.ATTR_INCTV_END_DT  >= :HQ-ATTR-INCTV-STRT-DT           
MFA-TR*         AND   HQ.PROC_STATUS_CD      = 'AC'                             
MFA-TR*         AND   HQ.OPT_ATTR_VSTART_TS = (                                 
MFA-TR*                SELECT MAX(H1.OPT_ATTR_VSTART_TS)                        
MFA-TR*                  FROM CRM_OPT_ATTR_INCTV H1                             
MFA-TR*                 WHERE H1.OPTION_CD    = HQ.OPTION_CD                    
MFA-TR*                   AND H1.RT_ATTR_INCTV_TYPE                             
MFA-TR*                                     = HQ.RT_ATTR_INCTV_TYPE             
MFA-TR*                   AND H1.ATTR_INCTV_STRT_DT                             
MFA-TR*                                    <= :HQ-ATTR-INCTV-STRT-DT            
MFA-TR*                   AND H1.ATTR_INCTV_END_DT                              
MFA-TR*                                    >= :HQ-ATTR-INCTV-STRT-DT            
MFA-TR*                   AND DATE(H1.OPT_ATTR_VSTART_TS)                       
MFA-TR*                                    <= :HQ-ATTR-INCTV-STRT-DT            
MFA-TR*                   AND DATE(H1.OPT_ATTR_VEND_TS)                         
MFA-TR*                                    >= :HQ-ATTR-INCTV-STRT-DT            
MFA-TR*                   AND H1.PROC_STATUS_CD      = 'AC')                    
MFA-TR*         ORDER BY HQ.ATTR_INCTV_STRT_DT                                  
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF ( WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND             
                WS-CPD65-FACTOR-ID = WS-EXIT-FEE )  OR                  
             (( WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND )  
                AND ( WS-CPD65-FACTOR-ID NOT =  WS-EXIT-FEE ))          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD65-RETURN-CODE     
              MOVE WS-PROGRAM               TO ABEND-PROGRAM            
              MOVE '7600'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_OPT_ATTR_INCTV'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-2          
              MOVE 'OPTION_CD'              TO TABLE-ELEMENT-3          
              MOVE 'ATTR_INCTV_STRT_DT'     TO TABLE-ELEMENT-4          
              MOVE WS-CPD65-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
              MOVE HQ-FACTOR-ID             TO HOSTVAR-ELEMENT-2        
              MOVE HQ-OPTION-CD             TO HOSTVAR-ELEMENT-3        
              MOVE HQ-ATTR-INCTV-STRT-DT    TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 7700-GET-SPCL-FCT-APPL.                                    **          
      ****************************************************************          
       7700-GET-SPCL-FCT-APPL.                                          
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) SA.FACTOR                                        
                 INTO :SA-FACTOR                                        
                FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)                
                WHERE SA.FACTOR_ID      = :SA-FACTOR-ID                 
                AND   SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO              
                AND   SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE            
                AND   SA.DATE_FROM     <= IIF(TRY_CONVERT(DATE, 
                                                          :SA-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-FROM
              ) <> 0) OR (LEN(:SA-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :SA-DATE-FROM
              ), CONVERT(DATE, :SA-DATE-FROM) )                 
                AND   SA.DATE_TO       >= IIF(TRY_CONVERT(DATE, 
                                                          :SA-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-FROM
              ) <> 0) OR (LEN(:SA-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :SA-DATE-FROM
              ), CONVERT(DATE, :SA-DATE-FROM) )                 
                AND   SA.CODE_STATUS    = :SA-CODE-STATUS               
                ORDER BY SA.DATE_FROM                                   
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT SA.FACTOR                                                
MFA-TR*          INTO :SA-FACTOR                                                
MFA-TR*         FROM CSS_SPCL_FCTR_APPL SA                                      
MFA-TR*         WHERE SA.FACTOR_ID      = :SA-FACTOR-ID                         
MFA-TR*         AND   SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO                      
MFA-TR*         AND   SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE                    
MFA-TR*         AND   SA.DATE_FROM     <= :SA-DATE-FROM                         
MFA-TR*         AND   SA.DATE_TO       >= :SA-DATE-FROM                         
MFA-TR*         AND   SA.CODE_STATUS    = :SA-CODE-STATUS                       
MFA-TR*         ORDER BY SA.DATE_FROM                                           
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD65-RETURN-CODE     
              MOVE WS-PROGRAM               TO ABEND-PROGRAM            
              MOVE '7700'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-2          
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-3          
              MOVE 'DATE_FROM'              TO TABLE-ELEMENT-4          
              MOVE WS-CPD65-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
              MOVE SA-FACTOR-ID             TO HOSTVAR-ELEMENT-2        
              MOVE SA-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-3        
              MOVE SA-DATE-FROM             TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 7750-GET-RATE-PLAN.                                        **          
      ****************************************************************          
       7750-GET-RATE-PLAN.                                              
                                                                        
                                                                        
           EXEC SQL                                                     
              SELECT UT.RATE_PLAN_NO                                    
               INTO :UT-RATE-PLAN-NO                                    
                FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
                WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                
                AND   UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE            
                AND   UT.IC_NO          = :UT-IC-NO                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UT.RATE_PLAN_NO                                            
MFA-TR*        INTO :UT-RATE-PLAN-NO                                            
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT                                        
MFA-TR*         WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                        
MFA-TR*         AND   UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                    
MFA-TR*         AND   UT.IC_NO          = :UT-IC-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD65-RETURN-CODE     
              MOVE WS-PROGRAM               TO ABEND-PROGRAM            
              MOVE '7750'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE UT-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 7800-GET-CURR-TIMESTAMP.                                   **          
      ****************************************************************          
       7800-GET-CURR-TIMESTAMP.                                         
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD65-RETURN-CODE     
              MOVE WS-PROGRAM               TO ABEND-PROGRAM            
              MOVE '7800'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE SPACES                   TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CURRENT TIMESTAMP'      TO TABLE-ELEMENT-2          
              MOVE WS-CPD65-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
              MOVE WS-CURRENT-TIMESTAMP     TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 7900-GET-SPCL-FCTR.                                        **          
      ****************************************************************          
       7900-GET-SPCL-FCTR.                                              
                                                                        
           EXEC SQL                                                     
                SELECT FACTOR_TEXT                                      
                      ,DEFLT_DURATION_NO                                
                      ,SF.SPCL_GROUP_CD                                 
                 INTO :SF-FACTOR-TEXT                                   
                     ,:SF-DEFLT-DURATION-NO :WS-NULL-IND-2               
                     ,:SF-SPCL-GROUP-CD                                 
                FROM CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                     
                WHERE SF.FACTOR_ID = :SF-FACTOR-ID                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT FACTOR_TEXT                                              
MFA-TR*               ,DEFLT_DURATION_NO                                        
MFA-TR*               ,SF.SPCL_GROUP_CD                                         
MFA-TR*          INTO :SF-FACTOR-TEXT                                           
MFA-TR*              ,:SF-DEFLT-DURATION-NO:WS-NULL-IND-2                       
MFA-TR*              ,:SF-SPCL-GROUP-CD                                         
MFA-TR*         FROM CSS_SPCL_FCTR SF                                           
MFA-TR*         WHERE SF.FACTOR_ID = :SF-FACTOR-ID                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD65-RETURN-CODE     
              MOVE WS-PROGRAM               TO ABEND-PROGRAM            
              MOVE '7900'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_SPCL_FCTR'          TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-4          
              MOVE FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE FF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE FF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE SF-FACTOR-ID             TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
PRJ430****************************************************************          
PRJ430** 7910-GET-COMP-ID-CD-J1                                     **          
PRJ430****************************************************************          
PRJ430*                                                                         
PRJ430 7910-GET-COMP-ID-CD-J1.                                          
PRJ430                                                                  
PRJ430     EXEC SQL                                                     
PRJ430          SELECT TOP(1) CMPNT_ID_CD                                      
PRJ430            INTO :WS-RATE-CMPNT-ID-CD                             
PRJ430            FROM CSS_RATE_COMP_DEF WITH(READUNCOMMITTED)                  
PRJ430           WHERE CODE_UTIL_TYPE   = :J1-CODE-UTIL-TYPE            
PRJ430             AND RATE_PLAN_NO     = :J1-RATE-PLAN-NO              
PRJ430             AND ENERGY_UNIT_CD   = 'B'                           
PRJ430           ORDER BY VERSION_NO_CNTRL DESC, CMPNT_ID_CD            
PRJ430                                              
PRJ430                                                           
PRJ430                                                      
PRJ430     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CMPNT_ID_CD                                              
MFA-TR*           INTO :WS-RATE-CMPNT-ID-CD                                     
MFA-TR*           FROM CSS_RATE_COMP_DEF                                        
MFA-TR*          WHERE CODE_UTIL_TYPE   = :J1-CODE-UTIL-TYPE                    
MFA-TR*            AND RATE_PLAN_NO     = :J1-RATE-PLAN-NO                      
MFA-TR*            AND ENERGY_UNIT_CD   = 'B'                                   
MFA-TR*          ORDER BY VERSION_NO_CNTRL DESC, CMPNT_ID_CD                    
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7910                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ430                                                                  
PRJ430     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
PRJ430                                                                  
PRJ430     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PRJ430        NEXT SENTENCE                                             
PRJ430     ELSE                                                         
PRJ430        MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD65-RETURN-CODE     
PRJ430        MOVE WS-PROGRAM               TO ABEND-PROGRAM            
PRJ430        MOVE '7910'                   TO ACTIVE-PARAGRAPH         
PRJ430        MOVE 'SELECT'                 TO ABEND-FUNCTION           
PRJ430        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
PRJ430                                         ABEND-TABLES             
PRJ430        MOVE 'CSS_RATE_COMP_DEF'      TO TABLE-1                  
PRJ430        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
PRJ430        MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
PRJ430        MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-2          
PRJ430        MOVE FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
PRJ430        MOVE J1-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
PRJ430        MOVE J1-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-3        
PRJ430        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
PRJ430     END-IF.                                                      
PRJ430                                                                  
PRJ430 7910-EXIT.                                                       
PRJ430     EXIT.                                                        
PRJ430*                                                                         
      ****************************************************************          
      ** 7999-GET-DELINQ-VALUE.                                     **          
      ****************************************************************          
       7999-GET-DELINQ-VALUE.                                           
                                                                        
           EXEC SQL                                                     
                SELECT  DELINQ_VALUE                                    
                INTO    :C8-DELINQ-VALUE                                
                FROM    CSS_DELINQUENCY WITH(READUNCOMMITTED)                   
                WHERE   DELINQ_CD  = :C8-DELINQ-CD                      
                AND     COMPANY_NO = :C8-COMPANY-NO                     
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  DELINQ_VALUE                                            
MFA-TR*         INTO    :C8-DELINQ-VALUE                                        
MFA-TR*         FROM    CSS_DELINQUENCY                                         
MFA-TR*         WHERE   DELINQ_CD  = :C8-DELINQ-CD                              
MFA-TR*         AND     COMPANY_NO = :C8-COMPANY-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD65-RETURN-CODE     
              MOVE WS-PROGRAM               TO ABEND-PROGRAM            
              MOVE '7999'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_DELINQUENCY'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-2          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-3          
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-4          
              MOVE WS-CPD65-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1        
              MOVE C8-DELINQ-CD             TO HOSTVAR-ELEMENT-2        
              MOVE C8-COMPANY-NO            TO HOSTVAR-ELEMENT-3        
              MOVE WS-CPD65-FACTOR-ID       TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7999-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      ** 8000-INSERT-FACTOR.                                        **          
      ****************************************************************          
       8000-INSERT-FACTOR.                                              
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_FIXED_FCTR (                            
                         ACCOUNT_NO                                     
                        ,CODE_UTIL_TYPE                                 
                        ,IC_NO                                          
                        ,FIXED_FCTR_SEQ_NO                              
                        ,FACTOR_ID                                      
                        ,EFF_DATE_FROM                                  
                        ,CMPNT_ID_CD                                    
                        ,CODE_SEASON                                    
                        ,INSTR_USE_TYPE_CD                              
                        ,CODE_TIME_PERIOD                               
                        ,EFF_DATE_TO                                    
                        ,FIXED_FCTR_TYP_CD                              
                        ,FACTOR                                         
                        ,FAC_CHRG_BASE_AM                               
                        ,LAST_UPDATE_TS                                 
                        ,DURATION_REMAIN_NO                             
                        ,RT_PKG_OPT_SEQ_NO)                             
               VALUES(   :FF-ACCOUNT-NO                                 
                        ,:FF-CODE-UTIL-TYPE                             
                        ,:FF-IC-NO                                      
                        ,:FF-FIXED-FCTR-SEQ-NO                          
                        ,:FF-FACTOR-ID                                  
                        ,IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )                            
                        ,:FF-CMPNT-ID-CD                                
                        ,:FF-CODE-SEASON                                
                        ,:FF-INSTR-USE-TYPE-CD                          
                        ,:FF-CODE-TIME-PERIOD                           
                        ,IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )                              
                        ,:FF-FIXED-FCTR-TYP-CD                          
                        ,:FF-FACTOR                                     
                        ,:FF-FAC-CHRG-BASE-AM                           
                        , CIS.CURRENT$TIMESTAMP()                             
                        ,:FF-DURATION-REMAIN-NO :WS-NULL-IND-1           
                        ,:FF-RT-PKG-OPT-SEQ-NO)                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_FIXED_FCTR (                                    
MFA-TR*                  ACCOUNT_NO                                             
MFA-TR*                 ,CODE_UTIL_TYPE                                         
MFA-TR*                 ,IC_NO                                                  
MFA-TR*                 ,FIXED_FCTR_SEQ_NO                                      
MFA-TR*                 ,FACTOR_ID                                              
MFA-TR*                 ,EFF_DATE_FROM                                          
MFA-TR*                 ,CMPNT_ID_CD                                            
MFA-TR*                 ,CODE_SEASON                                            
MFA-TR*                 ,INSTR_USE_TYPE_CD                                      
MFA-TR*                 ,CODE_TIME_PERIOD                                       
MFA-TR*                 ,EFF_DATE_TO                                            
MFA-TR*                 ,FIXED_FCTR_TYP_CD                                      
MFA-TR*                 ,FACTOR                                                 
MFA-TR*                 ,FAC_CHRG_BASE_AM                                       
MFA-TR*                 ,LAST_UPDATE_TS                                         
MFA-TR*                 ,DURATION_REMAIN_NO                                     
MFA-TR*                 ,RT_PKG_OPT_SEQ_NO)                                     
MFA-TR*        VALUES(   :FF-ACCOUNT-NO                                         
MFA-TR*                 ,:FF-CODE-UTIL-TYPE                                     
MFA-TR*                 ,:FF-IC-NO                                              
MFA-TR*                 ,:FF-FIXED-FCTR-SEQ-NO                                  
MFA-TR*                 ,:FF-FACTOR-ID                                          
MFA-TR*                 ,:FF-EFF-DATE-FROM                                      
MFA-TR*                 ,:FF-CMPNT-ID-CD                                        
MFA-TR*                 ,:FF-CODE-SEASON                                        
MFA-TR*                 ,:FF-INSTR-USE-TYPE-CD                                  
MFA-TR*                 ,:FF-CODE-TIME-PERIOD                                   
MFA-TR*                 ,:FF-EFF-DATE-TO                                        
MFA-TR*                 ,:FF-FIXED-FCTR-TYP-CD                                  
MFA-TR*                 ,:FF-FACTOR                                             
MFA-TR*                 ,:FF-FAC-CHRG-BASE-AM                                   
MFA-TR*                 , CURRENT TIMESTAMP                                     
MFA-TR*                 ,:FF-DURATION-REMAIN-NO:WS-NULL-IND-1                   
MFA-TR*                 ,:FF-RT-PKG-OPT-SEQ-NO)                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD65-RETURN-CODE     
              MOVE WS-PROGRAM               TO ABEND-PROGRAM            
              MOVE '8000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_FIXED_FCTR'         TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-4          
              MOVE FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE FF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE FF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              MOVE FF-FACTOR-ID             TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 8100-INSERT-MNT-TRANS-HIST.                                **          
      ****************************************************************          
       8100-INSERT-MNT-TRANS-HIST.                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MNT_TRANS_HIST (                         
                      TRANS_HIST_SEQ_NO                                 
                     ,DATE_TRANS                                        
                     ,CODE_TRAN_TYPE                                    
                     ,RESP_AREA_ID                                      
                     ,ACCOUNT_NO                                        
                     ,PREMISE_NO                                        
                     ,CUSTOMER_NO                                       
                     ,USER_ID                                           
                     ,APPL_PROGRAM_ID                                   
                     ,TRAN_COMMENT)                                     
               VALUES( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO)                
                      ,IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) )                               
                      ,:MH-CODE-TRAN-TYPE                               
                      ,:MH-RESP-AREA-ID                                 
                      ,:MH-ACCOUNT-NO                                   
                      ,:MH-PREMISE-NO                                   
                      ,:MH-CUSTOMER-NO                                  
                      ,:MH-USER-ID                                      
                      ,:MH-APPL-PROGRAM-ID                              
                      ,:MH-TRAN-COMMENT)                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MNT_TRANS_HIST (                                 
MFA-TR*               TRANS_HIST_SEQ_NO                                         
MFA-TR*              ,DATE_TRANS                                                
MFA-TR*              ,CODE_TRAN_TYPE                                            
MFA-TR*              ,RESP_AREA_ID                                              
MFA-TR*              ,ACCOUNT_NO                                                
MFA-TR*              ,PREMISE_NO                                                
MFA-TR*              ,CUSTOMER_NO                                               
MFA-TR*              ,USER_ID                                                   
MFA-TR*              ,APPL_PROGRAM_ID                                           
MFA-TR*              ,TRAN_COMMENT)                                             
MFA-TR*        VALUES( :MH-TRANS-HIST-SEQ-NO                                    
MFA-TR*               ,:MH-DATE-TRANS                                           
MFA-TR*               ,:MH-CODE-TRAN-TYPE                                       
MFA-TR*               ,:MH-RESP-AREA-ID                                         
MFA-TR*               ,:MH-ACCOUNT-NO                                           
MFA-TR*               ,:MH-PREMISE-NO                                           
MFA-TR*               ,:MH-CUSTOMER-NO                                          
MFA-TR*               ,:MH-USER-ID                                              
MFA-TR*               ,:MH-APPL-PROGRAM-ID                                      
MFA-TR*               ,:MH-TRAN-COMMENT)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD65-RETURN-CODE     
              MOVE WS-PROGRAM               TO ABEND-PROGRAM            
              MOVE '8100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                                ABEND-TABLES            
              MOVE 'CSS_MNT_TRANS_HIST'     TO TABLE-1                  
              MOVE 'TRANS_HIST_SEQ_NO'      TO TABLE-ELEMENT-1          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE 'DATE_TRANS'             TO TABLE-ELEMENT-3          
              MOVE 'APPL_PROGRAM_ID'        TO TABLE-ELEMENT-4          
              MOVE MH-TRANS-HIST-SEQ-NO     TO HOSTVAR-ELEMENT-1        
              MOVE MH-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2        
              MOVE MH-DATE-TRANS            TO HOSTVAR-ELEMENT-3        
              MOVE MH-APPL-PROGRAM-ID       TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 8200-INSERT-MT-TRN-HST-DET.                                **          
      ****************************************************************          
       8200-INSERT-MT-TRN-HST-DET.                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MT_TRN_HST_DET(                          
                      TRANS_HIST_SEQ_NO                                 
                     ,TRAN_APPL_NO                                      
                     ,COLUMN_DESC                                       
                     ,PRV_COLUMN_VALUE                                  
                     ,CHG_COLUMN_VALUE                                  
                     ,TABLE_ID)                                         
               VALUES( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO)                
                      ,:MI-TRAN-APPL-NO                                 
                      ,:MI-COLUMN-DESC                                  
                      ,:MI-PRV-COLUMN-VALUE                             
                      ,:MI-CHG-COLUMN-VALUE                             
                      ,:MI-TABLE-ID)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_MT_TRN_HST_DET(                                  
MFA-TR*               TRANS_HIST_SEQ_NO                                         
MFA-TR*              ,TRAN_APPL_NO                                              
MFA-TR*              ,COLUMN_DESC                                               
MFA-TR*              ,PRV_COLUMN_VALUE                                          
MFA-TR*              ,CHG_COLUMN_VALUE                                          
MFA-TR*              ,TABLE_ID)                                                 
MFA-TR*        VALUES( :MI-TRANS-HIST-SEQ-NO                                    
MFA-TR*               ,:MI-TRAN-APPL-NO                                         
MFA-TR*               ,:MI-COLUMN-DESC                                          
MFA-TR*               ,:MI-PRV-COLUMN-VALUE                                     
MFA-TR*               ,:MI-CHG-COLUMN-VALUE                                     
MFA-TR*               ,:MI-TABLE-ID)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO WS-CPD65-RETURN-CODE     
              MOVE WS-PROGRAM               TO ABEND-PROGRAM            
              MOVE '8200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_MT_TRN_HST_DET'     TO TABLE-1                  
              MOVE 'TRANS_HIST_SEQ_NO'      TO TABLE-ELEMENT-1          
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2          
              MOVE 'PRV_COLUMN_VALUE'       TO TABLE-ELEMENT-3          
              MOVE 'CHG_COLUMN_VALUE'       TO TABLE-ELEMENT-4          
              MOVE MI-TRANS-HIST-SEQ-NO     TO HOSTVAR-ELEMENT-1        
              MOVE MH-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2        
              MOVE MI-PRV-COLUMN-VALUE      TO HOSTVAR-ELEMENT-3        
              MOVE MI-CHG-COLUMN-VALUE      TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
