      *****************************************************************         
      **   CPD00063                                                  **         
      *****************************************************************         
      *****************************************************************         
      ** THIS COPYBOOK IS USED BY ON-LINE AND BATCH, AND IN          **         
      ** ORDER TO USE IT, YOUR PROGRAM MUST USE A SPECIAL ABEND      **         
      ** ROUTINE, INCLUDE CERTAIN DB2 TABLES AND HAVE SPECIFIC FIELDS**         
      ** POPULATED PRIOR TO PERFORMING THIS ROUTINE.  SEE THE SECTION**         
      ** LABELED REQUIRED FIELDS AND TABLES.  ADDITIONALLY, THE      **         
      ** PROGRAM NEEDS TO SET THE APPROPRIATE SWITCHES, SO THAT ONLY **         
      ** THE DATA NEEDED BY THE PROGRAM IS RETURNED, ELIMINATING THE **         
      ** NEED TO GO THROUGH LOGIC UNNECESSARILY                      **         
      *****************************************************************         
      *****************************************************************         
      **                                                             **         
      **              PROGRAM  MODIFICATION  LOG                     **         
      **              --------------------------                     **         
      **    DATE    INITIALS   REASON                                **         
      **  --------  --------   ------                                **         
      **  06/18/07  ANAND    COPYBOOK ORIGINALLY WRITTEN             **         
      **  01/01/08  JC91900  ACCOUNT LEVEL THERM PRICE CHANGES.      **         
PRDFIX**  07/14/08  JC91900  FIX PROD ISSUE.                         **         
PRDFIJ**  08/29/08  JC91900  FIX PROD ISSUE.                         **         
P00141**  04/14/09  SS97726  ADD START/END DATE TO CRM USER TABLE    **         
P00141**                     CRM_OPT_ATTR_INCTV TO HAVE MULTIPLE VRSN**         
I00251**  05/29/09  JC91900  PICK FUTURE CSC AND THERM PRICE AT THE  **         
I00251**                     OF RENEWALS.                            **         
P00165**  07/31/09  SS97726  SET THERM PRICE TO ZERO FOR STEP RATES. **         
I00484**  08/10/09  VY95550  GET PENDING OPTION PRICE DETAILS FOR A  **         
I00484**                     FIXED RATE CUSTOMER                     **         
P00120**  09/10/09  VY95550  CHANGES MADE TO USE VERS_PRORATE_CD OF  **         
P00120**                     CSS_SPCL_FCTR_APPL TABLE                **         
P00211**  11/17/09  JC91900  Added Exit fee column to return field.  **         
JCFIXX**  10/07/10  JC91900  Consider TS for factor end date calc.   **         
A02804**  11/01/10  MN90523  included INT_DISP_END_TS for combofixed **         
P00477**  01/24/10  JC91900  Add rate definition code.               **         
A03280**  04/2011   DM94438  Handle new rate renewal program name    **         
A03280**                     to pick next month price               **          
P00473**  06/2011   SB93596  CHGS INCLUDED TO PULL APPROVED          **         
P00473**                     OPTION/ATTR INCTV RECORDS.              **         
A04019**  05/2012   VIJAY    SEB CSC changes.                        **         
P00677**  07/01/12  GD97441  7570 PARA: FIX DURATION REMAIN QUERY    **         
P00680**  08/18/12  SS97726  CUSTOMER RETENTION AND ACQUISITION.     **         
P00610**  18/01/13  MS93554  GETTING THERM PRICE EFFECTIVE DATE      **         
      **                     FOR THE FACTOR.                         **         
ACT060**  28/05/13  DB41297  CHECK FOR NOT-FOUND IN PARA 7450-       **         
P00805**  01/25/16  SS45239  CSC Increase and Discounts.             **         
P00805**                  1. Do not process option attributes for    **         
P00805**                     therm price/CSC when determining account**         
P00805**                     level values.                           **         
P805CS**                  2. Adjust net CSC based on discounts.      **         
P805AP**  05/10/16  SV95326  ADVANCED PRICING ACCOUNT ATTRIBUTE      **         
P805AP**                     CHANGES.                                **         
ACT002**  08/30/16  GD43988  PRODFIX-RETURN GROSS CSC INSTEAD OF NET **         
ACT002**           APPL5631  FOR PCSCA153 CALL.                      **         
A05724**  01/12/17  SS45239  PRODFIX-DO NOT APPLY CSC DISCOUNTS WHEN **         
A05724**            ACT002   RECEIVING BUT NO LONGER ELIGIBLE.       **         
      *****************************************************************         
      *                                                                         
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
      **  RATE FACTORS ACCOCIATED WITH THE GIVEN RATE PLAN AND UTIL   **        
      **  TYPE.                                                       **        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE RATE_FCTR CURSOR FOR                             
                 SELECT SF.FACTOR_ID                                    
                       ,SF.FACTOR_TYPE                                  
P00120                 ,SA.VERS_PRORATE_CD                              
                       ,SF.ADJUST_ELEMENT                               
                       ,SF.SPCL_GROUP_CD                                
                       ,SF.OVR_RT_CALC_TYP_CD                           
                       ,SA.DATE_FROM                                    
                       ,SA.DATE_TO                                      
                       ,SA.FACTOR                                       
JCFIXX                 ,SF.RT_ATTR_INCTV_TYPE                           
                   FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)             
                       ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)             
                  WHERE SA.FACTOR_ID      = SF.FACTOR_ID                
                    AND SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE          
                    AND SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO            
                    AND SF.FACTOR_TYPE    IN ('A')                      
                    AND SA.CODE_STATUS    IN ('A')                      
JCFIXX              AND SF.ADJUST_ELEMENT IN ('C','F','J', 'L','O','N') 
                    AND SA.INT_DISP_START_TS <= CIS.CURRENT$TIMESTAMP()       
                  ORDER BY DATE_FROM DESC                               
                          ,SF.FACTOR_ID DESC                            
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE RATE_FCTR CURSOR FOR                                     
MFA-TR*          SELECT SF.FACTOR_ID                                            
MFA-TR*                ,SF.FACTOR_TYPE                                          
MFA-TR*                ,SA.VERS_PRORATE_CD                                      
MFA-TR*                ,SF.ADJUST_ELEMENT                                       
MFA-TR*                ,SF.SPCL_GROUP_CD                                        
MFA-TR*                ,SF.OVR_RT_CALC_TYP_CD                                   
MFA-TR*                ,SA.DATE_FROM                                            
MFA-TR*                ,SA.DATE_TO                                              
MFA-TR*                ,SA.FACTOR                                               
MFA-TR*                ,SF.RT_ATTR_INCTV_TYPE                                   
MFA-TR*            FROM CSS_SPCL_FCTR_APPL SA                                   
MFA-TR*                ,CSS_SPCL_FCTR      SF                                   
MFA-TR*           WHERE SA.FACTOR_ID      = SF.FACTOR_ID                        
MFA-TR*             AND SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE                  
MFA-TR*             AND SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO                    
MFA-TR*             AND SF.FACTOR_TYPE    IN ('A')                              
MFA-TR*             AND SA.CODE_STATUS    IN ('A')                              
MFA-TR*             AND SF.ADJUST_ELEMENT IN ('C','F','J', 'L','O','N')         
MFA-TR*             AND SA.INT_DISP_START_TS <= CURRENT TIMESTAMP               
MFA-TR*           ORDER BY DATE_FROM DESC                                       
MFA-TR*                   ,SF.FACTOR_ID DESC                                    
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING NON-RATE   **        
      **  FACTORS.                                                    **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE SPCL_FCTR CURSOR FOR                             
                 SELECT SF.FACTOR_ID                                    
                       ,SF.FACTOR_TYPE                                  
P00120                 ,SA.VERS_PRORATE_CD                              
                       ,SF.ADJUST_ELEMENT                               
                       ,SF.SPCL_GROUP_CD                                
                       ,SF.OVR_RT_CALC_TYP_CD                           
                       ,SA.DATE_FROM                                    
                       ,SA.DATE_TO                                      
                       ,SA.FACTOR                                       
JCFIXX                 ,SF.RT_ATTR_INCTV_TYPE                           
                   FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)             
                       ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)             
                  WHERE SA.FACTOR_ID      = SF.FACTOR_ID                
                    AND SA.FACTOR_ID      = :SA-FACTOR-ID               
                    AND SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE          
                    AND SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO            
P00680              AND SF.ADJUST_ELEMENT IN ('A','C','F','J',          
P00680                                            'L','O','N')          
A02804              AND SA.CODE_STATUS    IN ('A', 'S')                 
A02804              AND ( ( SF.FACTOR_TYPE IN ('V','F')                 
A02804                  AND SA.INT_DISP_START_TS <= 
           CIS.CURRENT$TIMESTAMP()   
A02804                    ) OR                                          
A02804                    ( SF.FACTOR_TYPE IN ('B')                     
A02804                  AND SA.INT_DISP_START_TS <= 
           CIS.CURRENT$TIMESTAMP()   
A02804                  AND SA.INT_DISP_END_TS  >  
           CIS.CURRENT$TIMESTAMP() ) )
                  ORDER BY DATE_FROM DESC                               
                          ,SF.FACTOR_ID DESC                            
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SPCL_FCTR CURSOR FOR                                     
MFA-TR*          SELECT SF.FACTOR_ID                                            
MFA-TR*                ,SF.FACTOR_TYPE                                          
MFA-TR*                ,SA.VERS_PRORATE_CD                                      
MFA-TR*                ,SF.ADJUST_ELEMENT                                       
MFA-TR*                ,SF.SPCL_GROUP_CD                                        
MFA-TR*                ,SF.OVR_RT_CALC_TYP_CD                                   
MFA-TR*                ,SA.DATE_FROM                                            
MFA-TR*                ,SA.DATE_TO                                              
MFA-TR*                ,SA.FACTOR                                               
MFA-TR*                ,SF.RT_ATTR_INCTV_TYPE                                   
MFA-TR*            FROM CSS_SPCL_FCTR_APPL SA                                   
MFA-TR*                ,CSS_SPCL_FCTR      SF                                   
MFA-TR*           WHERE SA.FACTOR_ID      = SF.FACTOR_ID                        
MFA-TR*             AND SA.FACTOR_ID      = :SA-FACTOR-ID                       
MFA-TR*             AND SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE                  
MFA-TR*             AND SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO                    
MFA-TR*             AND SF.ADJUST_ELEMENT IN ('A','C','F','J',                  
MFA-TR*                                           'L','O','N')                  
MFA-TR*             AND SA.CODE_STATUS    IN ('A', 'S')                         
MFA-TR*             AND ( ( SF.FACTOR_TYPE IN ('V','F')                         
MFA-TR*                 AND SA.INT_DISP_START_TS <= CURRENT TIMESTAMP           
MFA-TR*                   ) OR                                                  
MFA-TR*                   ( SF.FACTOR_TYPE IN ('B')                             
MFA-TR*                 AND SA.INT_DISP_START_TS <= CURRENT TIMESTAMP           
MFA-TR*                 AND SA.INT_DISP_END_TS  >  CURRENT TIMESTAMP ) )        
MFA-TR*           ORDER BY DATE_FROM DESC                                       
MFA-TR*                   ,SF.FACTOR_ID DESC                                    
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
      **  FACTOR IDS ASSOCIATED WITH THE GIVEN OPTION CD.             **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
               DECLARE ATTR_INCTV CURSOR FOR                            
                 SELECT  HQ.FACTOR_ID                                   
                        ,HQ.ATTR_INCTV_VALUE                            
                        ,HQ.PRIMRY_OPT_ATTR_FL                          
                        ,HQ.DURATION_NO                                 
                        ,HQ.RT_ATTR_INCTV_TYPE                          
                   FROM  CRM_OPT_ATTR_INCTV  HQ                         
                  WHERE  HQ.OPTION_CD          = :HQ-OPTION-CD          
I00484              AND  ATTR_INCTV_STRT_DT   <= IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) ) 
I00484              AND  ATTR_INCTV_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                  :HQ-ATTR-INCTV-END-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-END-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-END-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-END-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-END-DT) )  
I00484              AND  HQ.PROC_STATUS_CD     = 'AC'                   
P00473              AND HQ.OPT_ATTR_VSTART_TS = (                       
P00473               SELECT MAX(H1.OPT_ATTR_VSTART_TS)                  
P00473                 FROM CRM_OPT_ATTR_INCTV H1                       
P00473                WHERE H1.OPTION_CD    = HQ.OPTION_CD              
P00473                  AND H1.RT_ATTR_INCTV_TYPE                       
P00473                                      = HQ.RT_ATTR_INCTV_TYPE     
P00473                  AND H1.ATTR_INCTV_STRT_DT                       
P00473                                     <= IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )    
P00473                  AND H1.ATTR_INCTV_END_DT                        
P00473                                     >= IIF(TRY_CONVERT(DATE, 
                                                  :HQ-ATTR-INCTV-END-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-END-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-END-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-END-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-END-DT) )     
P00473                  AND CAST(H1.OPT_ATTR_VSTART_TS AS DATE)                 
P00473                                     <= IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )    
P00473                  AND CAST(H1.OPT_ATTR_VEND_TS AS DATE)                   
P00473                                     >= IIF(TRY_CONVERT(DATE, 
                                                  :HQ-ATTR-INCTV-END-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-END-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-END-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-END-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-END-DT) )     
P00473                  AND H1.PROC_STATUS_CD      = 'AC')              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ATTR_INCTV CURSOR FOR                                    
MFA-TR*          SELECT  HQ.FACTOR_ID                                           
MFA-TR*                 ,HQ.ATTR_INCTV_VALUE                                    
MFA-TR*                 ,HQ.PRIMRY_OPT_ATTR_FL                                  
MFA-TR*                 ,HQ.DURATION_NO                                         
MFA-TR*                 ,HQ.RT_ATTR_INCTV_TYPE                                  
MFA-TR*            FROM  CRM_OPT_ATTR_INCTV  HQ                                 
MFA-TR*           WHERE  HQ.OPTION_CD          = :HQ-OPTION-CD                  
MFA-TR*             AND  ATTR_INCTV_STRT_DT   <= :HQ-ATTR-INCTV-STRT-DT         
MFA-TR*             AND  ATTR_INCTV_END_DT    >= :HQ-ATTR-INCTV-END-DT          
MFA-TR*             AND  HQ.PROC_STATUS_CD     = 'AC'                           
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS = (                               
MFA-TR*              SELECT MAX(H1.OPT_ATTR_VSTART_TS)                          
MFA-TR*                FROM CRM_OPT_ATTR_INCTV H1                               
MFA-TR*               WHERE H1.OPTION_CD    = HQ.OPTION_CD                      
MFA-TR*                 AND H1.RT_ATTR_INCTV_TYPE                               
MFA-TR*                                     = HQ.RT_ATTR_INCTV_TYPE             
MFA-TR*                 AND H1.ATTR_INCTV_STRT_DT                               
MFA-TR*                                    <= :HQ-ATTR-INCTV-STRT-DT            
MFA-TR*                 AND H1.ATTR_INCTV_END_DT                                
MFA-TR*                                    >= :HQ-ATTR-INCTV-END-DT             
MFA-TR*                 AND DATE(H1.OPT_ATTR_VSTART_TS)                         
MFA-TR*                                    <= :HQ-ATTR-INCTV-STRT-DT            
MFA-TR*                 AND DATE(H1.OPT_ATTR_VEND_TS)                           
MFA-TR*                                    >= :HQ-ATTR-INCTV-END-DT             
MFA-TR*                 AND H1.PROC_STATUS_CD      = 'AC')                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING THERM PRICE**        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE ACCT_FCTR CURSOR FOR                             
                 SELECT FF.FACTOR                                       
                       ,SF.ADJUST_ELEMENT                               
                       ,SF.VERS_PRORATE_CD                              
                       ,FF.EFF_DATE_FROM                                
                       ,FF.EFF_DATE_TO                                  
                       ,FF.DURATION_REMAIN_NO                           
                       ,SF.FACTOR_TYPE                                  
                       ,SF.VERS_PRORATE_CD                              
                       ,SF.SPCL_GROUP_CD                                
I00484                 ,FF.RT_PKG_OPT_SEQ_NO                            
P00680                 ,SF.RT_ATTR_INCTV_TYPE                           
P00805                 ,SF.DURATION_TYPE_CD                             
                   FROM CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                  
                       ,CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                 
                  WHERE FF.FACTOR_ID      = SF.FACTOR_ID                
                    AND FF.ACCOUNT_NO     = :FF-ACCOUNT-NO              
                    AND FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE          
                    AND FF.IC_NO          = :FF-IC-NO                   
                    AND SF.FACTOR_TYPE    IN ('B','F')                  
                    FOR READ ONLY                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ACCT_FCTR CURSOR FOR                                     
MFA-TR*          SELECT FF.FACTOR                                               
MFA-TR*                ,SF.ADJUST_ELEMENT                                       
MFA-TR*                ,SF.VERS_PRORATE_CD                                      
MFA-TR*                ,FF.EFF_DATE_FROM                                        
MFA-TR*                ,FF.EFF_DATE_TO                                          
MFA-TR*                ,FF.DURATION_REMAIN_NO                                   
MFA-TR*                ,SF.FACTOR_TYPE                                          
MFA-TR*                ,SF.VERS_PRORATE_CD                                      
MFA-TR*                ,SF.SPCL_GROUP_CD                                        
MFA-TR*                ,FF.RT_PKG_OPT_SEQ_NO                                    
MFA-TR*                ,SF.RT_ATTR_INCTV_TYPE                                   
MFA-TR*                ,SF.DURATION_TYPE_CD                                     
MFA-TR*            FROM CSS_SPCL_FCTR SF                                        
MFA-TR*                ,CSS_FIXED_FCTR FF                                       
MFA-TR*           WHERE FF.FACTOR_ID      = SF.FACTOR_ID                        
MFA-TR*             AND FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                      
MFA-TR*             AND FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE                  
MFA-TR*             AND FF.IC_NO          = :FF-IC-NO                           
MFA-TR*             AND SF.FACTOR_TYPE    IN ('B','F')                          
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            
      ******************************************************************        
      **  0100-MAIN-PROCESS.                                          **        
      ******************************************************************        
      *                                                                         
       0100-MAIN-PROCESS.                                               
                                                                        
           PERFORM 1000-INITIALIZE-PROCEDURE THRU 1000-EXIT.            
                                                                        
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-INITIALIZE-PROCEDURE.                                       
                                                                        
I00484     INITIALIZE LS-CWS063-RETURN-FIELDS                           
I00484                WS-CALC-VARIABLES                                 
I00484                WS-RETURN-FIELDS-063.                             
           MOVE 'N'                      TO WS-NO-MORE-ROWS1            
                                           ,WS-NO-MORE-ROWS2.           
                                                                        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                          **        
      *     CALCULATE THE FIRST AND THE LAST DAY OF THE GIVEN REVENUE **        
      *     MONTH AND PROCESS ALL THE FACTORS.                        **        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
I00484     IF WS-ACCOUNT-NO-063 > ZEROS                                 
I00251        MOVE WS-ACCOUNT-NO-063            TO AT-ACCOUNT-NO        
I00251        PERFORM 7610-SELECT-ACCOUNT-DET   THRU 7610-EXIT          
I00484     END-IF.                                                      
I00484                                                                  
I00484     MOVE 'N'                          TO WS-PEND-OPTION-FLAG.    
I00484     IF WS-PENDING-OPTION-FL-063 = 'Y'                            
I00484                     OR WS-THERM-CSC-ACCT-FL EQUAL 'Y'            
I00484        IF WS-ACCOUNT-NO-063 > ZEROES                             
I00484         AND WS-IC-NO-063 > ZEROES                                
I00484         AND WS-CODE-UTIL-TYPE-063 > SPACES                       
I00484          MOVE WS-ACCOUNT-NO-063       TO DF-ACCOUNT-NO           
I00484          MOVE WS-CODE-UTIL-TYPE-063   TO DF-CODE-UTIL-TYPE       
I00484          MOVE WS-IC-NO-063            TO DF-IC-NO                
I00484          MOVE WS-PENDING-OPTION       TO DF-STATUS-CD            
I00484          MOVE 'N'                     TO WS-PEND063-OPT-EXIST-FL 
I00484          PERFORM 7650-CHECK-PEND-OPTION  THRU 7650-EXIT          
I00484          MOVE DF-RT-PKG-OPT-SEQ-NO    TO WS-PEND-PKG-OPT-SEQ-NO  
I00484        END-IF                                                    
I00484     END-IF.                                                      
I00484                                                                  
I00251     IF WS-CALLED-FROM-RENEWAL-PGMS                               
I00251        MOVE 'COMMON'                  TO G6-PROGRAM-NAME         
I00251        MOVE '01'                      TO G6-COMPANY-NO           
I00251        MOVE 'DATE'                    TO G6-CMND-CODE            
I00251        MOVE 10                        TO G6-SEQ-NO               
I00251        PERFORM 7000-SELECT-JOB-PARM      THRU 7000-EXIT          
I00251        MOVE G6-PARM-DATA(10:10)       TO WS-COMMON-DATE          
I00251        MOVE WS-ACCOUNT-NO-063         TO UT-ACCOUNT-NO           
I00251        MOVE WS-CODE-UTIL-TYPE-063     TO UT-CODE-UTIL-TYPE       
I00251        MOVE WS-IC-NO-063              TO UT-IC-NO                
I00251        PERFORM 7640-SEL-RT-PKG-OPT-STAT  THRU 7640-EXIT          
I00251        IF DF-STATUS-CD EQUAL WS-OPEN-FOR-RENEWAL                 
I00251           PERFORM 2050-CALC-FUTURE-DATES THRU 2050-EXIT          
I00251        ELSE                                                      
I00251           PERFORM 2100-CALC-EFFECTIVE-DATE THRU 2100-EXIT        
I00251        END-IF                                                    
I00251     ELSE                                                         
A03280       IF WS-GET-NEXT-MONTH-PRICE AND AT-REV-MTH-LST-NRML  > 0    
A03280          PERFORM 5250-NXT-REV-MONTH THRU 5250-EXIT               
A03280       ELSE                                                       
A03280          PERFORM 2100-CALC-EFFECTIVE-DATE THRU 2100-EXIT         
A03280       END-IF                                                     
I00251     END-IF                                                       
      *                                                                         
           PERFORM 2200-BUILD-RESULT            THRU 2200-EXIT.         
                                                                        
P805CS     MOVE WS-ACCOUNT-NO-063            TO WS-444-I-ACCT-NO.       
P805CS     MOVE PROGRAM-NAME                 TO WS-444-I-PGM-ID.        
P805CS     MOVE SPACES                       TO WS-444-I-USER-ID.       
P805CS                                                                  
P805CS     PERFORM 6000-CPD444-CSC-DISCOUNT-ELIG                        
P805CS        THRU 6000-CPD444-EXIT.                                    
P805CS                                                                  
P805CS     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P805CS        SET WS-CSC-DSCNT-063-INDX      TO 1                       
P805CS        MOVE WS-444-O-ACCT-QLFY-FL     TO WS-CSC-DSCNT-QLFY-FL-063
P805CS        PERFORM VARYING WS-444-S FROM 1 BY 1                      
P805CS                  UNTIL WS-444-S > 10                             
P805CS                     OR WS-444-O-ELIG-FL (WS-444-S) = SPACES      
P805CS           MOVE WS-444-O-DISC-CD    (WS-444-S)                    
P805CS             TO WS-CSC-DSCNT-CD-063       (WS-CSC-DSCNT-063-INDX) 
P805CS           MOVE WS-444-O-FCTR-ID    (WS-444-S)                    
P805CS             TO WS-CSC-DSCNT-FCTR-ID-063  (WS-CSC-DSCNT-063-INDX) 
P805CS           MOVE WS-444-O-ELIG-FL    (WS-444-S)                    
P805CS             TO WS-CSC-DSCNT-ELIG-FL-063  (WS-CSC-DSCNT-063-INDX) 
P805CS           MOVE WS-444-O-RECV-FL    (WS-444-S)                    
P805CS             TO WS-CSC-DSCNT-RECV-FL-063  (WS-CSC-DSCNT-063-INDX) 
P805CS           IF WS-THERM-CSC-ACCT-FL         EQUAL 'Y' AND          
P805CS              WS-CSC-TIMELINE-FL-063   NOT EQUAL 'Y' AND          
A05724*************(WS-444-O-RECV-FL  (WS-444-S) EQUAL 'Y' OR                   
P805CS              WS-444-O-ELIG-FL  (WS-444-S) EQUAL 'Y'              
ACT002              IF WS-CPD063-CALLING-PGM NOT = 'PCSCA153' AND       
ACT002                 WS-CPD063-CALLING-PGM NOT = 'PCSC153R'           
ACT002                 COMPUTE WS-CSC-AMT = WS-CSC-AMT                  
ACT002                                    - WS-444-O-FACTOR (WS-444-S)  
ACT002              END-IF                                              
P805CS           END-IF                                                 
P805CS           MOVE WS-444-O-PROMOTE-FL (WS-444-S)                    
P805CS             TO WS-CSC-DSCNT-PROMO-FL-063 (WS-CSC-DSCNT-063-INDX) 
P805CS           MOVE WS-444-O-DT-FROM    (WS-444-S)                    
P805CS             TO WS-CSC-DSCNT-FROM-DT-063  (WS-CSC-DSCNT-063-INDX) 
P805CS           MOVE WS-444-O-DT-TO      (WS-444-S)                    
P805CS             TO WS-CSC-DSCNT-TO-DT-063    (WS-CSC-DSCNT-063-INDX) 
P805CS           MOVE WS-444-O-FACTOR     (WS-444-S)                    
P805CS             TO WS-CSC-DSCNT-FACTOR-063   (WS-CSC-DSCNT-063-INDX) 
P805CS           MOVE WS-444-O-DELINQ-VAL (WS-444-S)                    
P805CS             TO WS-CSC-DSCNT-DLQ-VAL-063  (WS-CSC-DSCNT-063-INDX) 
P805CS            SET WS-CSC-DSCNT-063-INDX UP BY 1                     
P805CS        END-PERFORM                                               
P805CS     ELSE                                                         
P805CS        PERFORM 6999-CPD444-ERROR-ROUTINE                         
P805CS           THRU 6999-CPD444-EXIT                                  
P805CS     END-IF.                                                      
                                                                        
P805AP     IF WS-ADV-PRC-OPT-FL-063 = 'Y'AND                            
P805AP        WS-ACCOUNT-NO-063 > ZEROS                                 
P805AP        MOVE WS-ACCOUNT-NO-063      TO YP-ACCOUNT-NO              
P805AP        MOVE 'ADVANCED PRICE'       TO YP-ATTRIBUTE-DESC          
P805AP        MOVE 'A'                    TO YP-STATUS-CD               
P805AP        MOVE 'N'                    TO WS-ADV-PRC-OPT-FL-063      
P805AP        PERFORM 7900-GET-ACCOUNT-ATTRIBUTE THRU 7900-EXIT         
P805AP     END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
I00251******************************************************************        
I00251*                                                                *        
I00251* 2050-CALC-FUTURE-DATES.                                        *        
I00251******************************************************************        
I00251 2050-CALC-FUTURE-DATES.                                          
I00251                                                                  
I00484     PERFORM 2102-CALC-ACTIVE-DATE        THRU 2102-EXIT.         
I00251                                                                  
I00251     MOVE WS-START-DATE                TO WS-COM-REV-MONTH-FROM.  
I00251     MOVE WS-REV-MONTH-TMP             TO RW-REVENUE-MONTH        
I00251     MOVE AT-BILL-CYCLE                TO RW-READ-CYCLE           
I00251     PERFORM 7620-SELECT-READ-WINDOW      THRU 7620-EXIT          
I00251     MOVE RW-OPTIMUM-READ-DATE         TO WS-REV-PRT-DT-FRM.      
I00484                                                                  
I00484     IF PEND-OPTION-EXIST                                         
I00484        PERFORM 2102-CALC-ACTIVE-DATE     THRU 2102-EXIT          
I00484        MOVE WS-START-DATE             TO                         
I00484                                       WS-PEND-COMMON-DATE        
I00484                                       WS-PEND-COM-REV-MONTH-FROM 
I00484                                                                  
I00484        MOVE WS-REV-MONTH-TMP          TO RW-REVENUE-MONTH        
I00484        MOVE AT-BILL-CYCLE             TO RW-READ-CYCLE           
I00484        PERFORM 7620-SELECT-READ-WINDOW   THRU 7620-EXIT          
I00484        MOVE RW-OPTIMUM-READ-DATE      TO WS-PEND-REV-PRT-DT-FRM  
I00484     END-IF.                                                      
I00251                                                                  
I00251 2050-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
I00251******************************************************************        
I00251*                                                                *        
I00251* 2100-CALC-EFFECTIVE-DATE.                                      *        
I00251******************************************************************        
I00251 2100-CALC-EFFECTIVE-DATE.                                        
I00251                                                                  
I00251     MOVE 'COMMON'                    TO G6-PROGRAM-NAME          
I00251     MOVE '01'                        TO G6-COMPANY-NO            
I00251     MOVE 'DATE'                      TO G6-CMND-CODE             
I00251     MOVE 10                          TO G6-SEQ-NO                
I00251     PERFORM 7000-SELECT-JOB-PARM     THRU 7000-EXIT              
I00251     MOVE G6-PARM-DATA(10:10)         TO WS-COMMON-DATE           
I00251     MOVE WS-COMMON-DATE              TO WS-REV-PRT-DT-FRM        
I00251     MOVE WS-REV-PRT-DT-FRM           TO WS-ADD-ONE-MTH-DT        
I00251     PERFORM 7100-ADD-ONE-MONTH       THRU 7100-EXIT              
I00251     MOVE WS-RESULT-DATE              TO WS-REV-PRT-DT-TO         
I00251     MOVE 20                          TO G6-SEQ-NO                
I00251     PERFORM 7000-SELECT-JOB-PARM     THRU 7000-EXIT              
I00251     MOVE G6-PARM-DATA(15:6)          TO WS-COM-REV-MONTH.        
I00251     MOVE WS-COM-REV-MONTH(1:4)       TO WS-START-YR              
I00251     MOVE WS-COM-REV-MONTH(5:2)       TO WS-START-MT              
I00251     MOVE '01'                        TO WS-START-DY              
I00251     MOVE WS-START-DATE               TO WS-COM-REV-MONTH-FROM.   
I00251     MOVE WS-COM-REV-MONTH-FROM       TO WS-ADD-ONE-MTH-DT        
I00251     PERFORM 7100-ADD-ONE-MONTH       THRU 7100-EXIT              
I00251     MOVE WS-RESULT-DATE              TO WS-COM-REV-MONTH-TO.     
I00484                                                                  
I00484     IF PEND-OPTION-EXIST                                         
A04019        IF WS-CSC-TIMELINE-FL-063   = 'Y'  AND                    
A04019           WS-DATE-FOR-CSC-TIMELINE > SPACES                      
A04019           MOVE DF-STATUS-EFF-REV-MTH TO WS-REV-MONTH-TMP         
A04019           MOVE WS-START-YR-N         TO WS-START-YR              
A04019           MOVE WS-START-MT-N         TO WS-START-MT              
A04019           MOVE '05'                  TO WS-START-DY              
I00484           MOVE WS-START-DATE         TO WS-SAVE-PEND-DATE        
A04019        ELSE                                                      
I00484           PERFORM 2102-CALC-ACTIVE-DATE     THRU 2102-EXIT       
I00484           MOVE WS-START-DATE      TO WS-PEND-COMMON-DATE         
I00484                                      WS-PEND-REV-PRT-DT-FRM      
I00484                                      WS-PEND-COM-REV-MONTH-FROM  
A04019        END-IF                                                    
I00484     END-IF.                                                      
I00251                                                                  
I00251 2100-EXIT.                                                       
I00251     EXIT.                                                        
I00251*                                                                         
I00484*****************************************************************         
I00484* 2102-CALC-ACTIVE-DATE.                                       **         
I00484*                                                              **         
I00484*****************************************************************         
I00484 2102-CALC-ACTIVE-DATE.                                           
I00484*                                                                         
I00484     PERFORM 2105-GET-DURATION-REM        THRU 2105-EXIT.         
ACT060     IF AT-REV-MTH-LST-NRML > ZEROS                               
ACT060        MOVE AT-REV-MTH-LST-NRML      TO WS-REV-MONTH-TMP         
ACT060     ELSE                                                         
ACT060        PERFORM 7670-GET-BILL-CYC-DT THRU 7670-EXIT               
ACT060     END-IF.                                                      
I00484     COMPUTE WS-MONTHS-TO-ADD = WS-FF-DURATION-REM-063 + 1        
I00484     PERFORM 2110-STEP-UP-MONTHS          THRU 2110-EXIT.         
I00484                                                                  
I00484     MOVE WS-START-YR-N               TO WS-START-YR.             
I00484     MOVE WS-START-MT-N               TO WS-START-MT.             
I00484     MOVE '01'                        TO WS-START-DY.             
I00484*                                                                         
I00484 2102-EXIT.                                                       
I00484     EXIT.                                                        
I00484*                                                                         
I00484*****************************************************************         
I00484* 2105-GET-DURATION-REM.                                       **         
I00484*                                                              **         
I00484*****************************************************************         
I00484 2105-GET-DURATION-REM.                                           
I00484*                                                                         
I00484                                                                  
I00484     IF  WS-ACCOUNT-NO-063 > ZEROES                               
I00484       AND WS-IC-NO-063 > ZEROES                                  
I00484       AND WS-CODE-UTIL-TYPE-063 > SPACES                         
I00484        MOVE WS-OPTION-CD           TO HQ-OPTION-CD               
I00484        MOVE WS-ACCOUNT-NO-063      TO FF-ACCOUNT-NO              
I00484        MOVE WS-CODE-UTIL-TYPE-063  TO FF-CODE-UTIL-TYPE          
I00484        MOVE WS-IC-NO-063           TO FF-IC-NO                   
I00484                                                                  
I00484        MOVE ZEROES                 TO WS-FF-DURATION-REM-063     
I00484        MOVE WS-COMMON-DATE         TO HQ-ATTR-INCTV-STRT-DT      
I00484                                       HQ-ATTR-INCTV-END-DT       
I00484                                                                  
I00484        PERFORM 7570-SEL-FF-DUR-REM    THRU 7570-EXIT             
I00484        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
I00484           MOVE FF-DURATION-REMAIN-NO                             
I00484                                    TO WS-FF-DURATION-REM-063     
I00484        END-IF                                                    
I00484     END-IF.                                                      
I00484*                                                                         
I00484 2105-EXIT.                                                       
I00484     EXIT.                                                        
I00251*                                                                         
I00484*****************************************************************         
I00484* 2110-STEP-UP-MONTHS.                                         **         
I00484*                                                              **         
I00484*****************************************************************         
I00484 2110-STEP-UP-MONTHS.                                             
I00484                                                                  
I00484     PERFORM WS-MONTHS-TO-ADD TIMES                               
I00484       COMPUTE WS-START-MT-N = WS-START-MT-N + 1                  
I00484       IF WS-START-MT-N > 12                                      
I00484          COMPUTE WS-START-YR-N = WS-START-YR-N + 1               
I00484          MOVE 01                     TO WS-START-MT-N            
I00484       END-IF                                                     
I00484     END-PERFORM.                                                 
I00484*                                                                         
I00484 2110-EXIT.                                                       
I00484     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
      *                                                                         
           MOVE WS-OPTION-CD                 TO  FI-OPTION-CD           
                                                ,HQ-OPTION-CD.          
                                                                        
I00484     MOVE WS-COMMON-DATE              TO HQ-ATTR-INCTV-STRT-DT    
I00484                                         HQ-ATTR-INCTV-END-DT.    
I00484                                                                  
I00484     SET CURR-OPTION-MODE             TO TRUE.                    
I00484     PERFORM 2210-PROCESS-OPTION-CD   THRU 2210-EXIT.             
I00484     PERFORM 2450-MOVE-CURR-OPTN-DET  THRU 2450-EXIT.             
I00484                                                                  
           IF WS-CTR-ROWS = 0                                           
              MOVE NOT-FOUND                TO RS-RETURN-CODE           
           END-IF.                                                      
P00165                                                                  
I00484     IF J1-LAST-ENERGY-BLOCK > 1                                  
P00165        MOVE ZEROES                   TO WS-THERM-PRICE           
P00165     END-IF.                                                      
I00484                                                                  
I00484     IF PEND-OPTION-EXIST                                         
I00484        SET PEND-OPTION-MODE          TO TRUE                     
I00484        PERFORM 2205-PROCESS-PEND-OPTN    THRU 2205-EXIT          
I00484                                                                  
I00484        IF J1-LAST-ENERGY-BLOCK > 1                               
I00484           MOVE ZEROES                TO WS-PEND063-THERM-PRICE   
I00484        END-IF                                                    
I00484     END-IF.                                                      
I00484                                                                  
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
I00484******************************************************************        
I00484* 2205-PROCESS-PEND-OPTN.                                        *        
I00484*                                                                *        
I00484******************************************************************        
I00484 2205-PROCESS-PEND-OPTN.                                          
I00484*                                                                         
I00484     PERFORM 2500-INIT-063-VARIABLES   THRU 2500-EXIT.            
I00484                                                                  
I00484     MOVE DF-OPTION-CD                TO FI-OPTION-CD             
I00484                                        ,HQ-OPTION-CD.            
I00484     PERFORM 2210-PROCESS-OPTION-CD    THRU 2210-EXIT.            
I00484     PERFORM 2600-MOVE-PEND-OPTN-DET   THRU 2600-EXIT.            
I00484*                                                                         
I00484 2205-EXIT.                                                       
I00484     EXIT.                                                        
I00484*                                                                         
I00484******************************************************************        
I00484* 2210-PROCESS-OPTION-CD.                                        *        
I00484*                                                                *        
I00484******************************************************************        
I00484 2210-PROCESS-OPTION-CD.                                          
I00484*                                                                         
I00484     MOVE 'N'                         TO WS-CSC-REFND-FL-063.     
I00484     MOVE ZEROES                      TO WS-CSC-MNTHS-063.        
                                                                        
           PERFORM 7200-SELECT-RATE-OPTION-DET                          
                                            THRU 7200-EXIT              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
I00484        PERFORM 2220-GET-RATE-DETAILS     THRU 2220-EXIT          
I00484        PERFORM 2230-PROCESS-RATE-FCTRS   THRU 2230-EXIT          
I00484        PERFORM 2240-PROCESS-ATTR-INCTV   THRU 2240-EXIT          
I00484        PERFORM 2250-PROCESS-ACCT-REL-FCTRS                       
I00484                                          THRU 2250-EXIT          
              ADD 1                         TO WS-CTR-ROWS              
           END-IF.                                                      
I00484*                                                                         
I00484 2210-EXIT.                                                       
I00484     EXIT.                                                        
I00484*                                                                         
I00484******************************************************************        
I00484* 2220-GET-RATE-DETAILS                                          *        
I00484*                                                                *        
I00484******************************************************************        
I00484 2220-GET-RATE-DETAILS.                                           
I00484*                                                                         
              MOVE FI-CODE-UTIL-TYPE        TO SA-CODE-UTIL-TYPE        
                                              ,J4-CODE-UTIL-TYPE        
                                                                        
              MOVE FI-RATE-PLAN-NO          TO RT-RATE-PLAN-NO          
                                              ,PS-RATE-PLAN-NO          
                                              ,RD-RATE-PLAN-NO          
                                              ,SA-RATE-PLAN-NO          
                                              ,J4-RATE-PLAN-NO          
I00484                                        ,WS-CORE-RATE-PLAN-NO-063.
A04019        IF WS-CSC-TIMELINE-FL-063   = 'Y'  AND                    
A04019           WS-DATE-FOR-CSC-TIMELINE > SPACES                      
A04019            MOVE WS-DATE-FOR-CSC-TIMELINE  TO                     
A04019                                          RT-FROM-EFFECTIVE-DT    
A04019            PERFORM 7250-SELECT-CUST-CHRG THRU 7250-EXIT          
A04019            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL            
A04019               MOVE J4-AMT-CUST-CHRG     TO WS-CSC-AMT-063        
A04019               MOVE RT-VERSION-NO-CNTRL  TO PS-VERSION-NO-CNTRL   
P00610               MOVE RT-FROM-EFFECTIVE-DT TO WS-THRM-PRC-EFF-DT-063
A04019            ELSE                                                  
A04019               MOVE ZEROES               TO WS-CSC-AMT-063        
A04019            END-IF                                                
A04019        ELSE                                                      
                 PERFORM 7300-SELECT-RATE-CREATOR                       
                                               THRU 7300-EXIT           
                                                                        
                 MOVE RT-VERSION-NO-CNTRL      TO                       
                                               PS-VERSION-NO-CNTRL      
                                              ,J4-VERSION-NO-CNTRL      
                                                                        
                 PERFORM 7400-SELECT-CUST-CHRG THRU 7400-EXIT           
                                                                        
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
I00484              MOVE J4-AMT-CUST-CHRG      TO WS-CSC-AMT-063        
                 ELSE                                                   
I00484              MOVE ZEROES                TO WS-CSC-AMT-063        
                 END-IF                                                 
A04019        END-IF                                                    
                                                                        
P00165        PERFORM 7450-CHECK-STEP-RATE  THRU 7450-EXIT              
P00165                                                                  
P00165        IF J1-LAST-ENERGY-BLOCK > 1                               
I00484           MOVE ZEROES                TO WS-THERM-PRICE-063       
P00165        ELSE                                                      
                 PERFORM 7500-SELECT-PRICE-SCHED                        
                                            THRU 7500-EXIT              
                                                                        
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
I00484              MOVE PS-SCHED-PRICE-AM  TO WS-THERM-PRICE-063       
                 ELSE                                                   
I00484              MOVE ZEROES             TO WS-THERM-PRICE-063       
                 END-IF                                                 
P00165        END-IF                                                    
                                                                        
              PERFORM 7600-SELECT-RATE-CALC-CD                          
                                            THRU 7600-EXIT              
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
I00484           MOVE RD-RATE-CALC-TYPE-CD  TO WS-RATE-CALC-TYPE-CD-063 
P00477           MOVE RD-RATE-DEFINITION-CD TO WS-RATE-DEF-CD-063       
              ELSE                                                      
I00484           MOVE SPACES                TO WS-RATE-CALC-TYPE-CD-063 
P00477           MOVE SPACES                TO WS-RATE-DEF-CD-063       
              END-IF.                                                   
I00484*                                                                         
I00484 2220-EXIT.                                                       
I00484     EXIT.                                                        
I00484*                                                                         
I00484******************************************************************        
I00484* 2230-PROCESS-RATE-FCTRS.                                       *        
I00484*                                                                *        
I00484******************************************************************        
I00484 2230-PROCESS-RATE-FCTRS.                                         
I00484*                                                                         
I00484        MOVE 'N'                      TO WS-NO-MORE-ROWS1         
JCFIXX                                         WS-VAR-FCTR-END-DT-FL.   
              PERFORM 7700-OPEN-RATE-FCTRS  THRU 7700-EXIT              
                                                                        
              PERFORM 7710-FETCH-RATE-FCTRS THRU 7710-EXIT              
                                                                        
              PERFORM 5000-PROCESS-RATE-FCTRS                           
                                            THRU 5000-EXIT              
I00484                                      UNTIL NO-MORE-ROWS1         
                                                                        
              PERFORM 7720-CLOSE-RATE-FCTRS THRU 7720-EXIT              
                                                                        
              IF WS-REPL-AMT1 NOT EQUAL ZERO                            
I00484           MOVE WS-REPL-AMT1          TO WS-THERM-PRICE-063       
              END-IF                                                    
                                                                        
              IF WS-ADD-AMT1 NOT EQUAL  ZERO                            
I00484           COMPUTE WS-THERM-PRICE-063                             
I00484                              = WS-THERM-PRICE-063 + WS-ADD-AMT1  
              END-IF                                                    
                                                                        
              IF WS-SUB-AMT1 NOT EQUAL  ZERO                            
I00484           COMPUTE WS-THERM-PRICE-063                             
I00484                              = WS-THERM-PRICE-063 - WS-SUB-AMT1  
              END-IF                                                    
                                                                        
              IF WS-REPL-CSC-AMT1 NOT EQUAL ZERO                        
I00484           MOVE WS-REPL-CSC-AMT1      TO WS-CSC-AMT-063           
              END-IF                                                    
                                                                        
              IF WS-ADD-CSC-AMT1 NOT EQUAL  ZERO                        
I00484           COMPUTE WS-CSC-AMT-063                                 
I00484                              = WS-CSC-AMT-063 + WS-ADD-CSC-AMT1  
              END-IF                                                    
                                                                        
              IF WS-SUB-CSC-AMT1 NOT EQUAL  ZERO                        
I00484           COMPUTE WS-CSC-AMT-063                                 
I00484                              = WS-CSC-AMT-063 - WS-SUB-CSC-AMT1  
              END-IF                                                    
I00484     .                                                            
I00484*                                                                         
I00484 2230-EXIT.                                                       
I00484     EXIT.                                                        
I00484*                                                                         
I00484******************************************************************        
I00484* 2240-PROCESS-ATTR-INCTV.                                       *        
I00484*                                                                *        
I00484******************************************************************        
I00484 2240-PROCESS-ATTR-INCTV.                                         
I00484*                                                                         
I00484        MOVE 'N'                      TO WS-NO-MORE-ROWS1.        
P805AP        MOVE 'N'                      TO WS-ADV-PRC-OPT-FL-063.   
              PERFORM 7800-OPEN-ATTR-INCTV-DET                          
                                            THRU 7800-EXIT              
                                                                        
              PERFORM 7810-FETCH-ATTR-INCTV-DET                         
                                            THRU 7810-EXIT              
                                                                        
              PERFORM UNTIL NO-MORE-ROWS1                               
                                                                        
P00680           MOVE ZEROS                 TO WS-REPL-AMT2             
P00680                                         WS-ADD-AMT2              
P00680                                         WS-SUB-AMT2              
P00680                                         WS-REPL-CSC-AMT2         
P00680                                         WS-ADD-CSC-AMT2          
P00680                                         WS-SUB-CSC-AMT2          
                                                                        
                 IF HQ-PRIMRY-OPT-ATTR-FL  = 'Y'                        
I00484              MOVE HQ-DURATION-NO     TO WS-OPTN-VALID-MNTHS-063  
I00484              MOVE HQ-FACTOR-ID       TO WS-PRIM-FACTOR-ID-063    
                 END-IF                                                 
                                                                        
P805AP           IF HQ-RT-ATTR-INCTV-TYPE = 'ADVANCED PRICE'            
P805AP              MOVE 'Y'                TO WS-ADV-PRC-OPT-FL-063    
P805AP           END-IF                                                 
P805AP                                                                  
                 IF HQ-RT-ATTR-INCTV-TYPE EQUAL 'FREE CSC'              
I00484              MOVE 'Y'                TO WS-CSC-REFND-FL-063      
I00484              MOVE HQ-DURATION-NO     TO WS-CSC-MNTHS-063         
                 END-IF                                                 
                                                                        
P00211           IF HQ-RT-ATTR-INCTV-TYPE EQUAL 'EXIT FEE'              
P00211                                         AND CURR-OPTION-MODE     
P00211              MOVE HQ-ATTR-INCTV-VALUE   TO WS-EXIT-FEE-AMT-063   
P00211           END-IF                                                 
                                                                        
                 MOVE HQ-FACTOR-ID          TO SA-FACTOR-ID             
                                                                        
                 IF HQ-FACTOR-ID NOT EQUAL SPACES                       
                                                                        
                    MOVE 'N'                TO WS-CHNG-FCTR-END-DT-FL   
I00484              MOVE 'N'                TO WS-NO-MORE-ROWS2         
                    PERFORM 7730-OPEN-SPCL-FCTRS  THRU 7730-EXIT        
                                                                        
                    PERFORM 7740-FETCH-SPCL-FCTRS THRU 7740-EXIT        
                                                                        
                    PERFORM 5100-PROCESS-SPCL-FCTRS                     
                                                  THRU 5100-EXIT        
I00484                                            UNTIL NO-MORE-ROWS2   
                    PERFORM 7750-CLOSE-SPCL-FCTRS THRU 7750-EXIT        
                                                                        
P00805              IF WS-THERM-CSC-ACCT-FL NOT EQUAL 'Y'               
                       IF WS-REPL-AMT2 NOT EQUAL ZERO                   
I00484                    MOVE WS-REPL-AMT2        TO WS-THERM-PRICE-063
                       END-IF                                           
                                                                        
                       IF WS-ADD-AMT2 NOT EQUAL  ZERO                   
I00484                    COMPUTE WS-THERM-PRICE-063                    
I00484                             = WS-THERM-PRICE-063 + WS-ADD-AMT2   
                       END-IF                                           
                                                                        
                       IF WS-SUB-AMT2 NOT EQUAL  ZERO                   
I00484                    COMPUTE WS-THERM-PRICE-063                    
                                   = WS-THERM-PRICE-063 - WS-SUB-AMT2   
                       END-IF                                           
                                                                        
                       IF WS-REPL-CSC-AMT2 NOT EQUAL ZERO               
I00484                    MOVE WS-REPL-CSC-AMT2    TO WS-CSC-AMT-063    
                       END-IF                                           
                                                                        
                       IF WS-ADD-CSC-AMT2 NOT EQUAL  ZERO               
I00484                    COMPUTE WS-CSC-AMT-063  = WS-CSC-AMT-063      
                                                  + WS-ADD-CSC-AMT2     
                       END-IF                                           
                                                                        
                       IF WS-SUB-CSC-AMT2 NOT EQUAL  ZERO               
I00484                    COMPUTE WS-CSC-AMT-063  = WS-CSC-AMT-063      
                                                  - WS-SUB-CSC-AMT2     
                       END-IF                                           
P00805              END-IF                                              
                 END-IF                                                 
                                                                        
                 PERFORM 7810-FETCH-ATTR-INCTV-DET                      
                                                  THRU 7810-EXIT        
              END-PERFORM                                               
                                                                        
              PERFORM 7820-CLOSE-ATTR-INCTV-DET                         
                                            THRU 7820-EXIT              
I00484     .                                                            
I00484*                                                                         
I00484 2240-EXIT.                                                       
I00484     EXIT.                                                        
I00484*                                                                         
I00484******************************************************************        
I00484* 2250-PROCESS-ACCT-REL-FCTRS.                                   *        
I00484*                                                                *        
I00484******************************************************************        
I00484 2250-PROCESS-ACCT-REL-FCTRS.                                     
I00484*                                                                         
              IF WS-ACCOUNT-NO-063 > ZEROES                             
                                 AND WS-IC-NO-063 > ZEROES              
                                     AND WS-CODE-UTIL-TYPE-063 > SPACES 
                 MOVE WS-ACCOUNT-NO-063     TO FF-ACCOUNT-NO            
                 MOVE WS-CODE-UTIL-TYPE-063 TO FF-CODE-UTIL-TYPE        
                 MOVE WS-IC-NO-063          TO FF-IC-NO                 
A04019           IF WS-CSC-TIMELINE-FL-063   = 'Y'  AND                 
A04019             WS-DATE-FOR-CSC-TIMELINE > SPACES                    
A04019              MOVE WS-DATE-FOR-CSC-TIMELINE  TO WS-BEACON-DATE    
A04019           ELSE                                                   
A04019              PERFORM 7540-GET-BEACON-DATE  THRU 7540-EXIT        
A04019           END-IF                                                 
                 PERFORM 7550-SEL-CUST-ADJ-CSC THRU 7550-EXIT           
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    IF SA-FACTOR > ZEROES                               
I00484                 MOVE SA-FACTOR       TO WS-CSC-AMT-063           
                    END-IF                                              
                 END-IF                                                 
I00484         IF WS-PEND-OPTION-FLAG = 'N'                             
I00484           MOVE ZEROES                TO WS-FF-DURATION-REM-063   
                 PERFORM 7570-SEL-FF-DUR-REM    THRU 7570-EXIT          
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
I00484              MOVE FF-DURATION-REMAIN-NO TO WS-FF-DURATION-REM-063
                 END-IF                                                 
I00484         END-IF                                                   
              END-IF                                                    
I00484        IF ( WS-THERM-CSC-ACCT-FL EQUAL 'Y'                       
I00484                                  AND CURR-OPTION-MODE )          
I00484            OR ( WS-PENDING-OPTION-FL-063 EQUAL 'Y'               
I00484                                  AND PEND-OPTION-MODE )          
                 IF WS-ACCOUNT-NO-063 > ZEROES                          
                                 AND WS-IC-NO-063 > ZEROES              
                                     AND WS-CODE-UTIL-TYPE-063 > SPACES 
                   MOVE WS-ACCOUNT-NO-063     TO FF-ACCOUNT-NO          
                   MOVE WS-CODE-UTIL-TYPE-063 TO FF-CODE-UTIL-TYPE      
                   MOVE WS-IC-NO-063          TO FF-IC-NO               
I00484             MOVE 'N'                   TO WS-NO-MORE-ROWS1       
                   PERFORM 7850-OPEN-ACCT-REL-FCTRS  THRU 7850-EXIT     
                                                                        
                   PERFORM 7860-FETCH-ACCT-REL-FCTRS THRU 7860-EXIT     
                                                                        
                   PERFORM 5200-PROCESS-ACCT-REL-FCTRS                  
                                                 THRU 5200-EXIT         
I00484                                               UNTIL NO-MORE-ROWS1
                                                                        
                   PERFORM 7870-CLOSE-ACCT-REL-FCTRS  THRU 7870-EXIT    
                                                                        
                   IF WS-REPL-AMT3 NOT EQUAL ZERO                       
I00484                MOVE WS-REPL-AMT3       TO WS-THERM-PRICE-063     
                   END-IF                                               
                                                                        
                   IF WS-ADD-AMT3 NOT EQUAL  ZERO                       
I00484                COMPUTE WS-THERM-PRICE-063 = WS-THERM-PRICE-063   
                                               + WS-ADD-AMT3            
                   END-IF                                               
                                                                        
                   IF WS-SUB-AMT3 NOT EQUAL  ZERO                       
I00484                COMPUTE WS-THERM-PRICE-063 = WS-THERM-PRICE-063   
                                               - WS-SUB-AMT3            
                   END-IF                                               
                                                                        
A04019             IF WS-REPL-CSC-AMT3 NOT EQUAL ZERO                   
A04019               MOVE WS-REPL-CSC-AMT3      TO WS-CSC-AMT-063       
A04019             END-IF                                               
A04019                                                                  
A04019             IF WS-ADD-CSC-AMT3 NOT EQUAL  ZERO                   
A04019               COMPUTE WS-CSC-AMT-063                             
A04019                              = WS-CSC-AMT-063 + WS-ADD-CSC-AMT3  
A04019             END-IF                                               
A04019                                                                  
A04019             IF WS-SUB-CSC-AMT3 NOT EQUAL  ZERO                   
A04019              COMPUTE WS-CSC-AMT-063                              
A04019                              = WS-CSC-AMT-063 - WS-SUB-CSC-AMT3  
A04019             END-IF                                               
                 END-IF                                                 
              END-IF.                                                   
                                                                        
P00211        IF ( WS-THERM-CSC-ACCT-FL EQUAL 'Y'                       
P00211                                  AND CURR-OPTION-MODE )          
P00211           IF WS-ACCOUNT-NO-063 > ZEROES                          
P00211                           AND WS-IC-NO-063 > ZEROES              
P00211                               AND WS-CODE-UTIL-TYPE-063 > SPACES 
P00211             MOVE WS-ACCOUNT-NO-063     TO UT-ACCOUNT-NO          
P00211             MOVE WS-CODE-UTIL-TYPE-063 TO UT-CODE-UTIL-TYPE      
P00211             MOVE WS-IC-NO-063          TO UT-IC-NO               
P00211             PERFORM 7660-SEL-SIGN-UP-EXIT-FEE THRU 7660-EXIT     
P00211             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL       
P00211                MOVE HQ-ATTR-INCTV-VALUE TO WS-EXIT-FEE-AMT-063   
P00211             END-IF                                               
P00211        END-IF
              END-IF.                                                   
                                                                        
I00484 2250-EXIT.                                                       
I00484     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-CHECK-ADJ-TYPE.                                           *        
      *                                                                *        
      ******************************************************************        
       2300-CHECK-ADJ-TYPE.                                             
      *                                                                         
            EVALUATE TRUE                                               
               WHEN ADD-TO-NET-RATE                                     
P00610            IF SF-FACTOR-ID  EQUAL 'VARPRICE'                     
P00610               MOVE SA-DATE-FROM  TO WS-THRM-PRC-EFF-DT-063       
P00610            END-IF                                                
                  ADD SA-FACTOR        TO WS-ADD-AMT1                   
               WHEN SUB-FROM-NET-RATE                                   
                  ADD SA-FACTOR        TO WS-SUB-AMT1                   
               WHEN REPL-NET-RATE                                       
                  ADD SA-FACTOR        TO WS-REPL-AMT1                  
P00610            MOVE SA-DATE-FROM    TO WS-THRM-PRC-EFF-DT-063        
               WHEN ADD-TO-BFC-CHARGE                                   
                  ADD SA-FACTOR        TO WS-ADD-CSC-AMT1               
               WHEN SUBTRACT-FROM-BFC-CHARGE                            
                  ADD SA-FACTOR        TO WS-SUB-CSC-AMT1               
               WHEN REPLACE-BFC-CHARGE                                  
                  ADD SA-FACTOR        TO WS-REPL-CSC-AMT1              
            END-EVALUATE.                                               
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2350-CHECK-SPCL-ADJ-TYPE.                                      *        
      *                                                                *        
      ******************************************************************        
       2350-CHECK-SPCL-ADJ-TYPE.                                        
      *                                                                         
            EVALUATE TRUE                                               
               WHEN ADD-TO-NET-RATE                                     
                  IF HQ-ATTR-INCTV-VALUE EQUAL ZERO                     
                     ADD SA-FACTOR            TO WS-ADD-AMT2            
                  ELSE                                                  
                     ADD HQ-ATTR-INCTV-VALUE  TO WS-ADD-AMT2            
                  END-IF                                                
P00610            IF SF-FACTOR-ID  EQUAL 'VARPRICE'                     
P00610               MOVE SA-DATE-FROM  TO WS-THRM-PRC-EFF-DT-063       
P00610            END-IF                                                
                                                                        
               WHEN SUB-FROM-NET-RATE                                   
                  IF HQ-ATTR-INCTV-VALUE EQUAL ZERO                     
                     ADD SA-FACTOR           TO WS-SUB-AMT2             
                  ELSE                                                  
                     ADD HQ-ATTR-INCTV-VALUE TO WS-SUB-AMT2             
                  END-IF                                                
                                                                        
               WHEN REPL-NET-RATE                                       
                  IF HQ-ATTR-INCTV-VALUE EQUAL ZERO                     
                     ADD SA-FACTOR           TO WS-REPL-AMT2            
                  ELSE                                                  
                     ADD HQ-ATTR-INCTV-VALUE TO WS-REPL-AMT2            
                  END-IF                                                
P00610            MOVE SA-DATE-FROM          TO WS-THRM-PRC-EFF-DT-063  
                                                                        
               WHEN ADD-TO-BFC-CHARGE                                   
                  IF HQ-ATTR-INCTV-VALUE EQUAL ZERO                     
                     ADD SA-FACTOR           TO WS-ADD-CSC-AMT2         
                  ELSE                                                  
                     ADD HQ-ATTR-INCTV-VALUE TO WS-ADD-CSC-AMT2         
                  END-IF                                                
                                                                        
               WHEN SUBTRACT-FROM-BFC-CHARGE                            
                  IF HQ-ATTR-INCTV-VALUE EQUAL ZERO                     
                     ADD SA-FACTOR           TO WS-SUB-CSC-AMT2         
                  ELSE                                                  
                     ADD HQ-ATTR-INCTV-VALUE TO WS-SUB-CSC-AMT2         
                  END-IF                                                
                                                                        
               WHEN REPLACE-BFC-CHARGE                                  
                  IF HQ-ATTR-INCTV-VALUE EQUAL ZERO                     
                     ADD SA-FACTOR           TO WS-REPL-CSC-AMT2        
                  ELSE                                                  
                     ADD HQ-ATTR-INCTV-VALUE TO WS-REPL-CSC-AMT2        
                  END-IF                                                
P00680                                                                  
P00680         WHEN ADD-TO-COMPONENT-AMT                                
P00680            IF WS-CPD063-CALLING-PGM = CALLED-FROM-WEB            
P00680               EVALUATE HQ-RT-ATTR-INCTV-TYPE                     
P00680                   WHEN 'PRICE DISCOUNT'                          
P00680                     IF HQ-ATTR-INCTV-VALUE EQUAL ZERO            
P00680                        ADD SA-FACTOR           TO WS-ADD-AMT2    
P00680                     ELSE                                         
P00680                        ADD HQ-ATTR-INCTV-VALUE TO WS-ADD-AMT2    
P00680                     END-IF                                       
P00680                   WHEN 'CSC DISCOUNT'                            
P00680                     IF HQ-ATTR-INCTV-VALUE EQUAL ZERO            
P00680                        ADD SA-FACTOR           TO WS-ADD-CSC-AMT2
P00680                     ELSE                                         
P00680                        ADD HQ-ATTR-INCTV-VALUE TO WS-ADD-CSC-AMT2
P00680                     END-IF                                       
P00680               END-EVALUATE                                       
P00680            ELSE                                                  
P00680               CONTINUE                                           
P00680            END-IF                                                
            END-EVALUATE.                                               
      *                                                                         
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2400-CHECK-FF-ADJ-TYPE.                                        *        
      *                                                                *        
      ******************************************************************        
       2400-CHECK-FF-ADJ-TYPE.                                          
      *                                                                         
            EVALUATE TRUE                                               
               WHEN ADD-TO-NET-RATE                                     
                  ADD FF-FACTOR               TO WS-ADD-AMT3            
               WHEN SUB-FROM-NET-RATE                                   
                  ADD FF-FACTOR               TO WS-SUB-AMT3            
               WHEN REPL-NET-RATE                                       
                  ADD FF-FACTOR               TO WS-REPL-AMT3           
A04019         WHEN ADD-TO-BFC-CHARGE                                   
A04019            ADD FF-FACTOR               TO WS-ADD-CSC-AMT3        
A04019         WHEN SUBTRACT-FROM-BFC-CHARGE                            
A04019            ADD FF-FACTOR               TO WS-SUB-CSC-AMT3        
A04019         WHEN REPLACE-BFC-CHARGE                                  
A04019            ADD FF-FACTOR               TO WS-REPL-CSC-AMT3       
P00680         WHEN ADD-TO-COMPONENT-AMT                                
P00680            IF WS-CPD063-CALLING-PGM     = CALLED-FROM-WEB AND    
P00680                   SF-RT-ATTR-INCTV-TYPE = 'PRICE DISCOUNT'       
P00680               ADD FF-FACTOR            TO WS-ADD-AMT3            
P00680            ELSE                                                  
P00680               CONTINUE                                           
P00680            END-IF                                                
            END-EVALUATE.                                               
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
I00484*                                                                         
I00484*****************************************************************         
I00484* 2450-MOVE-CURR-OPTN-DET.                                     **         
I00484*                                                              **         
I00484*****************************************************************         
I00484 2450-MOVE-CURR-OPTN-DET.                                         
I00484*                                                                         
I00484     MOVE WS-THERM-PRICE-063            TO WS-THERM-PRICE.        
I00484     MOVE WS-OPTN-VALID-MNTHS-063       TO WS-OPTN-VALID-MNTHS.   
I00484     MOVE WS-PRIM-FACTOR-ID-063         TO WS-PRIM-FACTOR-ID.     
I00484     MOVE WS-CORE-RATE-PLAN-NO-063      TO WS-CORE-RATE-PLAN-NO.  
I00484     MOVE WS-RATE-CALC-TYPE-CD-063      TO WS-RATE-CALC-TYPE-CD.  
I00484     MOVE WS-CSC-AMT-063                TO WS-CSC-AMT.            
I00484     MOVE WS-CSC-REFND-FL-063           TO WS-CSC-REFND-FL.       
I00484     MOVE WS-CSC-MNTHS-063              TO WS-CSC-MNTHS.          
I00484     MOVE WS-FF-DURATION-REM-063        TO WS-FF-DURATION-REM.    
I00484*                                                                         
I00484 2450-EXIT.                                                       
I00484     EXIT.                                                        
I00484*                                                                         
I00484*****************************************************************         
I00484* 2500-INIT-063-VARIABLES.                                     **         
I00484*                                                              **         
I00484*****************************************************************         
I00484 2500-INIT-063-VARIABLES.                                         
I00484*                                                                         
I00484     INITIALIZE     WS-CALC-VARIABLES                             
I00484                   ,WS-RETURN-FIELDS-063.                         
I00484                                                                  
A04019     IF WS-CSC-TIMELINE-FL-063   = 'Y'  AND                       
A04019        WS-DATE-FOR-CSC-TIMELINE > SPACES                         
A04019        MOVE WS-SAVE-PEND-DATE TO WS-DATE-FOR-CSC-TIMELINE        
A04019                                  WS-PEND-COMMON-DATE             
A04019                                  WS-PEND-REV-PRT-DT-FRM          
A04019                                  WS-PEND-COM-REV-MONTH-FROM      
A04019     END-IF.                                                      
                                                                        
I00484     MOVE 'N'                         TO WS-NO-MORE-ROWS1         
I00484                                        ,WS-NO-MORE-ROWS2.        
I00484                                                                  
I00484     MOVE WS-PEND-COMMON-DATE         TO HQ-ATTR-INCTV-STRT-DT    
I00484                                         HQ-ATTR-INCTV-END-DT.    
I00484     MOVE WS-PEND-REV-PRT-DT-FRM      TO WS-REV-PRT-DT-FRM.       
I00484     MOVE WS-PEND-COM-REV-MONTH-FROM  TO WS-COM-REV-MONTH-FROM.   
I00484*                                                                         
I00484 2500-EXIT.                                                       
I00484     EXIT.                                                        
I00484*                                                                         
I00484*****************************************************************         
I00484* 2600-MOVE-PEND-OPTN-DET.                                     **         
I00484*                                                              **         
I00484*****************************************************************         
I00484 2600-MOVE-PEND-OPTN-DET.                                         
I00484*                                                                         
I00484     MOVE WS-THERM-PRICE-063        TO WS-PEND063-THERM-PRICE.    
I00484     MOVE WS-CORE-RATE-PLAN-NO-063  TO WS-PEND063-CORE-RATE-PLAN. 
I00484     MOVE WS-RATE-CALC-TYPE-CD-063  TO WS-PEND063-CALC-TYPE-CD.   
I00484     MOVE WS-CSC-AMT-063            TO WS-PEND063-CSC-AMT.        
I00484     MOVE WS-OPTN-VALID-MNTHS-063   TO WS-PEND063-VALID-MNTHS.    
I00484     MOVE WS-CSC-REFND-FL-063       TO WS-PEND063-CSC-REFND-FL.   
I00484     MOVE WS-CSC-MNTHS-063          TO WS-PEND063-CSC-MNTHS.      
I00484*                                                                         
I00484 2600-EXIT.                                                       
I00484     EXIT.                                                        
I00484*                                                                         
      *                                                                         
      *****************************************************************         
      * 5000-PROCESS-RATE-FCTRS.                                     **         
      *                                                              **         
      *****************************************************************         
       5000-PROCESS-RATE-FCTRS.                                         
                                                                        
           MOVE SF-ADJUST-ELEMENT           TO WS-BC-CODE-ADJUST-TYPE   
                                                                        
           IF SF-OVR-RT-CALC-TYP-CD > SPACES                            
I00484        MOVE SF-OVR-RT-CALC-TYP-CD    TO WS-RATE-CALC-TYPE-CD-063 
           END-IF                                                       
                                                                        
P00120     IF SA-VERS-PRORATE-CD EQUAL 'R'                              
              MOVE WS-COM-REV-MONTH-FROM    TO WS-COMP-DATE-FROM        
                                               WS-COMP-DATE-TO          
           ELSE                                                         
              MOVE WS-REV-PRT-DT-FRM        TO WS-COMP-DATE-FROM        
                                               WS-COMP-DATE-TO          
           END-IF                                                       
                                                                        
A04019     IF WS-CSC-TIMELINE-FL-063   = 'Y'  AND                       
A04019        WS-DATE-FOR-CSC-TIMELINE > SPACES                         
A04019        MOVE WS-DATE-FOR-CSC-TIMELINE TO WS-COMP-DATE-FROM        
A04019                                         WS-COMP-DATE-TO          
A04019     END-IF                                                       
                                                                        
JCFIXX      IF SF-RT-ATTR-INCTV-TYPE EQUAL 'VARIABLE PRICE'             
JCFIXX         IF WS-VAR-FCTR-END-DT-FL  EQUAL 'N'                      
JCFIXX            MOVE 'Y'                 TO WS-VAR-FCTR-END-DT-FL     
JCFIXX            IF SA-DATE-TO EQUAL '2999-12-31'                      
JCFIXX               CONTINUE                                           
JCFIXX            ELSE                                                  
JCFIXX               MOVE '2999-12-31'     TO SA-DATE-TO                
JCFIXX            END-IF                                                
JCFIXX         END-IF                                                   
JCFIXX     END-IF.                                                      
                                                                        
           IF (SA-DATE-FROM   <= WS-COMP-DATE-FROM                      
              AND SA-DATE-TO >= WS-COMP-DATE-TO)                        
              PERFORM 2300-CHECK-ADJ-TYPE THRU 2300-EXIT                
           END-IF                                                       
                                                                        
           PERFORM 7710-FETCH-RATE-FCTRS    THRU 7710-EXIT.             
      *                                                                         
       5000-EXIT.                                                       
             EXIT.                                                      
      *                                                                         
      *****************************************************************         
      * 5100-PROCESS-SPCL-FCTRS.                                     **         
      *                                                              **         
      *****************************************************************         
       5100-PROCESS-SPCL-FCTRS.                                         
                                                                        
           MOVE SF-ADJUST-ELEMENT           TO WS-BC-CODE-ADJUST-TYPE   
                                                                        
           IF SF-OVR-RT-CALC-TYP-CD > SPACES                            
I00484        MOVE SF-OVR-RT-CALC-TYP-CD    TO WS-RATE-CALC-TYPE-CD-063 
           END-IF                                                       
                                                                        
P00120     IF SA-VERS-PRORATE-CD EQUAL 'R'                              
PRDFIX           AND HQ-RT-ATTR-INCTV-TYPE NOT EQUAL 'FIXED PRICE'      
              MOVE WS-COM-REV-MONTH-FROM    TO WS-COMP-DATE-FROM        
                                               WS-COMP-DATE-TO          
           ELSE                                                         
              MOVE WS-REV-PRT-DT-FRM        TO WS-COMP-DATE-FROM        
                                               WS-COMP-DATE-TO          
           END-IF                                                       
                                                                        
A04019     IF WS-CSC-TIMELINE-FL-063   = 'Y'  AND                       
A04019        WS-DATE-FOR-CSC-TIMELINE > SPACES                         
A04019        MOVE WS-DATE-FOR-CSC-TIMELINE TO WS-COMP-DATE-FROM        
A04019                                         WS-COMP-DATE-TO          
A04019     END-IF                                                       
                                                                        
                                                                        
           IF WS-CHNG-FCTR-END-DT-FL EQUAL 'N'                          
                        AND SF-FACTOR-TYPE EQUAL 'F'                    
                           AND HQ-RT-ATTR-INCTV-TYPE EQUAL 'FIXED PRICE'
              MOVE 'Y'                      TO WS-CHNG-FCTR-END-DT-FL   
              IF SA-DATE-TO EQUAL '2999-12-31'                          
                 CONTINUE                                               
              ELSE                                                      
                 MOVE '2999-12-31'          TO SA-DATE-TO               
              END-IF                                                    
           END-IF                                                       
                                                                        
           IF (SA-DATE-FROM   <= WS-COMP-DATE-FROM                      
              AND SA-DATE-TO >= WS-COMP-DATE-TO)                        
              PERFORM 2350-CHECK-SPCL-ADJ-TYPE                          
                                            THRU 2350-EXIT              
           END-IF                                                       
                                                                        
                                                                        
           PERFORM 7740-FETCH-SPCL-FCTRS    THRU 7740-EXIT.             
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5200-PROCESS-ACCT-REL-FCTRS.                                 **         
      *                                                              **         
      *****************************************************************         
       5200-PROCESS-ACCT-REL-FCTRS.                                     
                                                                        
I00484     IF CURR-OPTION-MODE                                          
I00484       AND PEND-OPTION-EXIST                                      
I00484       AND WS-PEND-PKG-OPT-SEQ-NO = FF-RT-PKG-OPT-SEQ-NO          
I00484       AND FF-RT-PKG-OPT-SEQ-NO > 0                               
I00484        PERFORM 7860-FETCH-ACCT-REL-FCTRS   THRU 7860-EXIT        
I00484        GO TO 5200-EXIT                                           
I00484     END-IF.                                                      
I00484                                                                  
I00484     IF PEND-OPTION-MODE                                          
I00484       AND WS-PEND-PKG-OPT-SEQ-NO NOT = FF-RT-PKG-OPT-SEQ-NO      
I00484        PERFORM 7860-FETCH-ACCT-REL-FCTRS   THRU 7860-EXIT        
I00484        GO TO 5200-EXIT                                           
I00484     END-IF.                                                      
I00484                                                                  
           MOVE SF-ADJUST-ELEMENT           TO WS-BC-CODE-ADJUST-TYPE   
                                                                        
           IF SF-VERS-PRORATE-CD EQUAL 'R'                              
              MOVE WS-COM-REV-MONTH-FROM    TO WS-COMP-DATE-FROM        
                                               WS-COMP-DATE-TO          
           ELSE                                                         
              MOVE WS-REV-PRT-DT-FRM        TO WS-COMP-DATE-FROM        
                                               WS-COMP-DATE-TO          
           END-IF                                                       
                                                                        
A04019     IF WS-CSC-TIMELINE-FL-063   = 'Y'  AND                       
A04019        WS-DATE-FOR-CSC-TIMELINE > SPACES                         
A04019        MOVE WS-DATE-FOR-CSC-TIMELINE TO WS-COMP-DATE-FROM        
A04019                                         WS-COMP-DATE-TO          
A04019     END-IF                                                       
                                                                        
           IF SF-SPCL-GROUP-CD EQUAL 'CF'                               
                               AND FF-DURATION-REMAIN-NO > 0            
I00484        MOVE 'Y'                       TO WS-CSC-REFND-FL-063     
I00484        MOVE FF-DURATION-REMAIN-NO     TO WS-CSC-MNTHS-063        
           END-IF                                                       
                                                                        
P00805     EVALUATE SF-FACTOR-TYPE                                      
P00805         WHEN 'B'                                                 
P00805              IF (FF-EFF-DATE-FROM <= WS-COMP-DATE-FROM           
P00805                  AND FF-EFF-DATE-TO >= WS-COMP-DATE-TO)          
P00805                  PERFORM 2400-CHECK-FF-ADJ-TYPE   THRU 2400-EXIT 
P00805              END-IF                                              
P00805         WHEN 'F'                                                 
P00805              IF SF-DURATION-TYPE-CD EQUAL SPACES AND             
P00805                 (FF-EFF-DATE-FROM <= WS-COMP-DATE-FROM           
P00805                  AND FF-EFF-DATE-TO >= WS-COMP-DATE-TO)          
P00805                  PERFORM 2400-CHECK-FF-ADJ-TYPE   THRU 2400-EXIT 
P00805              ELSE                                                
P00805                 IF FF-DURATION-REMAIN-NO > 0                     
P00805                    PERFORM 2400-CHECK-FF-ADJ-TYPE THRU 2400-EXIT 
P00805                 END-IF                                           
P00805              END-IF                                              
P00805     END-EVALUATE.                                                
                                                                        
           PERFORM 7860-FETCH-ACCT-REL-FCTRS   THRU 7860-EXIT.          
      *                                                                         
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7000-SELECT-JOB-PARM.                                        **         
      *                                                              **         
      *****************************************************************         
       7000-SELECT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
               SELECT G6.PARM_DATA                                      
                 INTO :G6-PARM-DATA                                     
                 FROM CSS_JOB_PARM G6                                   
                WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                
                  AND G6.COMPANY_NO   = :G6-COMPANY-NO                  
                  AND G6.CMND_CODE    = :G6-CMND-CODE                   
                  AND G6.SEQ_NO       = :G6-SEQ-NO                      
                  AND G6.STATUS       = 'A'                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_JOB_PARM'           TO TABLE-1                  
              MOVE 'PROGRAM_NAME'           TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE 'CMND_CODE'              TO TABLE-ELEMENT-3          
              MOVE 'SEQ_NO'                 TO TABLE-ELEMENT-4          
              MOVE G6-PROGRAM-NAME          TO HOSTVAR-ELEMENT-1        
              MOVE G6-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
              MOVE G6-CMND-CODE             TO HOSTVAR-ELEMENT-3        
              MOVE G6-SEQ-NO                TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-ADD-ONE-MONTH.                                           **        
      *     CALCULATE END DATE OF THE MONTH.                          **        
      ******************************************************************        
       7100-ADD-ONE-MONTH.                                              
                                                                        
           EXEC SQL                                                     
            SELECT
              DATEADD( DAY, -1, (DATEADD( MONTH, 1, 
              IIF(TRY_CONVERT(DATE, :WS-ADD-ONE-MTH-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ADD-ONE-MTH-DT
              ) <> 0) OR (LEN(:WS-ADD-ONE-MTH-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ADD-ONE-MTH-DT
              ), CONVERT(DATE, :WS-ADD-ONE-MTH-DT) ) )) )
            INTO
              :WS-RESULT-DATE                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SET :WS-RESULT-DATE = (DATE(:WS-ADD-ONE-MTH-DT) + 1 MONTH)          
MFA-TR*                            - 1 DAY                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A03280******************************************************************        
A03280* 5250-NXT-REV-MONTH.                                           **        
A03280*     CALCULATE NEXT REV.                                       **        
A03280******************************************************************        
A03280 5250-NXT-REV-MONTH.                                              
A03280        MOVE 'COMMON'                  TO G6-PROGRAM-NAME         
A03280        MOVE '01'                      TO G6-COMPANY-NO           
A03280        MOVE 'DATE'                    TO G6-CMND-CODE            
A03280        MOVE 10                        TO G6-SEQ-NO               
A03280        PERFORM 7000-SELECT-JOB-PARM      THRU 7000-EXIT          
A03280        MOVE G6-PARM-DATA(10:10)       TO WS-COMMON-DATE          
A03280                                          WS-REV-PRT-DT-FRM.      
A03280*                                                                         
A03280        MOVE AT-REV-MTH-LST-NRML       TO WS-REV-MONTH-TMP        
A03280                                          RW-REVENUE-MONTH.       
A03280        MOVE 1  TO  WS-MONTHS-TO-ADD                              
A03280        PERFORM 2110-STEP-UP-MONTHS       THRU 2110-EXIT          
A03280                                                                  
A03280        MOVE WS-START-YR-N             TO WS-START-YR             
A03280        MOVE WS-START-MT-N             TO WS-START-MT             
A03280        MOVE '01'                      TO WS-START-DY             
      *                                                                         
A03280        MOVE WS-START-DATE             TO WS-COM-REV-MONTH-FROM.  
A03280                                                                  
      *                                                                         
A03280 5250-EXIT.                                                       
A03280     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-SELECT-RATE-OPTION-DET.                                   *        
      ******************************************************************        
       7200-SELECT-RATE-OPTION-DET.                                     
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) OPTION_CD,
              CODE_UTIL_TYPE,
              RATE_PLAN_NO                                    
                INTO   :FI-OPTION-CD                                    
                      ,:FI-CODE-UTIL-TYPE                               
                      ,:FI-RATE-PLAN-NO                                 
                FROM CRM_RT_PKG_OPTION    FI WITH(READUNCOMMITTED)              
               WHERE OPTION_CD         = :FI-OPTION-CD                  
P00473           AND FI.PROC_STATUS_CD = 'AC'                           
P00473         ORDER BY FI.OPT_VSTART_TS DESC                           
P00473                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT   OPTION_CD                                               
MFA-TR*               , CODE_UTIL_TYPE                                          
MFA-TR*               , RATE_PLAN_NO                                            
MFA-TR*         INTO   :FI-OPTION-CD                                            
MFA-TR*               ,:FI-CODE-UTIL-TYPE                                       
MFA-TR*               ,:FI-RATE-PLAN-NO                                         
MFA-TR*         FROM CRM_RT_PKG_OPTION    FI                                    
MFA-TR*        WHERE OPTION_CD         = :FI-OPTION-CD                          
MFA-TR*          AND FI.PROC_STATUS_CD = 'AC'                                   
MFA-TR*        ORDER BY FI.OPT_VSTART_TS DESC                                   
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_RT_PKG_OPTION'      TO TABLE-1                  
              MOVE 'OPTION_CD'              TO TABLE-ELEMENT-1          
              MOVE FI-OPTION-CD             TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A04019                                                                  
A04019******************************************************************        
A04019* 7250-SELECT-CUST-CHRG                                         **        
A04019* CUSTOMER CHARGE                                               **        
A04019******************************************************************        
A04019 7250-SELECT-CUST-CHRG.                                           
A04019     EXEC SQL                                                     
A04019        SELECT TOP(1) J4.AMT_CUST_CHRG,
              RT.VERSION_NO_CNTRL,
              RT.FROM_EFFECTIVE_DT                               
A04019          INTO :J4-AMT-CUST-CHRG                                  
A04019             , :RT-VERSION-NO-CNTRL                               
P00610             , :RT-FROM-EFFECTIVE-DT                              
A04019          FROM CSS_RATE_CREATOR  RT WITH(READUNCOMMITTED)                 
A04019              ,CSS_RATE_VRSN_DEF J4 WITH(READUNCOMMITTED)                 
A04019         WHERE RT.RATE_PLAN_NO      = :RT-RATE-PLAN-NO            
A04019           AND RT.CODE_UTIL_TYPE    = 'G'                         
A04019           AND RT.CODE_STATUS       = 'A'                         
A04019           AND RT.CODE_UTIL_TYPE    = J4.CODE_UTIL_TYPE           
A04019           AND RT.RATE_PLAN_NO      = J4.RATE_PLAN_NO             
A04019           AND RT.VERSION_NO_CNTRL  = J4.VERSION_NO_CNTRL         
A04019           AND RT.FROM_EFFECTIVE_DT <= IIF(TRY_CONVERT(DATE, 
                                                  :RT-FROM-EFFECTIVE-DT
              ) IS NULL OR (PATINDEX('%.%', :RT-FROM-EFFECTIVE-DT
              ) <> 0) OR (LEN(:RT-FROM-EFFECTIVE-DT
              ) <> 10), CIS.CHAR2DATE(:RT-FROM-EFFECTIVE-DT
              ), CONVERT(DATE, :RT-FROM-EFFECTIVE-DT) )      
A04019         ORDER BY RT.VERSION_NO_CNTRL DESC                        
A04019                                       
A04019                                                      
A04019     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT J4.AMT_CUST_CHRG                                           
MFA-TR*            , RT.VERSION_NO_CNTRL                                        
MFA-TR*            , RT.FROM_EFFECTIVE_DT                                       
MFA-TR*         INTO :J4-AMT-CUST-CHRG                                          
MFA-TR*            , :RT-VERSION-NO-CNTRL                                       
MFA-TR*            , :RT-FROM-EFFECTIVE-DT                                      
MFA-TR*         FROM CSS_RATE_CREATOR  RT                                       
MFA-TR*             ,CSS_RATE_VRSN_DEF J4                                       
MFA-TR*        WHERE RT.RATE_PLAN_NO      = :RT-RATE-PLAN-NO                    
MFA-TR*          AND RT.CODE_UTIL_TYPE    = 'G'                                 
MFA-TR*          AND RT.CODE_STATUS       = 'A'                                 
MFA-TR*          AND RT.CODE_UTIL_TYPE    = J4.CODE_UTIL_TYPE                   
MFA-TR*          AND RT.RATE_PLAN_NO      = J4.RATE_PLAN_NO                     
MFA-TR*          AND RT.VERSION_NO_CNTRL  = J4.VERSION_NO_CNTRL                 
MFA-TR*          AND RT.FROM_EFFECTIVE_DT <= :RT-FROM-EFFECTIVE-DT              
MFA-TR*        ORDER BY RT.VERSION_NO_CNTRL DESC                                
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*        QUERYNO 7250                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04019                                                                  
A04019     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
A04019                                                                  
A04019     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04019           CONTINUE                                               
A04019     ELSE                                                         
A04019        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
A04019        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
A04019        MOVE '7250'                   TO ACTIVE-PARAGRAPH         
A04019        MOVE 'SELECT'                 TO ABEND-FUNCTION           
A04019        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
A04019                                           ABEND-TABLES           
A04019        MOVE 'CSS_RATE_CREATOR'       TO TABLE-1                  
A04019        MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1          
A04019        MOVE RT-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
A04019        MOVE 'FROM_EFFECTIVE_DT'      TO TABLE-ELEMENT-2          
A04019        MOVE WS-DATE-FOR-CSC-TIMELINE TO HOSTVAR-ELEMENT-2        
A04019        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
A04019     END-IF.                                                      
A04019                                                                  
A04019 7250-EXIT.                                                       
A04019      EXIT.                                                       
      ******************************************************************        
      * 7300-SELECT-RATE-CREATOR.                                     **        
      *                                                               **        
      ******************************************************************        
       7300-SELECT-RATE-CREATOR.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RT.VERSION_NO_CNTRL                                
                INTO :RT-VERSION-NO-CNTRL :WS-NULL-IND                   
                FROM CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)                  
               WHERE RT.RATE_PLAN_NO      = :RT-RATE-PLAN-NO            
                 AND RT.CODE_UTIL_TYPE    = 'G'                         
                 AND RT.CODE_STATUS       = 'A'                         
                 AND RT.DISPLAY_START_TS  <= CIS.CURRENT$TIMESTAMP()          
               ORDER BY RT.VERSION_NO_CNTRL DESC                        
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RT.VERSION_NO_CNTRL                                        
MFA-TR*         INTO :RT-VERSION-NO-CNTRL:WS-NULL-IND                           
MFA-TR*         FROM CSS_RATE_CREATOR RT                                        
MFA-TR*        WHERE RT.RATE_PLAN_NO      = :RT-RATE-PLAN-NO                    
MFA-TR*          AND RT.CODE_UTIL_TYPE    = 'G'                                 
MFA-TR*          AND RT.CODE_STATUS       = 'A'                                 
MFA-TR*          AND RT.DISPLAY_START_TS  <= CURRENT TIMESTAMP                  
MFA-TR*        ORDER BY RT.VERSION_NO_CNTRL DESC                                
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND               
                WS-NULL-IND = ZERO                                      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                                 ABEND-TABLES           
              MOVE 'CSS_RATE_CREATOR'       TO TABLE-1                  
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1          
              MOVE RT-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7400-SELECT-CUST-CHRG.                                        **        
      *                                                               **        
      ******************************************************************        
       7400-SELECT-CUST-CHRG.                                           
                                                                        
           EXEC SQL                                                     
               SELECT J4.AMT_CUST_CHRG                                  
                 INTO :J4-AMT-CUST-CHRG                                 
                 FROM CSS_RATE_VRSN_DEF J4                              
                WHERE CODE_UTIL_TYPE   = :J4-CODE-UTIL-TYPE             
                  AND RATE_PLAN_NO     = :J4-RATE-PLAN-NO               
                  AND VERSION_NO_CNTRL = :J4-VERSION-NO-CNTRL           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE SPACES                   TO ABEND-TABLES             
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE '7400'                   TO ACTIVE-PARAGRAPH         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_RATE_VRSN_DEF'      TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-2          
              MOVE J4-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE J4-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
P00165*                                                                         
P00165******************************************************************        
P00165* 7450-CHECK-STEP-RATE.                                         **        
P00165*                                                               **        
P00165******************************************************************        
P00165 7450-CHECK-STEP-RATE.                                            
P00165                                                                  
P00165     EXEC SQL                                                     
P00165         SELECT LAST_ENERGY_BLOCK                                 
P00165           INTO :J1-LAST-ENERGY-BLOCK                             
P00165           FROM CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)                
P00165          WHERE J1.CODE_UTIL_TYPE   = 'G'                         
P00165            AND J1.RATE_PLAN_NO     = :PS-RATE-PLAN-NO            
P00165            AND J1.CMPNT_ID_CD      = '10'                        
P00165            AND J1.VERSION_NO_CNTRL = :PS-VERSION-NO-CNTRL        
P00165                                                           
P00165     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LAST_ENERGY_BLOCK                                         
MFA-TR*          INTO :J1-LAST-ENERGY-BLOCK                                     
MFA-TR*          FROM CSS_RATE_COMP_DEF J1                                      
MFA-TR*         WHERE J1.CODE_UTIL_TYPE   = 'G'                                 
MFA-TR*           AND J1.RATE_PLAN_NO     = :PS-RATE-PLAN-NO                    
MFA-TR*           AND J1.CMPNT_ID_CD      = '10'                                
MFA-TR*           AND J1.VERSION_NO_CNTRL = :PS-VERSION-NO-CNTRL                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00165                                                                  
P00165     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P00165                                                                  
P00165     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
ACT060                                NOT-FOUND                         
P00165        CONTINUE                                                  
P00165     ELSE                                                         
P00165        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
P00165        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P00165        MOVE '7450'                   TO ACTIVE-PARAGRAPH         
P00165        MOVE 'SELECT'                 TO ABEND-FUNCTION           
P00165        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
P00165                                         ABEND-TABLES             
P00165        MOVE 'CSS_RATE_COMP_DEF'      TO TABLE-1                  
P00165        MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1          
P00165        MOVE PS-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
P00165        MOVE 'VERSION_NO_CONTROL'     TO TABLE-ELEMENT-2          
P00165        MOVE PS-VERSION-NO-CNTRL      TO HOSTVAR-ELEMENT-2        
P00165        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
P00165     END-IF.                                                      
P00165                                                                  
P00165 7450-EXIT.                                                       
P00165     EXIT.                                                        
P00165                                                                  
      *                                                                         
      ******************************************************************        
      * 7500-SELECT-PRICE-SCHED.                                      **        
      *                                                               **        
      ******************************************************************        
       7500-SELECT-PRICE-SCHED.                                         
                                                                        
           EXEC SQL                                                     
               SELECT PS.SCHED_PRICE_AM                                 
                  INTO :PS-SCHED-PRICE-AM                               
                  FROM CSS_PRICE_SCHED  PS                              
                 WHERE PS.CODE_UTIL_TYPE      = 'G'                     
                   AND PS.RATE_PLAN_NO        = :PS-RATE-PLAN-NO        
                   AND PS.VERSION_NO_CNTRL    = :PS-VERSION-NO-CNTRL    
                   AND PS.CMPNT_ID_CD         = '10'                    
                   AND PS.CODE_SEASON         = 'B'                     
                   AND PS.CODE_TIME_PERIOD    = 0                       
                   AND PS.CODE_USE_INST_TYPE  = 'R'                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PRICE_SCHED'        TO TABLE-1                  
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1          
              MOVE PS-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
              MOVE 'VERSION_NO_CONTROL'     TO TABLE-ELEMENT-2          
              MOVE PS-VERSION-NO-CNTRL      TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
A04019                                                                  
A04019******************************************************************        
A04019*                                                               **        
A04019* 7540-GET-BEACON-DATE .                                        **        
A04019******************************************************************        
A04019 7540-GET-BEACON-DATE.                                            
A04019                                                                  
A04019     EXEC SQL                                                     
A04019        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-BEACON-DATE                        
A04019     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-BEACON-DATE = CURRENT DATE                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04019                                                                  
A04019     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
A04019                                                                  
A04019     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04019        CONTINUE                                                  
A04019     ELSE                                                         
A04019        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
A04019        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
A04019        MOVE '7540'                   TO ACTIVE-PARAGRAPH         
A04019        MOVE 'SET'                    TO ABEND-FUNCTION           
A04019        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
A04019                                         ABEND-TABLES             
A04019        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
A04019     END-IF.                                                      
A04019                                                                  
A04019 7540-EXIT.                                                       
A04019     EXIT.                                                        
      ******************************************************************        
      *                                                               **        
      * 7550-SEL-CUST-ADJ-CSC.                                        **        
      ******************************************************************        
       7550-SEL-CUST-ADJ-CSC.                                           
                                                                        
           EXEC SQL                                                     
               SELECT SA.FACTOR                                         
                 INTO :SA-FACTOR                                        
                 FROM CSS_SPCL_FCTR_APPL SA                             
                     ,CSS_SPCL_FCTR SF                                  
                     ,CSS_FIXED_FCTR FF                                 
                WHERE FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                
                  AND FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE            
                  AND FF.IC_NO          = :FF-IC-NO                     
                  AND SF.SPCL_GROUP_CD  = 'BS'                          
                  AND SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO              
                  AND SF.FACTOR_ID      = SA.FACTOR_ID                  
                  AND FF.FACTOR_ID      = SA.FACTOR_ID                  
A04019            AND FF.EFF_DATE_TO    >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                 
A04019            AND SA.DATE_FROM      <= IIF(TRY_CONVERT(DATE, 
                                                        :WS-BEACON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BEACON-DATE
              ) <> 0) OR (LEN(:WS-BEACON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-BEACON-DATE
              ), CONVERT(DATE, :WS-BEACON-DATE) )              
A04019            AND SA.DATE_TO        >= IIF(TRY_CONVERT(DATE, 
                                                        :WS-BEACON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-BEACON-DATE
              ) <> 0) OR (LEN(:WS-BEACON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-BEACON-DATE
              ), CONVERT(DATE, :WS-BEACON-DATE) )              
A04019            AND SA.CODE_STATUS    = 'A'                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SA.FACTOR                                                 
MFA-TR*          INTO :SA-FACTOR                                                
MFA-TR*          FROM CSS_SPCL_FCTR_APPL SA                                     
MFA-TR*              ,CSS_SPCL_FCTR SF                                          
MFA-TR*              ,CSS_FIXED_FCTR FF                                         
MFA-TR*         WHERE FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                        
MFA-TR*           AND FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE                    
MFA-TR*           AND FF.IC_NO          = :FF-IC-NO                             
MFA-TR*           AND SF.SPCL_GROUP_CD  = 'BS'                                  
MFA-TR*           AND SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO                      
MFA-TR*           AND SF.FACTOR_ID      = SA.FACTOR_ID                          
MFA-TR*           AND FF.FACTOR_ID      = SA.FACTOR_ID                          
MFA-TR*           AND FF.EFF_DATE_TO    >= CURRENT DATE                         
MFA-TR*           AND SA.DATE_FROM      <= :WS-BEACON-DATE                      
MFA-TR*           AND SA.DATE_TO        >= :WS-BEACON-DATE                      
MFA-TR*           AND SA.CODE_STATUS    = 'A'                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7550'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_SPCL_FCTR'          TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE FF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE FF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                               **        
      * 7570-SEL-FF-DUR-REM.                                          **        
      ******************************************************************        
       7570-SEL-FF-DUR-REM.                                             
                                                                        
           EXEC SQL                                                     
            SELECT FF.DURATION_REMAIN_NO                                
              INTO :FF-DURATION-REMAIN-NO :WS-NULL-IND                   
              FROM CRM_OPT_ATTR_INCTV HQ                                
                  ,CSS_FIXED_FCTR FF                                    
I00484            ,CSS_UTIL_ENVRNMT UT                                  
P00677            ,CSS_ACCT_RTPK_AGR DF                                 
P00677       WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO               
               AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE           
               AND FF.IC_NO              = :FF-IC-NO                    
               AND FF.DURATION_REMAIN_NO > 0                            
I00484         AND UT.ACCOUNT_NO         = FF.ACCOUNT_NO                
I00484         AND UT.CODE_UTIL_TYPE     = FF.CODE_UTIL_TYPE            
I00484         AND UT.IC_NO              = FF.IC_NO                     
I00484         AND UT.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO         
P00677         AND DF.ACCOUNT_NO         = UT.ACCOUNT_NO                
P00677         AND DF.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE            
P00677         AND DF.IC_NO              = UT.IC_NO                     
P00677         AND DF.RT_PKG_OPT_SEQ_NO  = UT.RT_PKG_OPT_SEQ_NO         
P00677         AND HQ.OPTION_CD          = DF.OPTION_CD                 
               AND HQ.FACTOR_ID          = FF.FACTOR_ID                 
P00677         AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                
I00484         AND HQ.ATTR_INCTV_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )      
I00484         AND HQ.ATTR_INCTV_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                  :HQ-ATTR-INCTV-END-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-END-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-END-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-END-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-END-DT) )       
P00473         AND HQ.PROC_STATUS_CD      = 'AC'                        
P00473         AND HQ.OPT_ATTR_VSTART_TS = (                            
P00473               SELECT MAX(H1.OPT_ATTR_VSTART_TS)                  
P00473                 FROM CRM_OPT_ATTR_INCTV H1                       
P00473                WHERE H1.OPTION_CD    = HQ.OPTION_CD              
P00473                  AND H1.RT_ATTR_INCTV_TYPE                       
P00473                                      = HQ.RT_ATTR_INCTV_TYPE     
P00473                  AND H1.ATTR_INCTV_STRT_DT                       
P00473                                     <= IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )    
P00473                  AND H1.ATTR_INCTV_END_DT                        
P00473                                     >= IIF(TRY_CONVERT(DATE, 
                                                  :HQ-ATTR-INCTV-END-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-END-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-END-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-END-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-END-DT) )     
P00473                  AND CAST(H1.OPT_ATTR_VSTART_TS AS DATE)                 
P00473                                     <= IIF(TRY_CONVERT(DATE, 
                                                 :HQ-ATTR-INCTV-STRT-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-STRT-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-STRT-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-STRT-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-STRT-DT) )    
P00473                  AND CAST(H1.OPT_ATTR_VEND_TS AS DATE)                   
P00473                                     >= IIF(TRY_CONVERT(DATE, 
                                                  :HQ-ATTR-INCTV-END-DT
              ) IS NULL OR (PATINDEX('%.%', :HQ-ATTR-INCTV-END-DT
              ) <> 0) OR (LEN(:HQ-ATTR-INCTV-END-DT
              ) <> 10), CIS.CHAR2DATE(:HQ-ATTR-INCTV-END-DT
              ), CONVERT(DATE, :HQ-ATTR-INCTV-END-DT) )     
P00473                  AND H1.PROC_STATUS_CD      = 'AC')              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     41146600
MFA-TR*     SELECT FF.DURATION_REMAIN_NO                                41146600
MFA-TR*       INTO :FF-DURATION-REMAIN-NO:WS-NULL-IND                   41146600
MFA-TR*       FROM CRM_OPT_ATTR_INCTV HQ                                41146600
MFA-TR*           ,CSS_FIXED_FCTR FF                                    41146600
MFA-TR*           ,CSS_UTIL_ENVRNMT UT                                          
MFA-TR*           ,CSS_ACCT_RTPK_AGR DF                                         
MFA-TR*      WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO               41146600
MFA-TR*        AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE           41146600
MFA-TR*        AND FF.IC_NO              = :FF-IC-NO                    41146600
MFA-TR*        AND FF.DURATION_REMAIN_NO > 0                            41146600
MFA-TR*        AND UT.ACCOUNT_NO         = FF.ACCOUNT_NO                        
MFA-TR*        AND UT.CODE_UTIL_TYPE     = FF.CODE_UTIL_TYPE                    
MFA-TR*        AND UT.IC_NO              = FF.IC_NO                             
MFA-TR*        AND UT.RT_PKG_OPT_SEQ_NO  = FF.RT_PKG_OPT_SEQ_NO                 
MFA-TR*        AND DF.ACCOUNT_NO         = UT.ACCOUNT_NO                        
MFA-TR*        AND DF.CODE_UTIL_TYPE     = UT.CODE_UTIL_TYPE                    
MFA-TR*        AND DF.IC_NO              = UT.IC_NO                             
MFA-TR*        AND DF.RT_PKG_OPT_SEQ_NO  = UT.RT_PKG_OPT_SEQ_NO                 
MFA-TR*        AND HQ.OPTION_CD          = DF.OPTION_CD                 41146600
MFA-TR*        AND HQ.FACTOR_ID          = FF.FACTOR_ID                 41146600
MFA-TR*        AND HQ.RT_ATTR_INCTV_TYPE = 'FIXED PRICE'                41146600
MFA-TR*        AND HQ.ATTR_INCTV_STRT_DT <= :HQ-ATTR-INCTV-STRT-DT              
MFA-TR*        AND HQ.ATTR_INCTV_END_DT  >= :HQ-ATTR-INCTV-END-DT               
MFA-TR*        AND HQ.PROC_STATUS_CD      = 'AC'                                
MFA-TR*        AND HQ.OPT_ATTR_VSTART_TS = (                                    
MFA-TR*              SELECT MAX(H1.OPT_ATTR_VSTART_TS)                          
MFA-TR*                FROM CRM_OPT_ATTR_INCTV H1                               
MFA-TR*               WHERE H1.OPTION_CD    = HQ.OPTION_CD                      
MFA-TR*                 AND H1.RT_ATTR_INCTV_TYPE                               
MFA-TR*                                     = HQ.RT_ATTR_INCTV_TYPE             
MFA-TR*                 AND H1.ATTR_INCTV_STRT_DT                               
MFA-TR*                                    <= :HQ-ATTR-INCTV-STRT-DT            
MFA-TR*                 AND H1.ATTR_INCTV_END_DT                                
MFA-TR*                                    >= :HQ-ATTR-INCTV-END-DT             
MFA-TR*                 AND DATE(H1.OPT_ATTR_VSTART_TS)                         
MFA-TR*                                    <= :HQ-ATTR-INCTV-STRT-DT            
MFA-TR*                 AND DATE(H1.OPT_ATTR_VEND_TS)                           
MFA-TR*                                    >= :HQ-ATTR-INCTV-END-DT             
MFA-TR*                 AND H1.PROC_STATUS_CD      = 'AC')                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7570'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_FIXD_FCTR'          TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
              MOVE FF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE FF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              MOVE FF-IC-NO                 TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7570-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7600-SELECT-RATE-CALC-CD.                                     **        
      *                                                               **        
      ******************************************************************        
       7600-SELECT-RATE-CALC-CD.                                        
                                                                        
           EXEC SQL                                                     
               SELECT RATE_CALC_TYPE_CD                                 
P00477               ,RATE_DEFINITION_CD                                
                 INTO :RD-RATE-CALC-TYPE-CD                             
P00477               ,:RD-RATE-DEFINITION-CD                            
                  FROM CSS_RATE_PLAN_DESC RD                            
                 WHERE RD.CODE_UTIL_TYPE      = 'G'                     
                   AND RD.RATE_PLAN_NO        = :RD-RATE-PLAN-NO        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7600'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_RATE_PLAN_DESC'     TO TABLE-1                  
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1          
              MOVE RD-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
I00251******************************************************************        
I00251*                                                               **        
I00251* 7610-SELECT-ACCOUNT-DET.                                      **        
I00251******************************************************************        
I00251 7610-SELECT-ACCOUNT-DET.                                         
I00251                                                                  
I00251     EXEC SQL                                                     
I00251        SELECT AT.REV_MTH_LST_NRML                                
I00251              ,AT.BILL_CYCLE                                      
I00251          INTO :AT-REV-MTH-LST-NRML                               
I00251              ,:AT-BILL-CYCLE                                     
I00251          FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
I00251         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
I00251                                                           
I00251     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.REV_MTH_LST_NRML                                        
MFA-TR*             ,AT.BILL_CYCLE                                              
MFA-TR*         INTO :AT-REV-MTH-LST-NRML                                       
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00251                                                                  
I00251     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
I00251                                                                  
I00251     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
I00251        CONTINUE                                                  
I00251     ELSE                                                         
I00251        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
I00251        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
I00251        MOVE '7610'                   TO ACTIVE-PARAGRAPH         
I00251        MOVE 'SELECT'                 TO ABEND-FUNCTION           
I00251        MOVE 'CSS_ACCOUNT'            TO TABLE-1                  
I00251        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
I00251        MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
I00251        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
I00251     END-IF.                                                      
I00251                                                                  
I00251 7610-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
I00251******************************************************************        
I00251* 7620-SELECT-READ-WINDOW.                                      **        
I00251*                                                               **        
I00251******************************************************************        
I00251 7620-SELECT-READ-WINDOW.                                         
I00251                                                                  
I00251     EXEC SQL                                                     
I00251        SELECT TOP(1) RW.OPTIMUM_READ_DATE                               
I00251          INTO :RW-OPTIMUM-READ-DATE                              
I00251          FROM CSS_READ_WINDOW RW WITH(READUNCOMMITTED)                   
I00251         WHERE RW.REVENUE_MONTH = :RW-REVENUE-MONTH               
I00251           AND RW.READ_CYCLE    = :RW-READ-CYCLE                  
I00251         ORDER BY RW.OPTIMUM_READ_DATE ASC                        
I00251                                       
I00251     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RW.OPTIMUM_READ_DATE                                       
MFA-TR*         INTO :RW-OPTIMUM-READ-DATE                                      
MFA-TR*         FROM CSS_READ_WINDOW RW                                         
MFA-TR*        WHERE RW.REVENUE_MONTH = :RW-REVENUE-MONTH                       
MFA-TR*          AND RW.READ_CYCLE    = :RW-READ-CYCLE                          
MFA-TR*        ORDER BY RW.OPTIMUM_READ_DATE ASC                                
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00251                                                                  
I00251     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
I00251                                                                  
I00251     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
I00251        CONTINUE                                                  
I00251     ELSE                                                         
I00251        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
I00251        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
I00251        MOVE '7620'                   TO ACTIVE-PARAGRAPH         
I00251        MOVE 'SELECT'                 TO ABEND-FUNCTION           
I00251        MOVE 'CSS_READ_WINDOW'        TO TABLE-1                  
I00251        MOVE 'REVENUE_MONTH'          TO TABLE-ELEMENT-1          
I00251        MOVE 'READ_CYCLE'             TO TABLE-ELEMENT-2          
I00251        MOVE RW-REVENUE-MONTH         TO HOSTVAR-ELEMENT-1        
I00251        MOVE RW-READ-CYCLE            TO HOSTVAR-ELEMENT-2        
I00251        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
I00251     END-IF.                                                      
I00251                                                                  
I00251 7620-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
I00251******************************************************************        
I00251*                                                               **        
I00251* 7630-SELECT-DELINQNCY.                                        **        
I00251******************************************************************        
I00251 7630-SELECT-DELINQNCY.                                           
I00251                                                                  
I00251     EXEC SQL                                                     
I00251        SELECT C8.DELINQ_VALUE                                    
I00251          INTO :C8-DELINQ-VALUE                                   
I00251          FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
I00251         WHERE C8.DELINQ_CD    = :C8-DELINQ-CD                    
I00251           AND C8.COMPANY_NO   = :C8-COMPANY-NO                   
I00251                                                           
I00251     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD    = :C8-DELINQ-CD                            
MFA-TR*          AND C8.COMPANY_NO   = :C8-COMPANY-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00251                                                                  
I00251     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
I00251                                                                  
I00251     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
I00251        CONTINUE                                                  
I00251     ELSE                                                         
I00251        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
I00251        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
I00251        MOVE '7630'                   TO ACTIVE-PARAGRAPH         
I00251        MOVE 'SELECT'                 TO ABEND-FUNCTION           
I00251        MOVE 'CSS_DELINQUENCY'        TO TABLE-1                  
I00251        MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-1          
I00251        MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
I00251        MOVE C8-DELINQ-CD             TO HOSTVAR-ELEMENT-1        
I00251        MOVE C8-COMPANY-NO            TO HOSTVAR-ELEMENT-2        
I00251        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
I00251     END-IF.                                                      
I00251                                                                  
I00251 7630-EXIT.                                                       
I00251     EXIT.                                                        
I00251                                                                  
I00251******************************************************************        
I00251*                                                               **        
I00251* 7640-SEL-RT-PKG-OPT-STAT.                                     **        
I00251******************************************************************        
I00251 7640-SEL-RT-PKG-OPT-STAT.                                        
I00251                                                                  
I00251     EXEC SQL                                                     
I00251        SELECT DF.STATUS_CD                                       
I00251          INTO :DF-STATUS-CD                                      
I00251          FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
I00251              ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
I00251         WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO              
I00251           AND UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE          
I00251           AND UT.IC_NO             = :UT-IC-NO                   
I00251           AND UT.ACCOUNT_NO        = DF.ACCOUNT_NO               
I00251           AND UT.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE           
I00251           AND UT.IC_NO             = DF.IC_NO                    
I00251           AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO        
I00251                                                           
I00251     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DF.STATUS_CD                                               
MFA-TR*         INTO :DF-STATUS-CD                                              
MFA-TR*         FROM CSS_ACCT_RTPK_AGR DF                                       
MFA-TR*             ,CSS_UTIL_ENVRNMT UT                                        
MFA-TR*        WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO                      
MFA-TR*          AND UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE                  
MFA-TR*          AND UT.IC_NO             = :UT-IC-NO                           
MFA-TR*          AND UT.ACCOUNT_NO        = DF.ACCOUNT_NO                       
MFA-TR*          AND UT.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE                   
MFA-TR*          AND UT.IC_NO             = DF.IC_NO                            
MFA-TR*          AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO                
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00251                                                                  
I00251     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
I00251                                                                  
I00251     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
I00251        CONTINUE                                                  
I00251     ELSE                                                         
I00251        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
I00251        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
I00251        MOVE '7640'                   TO ACTIVE-PARAGRAPH         
I00251        MOVE 'SELECT'                 TO ABEND-FUNCTION           
I00251        MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
I00251        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
I00251        MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
I00251        MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
I00251        MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
I00251        MOVE UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
I00251        MOVE UT-IC-NO                 TO HOSTVAR-ELEMENT-3        
I00251        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
I00251     END-IF.                                                      
I00251                                                                  
I00251 7640-EXIT.                                                       
I00251     EXIT.                                                        
I00484*                                                                         
I00484******************************************************************        
I00484* 7650-CHECK-PEND-OPTION.                                       **        
I00484*                                                               **        
I00484******************************************************************        
I00484 7650-CHECK-PEND-OPTION.                                          
I00484                                                                  
I00484     EXEC SQL                                                     
I00484         SELECT DF.OPTION_CD                                      
I00484               ,DF.RT_PKG_OPT_SEQ_NO                              
A04019               ,DF.STATUS_EFF_REV_MTH                             
I00484           INTO :DF-OPTION-CD                                     
I00484               ,:DF-RT-PKG-OPT-SEQ-NO                             
A04019               ,:DF-STATUS-EFF-REV-MTH                            
I00484           FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                
I00484          WHERE DF.ACCOUNT_NO     = :DF-ACCOUNT-NO                
I00484            AND DF.CODE_UTIL_TYPE = :DF-CODE-UTIL-TYPE            
I00484            AND DF.IC_NO          = :DF-IC-NO                     
I00484            AND DF.STATUS_CD      = :DF-STATUS-CD                 
I00484                                                           
I00484     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DF.OPTION_CD                                              
MFA-TR*              ,DF.RT_PKG_OPT_SEQ_NO                                      
MFA-TR*              ,DF.STATUS_EFF_REV_MTH                                     
MFA-TR*          INTO :DF-OPTION-CD                                             
MFA-TR*              ,:DF-RT-PKG-OPT-SEQ-NO                                     
MFA-TR*              ,:DF-STATUS-EFF-REV-MTH                                    
MFA-TR*          FROM CSS_ACCT_RTPK_AGR DF                                      
MFA-TR*         WHERE DF.ACCOUNT_NO     = :DF-ACCOUNT-NO                        
MFA-TR*           AND DF.CODE_UTIL_TYPE = :DF-CODE-UTIL-TYPE                    
MFA-TR*           AND DF.IC_NO          = :DF-IC-NO                             
MFA-TR*           AND DF.STATUS_CD      = :DF-STATUS-CD                         
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

I00484                                                                  
I00484     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
I00484                                                                  
I00484     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
I00484        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
I00484           SET PEND-OPTION-EXIST      TO TRUE                     
I00484           MOVE 'Y'                   TO WS-PEND063-OPT-EXIST-FL  
I00484        END-IF                                                    
I00484     ELSE                                                         
I00484        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
I00484        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
I00484        MOVE '7650'                   TO ACTIVE-PARAGRAPH         
I00484        MOVE 'SELECT'                 TO ABEND-FUNCTION           
I00484        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
I00484                                         ABEND-TABLES             
I00484        MOVE 'CSS_ACCT_RTPK_AGR'      TO TABLE-1                  
I00484        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
I00484        MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
I00484        MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
I00484        MOVE DF-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
I00484        MOVE DF-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
I00484        MOVE DF-IC-NO                 TO HOSTVAR-ELEMENT-3        
I00484        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
I00484     END-IF.                                                      
I00484*                                                                         
I00484 7650-EXIT.                                                       
I00484     EXIT.                                                        
                                                                        
P00211******************************************************************        
P00211*                                                               **        
P00211* 7660-SEL-SIGN-UP-EXIT-FEE.                                    **        
P00211******************************************************************        
P00211 7660-SEL-SIGN-UP-EXIT-FEE.                                       
P00211                                                                  
P00211     EXEC SQL                                                     
P00211        SELECT HQ.ATTR_INCTV_VALUE                                
P00211          INTO :HQ-ATTR-INCTV-VALUE                               
P00211          FROM CSS_ACCT_RTPK_AGR DF WITH(READUNCOMMITTED)                 
P00211              ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
P00211              ,CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)                
P00211         WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO              
P00211           AND UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE          
P00211           AND UT.IC_NO             = :UT-IC-NO                   
P00211           AND UT.ACCOUNT_NO        = DF.ACCOUNT_NO               
P00211           AND UT.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE           
P00211           AND UT.IC_NO             = DF.IC_NO                    
P00211           AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO        
P00211           AND HQ.OPTION_CD         = DF.OPTION_CD                
P00211           AND HQ.RT_ATTR_INCTV_TYPE = 'EXIT FEE'                 
P00211           AND HQ.ATTR_INCTV_STRT_DT <= DF.OPT_AGRMT_EFF_DT       
P00211           AND HQ.ATTR_INCTV_END_DT  >= DF.OPT_AGRMT_EFF_DT       
P00473           AND HQ.PROC_STATUS_CD      = 'AC'                      
P00473           AND HQ.OPT_ATTR_VSTART_TS = (                          
P00473               SELECT MAX(H1.OPT_ATTR_VSTART_TS)                  
P00473                 FROM CRM_OPT_ATTR_INCTV H1 WITH(READUNCOMMITTED)         
P00473                WHERE H1.OPTION_CD    = HQ.OPTION_CD              
P00473                  AND H1.RT_ATTR_INCTV_TYPE                       
P00473                                      = HQ.RT_ATTR_INCTV_TYPE     
P00473                  AND H1.ATTR_INCTV_STRT_DT                       
P00473                                     <= DF.OPT_AGRMT_EFF_DT       
P00473                  AND H1.ATTR_INCTV_END_DT                        
P00473                                     >= DF.OPT_AGRMT_EFF_DT       
P00473                  AND CAST(H1.OPT_ATTR_VSTART_TS AS DATE)                 
P00473                                     <= DF.OPT_AGRMT_EFF_DT       
P00473                  AND CAST(H1.OPT_ATTR_VEND_TS AS DATE)                   
P00473                                     >= DF.OPT_AGRMT_EFF_DT       
P00473                  AND H1.PROC_STATUS_CD      = 'AC')              
P00211                                                           
P00211     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT HQ.ATTR_INCTV_VALUE                                        
MFA-TR*         INTO :HQ-ATTR-INCTV-VALUE                                       
MFA-TR*         FROM CSS_ACCT_RTPK_AGR DF                                       
MFA-TR*             ,CSS_UTIL_ENVRNMT UT                                        
MFA-TR*             ,CRM_OPT_ATTR_INCTV HQ                                      
MFA-TR*        WHERE UT.ACCOUNT_NO        = :UT-ACCOUNT-NO                      
MFA-TR*          AND UT.CODE_UTIL_TYPE    = :UT-CODE-UTIL-TYPE                  
MFA-TR*          AND UT.IC_NO             = :UT-IC-NO                           
MFA-TR*          AND UT.ACCOUNT_NO        = DF.ACCOUNT_NO                       
MFA-TR*          AND UT.CODE_UTIL_TYPE    = DF.CODE_UTIL_TYPE                   
MFA-TR*          AND UT.IC_NO             = DF.IC_NO                            
MFA-TR*          AND UT.RT_PKG_OPT_SEQ_NO = DF.RT_PKG_OPT_SEQ_NO                
MFA-TR*          AND HQ.OPTION_CD         = DF.OPTION_CD                        
MFA-TR*          AND HQ.RT_ATTR_INCTV_TYPE = 'EXIT FEE'                         
MFA-TR*          AND HQ.ATTR_INCTV_STRT_DT <= DF.OPT_AGRMT_EFF_DT               
MFA-TR*          AND HQ.ATTR_INCTV_END_DT  >= DF.OPT_AGRMT_EFF_DT               
MFA-TR*          AND HQ.PROC_STATUS_CD      = 'AC'                              
MFA-TR*          AND HQ.OPT_ATTR_VSTART_TS = (                                  
MFA-TR*              SELECT MAX(H1.OPT_ATTR_VSTART_TS)                          
MFA-TR*                FROM CRM_OPT_ATTR_INCTV H1                               
MFA-TR*               WHERE H1.OPTION_CD    = HQ.OPTION_CD                      
MFA-TR*                 AND H1.RT_ATTR_INCTV_TYPE                               
MFA-TR*                                     = HQ.RT_ATTR_INCTV_TYPE             
MFA-TR*                 AND H1.ATTR_INCTV_STRT_DT                               
MFA-TR*                                    <= DF.OPT_AGRMT_EFF_DT               
MFA-TR*                 AND H1.ATTR_INCTV_END_DT                                
MFA-TR*                                    >= DF.OPT_AGRMT_EFF_DT               
MFA-TR*                 AND DATE(H1.OPT_ATTR_VSTART_TS)                         
MFA-TR*                                    <= DF.OPT_AGRMT_EFF_DT               
MFA-TR*                 AND DATE(H1.OPT_ATTR_VEND_TS)                           
MFA-TR*                                    >= DF.OPT_AGRMT_EFF_DT               
MFA-TR*                 AND H1.PROC_STATUS_CD      = 'AC')                      
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00211                                                                  
P00211     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00211                                                                  
P00211     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00211        CONTINUE                                                  
P00211     ELSE                                                         
P00211        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
P00211        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P00211        MOVE '7660'                   TO ACTIVE-PARAGRAPH         
P00211        MOVE 'SELECT'                 TO ABEND-FUNCTION           
P00211        MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                  
P00211        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
P00211        MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
P00211        MOVE 'IC_NO'                  TO TABLE-ELEMENT-3          
P00211        MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
P00211        MOVE UT-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
P00211        MOVE UT-IC-NO                 TO HOSTVAR-ELEMENT-3        
P00211        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
P00211     END-IF.                                                      
P00211                                                                  
P00211 7660-EXIT.                                                       
P00211     EXIT.                                                        
                                                                        
ACT060******************************************************************        
ACT060*                                                               **        
ACT060* 7670-GET-BILL-CYC-DT.                                         **        
ACT060******************************************************************        
ACT060 7670-GET-BILL-CYC-DT.                                            
ACT060                                                                  
ACT060     EXEC SQL                                                     
ACT060        SELECT TOP(1) REVENUE_MONTH                                      
ACT060          INTO :RW-REVENUE-MONTH                                  
ACT060          FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
ACT060         WHERE BILL_CYCLE           = :AT-BILL-CYCLE              
ACT060           AND DATE_EXTRACT         >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)               
ACT060           ORDER BY DATE_EXTRACT ASC                              
ACT060                                              
ACT060                                                           
ACT060     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT REVENUE_MONTH                                              
MFA-TR*         INTO :RW-REVENUE-MONTH                                          
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE BILL_CYCLE           = :AT-BILL-CYCLE                      
MFA-TR*          AND DATE_EXTRACT         >= CURRENT DATE                       
MFA-TR*          ORDER BY DATE_EXTRACT ASC                                      
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT060                                                                  
ACT060     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
ACT060                                                                  
ACT060     EVALUATE WS-ACTIVE-RETURN-CODE                               
ACT060       WHEN   SUCCESSFUL-CALL                                     
ACT060         MOVE RW-REVENUE-MONTH        TO WS-REV-MONTH-TMP         
ACT060       WHEN NOT-FOUND                                             
ACT060         PERFORM 7675-GET-COMMON-DT THRU 7675-EXIT                
ACT060       WHEN OTHER                                                 
ACT060        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
ACT060        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
ACT060        MOVE '7670'                   TO ACTIVE-PARAGRAPH         
ACT060        MOVE 'SELECT'                 TO ABEND-FUNCTION           
ACT060        MOVE 'CSS_BILL_WINDOW'        TO TABLE-1                  
ACT060        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
ACT060        MOVE 'BILL_CYCLE'             TO TABLE-ELEMENT-2          
ACT060        MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
ACT060        MOVE AT-BILL-CYCLE            TO HOSTVAR-ELEMENT-2        
ACT060        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
ACT060     END-EVALUATE.                                                
ACT060                                                                  
ACT060 7670-EXIT.                                                       
ACT060     EXIT.                                                        
                                                                        
ACT060******************************************************************        
ACT060* 7675-GET-COMMON-DT.                                           **        
ACT060******************************************************************        
ACT060 7675-GET-COMMON-DT.                                              
ACT060                                                                  
ACT060     MOVE 'COMMON'                  TO G6-PROGRAM-NAME            
ACT060     MOVE '01'                      TO G6-COMPANY-NO              
ACT060     MOVE 'DATE'                    TO G6-CMND-CODE               
ACT060     MOVE 20                        TO G6-SEQ-NO                  
ACT060                                                                  
ACT060     PERFORM 7000-SELECT-JOB-PARM      THRU 7000-EXIT             
ACT060     MOVE G6-PARM-DATA(15:6)        TO WS-REV-MONTH-TMP.          
ACT060                                                                  
ACT060 7675-EXIT.                                                       
ACT060     EXIT.                                                        
      *****************************************************************         
      * 7700-OPEN-RATE-FCTRS.                                        **         
      *                                                              **         
      *****************************************************************         
       7700-OPEN-RATE-FCTRS.                                            
                                                                        
           EXEC SQL                                                     
                OPEN RATE_FCTR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7700'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE SA-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
              MOVE SA-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7710-FETCH-RATE-FCTRS.                                       **         
      *                                                              **         
      *****************************************************************         
       7710-FETCH-RATE-FCTRS.                                           
                                                                        
           EXEC SQL                                                     
               FETCH RATE_FCTR                                          
                INTO :SF-FACTOR-ID                                      
                    ,:SF-FACTOR-TYPE                                    
P00120              ,:SA-VERS-PRORATE-CD                                
                    ,:SF-ADJUST-ELEMENT                                 
                    ,:SF-SPCL-GROUP-CD                                  
                    ,:SF-OVR-RT-CALC-TYP-CD :WS-RATE-CALC-NULL           
                    ,:SA-DATE-FROM                                      
                    ,:SA-DATE-TO                                        
                    ,:SA-FACTOR                                         
JCFIXX              ,:SF-RT-ATTR-INCTV-TYPE                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             IF WS-RATE-CALC-NULL NOT EQUAL ZEROES                      
                MOVE SPACES                  TO SF-OVR-RT-CALC-TYP-CD   
             END-IF                                                     
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
I00484         MOVE 'Y' TO WS-NO-MORE-ROWS1                             
             END-IF                                                     
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7710'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE SA-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-1       
              MOVE SA-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7720-CLOSE-RATE-FCTRS.                                       **         
      *                                                              **         
      *****************************************************************         
       7720-CLOSE-RATE-FCTRS.                                           
                                                                        
           EXEC SQL                                                     
               CLOSE RATE_FCTR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7720'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE SA-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-1        
              MOVE SA-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7720-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7730-OPEN-SPCL-FCTRS.                                        **         
      *                                                              **         
      *****************************************************************         
       7730-OPEN-SPCL-FCTRS.                                            
                                                                        
           EXEC SQL                                                     
                OPEN SPCL_FCTR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7730'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE SA-FACTOR-ID             TO HOSTVAR-ELEMENT-1        
              MOVE SA-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7730-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7740-FETCH-SPCL-FCTRS.                                       **         
      *                                                              **         
      *****************************************************************         
       7740-FETCH-SPCL-FCTRS.                                           
                                                                        
           EXEC SQL                                                     
               FETCH SPCL_FCTR                                          
                INTO :SF-FACTOR-ID                                      
                    ,:SF-FACTOR-TYPE                                    
P00120              ,:SA-VERS-PRORATE-CD                                
                    ,:SF-ADJUST-ELEMENT                                 
                    ,:SF-SPCL-GROUP-CD                                  
                    ,:SF-OVR-RT-CALC-TYP-CD :WS-RATE-CALC-NULL           
                    ,:SA-DATE-FROM                                      
                    ,:SA-DATE-TO                                        
                    ,:SA-FACTOR                                         
JCFIXX              ,:SF-RT-ATTR-INCTV-TYPE                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             IF WS-RATE-CALC-NULL NOT EQUAL ZEROES                      
                MOVE SPACES                  TO SF-OVR-RT-CALC-TYP-CD   
             END-IF                                                     
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
I00484         MOVE 'Y' TO WS-NO-MORE-ROWS2                             
             END-IF                                                     
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7740'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE SA-FACTOR-ID              TO HOSTVAR-ELEMENT-1       
              MOVE SA-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7740-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7750-CLOSE-SPCL-FCTRS.                                       **         
      *                                                              **         
      *****************************************************************         
       7750-CLOSE-SPCL-FCTRS.                                           
                                                                        
           EXEC SQL                                                     
               CLOSE SPCL_FCTR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7750'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_SPCL_FCTR_APPL'     TO TABLE-1                  
              MOVE 'FACTOR_ID'              TO TABLE-ELEMENT-1          
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-2          
              MOVE SA-FACTOR-ID             TO HOSTVAR-ELEMENT-1        
              MOVE SA-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7800-OPEN-ATTR-INCTV-DET.                                    **         
      *                                                              **         
      *****************************************************************         
       7800-OPEN-ATTR-INCTV-DET.                                        
                                                                        
           EXEC SQL                                                     
                OPEN ATTR_INCTV                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7800'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CRM_OPT_ATTR_INCTV'      TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE 'PRIMRY_OPT_ATTR_FL'      TO TABLE-ELEMENT-2         
              MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              MOVE HQ-PRIMRY-OPT-ATTR-FL     TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7810-FETCH-ATTR-INCTV-DET.                                   **         
      *                                                              **         
      *****************************************************************         
       7810-FETCH-ATTR-INCTV-DET.                                       
                                                                        
           EXEC SQL                                                     
               FETCH ATTR_INCTV                                         
                INTO :HQ-FACTOR-ID :WS-FACTOR-ID-NULL                    
                    ,:HQ-ATTR-INCTV-VALUE :WS-INCTV-VALUE-NULL           
                    ,:HQ-PRIMRY-OPT-ATTR-FL                             
                    ,:HQ-DURATION-NO                                    
                    ,:HQ-RT-ATTR-INCTV-TYPE                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                  IF WS-FACTOR-ID-NULL   NOT EQUAL ZEROES               
                     MOVE SPACES             TO HQ-FACTOR-ID            
                  END-IF                                                
                  IF WS-INCTV-VALUE-NULL NOT EQUAL ZEROES               
                     MOVE ZEROES             TO HQ-ATTR-INCTV-VALUE     
                  END-IF                                                
             WHEN NOT-FOUND                                             
                  MOVE 'Y'                   TO WS-NO-MORE-ROWS1        
             WHEN OTHER                                                 
                  MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE          
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE '7810'                TO ACTIVE-PARAGRAPH        
                  MOVE 'FETCH'               TO ABEND-FUNCTION          
                  MOVE 'CRM_OPT_ATTR_INCTV'  TO TABLE-1                 
                  MOVE 'OPTION_CD'           TO TABLE-ELEMENT-1         
                  MOVE 'PRIMRY_OPT_ATTR_FL'  TO TABLE-ELEMENT-2         
                  MOVE HQ-OPTION-CD          TO HOSTVAR-ELEMENT-1       
                  MOVE HQ-PRIMRY-OPT-ATTR-FL TO HOSTVAR-ELEMENT-2       
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
           END-EVALUATE.                                                
      *                                                                         
       7810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7820-CLOSE-ATTR-INCTV-DET.                                   **         
      *                                                              **         
      *****************************************************************         
       7820-CLOSE-ATTR-INCTV-DET.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE ATTR_INCTV                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7820'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CRM_OPT_ATTR_INCTV'     TO TABLE-1                  
              MOVE 'OPTION_CD'              TO TABLE-ELEMENT-1          
              MOVE 'PRIMRY_OPT_ATTR_FL'     TO TABLE-ELEMENT-2          
              MOVE HQ-OPTION-CD             TO HOSTVAR-ELEMENT-1        
              MOVE HQ-PRIMRY-OPT-ATTR-FL    TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
                                                                        
       7820-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7850-OPEN-ACCT-REL-FCTRS.                                    **         
      *                                                              **         
      *****************************************************************         
       7850-OPEN-ACCT-REL-FCTRS.                                        
                                                                        
           EXEC SQL                                                     
                OPEN ACCT_FCTR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7850'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_FIXED_FCTR'          TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE FF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FF-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE FF-IC-NO                  TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7860-FETCH-ACCT-REL-FCTRS.                                              
      *                                                              **         
      *****************************************************************         
       7860-FETCH-ACCT-REL-FCTRS.                                       
                                                                        
           EXEC SQL                                                     
               FETCH ACCT_FCTR                                          
                INTO :FF-FACTOR                                         
                    ,:SF-ADJUST-ELEMENT                                 
                    ,:SF-VERS-PRORATE-CD                                
                    ,:FF-EFF-DATE-FROM                                  
                    ,:FF-EFF-DATE-TO                                    
                    ,:FF-DURATION-REMAIN-NO :WS-DURN-REMN-NULL           
                    ,:SF-FACTOR-TYPE                                    
                    ,:SF-VERS-PRORATE-CD                                
                    ,:SF-SPCL-GROUP-CD                                  
I00484              ,:FF-RT-PKG-OPT-SEQ-NO                              
P00680              ,:SF-RT-ATTR-INCTV-TYPE                             
P00805              ,:SF-DURATION-TYPE-CD                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-DURN-REMN-NULL EQUAL -1                             
                 MOVE ZEROES                 TO FF-DURATION-REMAIN-NO   
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
I00484            MOVE 'Y'                   TO WS-NO-MORE-ROWS1        
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7860'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_FIXED_FCTR'          TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE FF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FF-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE FF-IC-NO                  TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7860-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7870-CLOSE-ACCT-REL-FCTRS.                                   **         
      *                                                              **         
      *****************************************************************         
       7870-CLOSE-ACCT-REL-FCTRS.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE ACCT_FCTR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7870'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_FIXED_FCTR'          TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
              MOVE FF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE FF-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE FF-IC-NO                  TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7870-EXIT.                                                       
           EXIT.                                                        
P805AP*****************************************************************         
P805AP* 7900-GET-ACCOUNT-ATTRIBUTE.                                    *        
P805AP*****************************************************************         
P805AP 7900-GET-ACCOUNT-ATTRIBUTE.                                      
P805AP                                                                  
P805AP     EXEC SQL                                                     
P805AP        SELECT 'Y'                                                
P805AP          INTO :WS-ADV-PRC-OPT-FL-063                             
P805AP          FROM CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)                
P805AP         WHERE YP.ACCOUNT_NO      = :YP-ACCOUNT-NO                
P805AP           AND YP.ATTRIBUTE_DESC  = :YP-ATTRIBUTE-DESC            
P805AP           AND YP.STATUS_CD       = :YP-STATUS-CD                 
P805AP                                                           
P805AP     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-ADV-PRC-OPT-FL-063                                     
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE YP                                      
MFA-TR*        WHERE YP.ACCOUNT_NO      = :YP-ACCOUNT-NO                        
MFA-TR*          AND YP.ATTRIBUTE_DESC  = :YP-ATTRIBUTE-DESC                    
MFA-TR*          AND YP.STATUS_CD       = :YP-STATUS-CD                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P805AP                                                                  
P805AP     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P805AP                                                                  
P805AP     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P805AP        NEXT SENTENCE                                             
P805AP     ELSE                                                         
P805AP        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P805AP        MOVE '7900'                    TO ACTIVE-PARAGRAPH        
P805AP        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P805AP        MOVE 'CSS_ACCT_ATTRIBUTE'      TO TABLE-1                 
P805AP        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
P805AP        MOVE YP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
P805AP        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
P805AP     END-IF.                                                      
P805AP                                                                  
P805AP 7900-EXIT.                                                       
P805AP     EXIT.                                                        
P805AP                                                                  
