      ******************************************************************        
      *  CPD00048                                                      *        
      *       INCLUDE MEMBER FOR PARTITION HANDLING PROCEDURE          *        
      *       USED WITH CWS00042                                       *        
      ******************************************************************        
       0101-GET-PARTITION-DATA.                                         
           OPEN INPUT FCSCM16-FILE.                                     
           READ FCSCM16-FILE                                            
               AT END                                                   
                   DISPLAY '*******************************************'
                   DISPLAY '****  PARTITION RANGE NOT AVAILABLE   *****'
                   DISPLAY '****  PROCESSING WILL CONTINUE WITH   *****'
                   DISPLAY '****  FULL RANGE                      *****'
                   DISPLAY '*******************************************'
                   MOVE ZERO TO WS-BEGIN-PREMISE-NO                     
                                WS-BEGIN-ACCOUNT-NO                     
                   MOVE WS-PART-ALL-NINES  TO  WS-END-PREMISE-NO        
                                               WS-END-ACCOUNT-NO        
                   MOVE WS-AT TO WS-PART-TYPE-1                         
                   MOVE WS-PR TO WS-PART-TYPE-2                         
                   CLOSE FCSCM16-FILE                                   
                   GO TO 0101-EXIT.                                     
      *                                                                         
           IF E-FCM16-PART-RANGE1  EQUAL SPACES OR LOW-VALUES           
              MOVE SPACES TO WS-PART-TYPE-1                             
           ELSE                                                         
              MOVE E-FCM16-PART-RANGE1 TO WS-PART-BREAKDOWN             
                                          O5-PARTITION-ID               
              IF VALID-PART                                             
                 MOVE WS-PART-TYPE TO WS-PART-TYPE-1                    
                 PERFORM 0102-GET-PART-RANGE THRU 0102-EXIT             
              ELSE                                                      
                 DISPLAY '**********************************'           
                 DISPLAY '** INVALID PART RANGE KEY ENTRY **'           
                 DISPLAY '** E-FCM16-PART-RANGE1 = ' E-FCM16-PART-RANGE1
                 DISPLAY '** PROCESSING TERMINATED        **'           
                 DISPLAY '**                              **'           
                 DISPLAY '**********************************'           
                 PERFORM 9900-ABEND  THRU 9900-EXIT                     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF E-FCM16-PART-RANGE2  EQUAL SPACES OR LOW-VALUES           
              MOVE SPACES TO WS-PART-TYPE-2                             
           ELSE                                                         
              MOVE E-FCM16-PART-RANGE2 TO WS-PART-BREAKDOWN             
                                          O5-PARTITION-ID               
              IF VALID-PART                                             
                 MOVE WS-PART-TYPE TO WS-PART-TYPE-2                    
                 PERFORM 0102-GET-PART-RANGE THRU 0102-EXIT             
              ELSE                                                      
                 DISPLAY '**********************************'           
                 DISPLAY '** INVALID PART RANGE KEY ENTRY **'           
                 DISPLAY '** E-FCM16-PART-RANGE2 = ' E-FCM16-PART-RANGE2
                 DISPLAY '** PROCESSING TERMINATED        **'           
                 DISPLAY '**                              **'           
                 DISPLAY '**********************************'           
                 PERFORM 9900-ABEND  THRU 9900-EXIT                     
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-PART-TYPE-1 = SPACES AND                               
              WS-PART-TYPE-2 = SPACES                                   
              MOVE ZERO TO WS-BEGIN-PREMISE-NO                          
                           WS-BEGIN-ACCOUNT-NO                          
              MOVE WS-PART-ALL-NINES  TO  WS-END-PREMISE-NO             
                                          WS-END-ACCOUNT-NO             
           END-IF.                                                      
           IF WS-PART-TYPE-2 = SPACES                                   
              IF WS-PART-TYPE-1 = 'PR'                                  
                 MOVE ZERO   TO  WS-BEGIN-ACCOUNT-NO                    
                 MOVE WS-PART-ALL-NINES TO WS-END-ACCOUNT-NO            
              ELSE                                                      
                 MOVE ZERO   TO WS-BEGIN-PREMISE-NO                     
                 MOVE WS-PART-ALL-NINES TO WS-END-PREMISE-NO            
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           CLOSE FCSCM16-FILE.                                          
       0101-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       0102-GET-PART-RANGE.                                             
           EXEC SQL                                                     
                SELECT  BEGIN_PART_RANGE,                               
                        END_PART_RANGE                                  
                INTO    :O5-BEGIN-PART-RANGE,                           
                        :O5-END-PART-RANGE                              
                FROM   CSS_BTCH_PARTITION                               
                WHERE  PARTITION_ID = :O5-PARTITION-ID                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               DISPLAY '*******************************************'    
               DISPLAY '****  PARTITION RANGE NOT AVAILABLE   *****'    
               DISPLAY '****  PROCESSING WILL CONTINUE WITH   *****'    
               DISPLAY '****  FULL RANGE                      *****'    
               DISPLAY '****  ENTRY-NO      *****'  O5-PARTITION-ID     
               DISPLAY '*******************************************'    
           END-IF.                                                      
      *                                                                         
           IF  PREMISE-PARTITION                                        
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   MOVE ZERO TO WS-BEGIN-PREMISE-NO                     
                   MOVE WS-PART-ALL-NINES  TO  WS-END-PREMISE-NO        
               ELSE                                                     
                   MOVE  O5-BEGIN-PART-RANGE TO WS-BEGIN-PREMISE-NO     
                   MOVE  O5-END-PART-RANGE   TO WS-END-PREMISE-NO       
               END-IF                                                   
           ELSE                                                         
           IF  ACCOUNT-PARTITION                                        
               IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                
                   MOVE ZERO TO WS-BEGIN-ACCOUNT-NO                     
                   MOVE WS-PART-ALL-NINES  TO  WS-END-ACCOUNT-NO        
               ELSE                                                     
                   MOVE  O5-BEGIN-PART-RANGE  TO  WS-BEGIN-ACCOUNT-NO   
                   MOVE  O5-END-PART-RANGE    TO  WS-END-ACCOUNT-NO     
               END-IF                                                   
           END-IF END-IF.                                               
      *                                                                         
       0102-EXIT.                                                       
           EXIT.                                                        
