      ******************************************************************00001000
      **   CPD0003B                                                   **00002000
      **..............................................................**00003000
      **  NOTE:                                                       **00004000
      **        REAPPLY MODIFICATIONS FOR THIS MEMBER TO CPD0003B.    **00004100
      **        REQUIRED FOR PCSSO100 SERIES.                         **00004200
      **..............................................................**00004300
      **                                                              **00004400
      **    THIS COPY STATEMENT IS THE PROCEDURE DIVISION STATEMENTS  **00004500
      **  APPLICATION PROGRAMS USE TO COMPUTE THE AMOUNT TO BE        **00004600
      **  REBATED WHEN PAYING OFF AN ADD-ON INTEREST RECEIVABLE.      **00004700
      **                                                              **00004800
      **  FIELDS WHICH MUST BE LOADED BY APPLICATION PROGRAM:         **00004900
      **        WS-NO-OF-PYMTS                                        **00005000
      **        WS-FINANCE-CHARGE                                     **00005100
      **        WS-INITIAL-DATE                                       **00005200
      **  RESULT WILL BE IN WS-REBATE-AMOUNT                          **00005300
      **  THIS FUNCTION REQUIRES THE FOLLOWING COPY STATEMENTS:       **00005400
      **      1) CWS00004 - WS-DATE-BREAKDOWN                         **00005500
      **      2) CWS00008 - WS-COMPUTE-REBATE-WORK-AREA               **00005600
      **      3) CPD00003 - COMPUTE-REBATE-AMOUNT                     **00005700
      **      4) CWS00007 - WS-COMPUTE-AR-DAYS (NEEDED FOR CURRENT    **00005800
      **                     DATE COMPUTATION WORK FIELDS)            **00005900
      **      5) CPD09900 - ABEND ROUTINE                             **00006000
      ******************************************************************00006100
      ***************************************************************   00006200
      *                  MODIFICATION LOG                           *   00006300
      **...........................................................**   00006400
      *                                                             *   00006500
      *    DATE     INITIALS     DESCRIPTION                        *   00006600
      *    -----    --------     ---------------------------------- *   00006700
      *   01/24/95    LRG        SCE&G CHANGES REQUIRED FOR DATES   *   00006800
BC0895*   0895        ADA        THE COPYBOOK WOULD NOT WORK IN 6101*   00006900
BC0895*                          SINCE WS-TEMP-DT IS X(10) AND      *   00007000
BC0895*                          WS-J-DATE-BREAKDOWN IS S(7).       *   00007100
T15695*   04/10/98    PD         CHECK FOR AMT-DEF-PYMT NOT         *   00007200
T15695*                          WS-FINANCE-CHARGE WHICH IS PRIOR   *   00007300
T15695*                          YEAR INTEREST.                     *   00007400
      ***************************************************************   00007200
                                                                        
       6100-COMPUTE-REBATE-AMOUNT.                                      
                                                                        
T15695     PERFORM 6103-SELECT-CONTRACT-DAYS THRU 6103-EXIT.            
           IF (WS-NO-OF-PYMTS EQUAL ZEROES)                             
T15695       OR (WS-CT-AMT-DEF-INTEREST EQUAL ZEROES)                   
               MOVE ZEROES TO WS-REBATE-AMOUNT                          
               GO TO 6100-EXIT
           END-IF.                                         
                                                                        
           PERFORM 6102-SELECT-ACCOUNT-DAYS  THRU 6102-EXIT.            
           PERFORM 6104-SELECT-CNT-AR-ROW    THRU 6104-EXIT.            
                                                                        
           MOVE WS-CT-DATE-CNT-DAYS   TO WS-INITIAL-DAYS                
           IF ( WS-INITIAL-DAYS < WS-ACC-LAST-BILL-DAYS )               
                MOVE WS-ACC-LAST-BILL-DAYS TO WS-INITIAL-DAYS           
           END-IF                                                       
           IF ( WS-INITIAL-DAYS < WS-CT-STATUS-CH-DAYS  )               
                MOVE WS-CT-STATUS-CH-DAYS  TO WS-INITIAL-DAYS           
           END-IF                                                       
                                                                        
           COMPUTE WS-AMT-UNBILLED-PRI =   WS-CPD3-AMT-TRAN-BALANCE     
                                         - WS-CPD3-AMT-AR-DAY-00        
                                         - WS-CPD3-AMT-AR-DAY-30        
                                         - WS-CPD3-AMT-AR-DAY-60        
                                         - WS-CPD3-AMT-AR-DAY-90        
                                         - WS-CPD3-AMT-UNUSED-CR        
                                         - WS-CT-AMT-DEF-INTEREST       
                                                                        
           COMPUTE WS-NUM-OF-DAYS-FOR-INT  =   WS-CURRENT-DAYS          
                                             - WS-INITIAL-DAYS          
                                                                        
           COMPUTE WS-TOTAL-INTEREST   =                                
                    (( WS-CT-INTRST-RATE * WS-AMT-UNBILLED-PRI          
                     * WS-NUM-OF-DAYS-FOR-INT ) / ( 100.0 * 360.0 ))    
                                                                        
           COMPUTE WS-REBATE-AMOUNT ROUNDED =  WS-CT-AMT-DEF-INTEREST   
                                             - WS-TOTAL-INTEREST.       
                                                                        
       6100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00046000
       6102-SELECT-ACCOUNT-DAYS.                                        
                                                                        
           EXEC SQL                                                     
              SELECT ACCOUNT_NO                                         
                   , CIS.DAYS(COALESCE(DATE_BILL_DAY_00,
              IIF(TRY_CONVERT(DATE, '1901-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1901-01-01'
              ) <> 0) OR (LEN('1901-01-01') <> 10), CIS.CHAR2DATE(
              '1901-01-01'), CONVERT(DATE, '1901-01-01') )))   
                   , CIS.DAYS( IIF(TRY_CONVERT(DATE, :LS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :LS-INPUT-DATE
              ) <> 0) OR (LEN(:LS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :LS-INPUT-DATE
              ), CONVERT(DATE, :LS-INPUT-DATE) ) )                             
              INTO   :AT-ACCOUNT-NO                                     
                   , :WS-ACC-LAST-BILL-DAYS                             
                   , :WS-CURRENT-DAYS                                   
              FROM CSS_ACCOUNT                                          
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     00049000
MFA-TR*       SELECT ACCOUNT_NO                                         00049100
MFA-TR*            , DAYS(VALUE(DATE_BILL_DAY_00,DATE('1901-01-01')))   00049200
MFA-TR*            , DAYS(:LS-INPUT-DATE)                               00049300
MFA-TR*       INTO   :AT-ACCOUNT-NO                                     00049500
MFA-TR*            , :WS-ACC-LAST-BILL-DAYS                             00049600
MFA-TR*            , :WS-CURRENT-DAYS                                   00049700
MFA-TR*       FROM CSS_ACCOUNT                                          00049800
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         00049900
MFA-TR*    END-EXEC.                                                    00050000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6102'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       6102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6103-SELECT-CONTRACT-DAYS.                                       
                                                                        
           EXEC SQL                                                     
               SELECT CIS.DAYS(DATE_CONTRACT)                               
                     ,CIS.DAYS(COALESCE(STATUS_CHANGE_DT,
              IIF(TRY_CONVERT(DATE, '1901-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1901-01-01'
              ) <> 0) OR (LEN('1901-01-01') <> 10), CIS.CHAR2DATE(
              '1901-01-01'), CONVERT(DATE, '1901-01-01') )))  
                     ,AMT_DEF_INTEREST                                  
                     ,INTRST_RATE                                       
                 INTO :WS-CT-DATE-CNT-DAYS                              
                     ,:WS-CT-STATUS-CH-DAYS                             
                     ,:WS-CT-AMT-DEF-INTEREST                           
                     ,:WS-CT-INTRST-RATE                                
                 FROM  CSS_CONTRACT                                     
                WHERE  ACCOUNT_NO        = :CT-ACCOUNT-NO               
                  AND  PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL        
                  AND  CNT_ITEM_ID       = :CT-CNT-ITEM-ID              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     00059900
MFA-TR*        SELECT DAYS(DATE_CONTRACT)                               00060000
MFA-TR*              ,DAYS(VALUE(STATUS_CHANGE_DT,DATE('1901-01-01')))  00061000
MFA-TR*              ,AMT_DEF_INTEREST                                  00062000
MFA-TR*              ,INTRST_RATE                                       00063000
MFA-TR*          INTO :WS-CT-DATE-CNT-DAYS                              00064000
MFA-TR*              ,:WS-CT-STATUS-CH-DAYS                             00065000
MFA-TR*              ,:WS-CT-AMT-DEF-INTEREST                           00066000
MFA-TR*              ,:WS-CT-INTRST-RATE                                00067000
MFA-TR*          FROM  CSS_CONTRACT                                     00068000
MFA-TR*         WHERE  ACCOUNT_NO        = :CT-ACCOUNT-NO               00069000
MFA-TR*           AND  PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL        00069100
MFA-TR*           AND  CNT_ITEM_ID       = :CT-CNT-ITEM-ID              00069200
MFA-TR*    END-EXEC.                                                    00069300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6103'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CONTRACT'        TO TABLE-1                     
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       6103-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       6104-SELECT-CNT-AR-ROW.                                          
                                                                        
           EXEC SQL                                                     
                SELECT AMT_AR_DAY_00                                    
                     , AMT_AR_DAY_30                                    
                     , AMT_AR_DAY_60                                    
                     , AMT_AR_DAY_90                                    
                     , AMT_UNUSED_CR                                    
                     , AMT_TRAN_BALANCE                                 
                 INTO  :WS-CPD3-AMT-AR-DAY-00                           
                     , :WS-CPD3-AMT-AR-DAY-30                           
                     , :WS-CPD3-AMT-AR-DAY-60                           
                     , :WS-CPD3-AMT-AR-DAY-90                           
                     , :WS-CPD3-AMT-UNUSED-CR                           
                     , :WS-CPD3-AMT-TRAN-BALANCE                        
               FROM CSS_AR_CNTL                                         
              WHERE ACCOUNT_NO         = :AC-ACCOUNT-NO                 
                AND PYMT_PRIORITY_LVL  = 100                            
                AND ITEM_ID            = :CT-CNT-ITEM-ID                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '6104'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_CNTL '        TO TABLE-1                     
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       6104-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
