      ***************************************************************           
      * CPD00039   S T A R T   A N D   R E A D   F C S C A 0 0      *           
      *                       RELEASE 1.0                           *           
      * ............................................................*           
      * WS-REFERENCE: CWS00039 (W-S FCA00 MISC)                     *           
      * PROCEDURE REFERENCES:  9900-ABEND                           *           
      * ............................................................*           
      * THIS CPD CONTAINS THE PARAGRAPH TO START AND READ THE       *           
      *    VSAM CONTROL FILE (FCSCA00-FILE).                        *           
      ***************************************************************           
      *                                                                         
       7620-START-FCSCA00.                                              
      **                                                                        
           EXEC SQL                                                     
              DECLARE CA00_CSR CURSOR FOR                               
              SELECT  PROGRAM_NAME                                      
                      ,COMPANY_NO                                       
                      ,CMND_CODE                                        
                      ,SEQ_NO                                           
                      ,STATUS                                           
                      ,PARM_DATA                                        
              FROM    CSS_JOB_PARM                                      
              WHERE   PROGRAM_NAME   = :G6-PROGRAM-NAME                 
                AND   CMND_CODE      = 'CA00'                           
                AND   COMPANY_NO     = :G6-COMPANY-NO                   
              ORDER BY SEQ_NO                                           
           END-EXEC.                                                    
                                                                        
           MOVE E-FCA00-KEY   TO G6-PROGRAM-NAME.                       
           MOVE 'PARM'        TO G6-CMND-CODE.                          
           MOVE '01'          TO G6-COMPANY-NO.                         
                                                                        
           EXEC SQL OPEN CA00_CSR END-EXEC.                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  ' WS-PGRMNAME ' PROCESSING ERROR  **'       
               DISPLAY '**  7620-ERROR ON OPEN CA00_CSR.      **'       
               DISPLAY '**  SQL STATUS IS ' SQLCODE                     
               DISPLAY '**    KEY IS '                                  
                       G6-PROGRAM-NAME                                  
                       G6-CMND-CODE                                     
                       G6-COMPANY-NO                                    
               DISPLAY '**  PROCESSING TERMINATED             **'       
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       7620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
       7621-READ-FCSCA00.                                               
      *                                                                         
           EXEC SQL FETCH CA00_CSR                                      
                INTO   :G6-PROGRAM-NAME                                 
                      ,:G6-COMPANY-NO                                   
                      ,:G6-CMND-CODE                                    
                      ,:G6-SEQ-NO                                       
                      ,:G6-STATUS                                       
                      ,:G6-PARM-DATA                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE EQUAL SUCCESSFUL-CALL                             
               MOVE G6-PROGRAM-NAME TO E-FCA00-KEY                      
               MOVE G6-PARM-DATA    TO E-FCA00-DATA                     
               MOVE '00'            TO WS-FCA00-STATUS                  
           ELSE                                                         
           IF SQLCODE EQUAL NOT-FOUND                                   
               MOVE SPACES TO E-FCA00-KEY                               
               MOVE WS-Y   TO WS-FCA00-EOF-SW                           
               MOVE '23'   TO WS-FCA00-STATUS                           
               PERFORM 7622-CLOSE-CA00-CSR THRU 7622-EXIT               
           ELSE                                                         
               DISPLAY '**  ' WS-PGRMNAME ' PROCESSING ERROR **'        
               DISPLAY '**  FETCH ERROR IN 7621-READ-FCSCA00 **'        
               DISPLAY '**  RETURN CODE =' SQLCODE                      
               DISPLAY '**  PROCESSING TERMINATED            **'        
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF
           END-IF.                       
      *                                                                         
       7621-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7622-CLOSE-CA00-CSR.                                             
      *                                                                         
           EXEC SQL CLOSE CA00_CSR END-EXEC.                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
               CONTINUE                                                 
           ELSE                                                         
               DISPLAY '**  ' WS-PGRMNAME ' PROCESSING ERROR **'        
               DISPLAY '**  7622-CLOSE-CA00-CSR              **'        
               DISPLAY '**  RETURN CODE =' SQLCODE                      
               DISPLAY '**  PROCESSING TERMINATED            **'        
               PERFORM 9900-ABEND      THRU  9900-EXIT
           END-IF.                 
                                                                        
       7622-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
