      *****************************************************************         
      ** CPD00029  INCLUDE  TO RESET RESTART-REQ PARAMETER TO INACTIVE*         
      **                     RELEASE 1.0                             **         
      **.............................................................**         
      **  WS-REFERENCE:  WS-IS-THIS-A-RESTART, WS-RESTART-REQ,       **         
      **                 WS-COUNT-UNSUCCESSFUL-ROWS,                 **         
      **                 WS-PGRMNAME (LITERAL CONTAINING PGM NAME),  **         
      **                 WS-I, WS-N, AND WS-Y (LITERALS              **         
      **                                                             **         
      **  PROCEDURE REFERENCE:  CPD00035  CPD00038  9900-ABEND       **         
      **                                                             **         
      **  PREREQUISITES: THE PARM MUST HAVE BEEN RETRIEVED FROM      **         
      **                 FCSJC01 PRIOR TO INVOKING THIS ROUTINE.     **         
      **                 CPD00035 DOES THIS RETRIEVAL.  THIS ROUTINE **         
      **                 RE-INVOKES CPD00035 TO ASSURE FCSJC01       **         
      **                 CONTENTS HAVE NOT CHANGED.                  **         
      **                                                             **         
      **  ADDITIONAL INFORMATION:  IF WS-RESTART-REQ IS FOUND TO     **         
      **  CONTAIN A 'Y' AND THERE ARE NO RESTART RECORDS FOR THIS    **         
      **  PROGRAM WHERE LAST EXECUTION WAS UNSUCCESSFUL, RENDER THE  **         
      **  JC01 RESTART-REQ PARAMETER INACTIVE.                       **         
      *****************************************************************         
      *                                                                         
      *                                                                         
       8893-RESET-RESTART-REQ-PARM.                                     
           MOVE ZEROES TO WS-COUNT-UNSUCCESSFUL-ROWS.                   
           PERFORM 8894-COUNT-RESTART-DATA THRU 8894-EXIT.              
           IF WS-COUNT-UNSUCCESSFUL-ROWS EQUAL ZERO                     
      *** RE-POSITION TO THE RESTART-REQ PARM:                          15600063
               PERFORM 6235-GET-FJC01-RESTART-REQ THRU 6235-EXIT        
      *** IF RESTART-REQ PARM CONTINUES TO = "Y", RENDER IT INACTIVE:   15600063
               IF WS-RESTART-REQ EQUAL WS-Y                             
                    MOVE WS-I TO WS-INPUT-STATUS                        
                                 G6-STATUS                              
                    MOVE WS-INPUT-AREA  TO FIOJC01                      
                    EXEC SQL                                            
                       UPDATE CSS_JOB_PARM                              
                          SET STATUS = :G6-STATUS                       
                       WHERE   PROGRAM_NAME   = :G6-PROGRAM-NAME        
                         AND   CMND_CODE      = :G6-CMND-CODE           
                         AND   COMPANY_NO     = :G6-COMPANY-NO          
                         AND   SEQ_NO         = :G6-SEQ-NO              
                    END-EXEC                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                    IF SQLCODE NOT EQUAL SUCCESSFUL-CALL                
                        DISPLAY '**  ' WS-PGRMNAME                      
                               ' PROCESSING ERROR   **'                 
                        DISPLAY '**  ERROR ON UPDATE CSS_JOB_PARM**'    
                        DISPLAY '** OCCURRED WHILE ATTEMPTING    **'    
                        DISPLAY '** TO CHANGE FCSJC01 RESTART-REQ**'    
                        DISPLAY '** PARAMETER TO INACTIVE STATUS **'    
                        DISPLAY '** RECORD KEY  = ' E-FJC01-KEY         
                        DISPLAY '** SQLCODE     = ' SQLCODE             
                        DISPLAY '**    PROCESSING TERMINATED     **'    
                        PERFORM 9900-ABEND THRU 9900-EXIT
                    END-IF
               END-IF
           END-IF.              
      *** IF THE REWRITE WAS ATTEMPTED, ASSURE IT WAS SUCCESSFUL:       15600063
           IF WS-INPUT-STATUS EQUAL WS-I                                
               IF SQLCODE EQUAL SUCCESSFUL-CALL                         
                   DISPLAY ' '                                          
                   DISPLAY '**  ' WS-PGRMNAME ' INFORMATIONAL MSG  **'  
                   DISPLAY '**  FCSJC01 RESTART-REQ = Y PARM**'         
                   DISPLAY '**    HAS NOW BEEN CHANGED TO   **'         
                   DISPLAY '**   INACTIVE STATUS, SINCE NO  **'         
                   DISPLAY '** OTHER PARTITIONED EXECUTIONS **'         
                   DISPLAY '** OF THIS PROGRAM ARE AWAITING **'         
                   DISPLAY '**     RESTART AT THIS TIME     **'         
                   DISPLAY '**    PROCESSING CONTINUING     **'         
               ELSE                                                     
                   DISPLAY ' '                                          
                   DISPLAY '**  ' WS-PGRMNAME ' PROCESSING ERROR   **'  
                   DISPLAY '**   UNSUCCESSFUL STATUS CODE   **'         
                   DISPLAY '**   OCCURRED WHILE ATTEMPTING  **'         
                   DISPLAY '** TO CHANGE FCSJC01 RESTART-REQ**'         
                   DISPLAY '** PARAMETER TO INACTIVE STATUS **'         
                   DISPLAY '**    RECORD KEY  = ' E-FJC01-KEY           
                   DISPLAY '**    SQLCODE     = ' E-FJC01-STATUS        
                   DISPLAY '**    PROCESSING TERMINATED     **'         
                   PERFORM 9900-ABEND THRU 9900-EXIT
               END-IF
           END-IF.                   
       8893-EXIT.                                                       
           EXIT.                                                        
       8894-COUNT-RESTART-DATA.                                         
           EXEC SQL                                                     
           SELECT COUNT (*)                                             
             INTO :WS-COUNT-UNSUCCESSFUL-ROWS                           
             FROM  CSS_RESTART                                          
            WHERE NAME_PROGRAM                  = :RF-NAME-PROGRAM      
              AND DUP_CNTRL_NO                  = 1                     
              AND (CIS.SUBSTR3(RESTART_DATA,1,1)    >= '1'                   
                   OR CIS.SUBSTR3(RESTART_DATA,2,1)  = 'C')                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     00483000
MFA-TR*    SELECT COUNT (*)                                             00483100
MFA-TR*      INTO :WS-COUNT-UNSUCCESSFUL-ROWS                           00483100
MFA-TR*      FROM  CSS_RESTART                                          00483200
MFA-TR*     WHERE NAME_PROGRAM                  = :RF-NAME-PROGRAM      00483300
MFA-TR*       AND DUP_CNTRL_NO                  = 1                     00483500
MFA-TR*       AND (SUBSTR(RESTART_DATA,1,1)    >= '1'                   00483500
MFA-TR*            OR SUBSTR(RESTART_DATA,2,1)  = 'C')                  00483500
MFA-TR*    END-EXEC.                                                    00483600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
               DISPLAY '8894-COUNT RETURN CODE =' WS-ACTIVE-RETURN-CODE 
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
       8894-EXIT.                                                       
           EXIT.                                                        
