      *****************************************************************         
      ***************************************************************           
      *  CPD00023    DEPOSIT INTEREST CALCULATION                   *           
      *                                                             *           
      ***************************************************************           
      *                 P R O G R A M  S U M M A R Y                *           
      *                                                             *           
      *  THIS PROCEDURE DIVISION WILL CALCULATE THE DEPOSIT PLUS    *           
      *  INTEREST DUE FOR A GIVEN DEPOSIT, BASED ON A DAILY         *           
      *  INTEREST VALUE. WHEN USING THIS CPD ALSO INCLUDE CPD00128, *           
      *  CWS0223B, AND CPD0023B IF THE PROGRAM IS BATCH OR CPD0023C *           
      *  IF THE PROGRAM IS A CICS TRASACTION.                       *           
      *                                                             *           
      ***************************************************************           
      *                                                             *           
      *                PROGRAM  MODIFICATION  LOG                   *           
      *                                                             *           
      *     DATE     INITIALS   COMMENTS                            *           
      *   --------   --------   ----------------------------------  *           
      *   10/09/95     JHR      COPYBOOK ORIGINALLY CODED.          *           
      *   05/01/96     PD       CHECK FOR NULL ON INTEREST CALC DATE*           
      *   06/20/96     CS       TPR 3753 ADD COMPOUND INTEREST TO   *           
      *                         DEPOSIT INTEREST CALCULATION.       *           
PCR482*   02/05/97     MAD      MODIFICATIONS MADE TO USE COPYBOOK  *           
      *                         FOR DEPOSIT INTEREST PROJECTIONS    *           
      *                         ON PANEL 57.                        *           
TP9420*   02/24/97     PD       COME OUT OF THE LOOP IF DEP INT INFO*           
      *                         IS NOT FOUND.                       *           
PCR482*   03/05/97     MAD      MODIFIED PARAGRAPH 5995 TO EXIT IF  *           
      *                         THE REFUND IS 'REFUNDED' OR         *           
      *                         'TRANSFERRED'.                      *           
MAD617*   06/17/97     MAD      MODIFIED THE COPYBOOK TO CHECK THE  *           
      *                         AGE OF ALL DEPOSIT PAYMENTS - SINCE *           
      *                         CSS_DEP_PAY_HST MAY CONTAIN MULTIPLE*           
      *                         PAYMENTS ON A SINGLE DEPOSIT, EACH  *           
      *                         PAYMENT DATE MUST BE EXAMINED TO    *           
      *                         DETERMINE IF IT MEETS THE AGE       *           
      *                         REQUIREMENT (> 6 MONTHS).           *           
T20796*   10/13/99     MDJ      IF INTEREST WAS CALCULATED ON AN AMT*           
      *                         MORE THAN CSS_DEP_ON_HAND AMT-DEPOSIT           
      *                         THEN INTEREST CALCULATION IS        *           
      *                         RECALCULATED ON AMT-DEPOSIT ON CSS_ *           
      *                         DEP_ON_HAND.                        *           
T23183*   05/03/01     KS88119  MODIFIED THE PROGRAM TO CALCULATE   *           
      *                         DEPOSIT INTEREST AFTER 91 DAYS FOR  *           
      *                         PSNC ACCOUNTS.                      *           
T24758*   08/30/01     AS       INITIALIZED THE FIELDS TO COMPUTE   *           
      *                         INTEREST CORRECTLY                  *           
T23980*   11/08/01     SM19366  MODIFIED THE PROGRAM TO CALCULATE   *           
      *                         DEPOSIT INTEREST AFTER 7 MONTHS FOR *           
      *                         SEB ACCOUNT (7 MTHS PER LISA RUCKER)*           
C25619*   11/14/01     SR82046  INTEREST CALCULATION FOR PSNC IS    *           
      *                         CHANGED TO CALCULATE FROM 90 DAYS   *           
      *                         FROM THE DEPOSIT PAID IN FULL       *           
C29752*   11/19/03     MDJ      IF S031 IS CALLING PROGRAM, DETERMINE           
      *                         IF MORE THAN 1 INTEREST RATE WAS    *           
      *                         USED TO CALC INT AMOUNT.  IF SO, SET*           
      *                         AN INDICATOR SO THAT S031 WILL      *           
      *                         DISPLAY 'MULT' ON PANEL 57 INSTEAD OF           
      *                         CURRENT INT RATE.                   *           
      *                         WHEN MULT INT RATES ARE USED, INCLUDE           
      *                         THE EFF-DATE-FROM ON THE INT TABLE IN           
      *                         THE NO-OF-DAYS CALCULATION.         *           
      *                         FOR PSNC, BEGIN INT CALC ON 91ST    *           
      *                         DAY, NOT 92ND.  NEEDED TO GET PREV  *           
      *                         DAY.                                *           
C29752*   01/11/03     MDJ      SET SWITCH IF INT IS RECALCULATED SO*           
      *                         THAT INTEREST HISTORY WILL BE INSERTED          
      *                         CORRECTLY IN CPD00128.              *           
T31755*   16/11/04     CVNS     MODIFIED TO USE VARIABLE FOR DEPOSIT*           
      *                CHENNAI  AMOUNT RETRIEVAL                    *           
T34097*   15/12/07     MR97640  REPLACED MODEL_SQL WITH SET COMMAND *           
T34097*                         AND ADDED WITH UR TO AVOID -911.    *           
P00394*   07/13/10     VP94820  REPLACED 'CURRENT DATE' WITH INPUT  *           
P00394*                         DATE                                *           
P00399*   09/28/10     MJ13662  REPLACED 'CURRENT DATE' WITH        *           
P00399*                         WS-REFUND-DATE.                     *           
A04531*   03/08/13     SV95326  REMOVE COMPOUND INTEREST CALC LOGIC *           
A04531*                         FROM 6005-ACCUMULATE-INTEREST.      *           
      ***************************************************************           
                                                                        
       5995-DEPOSIT-INTEREST-CALC.                                      
                                                                        
           MOVE '5995'                   TO ACTIVE-PARAGRAPH.           
                                                                        
      *    EXIT IF THE DEPOSIT HAS BEEN REFUNDED.                               
PCR482     IF DO-DEPOSIT-STATUS-CD = 'R' OR                             
PCR482      DO-DEPOSIT-STATUS-CD = 'T'                                  
              GO TO 5995-EXIT                                           
           END-IF.                                                      
                                                                        
      *    THIS IS FOR DETERMINING IF THE INTEREST IS TO BE                     
      *    CALCULATED BASED ON TODAY AS THE ENDING DATE OR TOMORROW             
      *    AS THE ENDING DATE.  BILLING WILL BE BILL IMMEDIATELY, BUT           
      *    SERVICE ORDERS AND PANELS WILL BE BILL TOMORROW                      
                                                                        
      *    SET UP INTEREST RATE TABLE.                                          
           SET WS-INT-INDX TO 1.                                        
P00394     IF WS-REFUND-DATE > SPACES                                   
P00394        CONTINUE                                                  
P00394     ELSE                                                         
P00394        MOVE WS-CURRENT-DATE          TO WS-REFUND-DATE           
P00394     END-IF.                                                      
CS         MOVE WS-REFUND-DATE           TO P6-EFF-DATE-FROM.           
           MOVE AT-LOCAL-OFFICE          TO P6-LOCAL-OFFICE.            
           MOVE AT-COMPANY-NO            TO P6-COMPANY-NO.              
           MOVE PR-REV-DISTRICT-CD       TO P6-REV-DISTRICT-CD.         
           PERFORM 5996-OPEN-DEP-INT-RATE       THRU 5996-EXIT.         
           PERFORM 5997-FETCH-DEP-INT-RATE      THRU 5997-EXIT.         
           PERFORM 5998-LOAD-DEP-INT-RATE       THRU 5998-EXIT          
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
           PERFORM 5999-CLOSE-DEP-INT-RATE      THRU 5999-EXIT.         
                                                                        
      *    DETERMINE INTEREST CALCULATION.                                      
           MOVE +0                       TO WS-INTEREST-CALC.           
C29752     MOVE 'N'                      TO WS-RECALC-SWITCH.           
T23183     IF AT-COMPANY-NO = '01' THEN                                 
T23980        IF SEB-DATABASE                                           
T23980           PERFORM 7009-GET-DATE-7-MNT-AGO   THRU 7009-EXIT       
T23980        ELSE                                                      
T23980           PERFORM 6009-GET-DATE-6-MNT-AGO   THRU 6009-EXIT       
T23980        END-IF                                                    
T23183     ELSE                                                         
T23183        PERFORM 6016-GET-DATE-91-DAYS-AGO THRU 6016-EXIT          
T23183        MOVE WS-DATE-91-DAYS-AGO   TO WS-MIN-DEP-INT-DATE         
T23183     END-IF.                                                      
           PERFORM 6000-DETERMINE-INTRST-CALC   THRU 6000-EXIT.         
      *                                                                         
      ************RESET COUNTERS FOR THE NEXT DEPOSIT**************             
CS         MOVE 0                        TO WS-NO-OF-DAYS.              
T20796     MOVE 0                        TO WS-AMT-DEPOSIT-REF.         
C29752     MOVE 'N'                      TO WS-RECALC-SWITCH.           
                                                                        
       5995-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 5996-OPEN-DEP-INT-RATE.                                    *            
      *                                                            *            
      * PERFORMED BY 5995-DEPOSIT-INTEREST-CALC.                   *            
      **************************************************************            
       5996-OPEN-DEP-INT-RATE.                                          
                                                                        
           MOVE '5996'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              OPEN DEP-INT-RATE                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSS_DEP_INT_RATE'    TO TABLE-1                     
              MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-1             
              MOVE P6-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1           
              MOVE 'REV_DISTRICT_CD'     TO TABLE-ELEMENT-2             
              MOVE P6-REV-DISTRICT-CD    TO HOSTVAR-ELEMENT-2           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3             
              MOVE P6-COMPANY-NO         TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       5996-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 5997-FETCH-DEP-INT-RATE.                                   *            
      *                                                            *            
      * PERFORMED BY 5995-DEPOSIT-INTEREST-CALC                    *            
      *              5998-LOAD-DEP-INT-RATE.                       *            
      **************************************************************            
       5997-FETCH-DEP-INT-RATE.                                         
                                                                        
           MOVE '5997'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              FETCH DEP-INT-RATE                                        
               INTO :P6-INTRST-RATE,                                    
                    :P6-EFF-DATE-FROM,                                  
                    :WS-EFF-DATE-END                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE 'CSS_DEP_INT_RATE'    TO TABLE-1                     
              MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-1             
              MOVE P6-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1           
              MOVE 'REV_DISTRICT_CD'     TO TABLE-ELEMENT-2             
              MOVE P6-REV-DISTRICT-CD    TO HOSTVAR-ELEMENT-2           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3             
              MOVE P6-COMPANY-NO         TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       5997-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 5998-LOAD-DEP-INT-RATE.                                    *            
      *                                                            *            
      * PERFORMED BY 5995-DEPOSIT-INTEREST-CALC.                   *            
      **************************************************************            
       5998-LOAD-DEP-INT-RATE.                                          
                                                                        
           MOVE '5998'                TO ACTIVE-PARAGRAPH.              
                                                                        
           MOVE AT-LOCAL-OFFICE       TO WS-LOCAL-OFFICE  (WS-INT-INDX).
           MOVE PR-REV-DISTRICT-CD    TO WS-TAX-DISTRICT  (WS-INT-INDX).
           MOVE P6-INTRST-RATE        TO WS-INTRST-RATE   (WS-INT-INDX).
           MOVE P6-EFF-DATE-FROM      TO WS-EFF-DATE-FROM (WS-INT-INDX).
                                                                        
           IF WS-INT-INDX = 1                                           
              MOVE WS-REFUND-DATE      TO WS-EFF-DATE-TO (WS-INT-INDX)  
           ELSE                                                         
              MOVE WS-EFF-DATE-TO-PREV TO WS-EFF-DATE-TO (WS-INT-INDX)  
           END-IF.                                                      
                                                                        
           MOVE WS-EFF-DATE-END       TO WS-EFF-DATE-TO-PREV.           
                                                                        
           PERFORM 5997-FETCH-DEP-INT-RATE      THRU 5997-EXIT.         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              SET WS-INT-INDX UP BY 1                                   
           END-IF.                                                      
                                                                        
       5998-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 5999-CLOSE-DEP-INT-RATE.                                   *            
      *                                                            *            
      * PERFORMED BY 5995-DEPOSIT-INTEREST-CALC.                   *            
      **************************************************************            
       5999-CLOSE-DEP-INT-RATE.                                         
                                                                        
           MOVE '5999'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              CLOSE DEP-INT-RATE                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE 'CSS_DEP_INT_RATE'    TO TABLE-1                     
              MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-1             
              MOVE P6-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1           
              MOVE 'REV_DISTRICT_CD'     TO TABLE-ELEMENT-2             
              MOVE P6-REV-DISTRICT-CD    TO HOSTVAR-ELEMENT-2           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3             
              MOVE P6-COMPANY-NO         TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       5999-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 6000-DETERMINE-INTRST-CALC.                                *            
      *                                                            *            
      * PERFORMED BY 5995-DEPOSIT-INTEREST-CALC.                   *            
      **************************************************************            
       6000-DETERMINE-INTRST-CALC.                                      
                                                                        
           MOVE '6000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           MOVE AT-ACCOUNT-NO               TO DP-ACCOUNT-NO.           
           MOVE DO-DEPOSIT-CERT-NO          TO DP-DEPOSIT-CERT-NO.      
T20796     PERFORM 6007-SELECT-DEP-ON-HAND          THRU 6007-EXIT.     
                                                                        
           PERFORM 6002-OPEN-DEP-PAY-HST            THRU 6002-EXIT.     
           PERFORM 6003-FETCH-DEP-PAY-HST           THRU 6003-EXIT.     
      *                                                                         
T23183     IF (DP-DEP-PAY-DT < WS-MIN-DEP-INT-DATE AND                  
PCR482        WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND               
C25169        AT-COMPANY-NO = '01')                                     
C25619*                                                                         
PCR482          OR (S031-IS-CALLING-PROG AND                            
PCR482                      WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL)    
C25619*                                                                         
C25619          OR (DO-DATE-CERT-ISSUE < WS-MIN-DEP-INT-DATE AND        
C25619                      WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND 
C25169             AT-COMPANY-NO = '26' AND DO-DATE-CERT-ISSUE > SPACES)
C25619*                                                                         
CS            MOVE 'Y'                      TO RS-LT-6-MOS-AGO          
CS    *                                                                         
CS            PERFORM 6001-PROCESS-DEP-PAYMENT         THRU 6001-EXIT   
CS                UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND           
CS    *                                                                         
CS            MOVE WS-REFUND-DATE            TO DO-DATE-INTST-CALC-TO   
           ELSE                                                         
              NEXT SENTENCE                                             
CS         END-IF.                                                      
      *                                                                         
           PERFORM 6004-CLOSE-DEP-PAY-HST           THRU 6004-EXIT.     
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 6001-PROCESS-DEP-PAYMENT                                   *            
      *                                                            *            
      * PERFORMED BY 6000-DETERMINE-INTRST-CALC.                   *            
      **************************************************************            
CS     6001-PROCESS-DEP-PAYMENT.                                        
CS                                                                      
CS         MOVE '6001'                      TO ACTIVE-PARAGRAPH.        
                                                                        
T23183     IF (DP-DEP-PAY-DT < WS-MIN-DEP-INT-DATE  AND                 
C25619         AT-COMPANY-NO = '01') OR                                 
C25619        (DO-DATE-CERT-ISSUE < WS-MIN-DEP-INT-DATE  AND            
C25619         AT-COMPANY-NO = '26' AND DO-DATE-CERT-ISSUE > SPACES) OR 
MAD617         S031-IS-CALLING-PROG                                     
MAD617        MOVE DP-DEP-PAY-AMT        TO WS-AMOUNT-WORK              
MAD617        ADD  DP-DEP-PAY-AMT        TO WS-AMT-DEPOSIT-REF          
T31755        IF WS-AMT-DEPOSIT-REF  >   WS-AMT-DEPOSIT-23              
T31755           MOVE WS-AMT-DEPOSIT-23  TO WS-AMOUNT-WORK              
T20796           MOVE +0                 TO WS-INTEREST-CALC            
T20796                                      WS-CURR-INTRST-CALC         
C29752           MOVE 'Y'                TO WS-RECALC-SWITCH            
T20796        END-IF                                                    
C25619        IF AT-COMPANY-NO = '01'                                   
CS               IF DP-DEP-PAY-DT <= DO-DATE-INTST-CALC-TO              
CS                  MOVE DO-DATE-INTST-CALC-TO TO WS-DATE-WORK          
CS               ELSE                                                   
CS                  MOVE DP-DEP-PAY-DT         TO WS-DATE-WORK          
CS               END-IF                                                 
C25619        ELSE                                                      
C25619******************************************************************        
C25619***  THE DEPOSIT INTEREST FOR PSNC IS CALCULATED FROM 90 DAYS FROM        
C25619***  THE DEPOSIT PAYMENT DATE.                                            
C25619***  IF THE DATE INTEREST CALC IS GREATER THAN THE DEP CERT ISSUE         
C25619***  DATE THEN INTEREST NEEDS TO BE CALCULATED FROM THE DATE              
C25619***  DATE-INTST-CALC-TO.                                                  
C25619******************************************************************        
C25619           MOVE DO-DATE-CERT-ISSUE       TO WS-PYMT-DATE          
C25619           PERFORM 6017-GET-DATE-90-DAYS-AFTER THRU 6017-EXIT     
C29752           MOVE WS-DATE-90-DAYS-AFTER    TO WS-DATE-TEMP-CPD23    
C29752           PERFORM 7094-CPD23-GET-PREVIOUS-DAY  THRU              
C29752                   7094-CPD23-EXIT                                
C25619           IF WS-DATE-TEMP-CPD23 <= DO-DATE-INTST-CALC-TO         
C25619              MOVE DO-DATE-INTST-CALC-TO TO WS-DATE-WORK          
C25619           ELSE                                                   
C29752              MOVE WS-DATE-TEMP-CPD23 TO          WS-DATE-WORK    
C25619           END-IF                                                 
C25619        END-IF                                                    
                                                                        
CS            PERFORM 6012-CALCULATE-INTEREST        THRU 6012-EXIT     
           END-IF.                                                      
CS    *                                                                         
CS         PERFORM 6003-FETCH-DEP-PAY-HST  THRU 6003-EXIT.              
CS    *                                                                         
CS     6001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 6002-OPEN-DEP-PAY-HST.                                     *            
      *                                                            *            
      * PERFORMED BY 6000-DETERMINE-INTRST-CALC.                   *            
      **************************************************************            
       6002-OPEN-DEP-PAY-HST.                                           
                                                                        
           MOVE '6002'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              OPEN DEP-PAY-HST                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSS_DEP_PAY_HST'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'DEPOSIT_CERT_NO'     TO TABLE-ELEMENT-2             
              MOVE DP-DEPOSIT-CERT-NO    TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       6002-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 6003-FETCH-DEP-PAY-HST.                                    *            
      *                                                            *            
      * PERFORMED BY 6000-DETERMINE-INTRST-CALC.                   *            
      **************************************************************            
       6003-FETCH-DEP-PAY-HST.                                          
                                                                        
           MOVE '6003'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              FETCH DEP-PAY-HST                                         
               INTO :DP-DEP-PAY-DT :WS-NULL-DEP-PAY-DT-IND,              
                    :DP-DEP-PAY-AMT                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-DEP-PAY-DT-IND < ZERO                          
                 MOVE LOW-VALUES         TO DP-DEP-PAY-DT               
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE 'CSS_DEP_PAY_HST'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'DEPOSIT_CERT_NO'     TO TABLE-ELEMENT-2             
              MOVE DP-DEPOSIT-CERT-NO    TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       6003-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 6004-CLOSE-DEP-PAY-HST.                                    *            
      *                                                            *            
      * PERFORMED BY 6000-DETERMINE-INTRST-CALC.                   *            
      **************************************************************            
       6004-CLOSE-DEP-PAY-HST.                                          
                                                                        
           MOVE '6004'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              CLOSE DEP-PAY-HST                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE 'CSS_DEP_PAY_HST'     TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'DEPOSIT_CERT_NO'     TO TABLE-ELEMENT-2             
              MOVE DP-DEPOSIT-CERT-NO    TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       6004-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 6005-ACCUMULATE-INTEREST.                                  *            
      *                                                            *            
      * PERFORMED BY 6012-CALCULATE-INTEREST.                      *            
      **************************************************************            
       6005-ACCUMULATE-INTEREST.                                        
                                                                        
           MOVE '6005'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           MOVE WS-EFF-DATE-TO (WS-INT-INDX)   TO WS-DATE-TO.           
                                                                        
PAL        IF WS-DATE-TO > WS-REFUND-DATE                               
PAL           MOVE WS-REFUND-DATE        TO WS-DATE-TO                  
PAL        END-IF.                                                      
                                                                        
CS         IF WS-DATE-FROM > WS-DATE-TO                                 
CS            MOVE 0                     TO WS-NO-OF-DAYS               
CS         ELSE                                                         
CS            PERFORM 6006-GET-NO-OF-DAYS         THRU 6006-EXIT        
CS         END-IF.                                                      
CS    *                                                                         
CS    *                                                                         
A04531     PERFORM 6010-CALC-SIMPLE-INTEREST   THRU 6010-CALC-EXIT      
CS    *                                                                         
           ADD WS-CURR-INTRST-CALC       TO WS-INTEREST-CALC.           
T24758                                                                  
      *                                                                         
C29752     IF S031-IS-CALLING-PROG                                      
C29752        IF WS-INTRST-RATE (WS-INT-INDX) IS NOT =                  
C29752           WS-PREV-INTRST-RATE                                    
C29752           MOVE 'Y' TO WS-MULTIPLE-INT-IND                        
C29752        END-IF                                                    
C29752     END-IF.                                                      
C29752*                                                                         
      *****ONLY UPDATE INTEREST HIST. IF INTEREST IS EARNED*****                
PCR482     IF WS-CURR-INTRST-CALC > 0 AND S031-NOT-CALLING-PROG         
CS            PERFORM 6050-PROCESS-INTEREST-HIST  THRU 6050-EXIT        
CS         END-IF.                                                      
                                                                        
       6005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 6006-GET-NO-OF-DAYS.                                       *            
      *                                                            *            
      * PERFORMED BY 6012-CALCULATE-INTEREST                       *            
      *              6005-ACCUMULATE-INTEREST.                     *            
      **************************************************************            
       6006-GET-NO-OF-DAYS.                                             
                                                                        
           MOVE '6006'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
T34097        SELECT
              CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-TO) <> 0) OR (LEN(
                                                            :WS-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-TO), CONVERT(DATE, 
                                                            :WS-DATE-TO
              ) )) -            
T34097                             CIS.DAYS(IIF(TRY_CONVERT(DATE, 
                                                          :WS-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-FROM
              ) <> 0) OR (LEN(:WS-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-FROM
              ), CONVERT(DATE, :WS-DATE-FROM) ))
            INTO
              :WS-NO-OF-DAYS            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-NO-OF-DAYS = DAYS(DATE(:WS-DATE-TO)) -                    
MFA-TR*                            DAYS(DATE(:WS-DATE-FROM))                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T34097        MOVE 'SET'                 TO ABEND-FUNCTION              
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       6006-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 6007-SELECT-DEP-ON-HAND                                    *            
      *                                                            *            
      * PERFORMED BY 6001-PROCESS-DEP-PAYMENT                      *            
      **************************************************************            
       6007-SELECT-DEP-ON-HAND.                                         
                                                                        
           MOVE '6007'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              SELECT AMT_DEPOSIT                                        
C25619              ,DATE_CERT_ISSUE                                    
T31755          INTO :WS-AMT-DEPOSIT-23                                 
C25619              ,:DO-DATE-CERT-ISSUE :WS-NULL-DEP-CERT-DT-IND       
                FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO = :DP-ACCOUNT-NO                       
                  AND DEPOSIT_CERT_NO = :DP-DEPOSIT-CERT-NO             
T34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AMT_DEPOSIT                                                
MFA-TR*             ,DATE_CERT_ISSUE                                            
MFA-TR*         INTO :WS-AMT-DEPOSIT-23                                         
MFA-TR*             ,:DO-DATE-CERT-ISSUE :WS-NULL-DEP-CERT-DT-IND               
MFA-TR*         FROM CSS_DEP_ON_HAND                                            
MFA-TR*         WHERE ACCOUNT_NO = :DP-ACCOUNT-NO                               
MFA-TR*           AND DEPOSIT_CERT_NO = :DP-DEPOSIT-CERT-NO                     
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
C25619        IF WS-NULL-DEP-CERT-DT-IND < 0                            
C25619           MOVE SPACES             TO DO-DATE-CERT-ISSUE          
C25619        END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
T34097        MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
T20796 6007-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 6009-GET-DATE-6-MNT-AGO.                                   *            
      *                                                            *            
      * PERFORMED BY                                               *            
      **************************************************************            
       6009-GET-DATE-6-MNT-AGO.                                         
                                                                        
           MOVE '6009'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
P00394       SELECT
              DATEADD( MONTH, -6, IIF(TRY_CONVERT(DATE, :WS-REFUND-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-REFUND-DATE
              ) <> 0) OR (LEN(:WS-REFUND-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-REFUND-DATE
              ), CONVERT(DATE, :WS-REFUND-DATE) ) )
            INTO
              :WS-MIN-DEP-INT-DATE
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-MIN-DEP-INT-DATE = DATE(:WS-REFUND-DATE) - 6 MONTHS        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T34097        MOVE 'SET'                 TO ABEND-FUNCTION              
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       6009-EXIT.                                                       
           EXIT.                                                        
      **************************************************************            
      * 6010-CALC-SIMPLE-INTEREST                                  *            
      *                                                            *            
      * PERFORMED BY 6005 TO CALCULATE SIMPLE INTEREST FOR DEPOSITS*            
      **************************************************************            
       6010-CALC-SIMPLE-INTEREST.                                       
                                                                        
           MOVE '6010'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           COMPUTE WS-CURR-INTRST-CALC ROUNDED                          
              = WS-NO-OF-DAYS * WS-AMOUNT-WORK *                        
                WS-INTRST-RATE (WS-INT-INDX) / WS-ONE-YEAR / 100.       
                                                                        
       6010-CALC-EXIT.                                                  
           EXIT.                                                        
      **************************************************************            
      * 6012-CALCULATE-INTEREST.                                   *            
      *                                                            *            
      * PERFORMED BY 6000-DETERMINE-INTRST-CALC.                   *            
      **************************************************************            
       6012-CALCULATE-INTEREST.                                         
                                                                        
           MOVE '6012'                             TO ACTIVE-PARAGRAPH. 
                                                                        
           SET WS-INT-INDX TO 1.                                        
           SEARCH WS-INTEREST-RATE-DATA                                 
              AT END                                                    
                 CONTINUE                                               
                                                                        
TP9420        WHEN ((WS-EFF-DATE-FROM (WS-INT-INDX) <= SPACES)          
TP9420        AND   (WS-EFF-DATE-TO (WS-INT-INDX)   <= SPACES))         
TP9420           CONTINUE                                               
              WHEN ((WS-EFF-DATE-FROM (WS-INT-INDX) <= WS-DATE-WORK)    
              AND   (WS-EFF-DATE-TO (WS-INT-INDX)   >= WS-DATE-WORK))   
                 MOVE WS-DATE-WORK                TO WS-DATE-FROM       
C29752           MOVE 'N'                         TO WS-MULTIPLE-INT-IND
C29752           MOVE WS-INTRST-RATE (WS-INT-INDX) TO                   
C29752                WS-PREV-INTRST-RATE                               
                 PERFORM 6005-ACCUMULATE-INTEREST      THRU 6005-EXIT   
                 PERFORM UNTIL WS-INT-INDX = 1                          
                    SET WS-INT-INDX DOWN BY 1                           
C29752              MOVE WS-EFF-DATE-TO (WS-INT-INDX + 1)               
C29752                                             TO WS-DATE-FROM      
                    PERFORM 6005-ACCUMULATE-INTEREST   THRU 6005-EXIT   
                 END-PERFORM                                            
                                                                        
           END-SEARCH.                                                  
                                                                        
       6012-EXIT.                                                       
           EXIT.                                                        
T23183**************************************************************            
T23183* 6016-GET-DATE-91-DAYS-AGO.                                 *            
T23183*                                                            *            
T23183* THIS PARAGRAPH GETS THE DATE 91 DAYS AGO                   *            
T23183**************************************************************            
T23183 6016-GET-DATE-91-DAYS-AGO.                                       
T23183                                                                  
T23183     MOVE '6016'                   TO ACTIVE-PARAGRAPH.           
T23183                                                                  
T23183     EXEC SQL                                                     
P00399       SELECT
              DATEADD( DAY, -91, IIF(TRY_CONVERT(DATE, :WS-REFUND-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-REFUND-DATE
              ) <> 0) OR (LEN(:WS-REFUND-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-REFUND-DATE
              ), CONVERT(DATE, :WS-REFUND-DATE) ) )
            INTO
              :WS-DATE-91-DAYS-AGO 
T23183     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-DATE-91-DAYS-AGO = DATE(:WS-REFUND-DATE) - 91 DAYS         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T23183                                                                  
T23183     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T23183                                                                  
T23183     IF SQLCODE = SUCCESSFUL-CALL                                 
T23183        NEXT SENTENCE                                             
T23183     ELSE                                                         
T23183        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
T23183        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T34097        MOVE 'SET'                 TO ABEND-FUNCTION              
T23183        PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
T23183     END-IF.                                                      
T23183                                                                  
T23183 6016-EXIT.                                                       
T23183     EXIT.                                                        
C25619**************************************************************            
C25619* 6017-GET-DATE-90-DAYS-AFTER                                *            
C25619*                                                            *            
C25619* THIS PARAGRAPH GETS THE DATE 91 DAYS AFTER THE PAYMENT DATE*            
C25619**************************************************************            
C25619 6017-GET-DATE-90-DAYS-AFTER.                                     
C25619                                                                  
C25619     MOVE '6017'                   TO ACTIVE-PARAGRAPH.           
C25619                                                                  
C25619     EXEC SQL                                                     
T34097       SELECT
              DATEADD( DAY, 90, IIF(TRY_CONVERT(DATE, :WS-PYMT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PYMT-DATE
              ) <> 0) OR (LEN(:WS-PYMT-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-PYMT-DATE
              ), CONVERT(DATE, :WS-PYMT-DATE) ) )
            INTO
              :WS-DATE-90-DAYS-AFTER 
C25619     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-DATE-90-DAYS-AFTER = DATE(:WS-PYMT-DATE) + 90 DAYS         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C25619                                                                  
C25619     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C25619                                                                  
C25619     IF SQLCODE = SUCCESSFUL-CALL                                 
C25619        NEXT SENTENCE                                             
C25619     ELSE                                                         
C25619        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
C25619        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T34097        MOVE 'SET'                 TO ABEND-FUNCTION              
C25619        PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
C25619     END-IF.                                                      
C25619                                                                  
C25619 6017-EXIT.                                                       
C25619     EXIT.                                                        
T23980**************************************************************            
T23980* 7009-GET-DATE-7-MNT-AGO.                                   *            
T23980*                                                            *            
T23980* THIS PARAGRAPH GETS THE DATE 7 MONTHS AGO                  *            
T23980**************************************************************            
T23980 7009-GET-DATE-7-MNT-AGO.                                         
T23980                                                                  
T23980     MOVE '7009'                   TO ACTIVE-PARAGRAPH.           
T23980                                                                  
T23980     EXEC SQL                                                     
P00394       SELECT
              DATEADD( MONTH, -7, IIF(TRY_CONVERT(DATE, :WS-REFUND-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-REFUND-DATE
              ) <> 0) OR (LEN(:WS-REFUND-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-REFUND-DATE
              ), CONVERT(DATE, :WS-REFUND-DATE) ) )
            INTO
              :WS-MIN-DEP-INT-DATE
T23980     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-MIN-DEP-INT-DATE = DATE(:WS-REFUND-DATE) - 7 MONTHS        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T23980                                                                  
T23980     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T23980                                                                  
T23980     IF SQLCODE = SUCCESSFUL-CALL                                 
T23980        NEXT SENTENCE                                             
T23980     ELSE                                                         
T23980        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
T23980        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T34097        MOVE 'SET'                 TO ABEND-FUNCTION              
T23980        PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
T23980     END-IF.                                                      
T23980                                                                  
T23980 7009-EXIT.                                                       
T23980     EXIT.                                                        
C29752*                                                                         
C29752 7094-CPD23-GET-PREVIOUS-DAY.                                     
C29752                                                                  
           EXEC SQL                                                     
T34097        SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                    :WS-DATE-TEMP-CPD23
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-TEMP-CPD23
              ) <> 0) OR (LEN(:WS-DATE-TEMP-CPD23
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-TEMP-CPD23
              ), CONVERT(DATE, :WS-DATE-TEMP-CPD23) ) )
            INTO
              :WS-DATE-TEMP-CPD23                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     15024604
MFA-TR*       SET :WS-DATE-TEMP-CPD23 =                                         
MFA-TR*              DATE(:WS-DATE-TEMP-CPD23) - 1 DAYS                         
MFA-TR*    END-EXEC.                                                    15024620

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T34097        MOVE 'SET'                 TO ABEND-FUNCTION              
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
C29752 7094-CPD23-EXIT.                                                 
           EXIT.                                                        
