     *******************************************************************00000500
     ***   CPD00007 - BATCH JOURNAL ROUTINE                          ***00001500
     ***       USES CWS00013 COPYBOOK                                ***00001500
     *******************************************************************00003000
     **                                                               **        
     **   DATE     INITIALS             DESCRIPTION                   **        
     **  ------    ----------     ---------------------------------   **        
BC0895*  BC0895    ADA            CHANGE TO ADD LOGIC TO CHECK IF     **        
BC0895*                           BATCH JOURNAL CONTROL IS PRESENT    **        
BC0895*                           AND IF NOT ADD IT.                  **        
FCSCHG*  FCSCHG    ADA            CHANGE CODE FOR THE FCS DATABASE    **        
FCSCHG*                           CHANGES FOR MAINLY EXPANDING BATCH  **        
FCSCHG*                           NO TO FIVE NEW FIELDS.              **        
TP5670*  TP5670    JHR            FIX BILLING TRANSACTIONS TO LOCAL   **        
TP5670*                           OFFICE "  " CAUSING ABENDS.         **        
TEST **            CSS            RELATE ENTRY NO TO A TRANSACTION    **        
CNTR **            CSS            REVISED JOURNAL CONTROL AMT LOGIC   **        
     **                           (ADDED 6425-PARA, 6498-PARA, 6426-) **        
     **                                                               **        
PAL  **  10/08/97  PD             FOR BATCH JOURNAL MAKE ENTRY NO     **        
PAL  **                           AND APPL NO INDEPENDENT OF EACH     **        
PAL  **                           OTHER.                              **        
T15874*  04/21/98  PD             FOR 201 JOURNAL DO NOT CHECK FOR OFF**        
T15874*                           OFFSET GL TO UPDATE CNTL BUT        **        
T15874*                           USE WS-100-GL-ACCT-NO TO UPDATE CNTL**        
      *  04/19/01  WR             MCR310 PSNC.  CSS_GL_ACCT_NO CHANGES**        
T35227*  01/10/07  DB41297        REPLACE MODEL_SQL CALLS WITH DB2 SET**        
     *******************************************************************00003000
                                                                        
      *****************************************************************         
      *    BATCH JOURNAL ROUTINE                                                
      *****************************************************************         
                                                                        
       6400-BATCH-JRNL-ROUTINE.                                         
                                                                        
           MOVE ZEROES TO WS-JRNL-MJ-ISRT-CNTR                          
                          WS-JRNL-BC-UPDT-CNTR                          
                          WS-JRNL-BJ-ISRT-CNTR.                         
                                                                        
           MOVE WS-JRNL-SUCCESS TO WS-JRNL-RTRN-CODE.                   
BC0895                                                                  
BC0895     EVALUATE WS-JRNL-OPERATION-RQST                              
BC0895       WHEN WS-JRNL-SELECT-AND-OR-INS                             
BC0895         PERFORM 6405-GET-CURRENT-JRNL-TIME     THRU 6405-EXIT    
BC0895         PERFORM 6410-GET-CURRENT-JRNL-DATE     THRU 6410-EXIT    
BC0895         PERFORM 6402-SELECT-AND-OR-INSERT      THRU 6402-EXIT    
BC0895       WHEN WS-JRNL-VALIDATE-OPER                                 
BC0895         PERFORM 6405-GET-CURRENT-JRNL-TIME     THRU 6405-EXIT    
BC0895         PERFORM 6410-GET-CURRENT-JRNL-DATE     THRU 6410-EXIT    
BC0895         PERFORM 6416-VALIDATE-BATCH-JRNL-CNTRL THRU 6416-EXIT    
BC0895       WHEN WS-JRNL-ONLY                                          
BC0895         PERFORM 6420-PROCESS-JRNL              THRU 6420-EXIT    
BC0895       WHEN WS-JRNL-CNTRL-ONLY                                    
BC0895         MOVE WS-JRNL-TRAN-DATE      TO BC-DATE-LAST-ACTIVITY     
BC0895         MOVE WS-JRNL-NO-ITEMS-CNTRL TO BC-NO-ITEMS-ENTERED       
BC0895         PERFORM 6495-UPDATE-BATCH-JRNL-CNTRL   THRU 6495-EXIT    
BC0895       WHEN WS-JRNL-AND-CNTRL                                     
BC0895         PERFORM 6418-PROCESS-JRNL-AND-CNTRL    THRU 6418-EXIT    
BC0895       WHEN OTHER                                                 
BC0895         MOVE WS-JRNL-UNKN-OPER-RQST TO WS-JRNL-RTRN-CODE         
BC0895     END-EVALUATE.                                                
      ***  NULL OUT INTERNAL WORK FIELDS.                               00018000
                                                                        
           MOVE ZERO TO WS-JRNL-CASH-DEBIT-AMT                          
                        WS-JRNL-RCV-DEBIT-AMT                           
                        WS-JRNL-CK-ISSUE-DEBIT-AMT                      
                        WS-JRNL-GEN-LEG-DEBIT-AMT                       
                        WS-JRNL-CASH-CREDIT-AMT                         
                        WS-JRNL-RCV-CREDIT-AMT                          
                        WS-JRNL-CK-ISSUE-CREDIT-AMT                     
                        WS-JRNL-GEN-LEG-CREDIT-AMT.                     
                                                                        
           MOVE HIGH-VALUES TO WS-100-USER-DEFINED-AREA.                
                                                                        
       6400-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
BC0895                                                                  
BC0895*****************************************************************         
BC0895*  LOOKS FOR A BATCH JOURNAL CONTROL RECORD TO BE ABLE TO POST  *         
BC0895*  PAYMENTS AND USE THIS ROW AS A SUMMARY OF THE BATCH_JOURNAL  *         
BC0895*  ROWS UPDATED. IF THERE IS NOT ONE WE WILL INSERT ONE.        *         
BC0895*****************************************************************         
BC0895                                                                  
BC0895 6402-SELECT-AND-OR-INSERT.                                       
FCSCHG*    MOVE WS-JRNL-BT-ENTRY-LOC-OFF TO BC-LOCAL-OFFICE-ENTRY               
FCSCHG     MOVE SPACES                   TO BC-LOCAL-OFFICE-ENTRY       
BC0895                                      BC-LOCAL-OFFICE-SEND.       
FCSCHG*    MOVE WS-JRNL-BT-BAT-POST-NO TO BC-BATCH-NO.                  00028500
FCSCHG     MOVE WS-JRNL-BT-BAT-COMPANY   TO BC-CASH-COMPANY-NO          
FCSCHG     MOVE WS-JRNL-BT-BAT-LOC-OFF   TO BC-CASH-LOCAL-OFFICE        
FCSCHG     MOVE WS-JRNL-BT-BAT-REPORT-NO TO BC-CASH-REPORT-NO           
FCSCHG     MOVE WS-JRNL-BT-BAT-REPORT-DT TO BC-DATE-CASH-REPORT         
FCSCHG     MOVE WS-JRNL-BT-BAT-CASH-DRWR TO BC-CASH-DRAWER-ID           
BC0895     PERFORM 6491-SELECT-BATCH-JRNL-CNTRL   THRU 6491-EXIT        
BC0895     IF WS-JRNL-DB2-RETURN EQUAL NOT-FOUND                        
BC0895       PERFORM 6403-VALUE-FOR-BC-INSERT     THRU 6403-EXIT        
BC0895     END-IF.                                                      
PAL        MOVE BC-NO-ITEMS-ENTERED      TO WS-JRNL-NO-ITEMS-CNTRL.     
PAL        ADD 1 TO BC-NO-ITEMS-ENTERED                                 
PAL             GIVING WS-JRNL-ENTRY-NO-HOLD                            
PAL        MOVE 0                        TO WS-100-TRAN-APPL-NO-HOLD.   
BC0895                                                                  
BC0895 6402-EXIT.                                                       
BC0895     EXIT.                                                        
HPCCDM*    EJECT                                                        
BC0895*****************************************************************         
BC0895* MOVES VALUES INTO DCLGEN VARIABLES TO BE ABLE TO INSERT A NEW *         
BC0895*  ROW INTO BATCH JOURNAL CONTROL.                              *         
BC0895*****************************************************************         
BC0895 6403-VALUE-FOR-BC-INSERT.                                        
BC0895     MOVE SPACES                        TO DCLCSS-BCH-JRNL-CNTL.  
FCSCHG*    MOVE WS-JRNL-BT-ENTRY-LOC-OFF      TO BC-LOCAL-OFFICE-ENTRY          
FCSCHG     MOVE SPACES                        TO BC-LOCAL-OFFICE-ENTRY  
BC0895                                           BC-LOCAL-OFFICE-SEND.  
FCSCHG*    MOVE WS-JRNL-BT-BAT-POST-NO        TO BC-BATCH-NO.           00028500
FCSCHG*    MOVE WS-JRNL-BT-BAT-COMPANY        TO BC-CASH-COMPANY-NO     00028500
FCSCHG     MOVE WS-100-COMPANY-NO             TO BC-CASH-COMPANY-NO     
FCSCHG     MOVE WS-JRNL-BT-BAT-LOC-OFF        TO BC-CASH-LOCAL-OFFICE   
FCSCHG     MOVE WS-JRNL-BT-BAT-REPORT-NO      TO BC-CASH-REPORT-NO      
FCSCHG     MOVE WS-JRNL-BT-BAT-REPORT-DT      TO BC-DATE-CASH-REPORT    
FCSCHG     MOVE WS-JRNL-BT-BAT-CASH-DRWR      TO BC-CASH-DRAWER-ID      
FCSCHG*    MOVE WS-100-COMPANY-NO             TO BC-COMPANY-NO.                 
BC0895     MOVE WS-JRNL-TRAN-DATE             TO BC-DATE-BATCH-ENTERED  
BC0895                                           BC-DATE-LAST-ACTIVITY. 
BC0895     MOVE 'A'                           TO BC-CODE-BATCH-STATUS.  
FCSCHG*                                          BC-CASH-DRAWER-ID.             
BC0895     MOVE ZEROES                        TO BC-NO-ITEMS-ENTERED    
BC0895                                           BC-AMT-CASH-DEBIT      
BC0895                                           BC-AMT-CASH-CREDIT     
BC0895                                           BC-AMT-AR-DEBIT        
BC0895                                           BC-AMT-AR-CREDIT       
BC0895                                           BC-AMT-CK-ISS-DEBIT    
BC0895                                           BC-AMT-CK-ISS-CREDIT   
BC0895                                           BC-AMT-GL-DEBIT        
BC0895                                           BC-AMT-GL-CREDIT       
BC0895                                           BC-AMT-NET-BATCH       
BC0895                                           BC-NO-ITEMS-POSTED     
BC0895                                           BC-AMT-BATCH-DEBITS    
BC0895                                           BC-AMT-BATCH-CREDITS.  
BC0895*                                                                         
BC0895       PERFORM 6497-INSERT-BATCH-JRNL-CNTRL THRU 6497-EXIT.       
BC0895                                                                  
BC0895 6403-EXIT.                                                       
BC0895     EXIT.                                                        
HPCCDM*    EJECT                                                        
      *****************************************************************         
      *    GET CURRENT JOURNAL TIME                                             
      *****************************************************************         
                                                                        
       6405-GET-CURRENT-JRNL-TIME.                                      
                                                                        
T35227     EXEC SQL                                                     
T35227         SELECT
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.')
            INTO
              :WS-JRNL-TRAN-TIME                    
T35227     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-JRNL-TRAN-TIME = CURRENT TIME                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '**  PROCESSING ERROR'                           
               DISPLAY '**  PARAGRAPH = 6405- '                         
               DISPLAY '**  SELECT CURRENT TIME'                        
               DISPLAY '**  RC        = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '**  PROCESSING TERMINATED'                      
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       6405-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
      *****************************************************************         
      *    GET CURRENT JOURNAL DATE                                             
      *****************************************************************         
                                                                        
       6410-GET-CURRENT-JRNL-DATE.                                      
T35227     EXEC SQL                                                     
T35227         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-JRNL-TRAN-DATE                    
T35227     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-JRNL-TRAN-DATE = CURRENT DATE                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                 MOVE WS-JRNL-TRAN-DATE TO WS-100-DATE-LAST-ACTION      
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '**  PROCESSING ERROR'                           
               DISPLAY '**  PARAGRAPH = 6410- '                         
               DISPLAY '**  SELECT CURRENT DATE'                        
               DISPLAY '**  RC        = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '**  PROCESSING TERMINATED'                      
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND THRU 9900-EXIT                        
           END-IF.                                                      
                                                                        
       6410-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
      *****************************************************************         
      *    VALIDATE BATCH JOURNAL CONTROL                                       
      *****************************************************************         
                                                                        
       6416-VALIDATE-BATCH-JRNL-CNTRL.                                  
                                                                        
FCSCHG*    MOVE WS-JRNL-BT-ENTRY-LOC-OFF TO BC-LOCAL-OFFICE-ENTRY.              
FCSCHG*    MOVE WS-JRNL-BT-BAT-POST-NO   TO BC-BATCH-NO.                00028500
FCSCHG     MOVE SPACES                   TO BC-LOCAL-OFFICE-ENTRY.      
FCSCHG     MOVE WS-JRNL-BT-BAT-COMPANY   TO BC-CASH-COMPANY-NO          
FCSCHG     MOVE WS-JRNL-BT-BAT-LOC-OFF   TO BC-CASH-LOCAL-OFFICE        
FCSCHG     MOVE WS-JRNL-BT-BAT-REPORT-NO TO BC-CASH-REPORT-NO           
FCSCHG     MOVE WS-JRNL-BT-BAT-REPORT-DT TO BC-DATE-CASH-REPORT         
FCSCHG     MOVE WS-JRNL-BT-BAT-CASH-DRWR TO BC-CASH-DRAWER-ID           
                                                                        
           PERFORM 6492-SELECT-BATCH-JRNL-CNTRL THRU 6492-EXIT.         
      *    PERFORM 6493-SELECT-BATCH-JRNL-CNTRL THRU 6493-EXIT.                 
                                                                        
           MOVE ZEROES                   TO WS-THIS-TRAN-ITEMS.         
           MOVE BC-CODE-BATCH-STATUS     TO WS-JRNL-BT-BAT-STATUS.      
           MOVE BC-NO-ITEMS-ENTERED      TO WS-JRNL-NO-ITEMS-CNTRL.     
PAL        ADD 1 TO BC-NO-ITEMS-ENTERED                                 
PAL             GIVING WS-JRNL-ENTRY-NO-HOLD                            
PAL        MOVE 0                        TO WS-100-TRAN-APPL-NO-HOLD.   
                                                                        
       6416-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
      *****************************************************************         
      *    PROCESS JOURNAL AND CONTROL                                          
      *****************************************************************         
                                                                        
       6418-PROCESS-JRNL-AND-CNTRL.                                     
                                                                        
           PERFORM 6420-PROCESS-JRNL THRU 6420-EXIT.                    
                                                                        
           IF WS-JRNL-RTRN-CODE NOT EQUAL WS-JRNL-SUCCESS               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-JRNL-TRAN-DATE TO BC-DATE-LAST-ACTIVITY          
               MOVE WS-JRNL-NO-ITEMS-CNTRL TO BC-NO-ITEMS-ENTERED       
               PERFORM 6495-UPDATE-BATCH-JRNL-CNTRL THRU 6495-EXIT
           END-IF.     
                                                                        
       6418-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
      *****************************************************************         
      *    PROCESS JOURNAL                                                      
      *****************************************************************         
                                                                        
       6420-PROCESS-JRNL.                                               
                                                                        
           IF WS-JRNL-OL-AUTH-TYPE EQUAL WS-JRNL-NON-CASH-UPDATE        
               PERFORM 6424-PROCESS-MISC-JRNL THRU 6424-EXIT            
           ELSE                                                         
               PERFORM 6422-PROCESS-BATCH-JRNL THRU 6422-EXIT           
               IF WS-JRNL-OPERATION-RQST EQUAL WS-JRNL-ONLY             
                   MOVE WS-JRNL-TRAN-DATE TO BC-DATE-LAST-ACTIVITY      
                   MOVE WS-JRNL-NO-ITEMS-CNTRL TO BC-NO-ITEMS-ENTERED   
                   IF WS-UPDATE-JRNL-CNTL-NOW EQUAL 'Y'                 
                       PERFORM 6494-UPDATE-BATCH-JRNL-CNTRL             
                             THRU 6494-EXIT
                   END-IF
               END-IF
           END-IF.                            
                                                                        
       6420-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
      *****************************************************************         
      *    CHECK FOR NEGATIVE AMOUNT                                            
      *****************************************************************         
                                                                        
HPCCDM*    EJECT                                                        
      *****************************************************************         
      *    PROCESS BATCH JOURNAL                                                
      *****************************************************************         
                                                                        
       6422-PROCESS-BATCH-JRNL.                                         
                                                                        
           IF WS-100-JRNL-TRAN-APPL-NO NOT NUMERIC                      
               MOVE WS-JRNL-INVALID-DATA TO WS-JRNL-RTRN-CODE           
               MOVE WS-JRNL-MSG-INV-DATA TO WS-JRNL-SYSTEM-MESSAGE      
               GO TO 6422-EXIT
           END-IF.                                         
                                                                        
           ADD 1 TO WS-JRNL-NO-ITEMS-CNTRL                              
                    WS-THIS-TRAN-ITEMS.                                 
                                                                        
PAL        ADD 1 TO WS-100-TRAN-APPL-NO-HOLD.                           
                                                                        
TEST  *    IF WS-100-JRNL-TRAN-APPL-NO = +1                                     
TEST  *       MOVE WS-JRNL-NO-ITEMS-CNTRL TO WS-JRNL-ENTRY-NO-HOLD              
TEST  *    END-IF.                                                              
                                                                        
           IF WS-JRNL-BT-AUTH-TYPE EQUAL WS-JRNL-CASH-UPDATE            
CELSO          PERFORM 6425-JRNL-CONTROL-EDITS        THRU 6425-EXIT    
               COMPUTE BC-AMT-CASH-DEBIT =                              
                     BC-AMT-CASH-DEBIT + WS-JRNL-CASH-DEBIT-AMT         
               COMPUTE BC-AMT-CASH-CREDIT =                             
                     BC-AMT-CASH-CREDIT + WS-JRNL-CASH-CREDIT-AMT       
               COMPUTE BC-AMT-AR-DEBIT =                                
                     BC-AMT-AR-DEBIT + WS-JRNL-RCV-DEBIT-AMT            
               COMPUTE BC-AMT-AR-CREDIT =                               
                     BC-AMT-AR-CREDIT + WS-JRNL-RCV-CREDIT-AMT          
               COMPUTE BC-AMT-CK-ISS-DEBIT =                            
                     BC-AMT-CK-ISS-DEBIT + WS-JRNL-CK-ISSUE-DEBIT-AMT   
               COMPUTE BC-AMT-CK-ISS-CREDIT =                           
                     BC-AMT-CK-ISS-CREDIT + WS-JRNL-CK-ISSUE-CREDIT-AMT 
               COMPUTE BC-AMT-GL-DEBIT =                                
                     BC-AMT-GL-DEBIT + WS-JRNL-GEN-LEG-DEBIT-AMT        
               COMPUTE BC-AMT-GL-CREDIT =                               
                     BC-AMT-GL-CREDIT + WS-JRNL-GEN-LEG-CREDIT-AMT
           END-IF.     
                                                                        
           MOVE WS-JRNL-BT-ENTRY-LOC-OFF  TO BJ-LOCAL-OFFICE            
FCSCHG*                                      BJ-ENTRY-LOC.                      
FCSCHG     MOVE SPACES                    TO BJ-ENTRY-LOC.              
                                                                        
TP5670     MOVE WS-100-LOCAL-OFFICE-CD    TO BJ-LOCAL-OFFICE            
FCSCHG**                                     BJ-BATCH-SEND-LOC.                 
TP5670**   MOVE SPACES                    TO BJ-BATCH-SEND-LOC.                 
                                                                        
FCSCHG*    MOVE WS-JRNL-BT-BAT-POST-NO    TO BJ-BATCH-NO.                       
FCSCHG     MOVE WS-JRNL-BT-BAT-COMPANY    TO BJ-CASH-COMPANY-NO         
FCSCHG     MOVE WS-JRNL-BT-BAT-LOC-OFF    TO BJ-CASH-LOCAL-OFFICE       
FCSCHG     MOVE WS-JRNL-BT-BAT-REPORT-NO  TO BJ-CASH-REPORT-NO          
FCSCHG     MOVE WS-JRNL-BT-BAT-REPORT-DT  TO BJ-DATE-CASH-REPORT        
FCSCHG     MOVE WS-JRNL-BT-BAT-CASH-DRWR  TO BJ-CASH-DRAWER-ID          
FCSCHG     MOVE WS-JRNL-CURRENCY-TYPE     TO BJ-CURRENCY-TYPE.          
           MOVE WS-JRNL-TRAN-DATE         TO BJ-DATE-TRAN.              
TEST****   MOVE WS-JRNL-NO-ITEMS-CNTRL    TO BJ-ENTRY-NO.                       
TEST       MOVE WS-JRNL-ENTRY-NO-HOLD     TO BJ-ENTRY-NO.               
PAL        MOVE WS-100-TRAN-APPL-NO-HOLD  TO BJ-TRAN-APPL-NO.           
           MOVE WS-100-JRNL-SORT-ID       TO BJ-JRNL-SORT-ID.           
                                                                        
           IF BJ-JRNL-SORT-ID EQUAL WS-JRNL-SORT-ID-A                   
               MOVE  WS-100-ACCT-NO       TO BJ-ACCOUNT-NO              
               MOVE  WS-100-CUSTOMER-NO   TO BJ-CUSTOMER-NO             
               MOVE  ZEROES               TO BJ-GL-ACCT-NO              
               MOVE  SPACES               TO BJ-METER-NO                
               MOVE  WS-100-COMPANY-NO    TO BJ-COMPANY-NO              
           ELSE                                                         
               IF BJ-JRNL-SORT-ID EQUAL WS-JRNL-SORT-ID-1               
                   MOVE WS-100-GL-ACCT-NO TO BJ-GL-ACCT-NO              
                   MOVE WS-100-COMPANY-NO TO BJ-COMPANY-NO              
                   MOVE ZEROES            TO BJ-ACCOUNT-NO              
                                             BJ-CUSTOMER-NO             
                   MOVE SPACES            TO BJ-METER-NO                
               ELSE                                                     
                   MOVE ZEROES            TO BJ-ACCOUNT-NO              
                                             BJ-GL-ACCT-NO              
                                             BJ-CUSTOMER-NO
               END-IF
           END-IF.            
                                                                        
           MOVE WS-JRNL-TRAN-TIME         TO BJ-TRAN-TIME.              
           MOVE WS-100-CODE-TERMINAL-TRAN TO BJ-TRAN-ID.                
           MOVE WS-100-DATE-LAST-ACTION   TO BJ-DATE-LAST-ACTION.       
           MOVE WS-100-CODE-ENTRY-SOURCE  TO BJ-CODE-ENTRY-SOURCE.      
FCSCHG*    MOVE WS-JRNL-BT-BAT-POST-NO    TO BJ-USER-ID.                        
FCSCHG     MOVE WS-JRNL-BT-BAT-CASH-DRWR  TO BJ-USER-ID.                
           MOVE WS-100-TRANS-ERRORS       TO BJ-CODE-TRAN-ERRORS.       
           MOVE WS-JRNL-NO                TO BJ-CODE-JRNL-EXTRACT.      
           MOVE 'A'                       TO BJ-CODE-STATUS.            
           MOVE WS-100-USER-DEFINED-AREA  TO BJ-TRAN-DATA.              
                                                                        
           PERFORM 6496-INSERT-BATCH-JRNL THRU 6496-EXIT.               
                                                                        
       6422-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
      *****************************************************************         
      *    PROCESS MISCELLANEOUS JOURNAL                                        
      *****************************************************************         
                                                                        
       6424-PROCESS-MISC-JRNL.                                          
                                                                        
           MOVE '6424' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF WS-100-JRNL-TRAN-APPL-NO NOT NUMERIC                      
               MOVE WS-JRNL-INVALID-DATA  TO WS-JRNL-RTRN-CODE          
               MOVE WS-JRNL-MSG-INV-DATA  TO WS-JRNL-SYSTEM-MESSAGE     
               GO TO 6424-EXIT
           END-IF.                                         
                                                                        
           MOVE WS-JRNL-BT-ENTRY-LOC-OFF  TO MJ-LOCAL-OFFICE.           
FCSCHG*    MOVE WS-JRNL-BT-BAT-POST-NO    TO MJ-CASH-DRAWER-ID.                 
FCSCHG     MOVE WS-JRNL-BT-BAT-CASH-DRWR  TO MJ-CASH-DRAWER-ID          
           MOVE WS-JRNL-TRAN-DATE         TO MJ-DATE-TRAN.              
                                                                        
           EXEC SQL                                                     
               SELECT  MAX(ENTRY_NO)                                    
                 INTO :MJ-ENTRY-NO :WS-100-NULL-IND                      
                 FROM  CSS_MISC_JRNL                                    
                WHERE  LOCAL_OFFICE   = :MJ-LOCAL-OFFICE                
                  AND  CASH_DRAWER_ID = :MJ-CASH-DRAWER-ID              
                  AND  DATE_TRAN      = IIF(TRY_CONVERT(DATE, 
                                                          :MJ-DATE-TRAN
              ) IS NULL OR (PATINDEX('%.%', :MJ-DATE-TRAN
              ) <> 0) OR (LEN(:MJ-DATE-TRAN) <> 10), CIS.CHAR2DATE(
                                                          :MJ-DATE-TRAN
              ), CONVERT(DATE, :MJ-DATE-TRAN) )                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  MAX(ENTRY_NO)                                            
MFA-TR*          INTO :MJ-ENTRY-NO:WS-100-NULL-IND                              
MFA-TR*          FROM  CSS_MISC_JRNL                                            
MFA-TR*         WHERE  LOCAL_OFFICE   = :MJ-LOCAL-OFFICE                        
MFA-TR*           AND  CASH_DRAWER_ID = :MJ-CASH-DRAWER-ID                      
MFA-TR*           AND  DATE_TRAN      = :MJ-DATE-TRAN                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-JRNL-DB2-RETURN.                          
                                                                        
           IF WS-JRNL-DB2-RETURN EQUAL SUCCESSFUL-CALL                  
               COMPUTE WS-JRNL-NO-ITEMS-MISC = MJ-ENTRY-NO + 1          
               MOVE WS-JRNL-SUCCESS TO WS-JRNL-RTRN-CODE                
           ELSE                                                         
               IF WS-JRNL-DB2-RETURN EQUAL NOT-FOUND                    
                   MOVE 1 TO WS-JRNL-NO-ITEMS-MISC                      
               ELSE                                                     
                   DISPLAY '*************************************'      
                   DISPLAY '**  PROCESSING ERROR'                       
                   DISPLAY '**  PARAGRAPH = 6424- '                     
                   DISPLAY '**  SELECT MAX ENTRIES '                    
                   DISPLAY '**  RC        = ' WS-JRNL-DB2-RETURN        
                   DISPLAY '**  PROCESSING TERMINATED'                  
                   DISPLAY '*************************************'      
                   PERFORM 9900-ABEND THRU 9900-EXIT
               END-IF
           END-IF.                   
                                                                        
           MOVE WS-100-JRNL-TRAN-APPL-NO  TO MJ-TRAN-APPL-NO.           
           MOVE WS-100-JRNL-SORT-ID       TO MJ-JRNL-SORT-ID.           
           MOVE WS-100-ACCT-NO            TO AT-ACCOUNT-NO.             
                                                                        
           EXEC SQL                                                     
               SELECT  LOCAL_OFFICE                                     
                 INTO :AT-LOCAL-OFFICE                                  
                 FROM  CSS_ACCOUNT                                      
                WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '**  PROCESSING ERROR'                           
               DISPLAY '**  PARAGRAPH = 6424- '                         
               DISPLAY '**  SELECT ACCOUNT '                            
               DISPLAY '**  RC        = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '**  PROCESSING TERMINATED'                      
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
           MOVE AT-LOCAL-OFFICE           TO WS-100-LOCAL-OFFICE-CD     
FCSCHG**                                     MJ-LOCAL-OFFICE-CODE               
FCSCHG**                                     MJ-BATCH-SEND-LOC.                 
FCSCHG     MOVE SPACES                    TO MJ-BATCH-SEND-LOC.         
           MOVE WS-100-ACCT-NO            TO MJ-ACCOUNT-NO.             
           MOVE WS-100-CUSTOMER-NO        TO MJ-CUSTOMER-NO.            
           MOVE WS-100-COMPANY-NO         TO MJ-COMPANY-NO.             
           MOVE WS-100-PREMISE-NO         TO MJ-PREMISE-NO.             
           MOVE SPACES                    TO MJ-METER-NO.               
           MOVE WS-JRNL-NO-ITEMS-MISC     TO MJ-ENTRY-NO.               
           MOVE WS-JRNL-TRAN-DATE         TO MJ-DATE-TRAN.              
           MOVE WS-JRNL-TRAN-TIME         TO MJ-TRAN-TIME.              
           MOVE WS-100-CODE-TERMINAL-TRAN TO MJ-TRAN-ID.                
           MOVE WS-100-JRNL-TRAN-APPL-NO  TO MJ-TRAN-APPL-NO.           
           MOVE WS-100-DATE-LAST-ACTION   TO MJ-DATE-LAST-ACTION.       
           MOVE WS-100-CODE-ENTRY-SOURCE  TO MJ-CODE-ENTRY-SOURCE.      
FCSCHG*    MOVE WS-JRNL-BT-BAT-POST-NO    TO MJ-USER-ID.                        
FCSCHG*    MOVE WS-JRNL-BT-ENTRY-LOC-OFF  TO MJ-ENTRY-LOC.                      
FCSCHG     MOVE WS-JRNL-BT-BAT-CASH-DRWR  TO MJ-USER-ID                 
FCSCHG     MOVE SPACES                    TO MJ-ENTRY-LOC.              
           MOVE WS-JRNL-NO                TO MJ-CODE-JRNL-EXTRACT.      
           MOVE 'A'                       TO MJ-CODE-STATUS.            
           MOVE WS-100-TRANS-ERRORS       TO MJ-CODE-TRAN-ERRORS.       
           MOVE WS-100-USER-DEFINED-AREA  TO MJ-TRAN-DATA.              
                                                                        
           EXEC SQL                                                     
               INSERT INTO  CSS_MISC_JRNL                               
                           (LOCAL_OFFICE,                               
                            CASH_DRAWER_ID,                             
                            DATE_TRAN,                                  
                            ENTRY_NO,                                   
                            TRAN_APPL_NO,                               
                            JRNL_SORT_ID,                               
                            ACCOUNT_NO,                                 
                            CUSTOMER_NO,                                
                            METER_NO,                                   
                            TRAN_TIME,                                  
                            TRAN_ID,                                    
                            DATE_LAST_ACTION,                           
                            CODE_ENTRY_SOURCE,                          
                            USER_ID,                                    
                            BATCH_SEND_LOC,                             
                            ENTRY_LOC,                                  
                            CODE_JRNL_EXTRACT,                          
                            CODE_STATUS,                                
                            CODE_TRAN_ERRORS,                           
                            TRAN_DATA,                                  
                            COMPANY_NO,                                 
                            PREMISE_NO)                                 
                   VALUES (:MJ-LOCAL-OFFICE,                            
                           :MJ-CASH-DRAWER-ID,                          
                           IIF(TRY_CONVERT(DATE, :MJ-DATE-TRAN
              ) IS NULL OR (PATINDEX('%.%', :MJ-DATE-TRAN
              ) <> 0) OR (LEN(:MJ-DATE-TRAN) <> 10), CIS.CHAR2DATE(
                                                          :MJ-DATE-TRAN
              ), CONVERT(DATE, :MJ-DATE-TRAN) ),                               
                           :MJ-ENTRY-NO,                                
                           :MJ-TRAN-APPL-NO,                            
                           :MJ-JRNL-SORT-ID,                            
                           :MJ-ACCOUNT-NO,                              
                           :MJ-CUSTOMER-NO,                             
                           :MJ-METER-NO,                                
                           CIS.CHAR2TIME(:MJ-TRAN-TIME),                        
                           :MJ-TRAN-ID,                                 
                           IIF(TRY_CONVERT(DATE, :MJ-DATE-LAST-ACTION
              ) IS NULL OR (PATINDEX('%.%', :MJ-DATE-LAST-ACTION
              ) <> 0) OR (LEN(:MJ-DATE-LAST-ACTION
              ) <> 10), CIS.CHAR2DATE(:MJ-DATE-LAST-ACTION
              ), CONVERT(DATE, :MJ-DATE-LAST-ACTION) ),                        
                           :MJ-CODE-ENTRY-SOURCE,                       
                           :MJ-USER-ID,                                 
                           :MJ-BATCH-SEND-LOC,                          
                           :MJ-ENTRY-LOC,                               
                           :MJ-CODE-JRNL-EXTRACT,                       
                           :MJ-CODE-STATUS,                             
                           :MJ-CODE-TRAN-ERRORS,                        
                           :MJ-TRAN-DATA,                               
MCR310*                    :MJ-COMPANY-NO,                                      
MCR310                     '01',                                        
                           :MJ-PREMISE-NO)                              
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO  CSS_MISC_JRNL                                       
MFA-TR*                    (LOCAL_OFFICE,                                       
MFA-TR*                     CASH_DRAWER_ID,                                     
MFA-TR*                     DATE_TRAN,                                          
MFA-TR*                     ENTRY_NO,                                           
MFA-TR*                     TRAN_APPL_NO,                                       
MFA-TR*                     JRNL_SORT_ID,                                       
MFA-TR*                     ACCOUNT_NO,                                         
MFA-TR*                     CUSTOMER_NO,                                        
MFA-TR*                     METER_NO,                                           
MFA-TR*                     TRAN_TIME,                                          
MFA-TR*                     TRAN_ID,                                            
MFA-TR*                     DATE_LAST_ACTION,                                   
MFA-TR*                     CODE_ENTRY_SOURCE,                                  
MFA-TR*                     USER_ID,                                            
MFA-TR*                     BATCH_SEND_LOC,                                     
MFA-TR*                     ENTRY_LOC,                                          
MFA-TR*                     CODE_JRNL_EXTRACT,                                  
MFA-TR*                     CODE_STATUS,                                        
MFA-TR*                     CODE_TRAN_ERRORS,                                   
MFA-TR*                     TRAN_DATA,                                          
MFA-TR*                     COMPANY_NO,                                         
MFA-TR*                     PREMISE_NO)                                         
MFA-TR*            VALUES (:MJ-LOCAL-OFFICE,                                    
MFA-TR*                    :MJ-CASH-DRAWER-ID,                                  
MFA-TR*                    :MJ-DATE-TRAN,                                       
MFA-TR*                    :MJ-ENTRY-NO,                                        
MFA-TR*                    :MJ-TRAN-APPL-NO,                                    
MFA-TR*                    :MJ-JRNL-SORT-ID,                                    
MFA-TR*                    :MJ-ACCOUNT-NO,                                      
MFA-TR*                    :MJ-CUSTOMER-NO,                                     
MFA-TR*                    :MJ-METER-NO,                                        
MFA-TR*                    :MJ-TRAN-TIME,                                       
MFA-TR*                    :MJ-TRAN-ID,                                         
MFA-TR*                    :MJ-DATE-LAST-ACTION,                                
MFA-TR*                    :MJ-CODE-ENTRY-SOURCE,                               
MFA-TR*                    :MJ-USER-ID,                                         
MFA-TR*                    :MJ-BATCH-SEND-LOC,                                  
MFA-TR*                    :MJ-ENTRY-LOC,                                       
MFA-TR*                    :MJ-CODE-JRNL-EXTRACT,                               
MFA-TR*                    :MJ-CODE-STATUS,                                     
MFA-TR*                    :MJ-CODE-TRAN-ERRORS,                                
MFA-TR*                    :MJ-TRAN-DATA,                                       
MFA-TR*                    :MJ-COMPANY-NO,                                      
MFA-TR*                    '01',                                                
MFA-TR*                    :MJ-PREMISE-NO)                                      
MFA-TR*        END-EXEC.                                                        

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

FCSCHG**                    LOCAL_OFFICE_CODE,                                  
FCSCHG**                   :MJ-LOCAL-OFFICE-CODE,                               
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           WS-JRNL-DB2-RETURN.                          
                                                                        
           IF WS-JRNL-DB2-RETURN EQUAL SUCCESSFUL-CALL                  
               MOVE WS-JRNL-SUCCESS TO WS-JRNL-RTRN-CODE                
               ADD 1 TO WS-JRNL-MJ-ISRT-CNTR                            
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '**  PROCESSING ERROR'                           
               DISPLAY '**  PARAGRAPH = 6424- '                         
               DISPLAY '**  INSERT MISC JRNL'                           
               DISPLAY '**  RC        = ' WS-ACTIVE-RETURN-CODE         
               DISPLAY '**  PROCESSING TERMINATED'                      
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
       6424-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *    6425-JRNL-CONTROL-EDITS                                              
      *****************************************************************         
                                                                        
       6425-JRNL-CONTROL-EDITS.                                         
      *                                                                         
           MOVE ZEROS     TO  WS-JRNL-CASH-DEBIT-AMT                    
                              WS-JRNL-CASH-CREDIT-AMT                   
                              WS-JRNL-RCV-DEBIT-AMT                     
                              WS-JRNL-RCV-CREDIT-AMT                    
                              WS-JRNL-CK-ISSUE-DEBIT-AMT                
                              WS-JRNL-CK-ISSUE-CREDIT-AMT               
                              WS-JRNL-GEN-LEG-DEBIT-AMT                 
                              WS-JRNL-GEN-LEG-CREDIT-AMT.               
                                                                        
           MOVE WS-100-COMPANY-NO          TO GO-COMPANY-NO.            
           MOVE WS-100-USER-DEFINED-AREA   TO WS-CWS13-JRNL-FMT.        
TEST       IF WS-CWS13-JRNL-FORMAT-NO = 201                             
TEST         MOVE WS-100-USER-DEFINED-AREA   TO WS-CWS13-JRNL-FMT-201   
TEST       ELSE                                                         
             IF WS-CWS13-ACCT-GEN-LED-DR = WS-CWS13-ACCT-GEN-LED-CR     
               GO TO 6425-EXIT                                          
TEST         END-IF                                                     
           END-IF.                                                      
                                                                        
           MOVE 'CLR-CASH  '               TO GO-GL-ACCT-NAME.          
           PERFORM 6498-SELECT-GEN-LED-ACCT-NO    THRU  6498-EXIT.      
           MOVE GO-GL-ACCT-NO              TO WS-CWS13-CASH-GL.         
                                                                        
           MOVE 'CLR-CK-ISS'               TO GO-GL-ACCT-NAME.          
           PERFORM 6498-SELECT-GEN-LED-ACCT-NO    THRU  6498-EXIT.      
           MOVE GO-GL-ACCT-NO              TO WS-CWS13-CHK-ISSUE-GL.    
                                                                        
      *                                                                         
           IF WS-CWS13-JRNL-FORMAT-NO = 201                             
             PERFORM 6426-ASSIGN-201-CNTL-AMTS THRU 6426-EXIT           
           ELSE                                                         
TEST         IF WS-CWS13-AMT-POSTED   < ZERO                            
TEST           MULTIPLY -1 BY WS-CWS13-AMT-POSTED                       
TEST         END-IF                                                     
             EVALUATE WS-CWS13-ACCT-GEN-LED-DR                          
               WHEN   WS-CWS13-CASH-GL                                  
                 MOVE WS-CWS13-AMT-POSTED  TO WS-JRNL-CASH-DEBIT-AMT    
               WHEN   WS-CWS13-CHK-ISSUE-GL                             
                 MOVE WS-CWS13-AMT-POSTED TO WS-JRNL-CK-ISSUE-DEBIT-AMT 
               WHEN OTHER                                               
                 MOVE WS-CWS13-ACCT-GEN-LED-DR  TO WS-CWS13-GEN-LED-CHK 
                 IF WS-CWS13-GEN-LED-MAJ = 142                          
                   MOVE WS-CWS13-AMT-POSTED  TO WS-JRNL-RCV-DEBIT-AMT   
                 ELSE                                                   
                 MOVE WS-CWS13-AMT-POSTED                               
                               TO WS-JRNL-GEN-LEG-DEBIT-AMT             
                 END-IF                                                 
             END-EVALUATE                                               
      *                                                                         
             EVALUATE WS-CWS13-ACCT-GEN-LED-CR                          
               WHEN   WS-CWS13-CASH-GL                                  
                 MOVE WS-CWS13-AMT-POSTED  TO WS-JRNL-CASH-CREDIT-AMT   
               WHEN   WS-CWS13-CHK-ISSUE-GL                             
                 MOVE WS-CWS13-AMT-POSTED TO WS-JRNL-CK-ISSUE-CREDIT-AMT
               WHEN OTHER                                               
                 MOVE WS-CWS13-ACCT-GEN-LED-CR  TO WS-CWS13-GEN-LED-CHK 
                 IF WS-CWS13-GEN-LED-MAJ = 142                          
                   MOVE WS-CWS13-AMT-POSTED  TO WS-JRNL-RCV-CREDIT-AMT  
                 ELSE                                                   
                   MOVE WS-CWS13-AMT-POSTED                             
                               TO WS-JRNL-GEN-LEG-CREDIT-AMT            
                 END-IF                                                 
             END-EVALUATE                                               
           END-IF.                                                      
      *                                                                         
       6425-EXIT.                                                       
      *                                                                         
       6426-ASSIGN-201-CNTL-AMTS.                                       
      *                                                                         
           IF WS-CWS13-201-AMT-POSTED  < ZERO                           
             MULTIPLY -1 BY WS-CWS13-201-AMT-POSTED                     
           END-IF.                                                      
           IF WS-CWS13-201-CODE-DR-CR EQUAL 'D'                         
T15874       EVALUATE WS-100-GL-ACCT-NO                                 
               WHEN   WS-CWS13-CASH-GL                                  
                 MOVE WS-CWS13-201-AMT-POSTED TO WS-JRNL-CASH-DEBIT-AMT 
               WHEN   WS-CWS13-CHK-ISSUE-GL                             
                 MOVE WS-CWS13-201-AMT-POSTED                           
                       TO WS-JRNL-CK-ISSUE-DEBIT-AMT                    
               WHEN OTHER                                               
                 MOVE WS-CWS13-201-OFFSET-GL-ACCT-NO                    
                                TO WS-CWS13-GEN-LED-CHK                 
                 IF WS-CWS13-GEN-LED-MAJ = 142                          
                   MOVE WS-CWS13-201-AMT-POSTED TO WS-JRNL-RCV-DEBIT-AMT
                 ELSE                                                   
                   MOVE WS-CWS13-201-AMT-POSTED                         
                        TO WS-JRNL-GEN-LEG-DEBIT-AMT                    
                 END-IF                                                 
             END-EVALUATE                                               
           END-IF.                                                      
      *                                                                         
           IF WS-CWS13-201-CODE-DR-CR EQUAL 'C'                         
T15874       EVALUATE WS-100-GL-ACCT-NO                                 
               WHEN   WS-CWS13-CASH-GL                                  
                 MOVE WS-CWS13-201-AMT-POSTED                           
                      TO WS-JRNL-CASH-CREDIT-AMT                        
               WHEN   WS-CWS13-CHK-ISSUE-GL                             
                 MOVE WS-CWS13-201-AMT-POSTED                           
                       TO WS-JRNL-CK-ISSUE-CREDIT-AMT                   
               WHEN OTHER                                               
                 MOVE WS-CWS13-201-OFFSET-GL-ACCT-NO                    
                                TO WS-CWS13-GEN-LED-CHK                 
                 IF WS-CWS13-GEN-LED-MAJ = 142                          
                   MOVE WS-CWS13-201-AMT-POSTED                         
                        TO WS-JRNL-RCV-CREDIT-AMT                       
                 ELSE                                                   
                   MOVE WS-CWS13-201-AMT-POSTED                         
                        TO WS-JRNL-GEN-LEG-CREDIT-AMT                   
                 END-IF                                                 
             END-EVALUATE                                               
           END-IF.                                                      
      *                                                                         
       6426-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                        
BC0895*****************************************************************         
BC0895* SELECT BATCH JOURNAL CONTROL TO SEE IF THERE IS ONE FOR       *         
BC0895* PAYMENT POSTING. IF THERE IS NOT ONE THEN WE WILL INSERT ONE. *         
BC0895*****************************************************************         
BC0895 6491-SELECT-BATCH-JRNL-CNTRL.                                    
BC0895                                                                  
BC0895     MOVE '6491' TO ACTIVE-PARAGRAPH.                             
BC0895                                                                  
BC0895     EXEC SQL                                                     
BC0895         SELECT  NO_ITEMS_ENTERED,                                
BC0895                 CODE_BATCH_STATUS,                               
BC0895                 DATE_LAST_ACTIVITY,                              
BC0895                 AMT_CASH_DEBIT,                                  
BC0895                 AMT_CASH_CREDIT,                                 
BC0895                 AMT_AR_DEBIT,                                    
BC0895                 AMT_AR_CREDIT,                                   
BC0895                 AMT_CK_ISS_DEBIT,                                
BC0895                 AMT_CK_ISS_CREDIT,                               
BC0895                 AMT_GL_DEBIT,                                    
BC0895                 AMT_GL_CREDIT                                    
BC0895           INTO :BC-NO-ITEMS-ENTERED,                             
BC0895                :BC-CODE-BATCH-STATUS,                            
BC0895                :BC-DATE-LAST-ACTIVITY,                           
BC0895                :BC-AMT-CASH-DEBIT,                               
BC0895                :BC-AMT-CASH-CREDIT,                              
BC0895                :BC-AMT-AR-DEBIT,                                 
BC0895                :BC-AMT-AR-CREDIT,                                
BC0895                :BC-AMT-CK-ISS-DEBIT,                             
BC0895                :BC-AMT-CK-ISS-CREDIT,                            
BC0895                :BC-AMT-GL-DEBIT,                                 
BC0895                :BC-AMT-GL-CREDIT                                 
BC0895           FROM  CSS_BCH_JRNL_CNTL                                
FCSCHG          WHERE  CASH_DRAWER_ID     = :BC-CASH-DRAWER-ID          
MCR310*           AND  CASH_COMPANY_NO    = :BC-CASH-COMPANY-NO                 
MCR310            AND  CASH_COMPANY_NO    = '01'                        
FCSCHG            AND  CASH_LOCAL_OFFICE  = :BC-CASH-LOCAL-OFFICE       
FCSCHG            AND  CASH_REPORT_NO     = :BC-CASH-REPORT-NO          
FCSCHG            AND  DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :BC-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:BC-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-CASH-REPORT
              ), CONVERT(DATE, :BC-DATE-CASH-REPORT) )        
BC0895     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  NO_ITEMS_ENTERED,                                        
MFA-TR*                CODE_BATCH_STATUS,                                       
MFA-TR*                DATE_LAST_ACTIVITY,                                      
MFA-TR*                AMT_CASH_DEBIT,                                          
MFA-TR*                AMT_CASH_CREDIT,                                         
MFA-TR*                AMT_AR_DEBIT,                                            
MFA-TR*                AMT_AR_CREDIT,                                           
MFA-TR*                AMT_CK_ISS_DEBIT,                                        
MFA-TR*                AMT_CK_ISS_CREDIT,                                       
MFA-TR*                AMT_GL_DEBIT,                                            
MFA-TR*                AMT_GL_CREDIT                                            
MFA-TR*          INTO :BC-NO-ITEMS-ENTERED,                                     
MFA-TR*               :BC-CODE-BATCH-STATUS,                                    
MFA-TR*               :BC-DATE-LAST-ACTIVITY,                                   
MFA-TR*               :BC-AMT-CASH-DEBIT,                                       
MFA-TR*               :BC-AMT-CASH-CREDIT,                                      
MFA-TR*               :BC-AMT-AR-DEBIT,                                         
MFA-TR*               :BC-AMT-AR-CREDIT,                                        
MFA-TR*               :BC-AMT-CK-ISS-DEBIT,                                     
MFA-TR*               :BC-AMT-CK-ISS-CREDIT,                                    
MFA-TR*               :BC-AMT-GL-DEBIT,                                         
MFA-TR*               :BC-AMT-GL-CREDIT                                         
MFA-TR*          FROM  CSS_BCH_JRNL_CNTL                                        
MFA-TR*         WHERE  CASH_DRAWER_ID     = :BC-CASH-DRAWER-ID                  
MFA-TR*           AND  CASH_COMPANY_NO    = :BC-CASH-COMPANY-NO                 
MFA-TR*           AND  CASH_COMPANY_NO    = '01'                                
MFA-TR*           AND  CASH_LOCAL_OFFICE  = :BC-CASH-LOCAL-OFFICE               
MFA-TR*           AND  CASH_REPORT_NO     = :BC-CASH-REPORT-NO                  
MFA-TR*           AND  DATE_CASH_REPORT   = :BC-DATE-CASH-REPORT                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

FCSCHG*         WHERE  LOCAL_OFFICE_ENTRY = :BC-LOCAL-OFFICE-ENTRY              
FCSCHG*           AND  BATCH_NO           = :BC-BATCH-NO                        
BC0895                                                                  
BC0895     MOVE SQLCODE TO WS-JRNL-DB2-RETURN.                          
BC0895                                                                  
BC0895     IF WS-JRNL-DB2-RETURN EQUAL SUCCESSFUL-CALL                  
BC0895                              OR NOT-FOUND                        
BC0895       MOVE WS-JRNL-SUCCESS TO WS-JRNL-RTRN-CODE                  
BC0895     ELSE                                                         
BC0895       MOVE WS-JRNL-DB2-ABEND TO WS-JRNL-RTRN-CODE                
BC0895       DISPLAY '6491 ' WS-JRNL-RTRN-CODE                          
BC0895       DISPLAY '*************************************'            
BC0895       DISPLAY '**  PROCESSING ERROR'                             
BC0895       DISPLAY '**  PARAGRAPH = 6491- '                           
BC0895       DISPLAY '**  SELECT BTCH JRNL CNTL'                        
BC0895       DISPLAY '**  RC                  = ' WS-JRNL-RTRN-CODE     
FCSCHG       DISPLAY '**  CASH COMPANY NUMBER = ' BC-CASH-COMPANY-NO    
FCSCHG       DISPLAY '**  CASH LOCAL OFFICE   = ' BC-CASH-LOCAL-OFFICE  
FCSCHG       DISPLAY '**  CASH REPORT NUMBER  = ' BC-CASH-REPORT-NO     
FCSCHG       DISPLAY '**  DATE CASH REPORT    = ' BC-DATE-CASH-REPORT   
FCSCHG       DISPLAY '**  CASH DRAWER ID      = ' BC-CASH-DRAWER-ID     
BC0895       DISPLAY '**  PROCESSING TERMINATED'                        
BC0895       DISPLAY '*************************************'            
BC0895       PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                         
BC0895                                                                  
BC0895 6491-EXIT.                                                       
BC0895     EXIT.                                                        
HPCCDM*    EJECT                                                        
      *****************************************************************         
      *    SELECT BATCH JOURNAL CONTROL TO UPDATE TOTALS                        
      *****************************************************************         
                                                                        
       6492-SELECT-BATCH-JRNL-CNTRL.                                    
                                                                        
           MOVE '6492' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               SELECT  NO_ITEMS_ENTERED,                                
                       CODE_BATCH_STATUS,                               
                       DATE_LAST_ACTIVITY,                              
                       AMT_CASH_DEBIT,                                  
                       AMT_CASH_CREDIT,                                 
                       AMT_AR_DEBIT,                                    
                       AMT_AR_CREDIT,                                   
                       AMT_CK_ISS_DEBIT,                                
                       AMT_CK_ISS_CREDIT,                               
                       AMT_GL_DEBIT,                                    
                       AMT_GL_CREDIT                                    
                 INTO :BC-NO-ITEMS-ENTERED,                             
                      :BC-CODE-BATCH-STATUS,                            
                      :BC-DATE-LAST-ACTIVITY,                           
                      :BC-AMT-CASH-DEBIT,                               
                      :BC-AMT-CASH-CREDIT,                              
                      :BC-AMT-AR-DEBIT,                                 
                      :BC-AMT-AR-CREDIT,                                
                      :BC-AMT-CK-ISS-DEBIT,                             
                      :BC-AMT-CK-ISS-CREDIT,                            
                      :BC-AMT-GL-DEBIT,                                 
                      :BC-AMT-GL-CREDIT                                 
                 FROM  CSS_BCH_JRNL_CNTL                                
FCSCHG          WHERE  CASH_DRAWER_ID     = :BC-CASH-DRAWER-ID          
MCR310*           AND  CASH_COMPANY_NO    = :BC-CASH-COMPANY-NO                 
MCR310            AND  CASH_COMPANY_NO    = '01'                        
FCSCHG            AND  CASH_LOCAL_OFFICE  = :BC-CASH-LOCAL-OFFICE       
FCSCHG            AND  CASH_REPORT_NO     = :BC-CASH-REPORT-NO          
FCSCHG            AND  DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :BC-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:BC-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-CASH-REPORT
              ), CONVERT(DATE, :BC-DATE-CASH-REPORT) )        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  NO_ITEMS_ENTERED,                                        
MFA-TR*                CODE_BATCH_STATUS,                                       
MFA-TR*                DATE_LAST_ACTIVITY,                                      
MFA-TR*                AMT_CASH_DEBIT,                                          
MFA-TR*                AMT_CASH_CREDIT,                                         
MFA-TR*                AMT_AR_DEBIT,                                            
MFA-TR*                AMT_AR_CREDIT,                                           
MFA-TR*                AMT_CK_ISS_DEBIT,                                        
MFA-TR*                AMT_CK_ISS_CREDIT,                                       
MFA-TR*                AMT_GL_DEBIT,                                            
MFA-TR*                AMT_GL_CREDIT                                            
MFA-TR*          INTO :BC-NO-ITEMS-ENTERED,                                     
MFA-TR*               :BC-CODE-BATCH-STATUS,                                    
MFA-TR*               :BC-DATE-LAST-ACTIVITY,                                   
MFA-TR*               :BC-AMT-CASH-DEBIT,                                       
MFA-TR*               :BC-AMT-CASH-CREDIT,                                      
MFA-TR*               :BC-AMT-AR-DEBIT,                                         
MFA-TR*               :BC-AMT-AR-CREDIT,                                        
MFA-TR*               :BC-AMT-CK-ISS-DEBIT,                                     
MFA-TR*               :BC-AMT-CK-ISS-CREDIT,                                    
MFA-TR*               :BC-AMT-GL-DEBIT,                                         
MFA-TR*               :BC-AMT-GL-CREDIT                                         
MFA-TR*          FROM  CSS_BCH_JRNL_CNTL                                        
MFA-TR*         WHERE  CASH_DRAWER_ID     = :BC-CASH-DRAWER-ID                  
MFA-TR*           AND  CASH_COMPANY_NO    = :BC-CASH-COMPANY-NO                 
MFA-TR*           AND  CASH_COMPANY_NO    = '01'                                
MFA-TR*           AND  CASH_LOCAL_OFFICE  = :BC-CASH-LOCAL-OFFICE               
MFA-TR*           AND  CASH_REPORT_NO     = :BC-CASH-REPORT-NO                  
MFA-TR*           AND  DATE_CASH_REPORT   = :BC-DATE-CASH-REPORT                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

FCSCHG*         WHERE  LOCAL_OFFICE_ENTRY = :BC-LOCAL-OFFICE-ENTRY              
FCSCHG*           AND  BATCH_NO           = :BC-BATCH-NO                        
                                                                        
           MOVE SQLCODE TO WS-JRNL-DB2-RETURN.                          
                                                                        
           IF WS-JRNL-DB2-RETURN EQUAL SUCCESSFUL-CALL                  
               MOVE WS-JRNL-SUCCESS TO WS-JRNL-RTRN-CODE                
           ELSE                                                         
               IF WS-JRNL-DB2-RETURN EQUAL NOT-FOUND                    
                   MOVE WS-JRNL-INVALID-OPER TO WS-JRNL-RTRN-CODE       
                   DISPLAY '*************************************'      
                   DISPLAY '**  PROCESSING ERROR'                       
                   DISPLAY '**  PARAGRAPH    = 6492- '                  
                   DISPLAY '**  ' WS-JRNL-MSG-INV-BAT-ID                
                   DISPLAY '**  JRNL RC      = ' WS-JRNL-RTRN-CODE      
FCSCHG             DISPLAY '**  CSH COMPANY NO = ' BC-CASH-COMPANY-NO   
FCSCHG             DISPLAY '**  CSH LOC OFF    = ' BC-CASH-LOCAL-OFFICE 
FCSCHG             DISPLAY '**  CSH RPT NUMBER = ' BC-CASH-REPORT-NO    
FCSCHG             DISPLAY '**  DATE REPORT    = ' BC-DATE-CASH-REPORT  
FCSCHG             DISPLAY '** CASH DRAWER ID  = ' BC-CASH-DRAWER-ID    
FCSCHG*            DISPLAY '**  BATCH NO     = ' BC-BATCH-NO                    
                   DISPLAY '**  MISSING FROM BCH_JRNL_CNTL '            
FCSCHG*            DISPLAY '**  LOCAL OFFICE = '                                
FCSCHG*                         BC-LOCAL-OFFICE-ENTRY                           
                   DISPLAY '**  RC           = '                        
                                WS-JRNL-DB2-RETURN                      
                   DISPLAY '**  PROCESSING TERMINATED'                  
                   DISPLAY '*************************************'      
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               ELSE                                                     
                   MOVE WS-JRNL-DB2-ABEND TO WS-JRNL-RTRN-CODE          
                   DISPLAY '6492 ' WS-JRNL-RTRN-CODE                    
                   DISPLAY '*************************************'      
                   DISPLAY '**  PROCESSING ERROR'                       
                   DISPLAY '**  PARAGRAPH = 6492- '                     
                   DISPLAY '**  SELECT BTCH JRNL CNTL'                  
                   DISPLAY '**  RC        = ' WS-JRNL-RTRN-CODE         
FCSCHG             DISPLAY '**  CSH COMPANY NO = ' BC-CASH-COMPANY-NO   
FCSCHG             DISPLAY '**  CSH LOC OFF    = ' BC-CASH-LOCAL-OFFICE 
FCSCHG             DISPLAY '**  CSH RPT NUMBER = ' BC-CASH-REPORT-NO    
FCSCHG             DISPLAY '**  DATE REPORT    = ' BC-DATE-CASH-REPORT  
FCSCHG             DISPLAY '** CASH DRAWER ID  = ' BC-CASH-DRAWER-ID    
                   DISPLAY '**  PROCESSING TERMINATED'                  
                   DISPLAY '*************************************'      
                   PERFORM 9900-ABEND THRU 9900-EXIT
               END-IF
           END-IF.                   
                                                                        
       6492-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
      *****************************************************************         
      *    SELECT BATCH JOURNAL CONTROL                                         
      *****************************************************************         
                                                                        
       6493-SELECT-BATCH-JRNL-CNTRL.                                    
                                                                        
           MOVE '6493' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               SELECT  CODE_BATCH_STATUS,                               
                       NO_ITEMS_ENTERED                                 
                 INTO :BC-CODE-BATCH-STATUS,                            
                      :BC-NO-ITEMS-ENTERED                              
                 FROM  CSS_BCH_JRNL_CNTL                                
FCSCHG          WHERE  CASH_DRAWER_ID     = :BC-CASH-DRAWER-ID          
MCR310*           AND  CASH_COMPANY_NO    = :BC-CASH-COMPANY-NO                 
MCR310            AND  CASH_COMPANY_NO    = '01'                        
FCSCHG            AND  CASH_LOCAL_OFFICE  = :BC-CASH-LOCAL-OFFICE       
FCSCHG            AND  CASH_REPORT_NO     = :BC-CASH-REPORT-NO          
FCSCHG            AND  DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :BC-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:BC-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-CASH-REPORT
              ), CONVERT(DATE, :BC-DATE-CASH-REPORT) )        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  CODE_BATCH_STATUS,                                       
MFA-TR*                NO_ITEMS_ENTERED                                         
MFA-TR*          INTO :BC-CODE-BATCH-STATUS,                                    
MFA-TR*               :BC-NO-ITEMS-ENTERED                                      
MFA-TR*          FROM  CSS_BCH_JRNL_CNTL                                        
MFA-TR*         WHERE  CASH_DRAWER_ID     = :BC-CASH-DRAWER-ID                  
MFA-TR*           AND  CASH_COMPANY_NO    = :BC-CASH-COMPANY-NO                 
MFA-TR*           AND  CASH_COMPANY_NO    = '01'                                
MFA-TR*           AND  CASH_LOCAL_OFFICE  = :BC-CASH-LOCAL-OFFICE               
MFA-TR*           AND  CASH_REPORT_NO     = :BC-CASH-REPORT-NO                  
MFA-TR*           AND  DATE_CASH_REPORT   = :BC-DATE-CASH-REPORT                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

FCSCHG*         WHERE  LOCAL_OFFICE_ENTRY = :BC-LOCAL-OFFICE-ENTRY              
FCSCHG*           AND  BATCH_NO           = :BC-BATCH-NO                        
                                                                        
           MOVE SQLCODE TO WS-JRNL-DB2-RETURN.                          
                                                                        
           IF WS-JRNL-DB2-RETURN EQUAL SUCCESSFUL-CALL                  
               MOVE WS-JRNL-SUCCESS TO WS-JRNL-RTRN-CODE                
           ELSE                                                         
               IF WS-JRNL-DB2-RETURN EQUAL NOT-FOUND                    
                   MOVE WS-JRNL-INVALID-OPER TO WS-JRNL-RTRN-CODE       
                   DISPLAY '*************************************'      
                   DISPLAY '**  PROCESSING ERROR'                       
                   DISPLAY '**  PARAGRAPH    = 6493- '                  
                   DISPLAY '**  ' WS-JRNL-MSG-INV-BAT-ID                
                   DISPLAY '**  JRNL RC      = ' WS-JRNL-RTRN-CODE      
FCSCHG             DISPLAY '**  CSH COMPANY NO = ' BC-CASH-COMPANY-NO   
FCSCHG             DISPLAY '**  CSH LOC OFF    = ' BC-CASH-LOCAL-OFFICE 
FCSCHG             DISPLAY '**  CSH RPT NUMBER = ' BC-CASH-REPORT-NO    
FCSCHG             DISPLAY '**  DATE REPORT    = ' BC-DATE-CASH-REPORT  
FCSCHG             DISPLAY '** CASH DRAWER ID  = ' BC-CASH-DRAWER-ID    
FCSCHG*            DISPLAY '**  BATCH NO     = ' BC-BATCH-NO                    
                   DISPLAY '**  MISSING FROM BCH_JRNL_CNTL '            
FCSCHG**           DISPLAY '**  LOCAL OFFICE = '                                
FCSCHG**                        BC-LOCAL-OFFICE-ENTRY                           
                   DISPLAY '**  RC           = '                        
                                WS-JRNL-DB2-RETURN                      
                   DISPLAY '**  PROCESSING TERMINATED'                  
                   DISPLAY '*************************************'      
                   PERFORM 9900-ABEND THRU 9900-EXIT                    
               ELSE                                                     
                   MOVE WS-JRNL-DB2-ABEND TO WS-JRNL-RTRN-CODE          
                   DISPLAY '6493 ' WS-JRNL-RTRN-CODE                    
                   DISPLAY '*************************************'      
                   DISPLAY '**  PROCESSING ERROR'                       
                   DISPLAY '**  PARAGRAPH = 6493- '                     
                   DISPLAY '**  SELECT BTCH JRNL CNTL'                  
                   DISPLAY '**  RC        = ' WS-JRNL-RTRN-CODE         
FCSCHG             DISPLAY '**  CSH COMPANY NO = ' BC-CASH-COMPANY-NO   
FCSCHG             DISPLAY '**  CSH LOC OFF    = ' BC-CASH-LOCAL-OFFICE 
FCSCHG             DISPLAY '**  CSH RPT NUMBER = ' BC-CASH-REPORT-NO    
FCSCHG             DISPLAY '**  DATE REPORT    = ' BC-DATE-CASH-REPORT  
FCSCHG             DISPLAY '** CASH DRAWER ID  = ' BC-CASH-DRAWER-ID    
                   DISPLAY '**  PROCESSING TERMINATED'                  
                   DISPLAY '*************************************'      
                   PERFORM 9900-ABEND THRU 9900-EXIT
               END-IF
           END-IF.                   
                                                                        
       6493-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
      *****************************************************************         
      *    UPDATE BATCH JOURNAL CONTROL                                         
      *****************************************************************         
                                                                        
       6494-UPDATE-BATCH-JRNL-CNTRL.                                    
                                                                        
           MOVE '6494' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BCH_JRNL_CNTL                                 
                  SET NO_ITEMS_ENTERED   = :BC-NO-ITEMS-ENTERED,        
                      DATE_LAST_ACTIVITY = IIF(TRY_CONVERT(DATE, 
                                                 :BC-DATE-LAST-ACTIVITY
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-LAST-ACTIVITY
              ) <> 0) OR (LEN(:BC-DATE-LAST-ACTIVITY
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-LAST-ACTIVITY
              ), CONVERT(DATE, :BC-DATE-LAST-ACTIVITY) )       
FCSCHG          WHERE CASH_DRAWER_ID     = :BC-CASH-DRAWER-ID           
MCR310*           AND CASH_COMPANY_NO    = :BC-CASH-COMPANY-NO                  
MCR310            AND CASH_COMPANY_NO    = '01'                         
FCSCHG            AND CASH_LOCAL_OFFICE  = :BC-CASH-LOCAL-OFFICE        
FCSCHG            AND CASH_REPORT_NO     = :BC-CASH-REPORT-NO           
FCSCHG            AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :BC-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:BC-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-CASH-REPORT
              ), CONVERT(DATE, :BC-DATE-CASH-REPORT) )         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BCH_JRNL_CNTL                                         
MFA-TR*           SET NO_ITEMS_ENTERED   = :BC-NO-ITEMS-ENTERED,                
MFA-TR*               DATE_LAST_ACTIVITY = :BC-DATE-LAST-ACTIVITY               
MFA-TR*         WHERE CASH_DRAWER_ID     = :BC-CASH-DRAWER-ID                   
MFA-TR*           AND CASH_COMPANY_NO    = :BC-CASH-COMPANY-NO                  
MFA-TR*           AND CASH_COMPANY_NO    = '01'                                 
MFA-TR*           AND CASH_LOCAL_OFFICE  = :BC-CASH-LOCAL-OFFICE                
MFA-TR*           AND CASH_REPORT_NO     = :BC-CASH-REPORT-NO                   
MFA-TR*           AND DATE_CASH_REPORT   = :BC-DATE-CASH-REPORT                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

FCSCHG*         WHERE LOCAL_OFFICE_ENTRY = :BC-LOCAL-OFFICE-ENTRY               
FCSCHG*           AND BATCH_NO           = :BC-BATCH-NO                         
                                                                        
           MOVE SQLCODE TO WS-JRNL-DB2-RETURN.                          
                                                                        
           IF WS-JRNL-DB2-RETURN EQUAL SUCCESSFUL-CALL                  
               MOVE WS-JRNL-SUCCESS TO WS-JRNL-RTRN-CODE                
               ADD 1 TO WS-JRNL-BC-UPDT-CNTR                            
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '**  PROCESSING ERROR'                           
               DISPLAY '**  PARAGRAPH = 6494- '                         
               DISPLAY '**  UPDATE BTCH JRNL CNTL'                      
               DISPLAY '**  RC        = ' WS-JRNL-DB2-RETURN            
FCSCHG         DISPLAY '**  CSH COMPANY NO = ' BC-CASH-COMPANY-NO       
FCSCHG         DISPLAY '**  CSH LOC OFF    = ' BC-CASH-LOCAL-OFFICE     
FCSCHG         DISPLAY '**  CSH RPT NUMBER = ' BC-CASH-REPORT-NO        
FCSCHG         DISPLAY '**  DATE REPORT    = ' BC-DATE-CASH-REPORT      
FCSCHG         DISPLAY '** CASH DRAWER ID  = ' BC-CASH-DRAWER-ID        
               DISPLAY '**  PROCESSING TERMINATED'                      
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
       6494-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
      *****************************************************************         
      *    UPDATE BATCH JOURNAL CONTROL                                         
      *****************************************************************         
                                                                        
       6495-UPDATE-BATCH-JRNL-CNTRL.                                    
                                                                        
           MOVE '6495' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BCH_JRNL_CNTL                                 
                  SET NO_ITEMS_ENTERED   = :BC-NO-ITEMS-ENTERED,        
                      DATE_LAST_ACTIVITY = IIF(TRY_CONVERT(DATE, 
                                                 :BC-DATE-LAST-ACTIVITY
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-LAST-ACTIVITY
              ) <> 0) OR (LEN(:BC-DATE-LAST-ACTIVITY
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-LAST-ACTIVITY
              ), CONVERT(DATE, :BC-DATE-LAST-ACTIVITY) ),      
                      AMT_CASH_DEBIT     = :BC-AMT-CASH-DEBIT,          
                      AMT_CASH_CREDIT    = :BC-AMT-CASH-CREDIT,         
                      AMT_AR_DEBIT       = :BC-AMT-AR-DEBIT,            
                      AMT_AR_CREDIT      = :BC-AMT-AR-CREDIT,           
                      AMT_CK_ISS_DEBIT   = :BC-AMT-CK-ISS-DEBIT,        
                      AMT_CK_ISS_CREDIT  = :BC-AMT-CK-ISS-CREDIT,       
                      AMT_GL_DEBIT       = :BC-AMT-GL-DEBIT,            
                      AMT_GL_CREDIT      = :BC-AMT-GL-CREDIT            
FCSCHG          WHERE CASH_DRAWER_ID     = :BC-CASH-DRAWER-ID           
MCR310*           AND CASH_COMPANY_NO    = :BC-CASH-COMPANY-NO                  
MCR310            AND CASH_COMPANY_NO    = '01'                         
FCSCHG            AND CASH_LOCAL_OFFICE  = :BC-CASH-LOCAL-OFFICE        
FCSCHG            AND CASH_REPORT_NO     = :BC-CASH-REPORT-NO           
FCSCHG            AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :BC-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:BC-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-CASH-REPORT
              ), CONVERT(DATE, :BC-DATE-CASH-REPORT) )         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BCH_JRNL_CNTL                                         
MFA-TR*           SET NO_ITEMS_ENTERED   = :BC-NO-ITEMS-ENTERED,                
MFA-TR*               DATE_LAST_ACTIVITY = :BC-DATE-LAST-ACTIVITY,              
MFA-TR*               AMT_CASH_DEBIT     = :BC-AMT-CASH-DEBIT,                  
MFA-TR*               AMT_CASH_CREDIT    = :BC-AMT-CASH-CREDIT,                 
MFA-TR*               AMT_AR_DEBIT       = :BC-AMT-AR-DEBIT,                    
MFA-TR*               AMT_AR_CREDIT      = :BC-AMT-AR-CREDIT,                   
MFA-TR*               AMT_CK_ISS_DEBIT   = :BC-AMT-CK-ISS-DEBIT,                
MFA-TR*               AMT_CK_ISS_CREDIT  = :BC-AMT-CK-ISS-CREDIT,               
MFA-TR*               AMT_GL_DEBIT       = :BC-AMT-GL-DEBIT,                    
MFA-TR*               AMT_GL_CREDIT      = :BC-AMT-GL-CREDIT                    
MFA-TR*         WHERE CASH_DRAWER_ID     = :BC-CASH-DRAWER-ID                   
MFA-TR*           AND CASH_COMPANY_NO    = :BC-CASH-COMPANY-NO                  
MFA-TR*           AND CASH_COMPANY_NO    = '01'                                 
MFA-TR*           AND CASH_LOCAL_OFFICE  = :BC-CASH-LOCAL-OFFICE                
MFA-TR*           AND CASH_REPORT_NO     = :BC-CASH-REPORT-NO                   
MFA-TR*           AND DATE_CASH_REPORT   = :BC-DATE-CASH-REPORT                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

FCSCHG*         WHERE LOCAL_OFFICE_ENTRY = :BC-LOCAL-OFFICE-ENTRY               
FCSCHG*           AND BATCH_NO           = :BC-BATCH-NO                         
                                                                        
           MOVE SQLCODE TO WS-JRNL-DB2-RETURN.                          
                                                                        
           IF WS-JRNL-DB2-RETURN EQUAL SUCCESSFUL-CALL                  
               MOVE WS-JRNL-SUCCESS TO WS-JRNL-RTRN-CODE                
               ADD 1 TO WS-JRNL-BC-UPDT-CNTR                            
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '**  PROCESSING ERROR'                           
               DISPLAY '**  PARAGRAPH = 6495- '                         
               DISPLAY '**  UPDATE BTCH JRNL CNTL'                      
               DISPLAY '**  RC        = ' WS-JRNL-DB2-RETURN            
FCSCHG         DISPLAY '**  CSH COMPANY NO = ' BC-CASH-COMPANY-NO       
FCSCHG         DISPLAY '**  CSH LOC OFF    = ' BC-CASH-LOCAL-OFFICE     
FCSCHG         DISPLAY '**  CSH RPT NUMBER = ' BC-CASH-REPORT-NO        
FCSCHG         DISPLAY '**  DATE REPORT    = ' BC-DATE-CASH-REPORT      
FCSCHG         DISPLAY '** CASH DRAWER ID  = ' BC-CASH-DRAWER-ID        
               DISPLAY '**  PROCESSING TERMINATED'                      
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
       6495-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        
      *****************************************************************         
      *    INSERT BATCH JOURNAL                                                 
      *****************************************************************         
                                                                        
       6496-INSERT-BATCH-JRNL.                                          
                                                                        
           MOVE '6496' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_BATCH_JRNL                               
                          (LOCAL_OFFICE,                                
                           COMPANY_NO,                                  
FCSCHG                     CASH_COMPANY_NO,                             
FCSCHG                     CASH_LOCAL_OFFICE,                           
FCSCHG                     CASH_REPORT_NO,                              
FCSCHG                     DATE_CASH_REPORT,                            
FCSCHG                     CASH_DRAWER_ID,                              
                           BATCH_NO,                                    
                           DATE_TRAN,                                   
                           ENTRY_NO,                                    
                           TRAN_APPL_NO,                                
                           JRNL_SORT_ID,                                
                           ACCOUNT_NO,                                  
                           CUSTOMER_NO,                                 
                           GL_ACCT_NO,                                  
                           METER_NO,                                    
                           TRAN_TIME,                                   
                           TRAN_ID,                                     
                           DATE_LAST_ACTION,                            
                           CODE_ENTRY_SOURCE,                           
                           USER_ID,                                     
                           BATCH_SEND_LOC,                              
                           ENTRY_LOC,                                   
                           CODE_JRNL_EXTRACT,                           
                           CODE_STATUS,                                 
                           CODE_TRAN_ERRORS,                            
FCSCHG                     CURRENCY_TYPE,                               
                           TRAN_DATA)                                   
                  VALUES (:BJ-LOCAL-OFFICE,                             
MCR310*                   :BJ-COMPANY-NO,                                       
MCR310                    '01',                                         
MCR310*                   :BJ-CASH-COMPANY-NO,                                  
MCR310                    '01',                                         
FCSCHG                    :BJ-CASH-LOCAL-OFFICE,                        
FCSCHG                    :BJ-CASH-REPORT-NO,                           
FCSCHG                    IIF(TRY_CONVERT(DATE, :BJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :BJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:BJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:BJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :BJ-DATE-CASH-REPORT) ),                        
FCSCHG                    :BJ-CASH-DRAWER-ID,                           
                          :BJ-BATCH-NO,                                 
                          IIF(TRY_CONVERT(DATE, :BJ-DATE-TRAN
              ) IS NULL OR (PATINDEX('%.%', :BJ-DATE-TRAN
              ) <> 0) OR (LEN(:BJ-DATE-TRAN) <> 10), CIS.CHAR2DATE(
                                                          :BJ-DATE-TRAN
              ), CONVERT(DATE, :BJ-DATE-TRAN) ),                               
                          :BJ-ENTRY-NO,                                 
                          :BJ-TRAN-APPL-NO,                             
                          :BJ-JRNL-SORT-ID,                             
                          :BJ-ACCOUNT-NO,                               
                          :BJ-CUSTOMER-NO,                              
                          :BJ-GL-ACCT-NO,                               
                          :BJ-METER-NO,                                 
                          CIS.CHAR2TIME(:BJ-TRAN-TIME),                         
                          :BJ-TRAN-ID,                                  
                          IIF(TRY_CONVERT(DATE, :BJ-DATE-LAST-ACTION
              ) IS NULL OR (PATINDEX('%.%', :BJ-DATE-LAST-ACTION
              ) <> 0) OR (LEN(:BJ-DATE-LAST-ACTION
              ) <> 10), CIS.CHAR2DATE(:BJ-DATE-LAST-ACTION
              ), CONVERT(DATE, :BJ-DATE-LAST-ACTION) ),                        
                          :BJ-CODE-ENTRY-SOURCE,                        
                          :BJ-USER-ID,                                  
                          :BJ-BATCH-SEND-LOC,                           
                          :BJ-ENTRY-LOC,                                
                          :BJ-CODE-JRNL-EXTRACT,                        
                          :BJ-CODE-STATUS,                              
                          :BJ-CODE-TRAN-ERRORS,                         
FCSCHG                    :BJ-CURRENCY-TYPE,                            
                          :BJ-TRAN-DATA)                                
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_BATCH_JRNL                                       
MFA-TR*                   (LOCAL_OFFICE,                                        
MFA-TR*                    COMPANY_NO,                                          
MFA-TR*                    CASH_COMPANY_NO,                                     
MFA-TR*                    CASH_LOCAL_OFFICE,                                   
MFA-TR*                    CASH_REPORT_NO,                                      
MFA-TR*                    DATE_CASH_REPORT,                                    
MFA-TR*                    CASH_DRAWER_ID,                                      
MFA-TR*                    BATCH_NO,                                            
MFA-TR*                    DATE_TRAN,                                           
MFA-TR*                    ENTRY_NO,                                            
MFA-TR*                    TRAN_APPL_NO,                                        
MFA-TR*                    JRNL_SORT_ID,                                        
MFA-TR*                    ACCOUNT_NO,                                          
MFA-TR*                    CUSTOMER_NO,                                         
MFA-TR*                    GL_ACCT_NO,                                          
MFA-TR*                    METER_NO,                                            
MFA-TR*                    TRAN_TIME,                                           
MFA-TR*                    TRAN_ID,                                             
MFA-TR*                    DATE_LAST_ACTION,                                    
MFA-TR*                    CODE_ENTRY_SOURCE,                                   
MFA-TR*                    USER_ID,                                             
MFA-TR*                    BATCH_SEND_LOC,                                      
MFA-TR*                    ENTRY_LOC,                                           
MFA-TR*                    CODE_JRNL_EXTRACT,                                   
MFA-TR*                    CODE_STATUS,                                         
MFA-TR*                    CODE_TRAN_ERRORS,                                    
MFA-TR*                    CURRENCY_TYPE,                                       
MFA-TR*                    TRAN_DATA)                                           
MFA-TR*           VALUES (:BJ-LOCAL-OFFICE,                                     
MFA-TR*                   :BJ-COMPANY-NO,                                       
MFA-TR*                   '01',                                                 
MFA-TR*                   :BJ-CASH-COMPANY-NO,                                  
MFA-TR*                   '01',                                                 
MFA-TR*                   :BJ-CASH-LOCAL-OFFICE,                                
MFA-TR*                   :BJ-CASH-REPORT-NO,                                   
MFA-TR*                   :BJ-DATE-CASH-REPORT,                                 
MFA-TR*                   :BJ-CASH-DRAWER-ID,                                   
MFA-TR*                   :BJ-BATCH-NO,                                         
MFA-TR*                   :BJ-DATE-TRAN,                                        
MFA-TR*                   :BJ-ENTRY-NO,                                         
MFA-TR*                   :BJ-TRAN-APPL-NO,                                     
MFA-TR*                   :BJ-JRNL-SORT-ID,                                     
MFA-TR*                   :BJ-ACCOUNT-NO,                                       
MFA-TR*                   :BJ-CUSTOMER-NO,                                      
MFA-TR*                   :BJ-GL-ACCT-NO,                                       
MFA-TR*                   :BJ-METER-NO,                                         
MFA-TR*                   :BJ-TRAN-TIME,                                        
MFA-TR*                   :BJ-TRAN-ID,                                          
MFA-TR*                   :BJ-DATE-LAST-ACTION,                                 
MFA-TR*                   :BJ-CODE-ENTRY-SOURCE,                                
MFA-TR*                   :BJ-USER-ID,                                          
MFA-TR*                   :BJ-BATCH-SEND-LOC,                                   
MFA-TR*                   :BJ-ENTRY-LOC,                                        
MFA-TR*                   :BJ-CODE-JRNL-EXTRACT,                                
MFA-TR*                   :BJ-CODE-STATUS,                                      
MFA-TR*                   :BJ-CODE-TRAN-ERRORS,                                 
MFA-TR*                   :BJ-CURRENCY-TYPE,                                    
MFA-TR*                   :BJ-TRAN-DATA)                                        
MFA-TR*        END-EXEC.                                                        

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

FCSCHG*                    LOCAL_OFFICE_CODE,                                   
FCSCHG*                   :BJ-LOCAL-OFFICE-CODE,                                
                                                                        
           MOVE SQLCODE TO WS-JRNL-DB2-RETURN.                          
                                                                        
           IF WS-JRNL-DB2-RETURN EQUAL SUCCESSFUL-CALL                  
               MOVE WS-JRNL-SUCCESS TO WS-JRNL-RTRN-CODE                
               ADD 1 TO WS-JRNL-BJ-ISRT-CNTR                            
           ELSE                                                         
               DISPLAY '*************************************'          
               DISPLAY '**  PROCESSING ERROR'                           
               DISPLAY '**  PARAGRAPH = 6496- '                         
               DISPLAY '**  INSERT BATCH JRNL'                          
               DISPLAY '**  LOCAL OFFICE = ' BJ-LOCAL-OFFICE            
FCSCHG         DISPLAY '**  CSH COMPANY NO = ' BJ-CASH-COMPANY-NO       
FCSCHG         DISPLAY '**  CSH LOC OFF    = ' BJ-CASH-LOCAL-OFFICE     
FCSCHG         DISPLAY '**  CSH RPT NUMBER = ' BJ-CASH-REPORT-NO        
FCSCHG         DISPLAY '**  DATE REPORT    = ' BJ-DATE-CASH-REPORT      
FCSCHG         DISPLAY '** CASH DRAWER ID  = ' BJ-CASH-DRAWER-ID        
FCSCHG*        DISPLAY '**  BATCH NO     = ' BJ-BATCH-NO                        
               DISPLAY '**  DATE TRN     = ' BJ-DATE-TRAN               
               DISPLAY '**  ENTRY NO     = ' BJ-ENTRY-NO                
               DISPLAY '**  TRAN APPL    = ' BJ-TRAN-APPL-NO            
               DISPLAY '**  RC           = ' WS-JRNL-DB2-RETURN         
               DISPLAY '**  PROCESSING TERMINATED'                      
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
       6496-EXIT.                                                       
           EXIT.                                                        
BC0895                                                                  
BC0895****************************************************************          
BC0895*  6497-INSERT-BCH-JRNL-CNTRL                                  *          
BC0895****************************************************************          
BC0895 6497-INSERT-BATCH-JRNL-CNTRL.                                    
BC0895     EXEC SQL                                                     
BC0895          INSERT INTO  CSS_BCH_JRNL_CNTL                          
BC0895          (LOCAL_OFFICE_ENTRY,                                    
FCSCHG           CASH_COMPANY_NO,                                       
FCSCHG           CASH_LOCAL_OFFICE,                                     
FCSCHG           CASH_REPORT_NO,                                        
FCSCHG           DATE_CASH_REPORT,                                      
FCSCHG           CASH_DRAWER_ID,                                        
BC0895           BATCH_NO,                                              
BC0895           CODE_BATCH_STATUS,                                     
BC0895           LOCAL_OFFICE_SEND,                                     
BC0895           DATE_BATCH_ENTERED,                                    
BC0895           DATE_LAST_ACTIVITY,                                    
BC0895           NO_ITEMS_ENTERED,                                      
BC0895           AMT_CASH_DEBIT,                                        
BC0895           AMT_CASH_CREDIT,                                       
BC0895           AMT_AR_DEBIT,                                          
BC0895           AMT_AR_CREDIT,                                         
BC0895           AMT_CK_ISS_DEBIT,                                      
BC0895           AMT_CK_ISS_CREDIT,                                     
BC0895           AMT_GL_DEBIT,                                          
BC0895           AMT_GL_CREDIT,                                         
BC0895           AMT_NET_BATCH,                                         
BC0895           NO_ITEMS_POSTED,                                       
BC0895           AMT_BATCH_DEBITS,                                      
FCSCHG           AMT_BATCH_CREDITS )                                    
BC0895      VALUES                                                      
BC0895          (:BC-LOCAL-OFFICE-ENTRY,                                
MCR310*          :BC-CASH-COMPANY-NO,                                           
MCR310           '01',                                                  
FCSCHG           :BC-CASH-LOCAL-OFFICE,                                 
FCSCHG           :BC-CASH-REPORT-NO,                                    
FCSCHG           IIF(TRY_CONVERT(DATE, :BC-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:BC-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-CASH-REPORT
              ), CONVERT(DATE, :BC-DATE-CASH-REPORT) ),                        
FCSCHG           :BC-CASH-DRAWER-ID,                                    
BC0895           :BC-BATCH-NO,                                          
BC0895           :BC-CODE-BATCH-STATUS,                                 
BC0895           :BC-LOCAL-OFFICE-SEND,                                 
BC0895           IIF(TRY_CONVERT(DATE, :BC-DATE-BATCH-ENTERED
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-BATCH-ENTERED
              ) <> 0) OR (LEN(:BC-DATE-BATCH-ENTERED
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-BATCH-ENTERED
              ), CONVERT(DATE, :BC-DATE-BATCH-ENTERED) ),                      
BC0895           IIF(TRY_CONVERT(DATE, :BC-DATE-LAST-ACTIVITY
              ) IS NULL OR (PATINDEX('%.%', :BC-DATE-LAST-ACTIVITY
              ) <> 0) OR (LEN(:BC-DATE-LAST-ACTIVITY
              ) <> 10), CIS.CHAR2DATE(:BC-DATE-LAST-ACTIVITY
              ), CONVERT(DATE, :BC-DATE-LAST-ACTIVITY) ),                      
BC0895           :BC-NO-ITEMS-ENTERED,                                  
BC0895           :BC-AMT-CASH-DEBIT,                                    
BC0895           :BC-AMT-CASH-CREDIT,                                   
BC0895           :BC-AMT-AR-DEBIT,                                      
BC0895           :BC-AMT-AR-CREDIT,                                     
BC0895           :BC-AMT-CK-ISS-DEBIT,                                  
BC0895           :BC-AMT-CK-ISS-CREDIT,                                 
BC0895           :BC-AMT-GL-DEBIT,                                      
BC0895           :BC-AMT-GL-CREDIT,                                     
BC0895           :BC-AMT-NET-BATCH,                                     
BC0895           :BC-NO-ITEMS-POSTED,                                   
BC0895           :BC-AMT-BATCH-DEBITS,                                  
FCSCHG           :BC-AMT-BATCH-CREDITS )                                
BC0895     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO  CSS_BCH_JRNL_CNTL                                  
MFA-TR*         (LOCAL_OFFICE_ENTRY,                                            
MFA-TR*          CASH_COMPANY_NO,                                               
MFA-TR*          CASH_LOCAL_OFFICE,                                             
MFA-TR*          CASH_REPORT_NO,                                                
MFA-TR*          DATE_CASH_REPORT,                                              
MFA-TR*          CASH_DRAWER_ID,                                                
MFA-TR*          BATCH_NO,                                                      
MFA-TR*          CODE_BATCH_STATUS,                                             
MFA-TR*          LOCAL_OFFICE_SEND,                                             
MFA-TR*          DATE_BATCH_ENTERED,                                            
MFA-TR*          DATE_LAST_ACTIVITY,                                            
MFA-TR*          NO_ITEMS_ENTERED,                                              
MFA-TR*          AMT_CASH_DEBIT,                                                
MFA-TR*          AMT_CASH_CREDIT,                                               
MFA-TR*          AMT_AR_DEBIT,                                                  
MFA-TR*          AMT_AR_CREDIT,                                                 
MFA-TR*          AMT_CK_ISS_DEBIT,                                              
MFA-TR*          AMT_CK_ISS_CREDIT,                                             
MFA-TR*          AMT_GL_DEBIT,                                                  
MFA-TR*          AMT_GL_CREDIT,                                                 
MFA-TR*          AMT_NET_BATCH,                                                 
MFA-TR*          NO_ITEMS_POSTED,                                               
MFA-TR*          AMT_BATCH_DEBITS,                                              
MFA-TR*          AMT_BATCH_CREDITS )                                            
MFA-TR*     VALUES                                                              
MFA-TR*         (:BC-LOCAL-OFFICE-ENTRY,                                        
MFA-TR*          :BC-CASH-COMPANY-NO,                                           
MFA-TR*          '01',                                                          
MFA-TR*          :BC-CASH-LOCAL-OFFICE,                                         
MFA-TR*          :BC-CASH-REPORT-NO,                                            
MFA-TR*          :BC-DATE-CASH-REPORT,                                          
MFA-TR*          :BC-CASH-DRAWER-ID,                                            
MFA-TR*          :BC-BATCH-NO,                                                  
MFA-TR*          :BC-CODE-BATCH-STATUS,                                         
MFA-TR*          :BC-LOCAL-OFFICE-SEND,                                         
MFA-TR*          :BC-DATE-BATCH-ENTERED,                                        
MFA-TR*          :BC-DATE-LAST-ACTIVITY,                                        
MFA-TR*          :BC-NO-ITEMS-ENTERED,                                          
MFA-TR*          :BC-AMT-CASH-DEBIT,                                            
MFA-TR*          :BC-AMT-CASH-CREDIT,                                           
MFA-TR*          :BC-AMT-AR-DEBIT,                                              
MFA-TR*          :BC-AMT-AR-CREDIT,                                             
MFA-TR*          :BC-AMT-CK-ISS-DEBIT,                                          
MFA-TR*          :BC-AMT-CK-ISS-CREDIT,                                         
MFA-TR*          :BC-AMT-GL-DEBIT,                                              
MFA-TR*          :BC-AMT-GL-CREDIT,                                             
MFA-TR*          :BC-AMT-NET-BATCH,                                             
MFA-TR*          :BC-NO-ITEMS-POSTED,                                           
MFA-TR*          :BC-AMT-BATCH-DEBITS,                                          
MFA-TR*          :BC-AMT-BATCH-CREDITS )                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

FCSCHG*          AMT_BATCH_CREDITS,                                             
FCSCHG*          COMPANY_NO )                                                   
FCSCHG*          :BC-AMT-BATCH-CREDITS,                                         
FCSCHG*          :BC-COMPANY-NO )                                               
BC0895*                                                                         
BC0895     MOVE SQLCODE TO WS-JRNL-DB2-RETURN.                          
BC0895                                                                  
BC0895     IF WS-JRNL-DB2-RETURN EQUAL SUCCESSFUL-CALL                  
BC0895         MOVE WS-JRNL-SUCCESS TO WS-JRNL-RTRN-CODE                
BC0895         ADD 1 TO WS-JRNL-BJ-ISRT-CNTR                            
BC0895     ELSE                                                         
BC0895         DISPLAY '*************************************'          
BC0895         DISPLAY '**  PROCESSING ERROR'                           
BC0895         DISPLAY '**  PARAGRAPH = 6497- '                         
BC0895         DISPLAY '**  INSERT BATCH JRNL'                          
FCSCHG**       DISPLAY '**  LOCAL OFFICE = ' BC-LOCAL-OFFICE-ENTRY              
FCSCHG         DISPLAY '**  CSH COMPANY NO = ' BC-CASH-COMPANY-NO       
FCSCHG         DISPLAY '**  CSH LOC OFF    = ' BC-CASH-LOCAL-OFFICE     
FCSCHG         DISPLAY '**  CSH RPT NUMBER = ' BC-CASH-REPORT-NO        
FCSCHG         DISPLAY '**  DATE REPORT    = ' BC-DATE-CASH-REPORT      
FCSCHG         DISPLAY '** CASH DRAWER ID  = ' BC-CASH-DRAWER-ID        
FCSCHG*        DISPLAY '**  BATCH NO     = ' BC-BATCH-NO                        
FCSCHG*        DISPLAY '**  DATE TRN     = ' BC-COMPANY-NO                      
BC0895         DISPLAY '**  RC           = ' WS-JRNL-DB2-RETURN         
BC0895         DISPLAY '**  PROCESSING TERMINATED'                      
BC0895         DISPLAY '*************************************'          
BC0895         PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
BC0895 6497-EXIT.                                                       
BC0895     EXIT.                                                        
BC0895                                                                  
      *****************************************************************         
      *    SELECT GENERAL LEDGER NO                                             
      *****************************************************************         
                                                                        
       6498-SELECT-GEN-LED-ACCT-NO.                                     
                                                                        
           MOVE '6498' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               SELECT  GL_ACCT_NO                                       
                 INTO :GO-GL-ACCT-NO                                    
                 FROM  CSS_GL_ACCT_NO                                   
MCR310*         WHERE  COMPANY_NO         = :GO-COMPANY-NO                      
MCR310          WHERE  COMPANY_NO         = '01'                        
                  AND  GL_ACCT_NAME       = :GO-GL-ACCT-NAME            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-JRNL-DB2-RETURN.                          
                                                                        
           IF WS-JRNL-DB2-RETURN EQUAL SUCCESSFUL-CALL                  
               MOVE WS-JRNL-SUCCESS TO WS-JRNL-RTRN-CODE                
           ELSE                                                         
               MOVE WS-JRNL-INVALID-OPER TO WS-JRNL-RTRN-CODE           
               DISPLAY '*************************************'          
               DISPLAY '**  PROCESSING ERROR'                           
               DISPLAY '**  PARAGRAPH    = 6498- '                      
               DISPLAY '**  ' WS-JRNL-MSG-INV-BAT-ID                    
               DISPLAY '**  JRNL RC      = ' WS-JRNL-RTRN-CODE          
               DISPLAY '**  CSH COMPANY NO = ' BC-CASH-COMPANY-NO       
               DISPLAY '**  GL ACCT NAME   = ' GO-GL-ACCT-NAME          
               DISPLAY '**  GL ACCT NO     '                            
               DISPLAY '**  MISSING FROM CSS_GL_ACCT_NO'                
               DISPLAY '**  RC           = '                            
                                WS-JRNL-DB2-RETURN                      
               DISPLAY '**  PROCESSING TERMINATED'                      
               DISPLAY '*************************************'          
               PERFORM 9900-ABEND THRU 9900-EXIT
           END-IF.                       
                                                                        
       6498-EXIT.                                                       
           EXIT.                                                        
