Rem
Rem $Header: javavm/ojvmwcu/install/configure_ojvmwcu.sql /main/4 2016/03/18 00:12:37 kdere Exp $
Rem
Rem configure_ojvmwcu.sql
Rem
Rem Copyright (c) 2015, 2016, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      configure_ojvmwcu.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    BEGIN SQL_FILE_METADATA 
Rem    SQL_SOURCE_FILE: javavm/ojvmwcu/configure_ojvmwcu.sql 
Rem    SQL_SHIPPED_FILE: 
Rem    SQL_PHASE: 
Rem    SQL_STARTUP_MODE: NORMAL 
Rem    SQL_IGNORABLE_ERRORS: NONE 
Rem    SQL_CALLING_FILE: 
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    kdere       03/14/16 - Remove permission createAccessControlContext
Rem    kdere       03/08/16 - Adding user parameter to export procedures
Rem    kdere       10/15/15 - Adding permissions for SOAP part
Rem    kdere       08/13/15 - Created
Rem

whenever sqlerror exit sql.sqlcode

create or replace package ojvmwcu_sys authid current_user as
 procedure require_sys;
 procedure create_user;
 procedure create_role;
 procedure configure;
 procedure load_jar(filename varchar2);
 procedure drop_jar(filename varchar2);
 procedure export_class(uname varchar2, name varchar2);
 procedure export_resource(uname varchar2, name varchar2);
end ojvmwcu_sys;
/ 

create or replace package body ojvmwcu_sys as

install_schema  VARCHAR2(20) := 'OJVMWCU_INSTALL';

procedure require_sys as
begin
  if login_user != 'SYS' then
    declare
      foo exception;
      pragma exception_init(foo,-1031);
    begin
      raise foo;
    end;
  end if;
end;

procedure create_user as
  user_exists integer := 0;
begin
  select count(1) into user_exists from dba_users where username = install_schema;
  if user_exists != 0 then
    execute immediate 'drop user ' || install_schema || ' cascade';
  end if;
  execute immediate 'create user ' || install_schema || ' identified by &1';
  dbms_java.grant_permission( 'OJVMWCU_INSTALL', 'SYS:java.net.SocketPermission', '*', 'connect,resolve' );
  dbms_java.grant_permission( 'OJVMWCU_INSTALL', 'SYS:java.lang.RuntimePermission', 'accessDeclaredMembers', '' );
  dbms_java.grant_permission( 'OJVMWCU_INSTALL', 'SYS:java.lang.reflect.ReflectPermission', 'suppressAccessChecks', '' );
  dbms_java.grant_permission( 'OJVMWCU_INSTALL', 'SYS:java.lang.RuntimePermission', 'getClassLoader', '' );
  dbms_java.grant_permission( 'OJVMWCU_INSTALL', 'SYS:java.util.PropertyPermission', '*', 'read,write' );
  dbms_java.grant_permission( 'OJVMWCU_INSTALL', 'SYS:java.lang.RuntimePermission','setFactory', '' );
  dbms_java.grant_permission( 'OJVMWCU_INSTALL', 'SYS:java.net.NetPermission', 'setDefaultAuthenticator', '' );       
end;

procedure load_jar(filename varchar2) as
  verifier_status number;
  ORACLE_HOME varchar2(100);
  trash varchar2(300) := dbms_java.endsession_and_related_state;
begin
  require_sys;
  verifier_status := dbms_java.option_controller(2,3);
  begin
    dbms_output.put_line('WCU: Loading - '||filename);
    dbms_system.get_env('ORACLE_HOME', ORACLE_HOME);
    if ORACLE_HOME is null then
      dbms_java.loadjava('-v -force -schema ' || install_schema || ' -resolver ((* ' || install_schema || ')(* SYS)(* -)) -resolve  javavm/ojvmwcu/lib/' || filename);
    else
      dbms_java.loadjava('-v -force -schema ' || install_schema || ' -resolver ((* ' || install_schema || ')(* SYS)(* -)) -resolve ' || ORACLE_HOME || '/javavm/ojvmwcu/lib/' || filename);
    end if;
    if verifier_status = 1 then
       verifier_status := dbms_java.option_controller(2,2);
    end if;
  exception when others then
    if verifier_status = 1 then
       verifier_status := dbms_java.option_controller(2,2);
    end if;
    raise;
  end;
end;

procedure drop_jar(filename varchar2) as
  verifier_status number;
  trash varchar2(300) := dbms_java.endsession_and_related_state;
begin
  require_sys;
  verifier_status := dbms_java.option_controller(2,3);
  begin
    dbms_output.put_line('WCU: Dropping - '||filename);
    dbms_java.dropjava('-v -schema ' || install_schema || ' -synonym ojvmwcu/lib/'||filename);
    if verifier_status = 1 then
       verifier_status := dbms_java.option_controller(2,2);
    end if;
  exception when others then
    if verifier_status = 1 then
       verifier_status := dbms_java.option_controller(2,2);
    end if;
    raise;
  end;
end;


procedure create_role as
begin
  require_sys;
  initjvmaux.drp('drop role ojvmwcu');
  initjvmaux.exec('create role ojvmwcu');
  initjvmaux.exec('grant ojvmwcu to SYS');
  -- grant ojvmwcu-specific guarding permisssions
  dbms_java.grant_permission( 'OJVMWCU', 'SYS:java.lang.RuntimePermission', 'ojvmwcuUser', '' );  
  dbms_java.grant_permission( 'OJVMWCU', 'SYS:java.net.SocketPermission', '*', 'connect,resolve' );
  dbms_java.grant_permission( 'OJVMWCU', 'SYS:java.lang.RuntimePermission', 'setContextClassLoader', '' );
  dbms_java.grant_permission( 'OJVMWCU', 'SYS:java.lang.RuntimePermission', 'accessDeclaredMembers', '' );
  execute immediate 'grant ojvmwcu to '|| install_schema;
end;

procedure configure as 
begin
  create_user;
  create_role;
end;

procedure export_class(uname varchar2, name varchar2) as
  id varchar2(256);
  ojvmwcuuser varchar2(256); 
begin
  require_sys;
  id := sys.dbms_assert.enquote_name(name, false)  ;
  ojvmwcuuser := sys.dbms_assert.schema_name(uname); 
  execute immediate 'grant execute on ' || install_schema || '.' || id || ' to ' || ojvmwcuuser;
  execute immediate 'create or replace synonym ' || ojvmwcuuser || '.' || id || ' for ' || 
     install_schema || '.' || id;
end;

procedure export_resource(uname varchar2, name varchar2) as
  id varchar2(256);
  ojvmwcuuser varchar2(256); 
begin
  require_sys;
  id := sys.dbms_assert.enquote_name(name, false)  ;
  ojvmwcuuser := sys.dbms_assert.schema_name(uname); 
  execute immediate 'grant execute on java resource ' || install_schema || '.' || id || ' to ' || ojvmwcuuser;
  execute immediate 'create or replace synonym ' || ojvmwcuuser || '.' || id || ' for ' || 
     install_schema || '.' || id;
end;
end ojvmwcu_sys;
/

call dbms_output.put_line('WCU: Configuring ojvmwcu'); 
call ojvmwcu_sys.configure();
call dbms_output.put_line('WCU: Done Configuring ojvmwcu'); 
