#!/usr/local/bin/perl
# 
# $Header: javavm/ojvmwcu/bin/ojvmwcu.pl /main/8 2016/06/08 04:26:03 kdere Exp $
#
# ojvmwcu.pl
# 
# Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      ojvmwcu.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    kdere       10/14/15 - Adding Security jar
#    kdere       07/29/15 - Creation
# 

use Env qw($JAVA_HOME);
use Env qw($ORACLE_HOME);
use Env qw($OSTYPE);
use Config;
use File::Spec::Functions;

$OSTYPE = $Config{osname};
$OJVMWCU_JAR_PATH = catfile($ORACLE_HOME,'javavm','ojvmwcu','lib','ojvmwcu.jar');
$OJVMWCU_SECURITY_JAR = catfile($ORACLE_HOME,'javavm','ojvmwcu','lib','ojvmwcu-security.jar');
$JAVAX_API_JAR = catfile($ORACLE_HOME,'javavm','ojvmwcu','lib','oracle-jaxrs-ri.jar');
$OJVMWCU_LIB = catfile($ORACLE_HOME,'javavm','ojvmwcu','lib','*');
$AURORA_ZIP_PATH = catfile($ORACLE_HOME,'javavm','lib','aurora.zip');
$OJDBC_JAR_PATH = catfile($ORACLE_HOME,'jdbc','lib','ojdbc8.jar');

if ( $JAVA_HOME ) {
  print "OjvmWCU : Using JAVA_HOME as $JAVA_HOME\n";
} else {
  print "OjvmWCU : JAVA_HOME is not set. Please make sure JAVA_HOME is set prior to running tool\n";
  exit(0);
}

if( index("$OSTYPE", "linux") != -1 || index("$OSTYPE", "solaris") != -1) {
  $CLASS_PATH = "$OJVMWCU_JAR_PATH:$AURORA_ZIP_PATH:$OJDBC_JAR_PATH:$OJVMWCU_LIB:$JAVAX_API_JAR";
  $ARG_CLASS_PATH = "$OJDBC_JAR_PATH:$OJVMWCU_SECURITY_JAR:$OJVMWCU_LIB:$JAVAX_API_JAR";
} else { 
  $CLASS_PATH = "$OJVMWCU_JAR_PATH;$AURORA_ZIP_PATH;$OJDBC_JAR_PATH;$OJVMWCU_LIB;$JAVAX_API_JAR";
  $ARG_CLASS_PATH = "$OJDBC_JAR_PATH;$OJVMWCU_SECURITY_JAR;$OJVMWCU_LIB;$JAVAX_API_JAR";
}

$JAVA_CMD = "java -cp $CLASS_PATH oracle.aurora.server.tools.ojvmwcu.OjvmWCU -cp $ARG_CLASS_PATH @ARGV";

system "$JAVA_CMD";
