@echo off

REM **********************************************************************
REM Copyright (c) 2007, 2011, Oracle and/or its affiliates. 
REM All rights reserved. 
REM
REM   DESCRIPTION
REM       Flattens the instant client home
REM
REM   MODIFIED   (MM/DD/YY)
REM   scravind    06/21/11 - Removing OH\light before moving contents of
REM                          OH\instantClient\light to OH\light for lrg problem
REM                          id 5665724
REM   rochang     08/17/07 - Creation
REM **********************************************************************


REM **********************************************************************
REM  The enabledelayedexpansion option is required to set the variables
REM  properly for each iteration through the for loop.
REM **********************************************************************

setlocal EnableDelayedExpansion
set OH=%1
cd /D %OH%


REM **********************************************************************
REM  Need to move %OH%\instantclient\light directory to %OH%\light so
REM  that the contents of this directory is preserved and not flattenten
REM  by the rest of the batch file.
REM **********************************************************************

if exist %OH%\instantclient\light (
    if exist %OH%\instantclient\light (
	rmdir /s /q %OH%\light > NUL 2>&1
    )
    mkdir %OH%\light
    cd /D %OH%\instantclient\light
    for /R %%L in (*) do (
        copy %%L %OH%\light > NUL 2>&1
    )
    cd %OH%
    rmdir /s /q %OH%\instantclient\light > NUL 2>&1

)


Set FLATTEN_FILE_LIST=%OH%\flatten_file_list

rem ***********************************************************
rem make sure $OHOME/flatten_file_list file exist 
rem ***********************************************************
    IF NOT EXIST %flatten_file_list% (
	echo "%FLATTEN_FILE_LIST% : does not exists"
	goto end
    ) ELSE (
	echo "%FLATTEN_FILE_LIST% : does exists"


    )

rem ***********************************************************
rem moving the files mentioned in flatten file list to OH
rem ***********************************************************

:ProcessFiles
FOR /F "tokens=1" %%i in (%flatten_file_list%) do (
 echo move /Y %OH%\%%i %OH%
 move /Y %OH%\%%i %OH% > NUL 2>&1
)

rem ***********************************************************
rem removing the folders after moving the files if they are empty
rem ***********************************************************


:RemoveEmptyFolders
FOR /F "tokens=1" %%i in (%flatten_file_list%) do (
	for %%F in (%OH%\%%i) do rmdir /q %%~dpF  > NUL 2>&1

	
)
:end


 cd /D %OH%

endlocal


endlocal
