#!/usr/bin/perl

package module::CommandOptions;

use warnings;
use strict;

use Exporter qw(import);

our @EXPORT_OK = qw(processArgs processOpts processSwitch addOpt addOptAtBeginning removeOpt removeAllOpt getArgumentCnt getArguments getOptValue optExists isDescSession isActionSession isApplySession isRollbackSession isResumeSession);
our %commandOpts= ();
our @commandOptsArray= ();
my $argumentSize=$#ARGV;
my @orginalArgs=@ARGV;

 sub addOptAtBeginning{
    my $key = $_[0];
    my $value = $_[1];
    $commandOpts{$key}=$value;
    unshift @commandOptsArray, $key;
 }

 sub addOpt{
    my $index=getArgumentCnt();
    my $key = $_[0];
    my $value = $_[1];
    $commandOpts{$key}=$value;
    $commandOptsArray[$index]=$key;
  }
  
  sub removeOpt{
   my $key = $_[0];
   if(exists $commandOpts{$key}){
    delete($commandOpts{$key});
    my $index = 0;
    $index++ until $commandOptsArray[$index] eq $key;{splice( @commandOptsArray, $index, 1 );}
    return 1; 
   }
   
   return 0;
 }
 
  sub removeAllOpt{
   %commandOpts = ();
   @commandOptsArray = ();
   return 0;
 }
  
  sub getArgumentCnt(){
    my @keys = keys %commandOpts;
    my $mysize = @keys;
    return $mysize;
  }
  
  #This will return value only for option not for switch/values.
  sub getOptValue{
    my $key = $_[0];
    return $commandOpts{$key}
  }
  
  #This will 1 if the key is available Otherwise return 0.
   sub optExists{
    my $key = $_[0];
    my $exist=exists($commandOpts{$key})?1:0;
    return $exist;
  }
  
 sub isDescSession{
  my $_scriptDir=$0;
  return optExists('help')==1 || optExists('version')==1 || optExists('lsphases')==1 || optExists('lsplans')==1;
 }
 
 sub isActionSession{
  return optExists('action');
 }
 
 sub isApplySession{
  return optExists('apply');
 }
 
 
 sub isRollbackSession{
  return optExists('rollback');
 }
  
 sub isResumeSession{
  return optExists('resume');
 }
   
 sub processArgs{
     addOpt($_[0],"arg");
 }
   
  sub processOpts{
    addOpt($_[0],$_[1]);
  }
  
  sub processSwitch{
    addOpt($_[0],"switch");
  }
 
 sub getArguments{
   my $value="";
   my $arguments="";
   foreach my $key (@commandOptsArray) { 
    $value=$commandOpts{$key};
    if($value eq "arg"){
       $arguments=$arguments.' '.$key;
    } elsif( $value eq "switch"){
       $arguments=$arguments.' -'.$key;
    } else{
       $arguments=$arguments.' -'.$key.' '.$value;
    }
  } 
  $arguments =~ s/^\s+|\s+$//g;
  return $arguments;
}

1;