/* $Header: install/jsrc/installer/src/oracle/install/ivw/client/resource/ClientDialogLabelResID.java.pp /main/36 2014/11/19 21:24:15 haagrawa Exp $ */

/* Copyright (c) 2008, 2014, Oracle and/or its affiliates. 
All rights reserved.*/

/*
	DESCRIPTION
		<short description of component this file declares/defines>

	PRIVATE CLASSES
		<list of private classes defined - with one-line descriptions>

	NOTES
		<other useful comments, qualifications, etc.>

	MODIFIED		(MM/DD/YY)
	 haagrawa  11/18/14 - Fix Bug# 20048203
	 haagrawa  01/11/13 - fix for bug #16911368
	 pvallam   01/10/13 - XbranchMerge pvallam_bug-16071058 from
	                        st_install_12.1.0.1
	 pvallam   12/27/12 - updating winsec text prompt
         jaikrish  03/12/12 - WinSec Client label changes.
         jaikrish  01/29/11 - CMAN changes

         pvallam   10/14/11 - updating the text in train to read Software
                              Updates instead of Download Software Updates
         jaikrish  07/20/11 - Updated label Oracle Service User
         gramamur  05/12/11 - Adding label Oracle Service User
         pvallam   04/26/11 - XbranchMerge pvallam_bug-11770204_11203 from
                              st_install_11.2.0
         gramamur  03/02/11 - Adding tag for windows security option
         pvallam   02/15/11 - adding description for mts port number
         xiaofwan  06/07/10 - Fix bug 9787061
         svaggu    01/13/10 - XbranchMerge svaggu_bug-9241511 from
                              st_install_11.2.0.1.0
         dschrein  10/26/09 - UPGRADE
         pvallam   01/07/10 - adding entry for finish updates
         rmallego  06/15/09 - Changing hard coded installation sizes to place
                              holders
         sangkuma  06/09/09 - Importing Updates
         pvallam   06/04/09 - updating the label of install location
         rochang   05/28/09 - Updating scheduler agent dialog text for bug
                              8555152
         rochang   04/28/09 - Adding keyboard mnemonics
         sangkuma  04/07/09 - Importing Updates
         mwidjaja  03/04/09 - Added scheduler agent in client custom
         mwidjaja  02/24/09 - Updated images
         pvallam   09/12/08 - adding labels for ntoramts dialog
         poosrini  08/22/08 - Inventory locaiton label in Summary
	 poosrini  06/09/08 - Updated descriptions for ORACLE_BASE & ORACLE_HOME fields - bugs 7117382 & 7129921 - text approved by Matt, Doug and Saar
	 xiaofwan  05/13/08 - Update the description for Oracle home in the install
	                      dialog
	 mwidjaja  03/21/08 - Added language panel
		dschrein	 02/04/08 - creation
 */

/**
 *  @version $Header: install/jsrc/installer/src/oracle/install/ivw/client/resource/ClientDialogLabelResID.java.pp /main/36 2014/11/19 21:24:15 haagrawa Exp $
 *  @author  dschrein
 *  @since	release specific (what release of product did this appear in)
 */

package oracle.install.ivw.client.resource;

import java.util.ListResourceBundle;

public class ClientDialogLabelResID extends ListResourceBundle
{
		static final Object[][] mesgKey =
	{
		{"application.name","Oracle Database Client @<DBNRMAJVSNLETTER_STR>@ Release @<DB_VERSION_SECOND_DIGIT>@ Installer"},
                {"oracle.network.cman.CMAN","Services For Oracle Connection Manager"},
		{"oracle.rdbms.scheduler.SchedulerAgent","Oracle Services For Scheduler Agent"},
		{"application.logo","/oracle/install/ivw/client/resource/image/logo.png"},
		{"application.splash","/oracle/install/ivw/client/resource/image/splash.gif"},
		// Page titles, I gather
		{"inventoryPage.name","Create Inventory"},
		{"getOracleHome.name","Specify Installation Location"},
		{"clientInstallType.name","Select Installation Type"},
		{"clientInstallType.accessibleDescription","What type of Installation do you want?"},
		{"clientInstallMode.name","Select Installation Mode"},
		{"checkPrereqs.name","Perform Prerequisite Checks"},
		{"summary.name","Summary"},
		{"clientCustomInstall.name","Available Product Components"},
		{"mtsDialog.name","Oracle Services for Microsoft Transaction Services"},
		{"mtsDialog.tag","Oracle Services for MTS"},
		{"schedulerAgent.name","Oracle Database Scheduler Agent"},
		{"schedulerAgent.tag","Scheduler Agent"},
		{"setup.name","Install Product"},
		{"finish.name","Finish"},
	        {"finishupdates.name","Finish Updates"},
		{"recordingFinished.name","Recording Finish"},
		// what is this?  why description instead of name?
		{"setup.description","Oracle Client Installation"},
		{"configJob.description","Oracle Client Configuration"},
		{"wizard.titleBar.wizardName","Oracle Database Client @<DBNRMAJVSNLETTER_STR>@ Release @<DB_VERSION_SECOND_DIGIT>@ Installer"},
		// Windows Security option settings
		{"getWindowsSecureOptionDetails.name","Specify Oracle Home User"},
		{"getWindowsSecureOptionDetails.tag","Oracle Home User Selection"},

		{"productLanguage.name","Select Product Languages"},
                {
                          "AutoUpdatesOptionsUI.name",
                          "Download Software Updates"
                },
                {
                          "AutoUpdatesOptionsUI.tag",
                          "Software Updates"
                },
                {
                           "UpdatesListUI.name",
                           "Apply Software Updates"
                },

	// Install Type dialog labels
		{
				"INSTALL_CLIENT_INSTALL_TYPE_DLG_PROMPT",
				"What type of Installation do you want?"
		},
		{
				"INSTALL_CLIENT_INSTALL_TYPE_DLG_INSTANTCLIENT_LABEL",
				"In&stantClient ({0})"
		},
		{
				"INSTALL_CLIENT_INSTALL_TYPE_DLG_INSTANTCLIENT_PROMPT",
				"Installs Instant Client Software"
		},
		{
				"INSTALL_CLIENT_INSTALL_TYPE_DLG_ADMINISTRATOR_LABEL",
				"&Administrator ({0})"
		},
		{
				"INSTALL_CLIENT_INSTALL_TYPE_DLG_ADMINISTRATOR_PROMPT",
				"Installs the management console, management tools, networking services, utilities and basic client software."
		},
		{
				"INSTALL_CLIENT_INSTALL_TYPE_DLG_RUNTIME_LABEL",
				"&Runtime ({0})"
		},
		{
				"INSTALL_CLIENT_INSTALL_TYPE_DLG_RUNTIME_PROMPT",
				"Installs tools for developing applications, networking services and basic client software."
		},
		{
				"INSTALL_CLIENT_INSTALL_TYPE_DLG_CUSTOM_LABEL",
				"&Custom"
		},
		{
				"INSTALL_CLIENT_INSTALL_TYPE_DLG_CUSTOM_PROMPT",
				"Enables you to choose individual components to install."
		},
        {
                "INSTALL_CLIENT_INSTALL_TYPE_DLG_UPGRADE_LABEL",
                "&Upgrade"
        },
        {
                "INSTALL_CLIENT_INSTALL_TYPE_DLG_UPGRADE_PROMPT",
                "Updates existing client software with the current version."
        },		
        // Install Mode (new vs. upgrade) Labels
        {
            "INSTALL_CLIENT_INSTALL_MODE_PROMPT",
            "Choose a mode of installation."
        },
        {
            "INSTALL_CLIENT_INSTALL_MODE_NEWINSTALL_LABEL",
            "New &Install"
        },
        {
            "INSTALL_CLIENT_INSTALL_MODE_NEWINSTALL_PROMPT",
            "Installs client software into a new location."
        },
        {
            "INSTALL_CLIENT_INSTALL_MODE_UPGRADE_LABEL",
            "&Upgrade"
        },
        {
            "INSTALL_CLIENT_INSTALL_MODE_UPGRADE_PROMPT",
            "Updates existing client software with the current version."
        },


		// Summary dialog labels
		{
			"INSTALL_CLIENT_SUMMARY_GLOBAL_SETTING_CATEGORY",
			"Global Settings"
		},
		{
			"INSTALL_CLIENT_SUMMARY_USER_DETAIL_CATEGORY",
			"User and Group information"
		},
		{
			"INSTALL_CLIENT_SUMMARY_INVENTORY_CATEGORY",
			"Inventory information"
		},		
		{
			"INSTALL_CLIENT_SUMMARY_INVENTORY_LOCATION",
			"Inventory location."
		},
		{ 
			"INSTALL_CLIENT_SUMMARY_TITLE_ORACLE_BASE", 
			"Oracle Base"
		},
		{
			"INSTALL_CLIENT_SUMMARY_TITLE_ORACLE_HOME",
			"Oracle Home location"
		},
		{
			"INSTALL_CLIENT_SUMMARY_TITLE_ORACLE_HOME_NAME",
			"Oracle Home Name"
		},
		{
			"INSTALL_CLIENT_SUMMARY_TITLE_SOURCE_LOC",
			"Source Location"
		},
		{
			"INSTALL_CLIENT_SUMMARY_INSTALL_USER",
			"Username:"
		},
		{
			"INSTALL_CLIENT_SUMMARY_OPER_GROUP",
			"oraInventory group"
		},
		{
			"INSTALL_CLIENT_SUMMARY_INSTALL_METHOD",
			"Install Method"
		},
		/* seems silly to define these here and for the install types dialog
		but for the fact that the former contains the size (919 MB)
		the size could be a separate String though */
		{
			"INSTALL_CLIENT_SUMMARY_TYPE_LABEL",
			"Install Type"
		},
		{
			"INSTALL_CLIENT_SUMMARY_TYPE_INSTANTCLIENT_LABEL",
			"InstantClient"
		},
		{
			"INSTALL_CLIENT_SUMMARY_TYPE_ADMINISTRATOR_LABEL",
			"Administrator"
		},
		{
			"INSTALL_CLIENT_SUMMARY_TYPE_RUNTIME_LABEL",
			"Runtime"
		},
		{
			"INSTALL_CLIENT_SUMMARY_TYPE_CUSTOM_LABEL",
			"Custom"
		},
	    {
            "INSTALL_CLIENT_SUMMARY_TYPE_UPGRADE_LABEL",
            "Upgrade"
        },

		/* end of disputed section */
		{
			"INSTALL_CLIENT_SUMMARY_DISK_SPACE",
			"Disk Space"
		},
		{
			"INSTALL_CLIENT_SUMMARY_DISK_SPACE_REQUIRED",
			"required {0} available {1}"
		},
		
		// Install location dialog labels
		{
			"INSTALL_CLIENT_LOCATION_DLG_LABEL_ORAHOME_DESC",
			"Specify a location for storing Oracle software files.  This location is the Oracle home directory."
		},
		{
			"INSTALL_CLIENT_LOCATION_DLG_LABEL_ORACLE_BASE",
			"Oracle base:"
		},
		{
			"INSTALL_CLIENT_LOCATION_DLG_LABEL_ORABASE_DESC",
			"Specify an Oracle base path to place all Oracle software and configuration-related files.  This location is the Oracle base directory."
		},
		// Finish (Install complete) dialog labels
		{
			"INSTALL_CLIENT_FINISH_DLG_SUCCESS_PROMPT",
			"The installation of Oracle Client was successful."
		},
		{
			"INSTALL_CLIENT_FINISH_DLG_DESC",
			"Oracle Client "
		},
		// OraMTS dialog labels
		{
			"ORAMTS_DIALOG_DESC",
			"The Oracle MTS Recovery Service is automatically installed with Oracle Services for Microsoft Transaction Server. The Oracle MTS Recovery Service accepts requests to resolve in-doubt MS DTC-coordinated transactions started on this computer. Enter the port number on which the Oracle MTS Recovery Service will listen for requests on this computer."  
		},
		{
			"PORT_NUMBER_LABEL",
			"&Specify port number: "
		},

                // Scheduler agent dialog
		{
			"SCH_AGT_DIALOG_DESC",
			"Provide the following installation details for the Oracle Database Scheduler Agent."
		},
		{
			"SCH_AGT_HOSTNAME_LABEL",
			"&Scheduler Agent Host Name: "
		},
		{
			"SCH_AGT_PORT_NUM_LABEL",
			"Scheduler &Agent Port Number: "
		},
		{
			"MTS_PORT_DESC",
			"OraMTS Port Number"
		},
		{
			"ORACLE_SERVICE_USER",
			"Oracle Home User Selection"
		},
		{"WindowsSecureOptionPane.lblPageDesc.text","Use Windows Built-in Account or specify a standard Windows User Account (not an Administrator account) to install and configure the Oracle Home. This account is used for running the Windows Services for the Oracle Home. Do not log in using this account to perform administrative tasks."}

	};

	public Object[][] getContents()
	{
		return mesgKey;
	}
}

