/* $Header: oapt.h,v 1.7 97/03/19 15:27:13 sgans: Stab $ */
#ifdef NOTDEF
/*     Copyright (c) Oracle Corporation 1991.  All Rights Reserved.   */

NAME
    oapt -- OA manage Process registration Table

FUNCTION
    This is a collection of functions for initializing, updating and fetching
    various records in the OA process registration table.  A 'user' of the
    registration service is merely defined as some unique value for the 
    'key1' and 'key2' columns.  While a certain recommended use will be
    suggested (i.e., KEY1 = account_no, KEY2 = person_no) they will be dealt
    with in a generic manner.  It will also be presumed that there will be
    no active "users" for which either of their keys is 0 since that will 
    have a special meaning in the API.

    Registration records with OS_PROCESS_ID and DBS_SESSION_ID as null and 0
    are considered as default records for that {KEY1, KEY2, APP_ID} trio.

    Cursor Management:    This module does not do explicit cursor management in
    the sense that most of the calls (except for the Fetch set) will be used 
    usually just once per user session (i.e., one call to register and one to 
    unregister.)  These will simply open and then close their own cursors.

    The fetch calls will each take a cursor_ptr.  Typical behavior will be:

     cursor_ptr == NULLP(word);		open and close the cursor explicitly
    *cursor_ptr == NULL;		open cursor and return the index
    *cursor_ptr != NULL;		use that index for the cursor - just
                                         reexecute and fetch

    Error Management:  This module does not make use of any fancy error 
    management.  It will return special status codes in the 'status' argument
    passed into most of the calls.  It should probably be converted some time
    into using the OAE module.

    NOTE:  This utility requires select privilege on the sys.v_$session table.

    The functions are broken down into sets: 
    (+ means finished, . means pending, - means obsoleted by oaptfxx)

    + oaptini -		create the oa_registration table
    
    + oaptscr - 	CReate a new Session record
    + oaptsdl - 	DeLete current Session records
    + oaptsdi - 	Delete all Inactive Session records
    + oaptsda -		Delete all Session records associated with an Appl

    + oaptdcr -		CReate a Default record
    . oaptddl -		DeLete a Default record
    . oaptddd -		Delete all Default records
    . oaptdda -		Delete all Default records associated with an Appl
    . oaptddu -		Delete all Default records associated with a User
    . oaptddc -		Delete all Default records associated with an aCcount

    - oaptfus -		Fetch session and/or default records for a USer
    - oaptfac -		Fetch records for a given ACcount
    - oaptfap - 	Fetch records for a given APplication
    - oaptfff - 	Fetch all valid registration records

    + oaptfxx -		Fetch records based on Key1 / Key2 / App_id

NOTES

OWNER
    Steven Gans

MODIFIED
    sgans      03/19/97 -  remove quote character 
    ewinner    08/13/93 -  fix line that is too long 
    nakumar    06/25/93 -  Add prototype for oaptcuh. 
    ewinner    06/23/93 -  change CALUI constant to be same as office one 
    sgans      06/17/93 -  add new prototypes, application constants 
    nakumar    05/25/93 -  Remove include of hstdef.h 
    sgans       4/14/92	   rename oaptatt to oapta
    dfrazier    03/23/92 -  olint 
    bijan 11/22/91	added oaptfsp() temporarily until oaptfxx() is
			improved to fetch desired columns only.
    sgans 11/21/91	added oapti structure for inserts
    sgans 11/15/91	added oaptfxx(), OAPT_IGNORE (obsolete oaptf{ch,ac,us})
    sgans  9/27/91    	added public constants for USAGE, NOTIFY_TYPE
    sgans  9/13/91    	created

#endif /* NOTDEF */
/*--------------------------------------------------------------------*/

#ifndef OAPT
#define OAPT

#ifndef  S
#include <s.h>
#endif									/* S */

#ifndef  OAXM
#include <oaxm.h>
#endif								     /* OAXM */

#ifndef  SOA
#include <soa.h>
#endif								      /* SOA */

#ifndef  OA
#include <oa.h>
#endif								       /* OA */

#ifndef  OACM
#include <oacm.h>
#endif

/*----------------------+
!  OMUPI information	!
+----------------------*/

/* These constants and macros should probably be defined somewhere in common
** but for now will be included here.  In the Oracle*Mail backend, these are
** all defined in omupi.h
*/

#ifndef OMUPI
#include <omupi.h>
#endif								    /* OMUPI */

/*----------------------+
!  Public Constants	!
+----------------------*/

/*
** Return values -- indicate where an error occurred, and (sometimes) what the
** error was (if we can know that.)
*/
#define OAPT_ST_SUCC        OA_SUCC
#define OAPT_ST_FAIL	    OA_FAIL
#define OAPT_ST_IN_OAE      1		  /* Error was pushed on error stack */
#define OAPT_ST_NOCONN	    2		 /* hstdef supplied is not connected */
#define OAPT_ST_OERR	    3		     /* Oracle error found in status */


/*
** Application Ids
*/

#define OAPT_APP_MAILUI	    (ub4)1			   /* mail front-end */
/* CALUI moved below */
#define OAPT_APP_TOADS	    (ub4)3		       /* directory services */
#define OAPT_APP_ADMIN	    (ub4)4		     /* office admin utility */
#define OAPT_APP_SERVER	    (ub4)5		  /* office server processes */

/* Note:  Application Ids > 100 will be cleaned up by the Keep-Alive scheme */
#define OAPT_APP_OFFICE	    (ub4)101 			 /* office front-end */
/* convenience so scheduler need not change any code -ewinner */
#define OAPT_APP_CALUI	    OAPT_APP_OFFICE           /* cal-sched front-end */

/*
** oaptfxx contstants
*/

#define OAPT_IGNORE	        0		/* ignore this value in bind */

/*
** Usage values
*/

#define OAPT_USG_NOOP	    (ub4)0			       /* no meaning */
#define OAPT_USG_ALL	    (ub4)1	       /* always perform this action */
#define OAPT_USG_CONN	    (ub4)2	 /* only perform this when connected */
#define OAPT_USG_NOCONN	    (ub4)3   /* only perform this when not connected */

/*
** Notification types
*/

#define OAPT_TYP_UNKNOWN    (ub4)0	       /* no specific type - generic */
#define OAPT_TYP_OSEXE	    (ub4)1		 /* operating system trigger */
#define OAPT_TYP_LAMP	    (ub4)2	  /* standard lamp/ping to front-end */
#define OAPT_TYP_ACCT2	    (ub4)3	      /* additional usr to lamp/ping */
#define OAPT_TYP_OSOFF	    (ub4)4		 /* turn off OS notification */
#define OAPT_TYP_OSALL	    (ub4)5	   /* always perform OS notification */

/*----------------------+
!  Public Structures	!
+----------------------*/

#define  OAPTATT_SIZE    ((7 * TAB_NUMBER) + (3 * TAB_STRING) + (TAB_STRSHT))

struct oapta
{
    eword  oaptasiz;				    /* size of array buffers */
    eword  oaptacnt;					      /* result size */
    ub4	*oaptak1;					      /* KEY1 column */
    ub4	*oaptak2;					      /* KEY2 column */
    ub4	*oaptaapp;				    /* APPLICATION_ID column */
    ub4 *oaptausg;					     /* USAGE column */
    ub4 *oaptatyp;				       /* NOTIFY_TYPE column */
    ub4 *oaptadbs;				     /* DB_SESSION_ID column */
    ub4 *oaptai1;					     /* INFO1 column */
    text *oaptapid;				     /* OS_PROCESS_ID column */
    text *oaptanam;				       /* NOTIFY_NAME column */
    text *oaptahst;					 /* HOST_NAME column */
    text *oaptai2;					     /* INFO2 column */
};

typedef struct oapta oapta;


struct oapti
{
    ub4	oaptik1;					      /* KEY1 column */
    ub4	oaptik2;					      /* KEY2 column */
    ub4	oaptiapp;				    /* APPLICATION_ID column */
    ub4 oaptiusg;					     /* USAGE column */
    ub4 oaptityp;				       /* NOTIFY_TYPE column */
    ub4 oaptii1;					     /* INFO1 column */
    text oaptipid[TAB_STRSHT];	      /* OS_PROCESS_ID column (max size: 80) */
    text oaptinam[TAB_STRING];	       /* NOTIFY_NAME column (max size: 240) */
    text oaptihst[TAB_STRING];		 /* HOST_NAME column (max size: 240) */
    text oaptii2[TAB_STRING];		     /* INFO2 column (max size: 240) */
};

typedef struct oapti oapti;


/*----------------------+
!  Function Prototypes	!
+----------------------*/

/* oaptiaa:
**    register an _I_Am_Alive_ message for this { key1, key2 } pair.
**	offset is the number of hours from "now" for which this connection 
**	is to be considered "alive".
**    Returns:
**	OA_SUCC upon success
**	OAPT_ST_OERR 	upon a SQL error (with the Oracle error in status)
*/
eword oaptiaa (/*_ oacmd *uenv, ub4 curid, ub4 key1, ub4 key2, ub4 offset,
	       eword *status _*/);

/* oaptini:
**    create the OA_REGISTRATION table
**    Returns:
**	OA_SUCC upon success
**	OA_FAIL otherwise (with an error code in status)
*/
eword oaptini (/*_ struct hstdef *hst, eword *status _*/);

/* oaptscr
**   CReate a new Session record with the given attributes. 
**	The sessionId will be filled in automatically by oaptscr().  An
**	application can register itself multiple times (in order to 
**	request different forms of notification) in a session.  All will
**	be cleaned up by the oaptsdl() call.
**
**   Returns:
**	OA_SUCC 	upon success
**	OAPT_ST_OERR 	upon a SQL error (with the Oracle error in status)
*/
eword oaptscr (/*_ struct hstdef *hst, oapti *astruc, eword *status _*/);

/* oaptsdl
**   DeLete current Session records
**	This deletes an non-default session records associated with the
**	current database process as identified by userenv('SESSIONID').
**   Returns:
**	OA_SUCC 	upon success
**	OAPT_ST_OERR	upon a SQL error (with the Oracle error in status)
*/
eword oaptsdl (/*_ struct hstdef *hst, eword *status _*/);

/* oaptsdi
**   Delete all Inactive Session records
**	Inactive records are ones for which there is no corresponding record
**	in the v$session table.
**   Returns:
**	OA_SUCC 	upon success
**	OAPT_ST_OERR 	upon a SQL error (with the Oracle error in status)
*/
eword oaptsdi (/*_ struct hstdef *hst, eword *status _*/);

/* oaptsda
**   Delete all non-default Session records associated with an Appl
**   Returns:
**	OA_SUCC 	upon success
**	OAPT_ST_OERR 	upon a SQL error (with the Oracle error in status)
*/
eword  oaptsda(/*_ struct hstdef *hst, ub4 app_id, eword *status _*/);

/* oaptdcr
**   CReate a Default record with the given attributes. 
**	The sessionId will be filled in as '0' by oaptdcr().  An
**	application can create multiple default records (in order to 
**	request different forms of notification.)
**
**   Returns:
**	OA_SUCC 	upon success
**	OAPT_ST_OERR 	upon a SQL error (with the Oracle error in status)
*/
eword oaptdcr (/*_ struct hstdef *hst, oapti *astruc, eword *status _*/);

/* oaptfxx
**   Fetch session and/or default records for a given set of Key1/Key2/App_id
**   	This call will try to fetch up to 'oaptasiz' records, and then will
**	update oaptacnt with the number of records actually fetched.
**
**	if (cursor == NULLP(word))	- cursor opened and closed
**	if (*cursor == NULL)		- cursor opened and saved in *cursor
**	if (*cursor)			- *cursor used
**
**   If any of 'key1', 'key2', or 'app_id' is OAPT_IGNORE then that column
**	will not be used in the join statement.
**
**   Returns:
**	OA_SUCC 	upon success (with 'arrsize' set to # found)
**	OAPT_ST_OERR 	upon a SQL error (with the Oracle error in status)
*/
eword oaptfxx (/*_ struct hstdef *hst, ub4 key1, ub4 key2, ub4 app_id, 
		 word *cursor, oapta *astruc, eword *status _*/);

/* oaptfsp
**   Very similar to oaptfxx, except that app_id is taken to be server, and
**   	only the key1, key2, and os_pid are fetched for records with a local
**	hostname.  Used by ooss until oaptfxx is generalized to fetch only
**	desired columns.
**
**   Returns:
**	OA_SUCC 	upon success (with 'arrsize' set to # found)
**	OAPT_ST_OERR 	upon a SQL error (with the Oracle error in status)
*/
eword oaptfsp (/*_ struct hstdef *hst, ub4 key1, ub4 key2, word *cursor,
		 oapta *astruc, eword *status _*/);

/* oaptcuh
**   This call examines the v$process and v$session tables on the database,
**   in conjunction with the ds_registration table, to determine which
**   processes the RDBMS thinks still exist yet haven't sent an 
**   _I_Am_Alive_message recently.  It can only kill coexistent RDBMS Shadow 
**   processes on the node from which it is executed.  
**
**   Returns:
**	OA_SUCC		upon success
**	OA_FAIL		upon failure; *status set to Failure reason.
*/

sword oaptcuh(/*_ oacmd *uenv, ub4 curid1, ub4 curid2, ub4 flags,
		  eword *status _*/);

/*----------------------+
!  Internal Prototypes	!
+----------------------*/
/* Please do not call any of these directly */
eword oaptexe (/*_ struct hstdef *hst, text *sqlbuf, eword *status _*/);
eword oaptins (/*_ struct hstdef *hst, oapti *astruc, text *session_source,
		 eword *status _*/);

#endif /* OAPT */

