# 
# $Header: has/install/crsconfig/s_orachm.pm /nt/1 2015/07/02 23:20:34 shullur Exp $
#
# s_orachm.pm
# 
# Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      s_orachm.pm - port specific subroutines of CHM
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    shullur     06/12/15 - For migrating CHM subroutines
#    shullur     06/12/15 - Creation
# 

package oraClusterwareComp::orachm;

use parent 'oraClusterwareComp';

use strict;
use English;
use Carp;
use File::Copy;
use File::Path;
use File::Find;
use File::Basename;
use File::Spec::Functions;

use crsutils;
use s_crsutils;


sub s_isCHMSupported
#-----------------------------------------------------------------------------
# Function: Check if CHM is supported on this platform
# Returns : TRUE if supported else FALSE
#-----------------------------------------------------------------------------
{
  my $osysmond_exe = catfile ($CFG->ORA_CRS_HOME, "bin", "osysmond.exe");

  if (! (-e $osysmond_exe)) {
    trace ("Cluster Health Monitor osysmond not found");
    return FALSE;
  }else
  {
    return TRUE;
  }
}

sub s_chm_check_bdbloc
{
  my $bdbloc = $_[0];

  trace("IPD/OS BDB location checks: $bdbloc");

  # check for existence first
  if (! -d $bdbloc)
  {
    trace("INFO: BDB path $bdbloc does not exist, creating it...\n");
    mkpath($bdbloc, 0, 0755);
    if (! -d $bdbloc)
    {
      trace("INFO: BDB path $bdbloc could not be created.\n");
      return 15;
    }
  }
  else
  {
    if (! -w $bdbloc)
    {
      trace("INFO: BDB path $bdbloc is not writable, changing ");
      trace("permissions on it...\n");
      chmod oct('0755'),"$bdbloc";
    }
  }

  # check for space now. fsutil reports bytes. Check for 2GB per node.
  my $rqrd;
  my $nodelist = $_[1];

  chomp($nodelist);
  my @hosts = split(/[,]+/, $nodelist);

  $rqrd = (@hosts)*2*1024*1024*1024;
  if (open(DFH, "fsutil volume diskfree $bdbloc"))
  {
    while (<DFH>)
    {
      chomp();
      if (!($_ =~ m/Total # of avail free bytes.*/i))
      {
        my @parts = split(/[ ]+/, $_);
        my $avl = $parts[8];
        if ($avl < $rqrd)
        {
          error("Insufficient free space available in BDB path $bdbloc; run oclumon to change BDB location");
          return 13;
        }
      }
    }
    close DFH;
  }
}

sub s_chm_remove_itab
{
  my $instdir = "C:\\Program Files\\oracrf";
  my $cmd;

  trace("Removing OracelOsToolSysmService on Windows.");
  $cmd = catfile("$instdir", "bin", "osysmond.exe");
  system("$cmd stop");
  system("$cmd remove");
}


1;
