#!/usr/bin/perl
# 
# $Header: has/install/crsconfig/dropdb.pl /main/3 2014/07/16 23:32:00 xyuan Exp $
#
# dropdb.pl
# 
# Copyright (c) 2013, 2014, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      dropdb.pl - Specific for dropping the Management database
#
#    DESCRIPTION
#      This is a Perl program for the convenience of dropping the Management 
#      database.
#
#    NOTES
#      usage: dropdb.pl <ORACLE_HOME>
#
#    MODIFIED   (MM/DD/YY)
#    xyuan       07/02/14 - Fix bug 18777835
#    xyuan       11/13/13 - Creation
# 

use strict;
use English;
use File::Copy;
use File::Path;
use File::Find;
use File::Basename;
use File::Spec::Functions;
use DBI;

BEGIN {
   # Add the directory of this file to the search path
   push @INC, dirname($PROGRAM_NAME);
}

use crsutils;
use s_crsutils;

sub dropdb
{
  my $oraHOME = $_[0];

  my $usr;
  my $passwd;
  my %session_mode;
  my $driver;

  $ENV{'ORACLE_HOME'} = $oraHOME;
  $ENV{'ORACLE_SID'} = "-MGMTDB";

  $session_mode{'ora_session_mode'} = 2; # sysdba = 2
  $driver = 'dbi:Oracle:';

  # Try to connect DB instance
  # ora_session_mode => 2 means to connect as sysdba
  my $dbh = DBI->connect($driver, $usr, $passwd, \%session_mode);
  if (! $dbh)
  {
    print "Couldn't connect to database: ". $DBI::errstr . "\n";
    exit(1);
  }

  # Execute SQL statement to drop DB
  my $stmt = "drop database";
  my $sth = $dbh->do($stmt);
  if (! $sth)
  {
    print "Couldn't execute SQL statement: ". $DBI::errstr . "\n";
    $dbh->disconnect
      or warn "Failed to disconnect: " . $DBI::errstr ."\n";
    exit(1);
  }
  
  $dbh->disconnect
    or warn "Failed to disconnect: " . $DBI::errstr ."\n";
}

sub removeMgmtdbSvc
{
  my $oraHOME = $_[0];
  my $ret = SUCCESS;

  trace("Attempt to remove the MGMTDB service on each node");
  my ($rc, @nodelist) = get_olsnodes_info($CFG->ORA_CRS_HOME);
  if (0 == $rc)
  {
    foreach my $node (@nodelist)
    {
      trace("Running 'oradim' locally to remove the MGMTDB service ".
            "from node $node");
      my $oradim = catfile($CFG->ORA_CRS_HOME, 'bin', 'oradim.exe');
      my $cmd = "$oradim -delete -host $node " .
                "-ORACLE_HOME $oraHOME -mgmtdbsid \"-MGMTDB\"";
      my @out = system_cmd_capture($cmd);
      my $rc = shift @out;
      if (0 != $rc)
      {
        trace("Failed to delete the MGMTDB service on $node");
        print("Failed to delete the MGMTDB service on $node\n");
        $ret = FAILED; 
      } 
      else
      { 
        trace("Succeeded in removing the MGMTDB service on $node");
      }
    }
  }
  else
  {
    trace("Failed to run 'olsnodes' to obtain the node list");
    $ret = FAILED;
  }

  return $ret;
}

# Execution:
my $oracle_home = $ARGV[0];

dropdb($oracle_home);

if (s_get_platform_family() ne 'windows')
{
  print "dropdb.pl exiting ...\n";
  exit(0);  
}

my $DEBUG = 0;
if (! $DEBUG) { $DEBUG = $ENV{'ORA_INSTALL_DEBUG'}; }
my $PARAM_FILE = catfile(dirname($0), 'crsconfig_params');
my $addfile = catfile(dirname($0), 'crsconfig_addparams');
my $osdfile = catfile(dirname($0), 's_crsconfig_defs');

crsutils->new(SIHA                => FALSE,
              DEBUG               => $DEBUG,
              paramfile           => $PARAM_FILE,
              osdfile             => $osdfile,
              addfile             => $addfile,
              crscfg_trace        => TRUE
             );

removeMgmtdbSvc($oracle_home);

print "dropdb.pl exiting ...\n";
exit(0);
