# 
# $Header: has/install/crsconfig/s_oraocr.pm /nt/3 2016/06/28 22:36:03 luoli Exp $
#
# s_oraocr.pm
# 
# Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      s_oraocr.pm - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    luoli       06/23/16 - Fix bug 23621915
#    muhe        12/09/15 - Fix bug 22259727
#    sbezawad    01/20/15 - Bug 20019354: Migrate OCR and OLR to new framework
#    sbezawad    01/20/15 - Creation
# 

package oraClusterwareComp::oraocr;

use parent 'oraClusterwareComp';

use strict;
use Win32;
use Win32::NetAdmin qw(DOMAIN_ALIAS_RID_ADMINS GetAliasFromRID
                       LocalGroupIsMember GroupIsMember);
use Win32::TieRegistry (Delimiter => '/');
use Win32::Service;
use Win32API::File  qw(DeleteFile);
use File::Spec::Functions;
use File::Path;
use File::Temp qw/ tempfile /;
use Cwd;

use crsutils;
use s_crsutils;

#
# Export functions specific to oraocr class.
#

sub s_ResetOCR
#------------------------------------------------------------------------------
# Function: Reset OCR
# Args    : None
# Returns : TRUE  if success
#           FALSE if failed
#------------------------------------------------------------------------------
{
  my $self    = shift;
    trace ("Reset OCR");
  my $OCRLOC   = $CFG->params('OCRLOC');
  my $SRVCONFIG;
  if ($CFG->defined_param('SRVCONFIG'))
  {
    $SRVCONFIG = $CFG->params('SRVCONFIG');
  }

  my ($ocr_loc, $ocr_mirror_loc, $ocr_loc3, $ocr_loc4, $ocr_loc5);

  my $olrdisk = s_get_config_key("olr", "olrconfig_loc");
  trace("Removing OLR disk: $olrdisk");

  s_remove_file($olrdisk);

  # remove olr registry key
  my $OLRLOC = $CFG->params('OLRLOC');
  my $olrvalue  = delete $Registry->{"LMachine/$OLRLOC/"};

  if (! $CFG->LASTNODE)
  {
    # remove ocr registry key
    my $value = delete $Registry->{"LMachine/$OCRLOC/"};
    return TRUE;
  }

  $ocr_loc = $self->get_ocrdisk();
  $ocr_mirror_loc = $self->get_ocrmirrordisk();
  $ocr_loc3 = $self->get_ocrloc3disk();
  $ocr_loc4 = $self->get_ocrloc4disk();
  $ocr_loc5 = $self->get_ocrloc5disk();

  if (! -f $ocr_loc)
  {
    # ocr.loc file does not exist. Take ocr location of srvconfig.loc. 
    if (-f $SRVCONFIG)
	{
      $ocr_loc = get_srvdisk();
    }
  }

  if ($ocr_mirror_loc)
  {
    trace("Removing OCR mirror device: $ocr_mirror_loc");
    s_remove_file($ocr_mirror_loc);
  }

  if ($ocr_loc3)
  {
    trace("Removing OCR mirror device 3: $ocr_loc3");
    s_remove_file($ocr_loc3);
  }

  if ($ocr_loc4)
  {
    trace("Removing OCR mirror device 4: $ocr_loc4");
    s_remove_file($ocr_loc4);
  }

  if ($ocr_loc5)
  {
    trace("Removing OCR mirror device 5: $ocr_loc5");
    s_remove_file($ocr_loc5);
  }

  # reset OCR device if it's not on ASM
  if (($CFG->LASTNODE)    &&
      (! $CFG->DOWNGRADE) &&
      (! $CFG->ASM_STORAGE_USED)) 
  {
    trace("Removing OCR device: $ocr_loc");
    s_remove_file($ocr_loc);
  }

  # remove ocr.loc 
  my $value = delete $Registry->{"LMachine/$OCRLOC/"};
}

sub s_backupocrloc
#------------------------------------------------------------------------------
# Function: Back up OCR configuration during upgrade
# Args    : None
# Returns : TRUE  if success
#           FALSE if failed
#------------------------------------------------------------------------------
{
  my $self      = shift;
  my $ocrloc    = $CFG->params('OCRLOC');
  my $ocrlocbkp = $ocrloc . ".bkp";

  trace("Back up the ocr.loc file");
  s_copyRegKey($ocrloc, $ocrlocbkp);

  return TRUE;
}

#
# Private methods
#

sub s_validateOCR
#------------------------------------------------------------------------------
# Function: Validating OCR locations based on existing ocr settings
# Args    : [0] Path for Oracle CRS home
#           [1] Cluster name
#           [2] Comma separated OCR locations
# Returns : TRUE  if success
#           FALSE if failed
#------------------------------------------------------------------------------
{
  if (isAddNode($CFG->HOST))
  {
    return TRUE;
  }

  my $crshome = $_[0];
  my $clustername = $_[1];
  my $ocrlocations = $_[2];
  my $status = TRUE;

  trace ("Setting OCR locations in registry");
  s_validate_ocrconfig ($ocrlocations, 0) or {$status = FALSE};

  # XXX: do we need to do anything more here?
  return $status;
}

sub s_validate_ocrconfig
#------------------------------------------------------------------------------
# Function: Creates OCR config file if it does not exists.
# Args    : [0] List of OCR locations
#           [1] TRUE  - SIHA mode
#               FALSE - Cluster mode
# Returns : TRUE  if success
#           FALSE if failed
#------------------------------------------------------------------------------
{
  trace ("Validating OCR locations in OCR registry key");

  my $ocrlocations = shift;
  my $isHas        = shift;
  my $OCRLOC       = $CFG->params('OCRLOC');
  my ($ocrlocation,
      $ocrmirrorlocation,
      $ocrlocation3,
      $ocrlocation4,
      $ocrlocation5) = split (/\s*,\s*/, $ocrlocations);

  trace ("Setting ocr location " . $ocrlocation);
  $Registry->{"LMachine/$OCRLOC/"} = {
      "/ocrconfig_loc" => "$ocrlocation",
  };

  if ($ocrmirrorlocation)
  {
    trace ("Setting ocr mirror location " . $ocrmirrorlocation);
    $Registry->{"LMachine/$OCRLOC/"} = {
        "/ocrmirrorconfig_loc" => "$ocrmirrorlocation",
    };
  }

  if ($ocrlocation3)
  {
    trace ("Setting ocr location3 " . $ocrlocation3);
    $Registry->{"LMachine/$OCRLOC/"} = {
        "/ocrconfig_loc3" => "$ocrlocation3",
    };
  }

  if ($ocrlocation4)
  {
    trace ("Setting ocr location4 " . $ocrlocation4);
    $Registry->{"LMachine/$OCRLOC/"} = {
        "/ocrconfig_loc4" => "$ocrlocation4",
    };
  }

  if ($ocrlocation5)
  {
    trace ("Setting ocr location5 " . $ocrlocation5);
    $Registry->{"LMachine/$OCRLOC/"} = {
        "/ocrconfig_loc5" => "$ocrlocation5",
    };
  }

  if ($isHas)
  {
    $Registry->{"LMachine/$OCRLOC/"} = {
        "/local_only" => "TRUE",
    };
  }
  else
  {
    $Registry->{"LMachine/$OCRLOC/"} = {
        "/local_only" => "FALSE",
    };
  }

  return TRUE;
}

sub s_createLocalOnlyOCR
#------------------------------------------------------------------------------
# Function: Create local-only OCR
# Args    : None
# Returns : TRUE  if success
#           FALSE if failed
#------------------------------------------------------------------------------
{
  trace ("Create local_only OCR on Windows...");
  my $OCRLOC = $CFG->params('OCRLOC');
     
  # create local_only OCR
  $Registry->{"LMachine/$OCRLOC/"} = {
              "/local_only" => "TRUE",
   	          };
}

sub s_copyOCRLoc
#------------------------------------------------------------------------------
# Function: Copy the local OCR configuration to all new nodes that are being
#           added
# Args    : None
# Returns : TRUE  if success
#           FALSE if failed
# NOTES: OCR handles the ocr.loc updates on its own, and this is kept around
#        as a fallback
#-------------------------------------------------------------------------------
{
  trace ("Creating ocr key using ocr key from other node");

  my @node_list = getCurrentNodenameList();
  my $OCRLOC    = $CFG->params('OCRLOC');
  my $HOST      = $CFG->HOST;
  my $rc	    = FALSE;
  my $node;

  foreach $node (@node_list)
  {
    if ($node !~ /\b$HOST\b/i)
	{
	  trace("get OCR key from node=$node");
	  my $remKey = $Registry->Connect("\\\\$node", 
	   			  	 "LMachine/$OCRLOC");
	  my @vnames = $remKey->ValueNames;
      my ($vname, $vdata);

	  foreach $vname (@vnames)
	  {
        $vdata = $remKey->GetValue("$vname");

        print ("creating $vname=$vdata from node=$node\n");
        trace ("creating $vname=$vdata from node=$node");
        $Registry->{"LMachine/$OCRLOC/"} = {
              "$vname" => "$vdata",
        };
      }

	  $rc = TRUE;
 	  last;

    }
    else
	{
      trace("Avoiding self copy of ocr on node: $node");
    }
  }
  return $rc;
}

sub s_restoreocrloc
#------------------------------------------------------------------------------
# Function: During downgrade, restore OCR configuration from a backup
# Args    : None
# Returns : TRUE  if success
#           FALSE if failed
#------------------------------------------------------------------------------
{
  my $ocrloc    = $CFG->params('OCRLOC');
  my $ocrlocbkp = $ocrloc . ".bkp";

  if ($Registry->{"LMachine/$ocrlocbkp/"})
  {
    trace("Restore old ocr.loc file");
    s_copyRegKey($ocrlocbkp, $ocrloc);
    return TRUE;
  }
  else
  {
    trace("Failed to restore OCR location because the backup ".
          "OCR location does not exist.");
    return FAILED;
  }
}

1;
