set echo off;
set term on;
set feedback 0;
set serveroutput on;
set long 10000;
set verify off;
whenever sqlerror exit failure;
define sqlplus_cdb_dbcs_name = null;
define sqlplus_fdb_name = null;
define sqlplus_pdb_name = null;
define sqlplus_pdb_id = null;
column sqlplus_cdb_dbcs_name new_value sqlplus_cdb_dbcs_name;
column sqlplus_fdb_name      new_value sqlplus_fdb_name;
column sqlplus_pdb_name      new_value sqlplus_pdb_name;
column sqlplus_pdb_id        new_value sqlplus_pdb_id;
declare
  not_as_sys_20001 constant varchar2(80 byte) :=
    'You can run this script only if logged in as SYSDBA.';

  dbcs_unchanged_20013 constant varchar2(80 byte) :=
    'CSREPAIR failed. The database character set remains unchanged.';

begin
  
  if (user <> 'SYS') then
    raise_application_error(-20001, not_as_sys_20001, true);
  end if;

exception
  when others then
    raise_application_error(-20013, dbcs_unchanged_20013, true);
end;
/
set term off;
whenever sqlerror continue;
prompt
prompt === Start of Compatibility Section 1 ===
prompt Ignore any ORA-65090, ORA-02248, and ORA-02003 errors reported in this section.
prompt
SELECT sys_context('USERENV', 'CON_NAME') sqlplus_pdb_name FROM dual;
SELECT sys_context('USERENV', 'CON_ID')   sqlplus_pdb_id FROM dual;
SELECT sys_context('USERENV', 'FEDERATION_NAME') sqlplus_fdb_name FROM dual;
ALTER SESSION SET CONTAINER = cdb$root;
prompt
prompt === End of Compatibility Section 1 ===
prompt
whenever sqlerror exit failure;
set term on;
declare
  application_con_name varchar2(128 byte) := '&sqlplus_fdb_name';
  

  previous_con_id      varchar2(5 byte) := '&sqlplus_pdb_id';
  current_con_id       varchar2(5 byte) := null;

  set_container_to_root_20040 constant varchar2(80 byte) :=
    'Unable to switch to the root container. Check user privileges.';

  container_is_root_20042 constant varchar2(80 byte) :=
    'Running CSREPAIR in a CDB root container is not supported.';

  container_is_federated_20043 constant varchar2(80 byte) :=
    'Running CSREPAIR in an application container is not supported.';

  pdb_is_seed_20044 constant varchar2(80 byte) :=
    'Running CSREPAIR in a PDB seed container is not supported.';

  dbcs_unchanged_20013 constant varchar2(80 byte) :=
    'CSREPAIR failed. The database character set remains unchanged.';

begin
  if (application_con_name <> 'null') then
    dbms_output.put_line('The name of the current application container is ' ||
                         application_con_name);
    raise_application_error(-20043, container_is_federated_20043, true);
  end if;

  if (previous_con_id = '1') then                                
    raise_application_error(-20042, container_is_root_20042, true);
  elsif (previous_con_id = '2') then                             
    raise_application_error(-20044, pdb_is_seed_20044, true);
  elsif (previous_con_id = '0') then                              
    null ;
  elsif (previous_con_id = 'null') then                 
    null ;
  else                
    begin
      SELECT sys_context('USERENV', 'CON_ID')
        INTO current_con_id
        FROM dual;
    exception
      when others then
        if (SQLCODE <> -2003) then 
          raise;
        end if;
    end;

    if (current_con_id <> '1') then
      





      raise_application_error(-20040, set_container_to_root_20040, true);
    end if;
  end if;

exception
  when others then
    raise_application_error(-20013, dbcs_unchanged_20013, true);
end;
/
set term off;
whenever sqlerror continue;
SELECT value sqlplus_cdb_dbcs_name
  FROM nls_database_parameters
 WHERE parameter='NLS_CHARACTERSET';
prompt
prompt === Start of Compatibility Section 2 ===
prompt Ignore any ORA-65090 and ORA-02248 errors reported in this section.
prompt
alter session set container = &sqlplus_pdb_name;
prompt
prompt === End of Compatibility Section 2 ===
prompt
whenever sqlerror exit failure;
set term on;
declare
  
  previous_con_id varchar2(5 byte) := '&sqlplus_pdb_id';
  current_con_id  varchar2(5 byte) := null;

  set_container_to_pdb_20041 constant varchar2(80 byte) :=
    'Unable to switch back to the PDB. Check user privileges.';

  dbcs_unchanged_20013 constant varchar2(80 byte) :=
    'CSREPAIR failed. The database character set remains unchanged.';

begin
  if (previous_con_id <> 'null' and
      previous_con_id <> '0') then   
    begin
      SELECT sys_context('USERENV', 'CON_ID')
        INTO current_con_id
        FROM dual;
    exception
      when others then
        if (SQLCODE <> -2003) then 
          raise_application_error(-20041, set_container_to_pdb_20041, true);
        end if;
    end;

    if (current_con_id <> previous_con_id) then
      raise_application_error(-20041, set_container_to_pdb_20041, true);
    end if;
  end if;
exception
  when others then
    raise_application_error(-20013, dbcs_unchanged_20013, true);
end;
/
declare
  heterogeneous_dbcs   varchar2(4000 byte);             
                                
  sqlstmt              varchar2(400 byte) := '';
  pdb_id               integer;
  pdb_name             varchar2(128 byte);
                               
  root_dbcs_name       sys.props$.value$%type;            
  v_count              integer;
  current_dbcs_id      number;
  current_dbcs_name    varchar2(28 byte);
  assumed_dbcs_id      number;
  assumed_dbcs_name    varchar2(28 byte);
  dbcs_charset_type    integer;
  assumed_charset_type integer;
  trace_on             boolean := FALSE;      

  get_charset_type_failed_20000 constant varchar2(80 byte) :=
    'UTL_I18N.GET_MAX_CHARACTER_SIZE reported an error.';

  bad_dmu_version_20002 constant varchar2(160 byte) :=
    'The version of the installed DMU repository is not supported by this version of CSREPAIR.';

  bad_dmu_session_20003 constant varchar2(160 byte) :=
    'A DMU session is running or the last DMU session ended abruptly in this database. Make sure the DMU is closed in the standard way. Then, rerun CSREPAIR.';

  bad_dmu_scan_20004 constant varchar2(160 byte) :=
    'One or more columns have not been scanned by the DMU. Run a full database scan in the DMU before executing CSREPAIR.';

  bad_assumed_dbcs_20005 constant varchar2(160 byte) :=
    'Run a full DMU scan with the Assumed Database Character Set database property set to the desired target character set.';

  same_dbcs_20006 constant varchar2(160 byte) :=
    'The target character set provided in the Assumed Database Character Set database property is the same as the current database character set.';

  assumed_dbcs_super_ascii_20007 constant varchar2(160 byte) :=
    'The target character set provided in the Assumed Database Character Set database property must be a binary superset of US7ASCII.';

  not_multi_to_single_20008 constant varchar2(160 byte) :=
    'Changing the database character set from multi-byte to single-byte is not supported.';

  not_single_to_multi_20009 constant varchar2(160 byte) :=
    'Changing the database character set from single-byte to multi-byte is not supported.';

  bad_assumed_column_cs_20010 constant varchar2(160 byte) :=
    'The assumed character set of one or more columns does not match the assumed database character set.';

  invalid_data_20011 constant varchar2(160 byte) :=
    'The DMU has reported data with invalid binary representation. Correct the data before running CSREPAIR.';

  altered_dmu_20012 constant varchar2(160 byte) :=
    'One or more tables have been altered since the last DMU scan. Rerun a full database scan in the DMU before executing CSREPAIR.';

  failing_feasibility_20014 constant varchar2(160 byte) :=
    'CSREPAIR failed. The database character set remains unchanged. Restart the database to restore system parameters modified by the script.';

  shutdown_abort_20015 constant varchar2(80 byte) :=
    'CSREPAIR failed. Shut down the database and contact Oracle Support.';

  bad_dmu_repository_20016_20023 constant varchar2(240 byte) :=
    'The DMU repository does not exist or is corrupted. Install the repository and run a full DMU database scan specifying the desired target character set in the Assumed Database Character Set database property.';

  unsupported_dbcs_20024 constant varchar2(80 byte) :=
    'The database character set is not supported by CSREPAIR.';

  unsupported_assumed_cs_20025 constant varchar2(80 byte) :=
    'The target character set is not supported by CSREPAIR.';

  CDB_and_assumed_dbcs_20026 constant varchar2(160 byte) :=
    'The target character set differs from the database character set of the root container of this container database.';

  CDB_SEED_not_supported_20027 constant varchar2(80 byte) :=     
    'Running CSREPAIR in a CDB root or seed container is not supported.';

  shutdown_abort_20028 constant varchar2(80 byte) :=
    'CSREPAIR failed. Close the pluggable database and contact Oracle Support.';

  failing_PDB_feasibility_20029 constant varchar2(160 byte) :=
    'CSREPAIR failed. The database character set of the pluggable database remains unchanged.';

  shutdown_abort_20030 constant varchar2(240 byte) :=
    'CSREPAIR failed. The database character set has not been changed permanently. Note the additional information returned, restart the database, take corrective actions, then retry CSREPAIR.';

  concurrent_connections_20031 constant varchar2(160 byte) :=
    'CSREPAIR cannot run when other sessions are active. Terminate all other sessions and retry.';

  concurrent_jobs_20032 constant varchar2(160 byte) :=
    'CSREPAIR cannot run when background jobs are active. Terminate all jobs, make sure Job Scheduler processes are stopped, and retry.';

  real_application_cluster_20033 constant varchar2(320 byte) :=
    'CSREPAIR cannot run in an Oracle Real Application Clusters environment. Set the CLUSTER_DATABASE initialization parameter to FALSE, then restart the database and retry CSREPAIR. Reset the parameter to TRUE after the character set has been changed.';





  
  procedure csr$trace(message IN varchar2)
  is
  begin
    if (trace_on = TRUE) then
      dbms_output.put_line(message);
    end if;
  end csr$trace;                                           


  





  function csr$get_pdb_id_and_name(pdb_name OUT varchar2)
    return integer
  is
    pdb_id integer;
  begin
    pdb_name := SYS_CONTEXT('USERENV', 'CON_NAME');
    pdb_id   := NVL(SYS_CONTEXT('USERENV', 'CON_ID'), 0);

    csr$trace('The ID of the PDB is ' || pdb_id);
    csr$trace('The name of the PDB is ' || pdb_name);
    return pdb_id;

  exception
    when others then                 
      csr$trace('CSREPAIR failed to retrieve the ID and name of the PDB');
      pdb_name := NULL;

    return 0;
  end csr$get_pdb_id_and_name;                             


  








  function csr$get_charset_type(cs_name IN varchar2)
    return integer
  is
    cs_id        integer;
    max_cs_width integer;
    no_get_maxsize EXCEPTION;
    PRAGMA EXCEPTION_INIT(no_get_maxsize, -904);
  begin
    



    begin
      EXECUTE IMMEDIATE
        'SELECT utl_i18n.get_max_character_size(:1) FROM dual'
      INTO max_cs_width
      USING cs_name;

      if (max_cs_width > 1) then
        max_cs_width := 2;
      end if;

      return max_cs_width;

    exception
      when no_get_maxsize then
      

      








      cs_id := nls_charset_id(cs_name);

      case                                                  
        when cs_id = 1002  then max_cs_width := 1;              
      else
        if ((cs_id >= 1) and (cs_id <= 798)) then
          max_cs_width := 1;
        elsif ((cs_id >= 829) and (cs_id <= 7999) or
                       
               (cs_id >= 9000) and (cs_id <= 9999)) then
          max_cs_width := 2;
        else
          max_cs_width := 0;                  
        end if;
      end case;

      return max_cs_width;
    end;

  exception
    when others then
      raise_application_error(-20000, get_charset_type_failed_20000, true);

  end csr$get_charset_type;                                



begin
 begin
  
  pdb_id := csr$get_pdb_id_and_name(pdb_name);

  

  EXECUTE IMMEDIATE 'ALTER SYSTEM ENABLE RESTRICTED SESSION';

  if (pdb_id = 0) then
    EXECUTE IMMEDIATE 'ALTER SYSTEM SET job_queue_processes=0 SCOPE=MEMORY';
    EXECUTE IMMEDIATE 'ALTER SYSTEM SET aq_tm_processes=0 SCOPE=MEMORY';
  end if;


  
  SELECT count(*) INTO v_count FROM dba_scheduler_running_jobs;
  if (v_count > 0) then
    raise_application_error(-20032, concurrent_jobs_20032, true);
  end if;

  
  SELECT count(*) INTO v_count FROM v$session WHERE type='USER';
  if (v_count > 1) then
    raise_application_error(-20031, concurrent_connections_20031, true);
  end if;

  
  SELECT count(*) INTO v_count FROM v$instance WHERE parallel = 'YES';
  if (v_count > 0) then
    raise_application_error(-20033, real_application_cluster_20033, true);
  end if;


  
  
  SELECT count(*) INTO v_count FROM dba_objects
    WHERE object_type='TABLE' AND owner='SYSTEM' AND object_name IN
         ('DUM$DATABASE', 'DUM$TABLES', 'DUM$COLUMNS',
          'DUM$TABLE_PROFILES', 'DUM$COLUMN_PROFILES', 'DUM$SCHEMA_PROFILES',
          'DUM$SESSIONS',
          'DUM$ATTRIBUTES', 'DUM$SEGMENTS', 'DUM$TABLESPACES',
          'DUM$TABLE_CHUNKS', 'DUM$EXCEPTIONS', 'DUM$SQLTEXT',
          'DUM$INDEXES', 'DUM$SESSION_HISTORY');
  




  if (v_count <> 15) then
    raise_application_error(-20023, bad_dmu_repository_20016_20023, true);
  end if;

  sqlstmt := 'SELECT count(*) FROM system.dum$database';
  EXECUTE IMMEDIATE sqlstmt INTO v_count;
  if (v_count <> 1) then
    raise_application_error(-20016, bad_dmu_repository_20016_20023, true);
  end if;

  
  sqlstmt := 'SELECT version FROM system.dum$database';
  EXECUTE IMMEDIATE sqlstmt INTO v_count;
  if (v_count <> 7) then
    
    raise_application_error(-20002, bad_dmu_version_20002, true);
  end if;

  
  sqlstmt := 'SELECT /*+ first_rows(2) */ count(*) FROM system.dum$tables WHERE rownum < 2';
  EXECUTE IMMEDIATE sqlstmt INTO v_count;
  if (v_count < 1) then
    raise_application_error(-20017, bad_dmu_repository_20016_20023, true);
  end if;

  sqlstmt := 'SELECT /*+ first_rows(2) */ count(*) FROM system.dum$columns WHERE rownum < 2';
  EXECUTE IMMEDIATE sqlstmt INTO v_count;
  if (v_count < 1) then
    raise_application_error(-20018, bad_dmu_repository_20016_20023, true);
  end if;

  sqlstmt := 'SELECT /*+ first_rows(2) */ count(*) FROM system.dum$column_profiles WHERE rownum < 2';
  EXECUTE IMMEDIATE sqlstmt INTO v_count;
  if (v_count < 1) then
    raise_application_error(-20019, bad_dmu_repository_20016_20023, true);
  end if;

  sqlstmt := 'SELECT /*+ first_rows(2) */ count(*) FROM system.dum$table_profiles WHERE rownum < 2';
  EXECUTE IMMEDIATE sqlstmt INTO v_count;
  if (v_count < 1) then
    raise_application_error(-20020, bad_dmu_repository_20016_20023, true);
  end if;

  sqlstmt := 'SELECT /*+ first_rows(2) */ count(*) FROM system.dum$schema_profiles WHERE rownum < 2';
  EXECUTE IMMEDIATE sqlstmt INTO v_count;
  if (v_count < 1) then
    raise_application_error(-20021, bad_dmu_repository_20016_20023, true);
  end if;

  


  sqlstmt := 'SELECT count(*) FROM system.dum$sessions';
  EXECUTE IMMEDIATE sqlstmt INTO v_count;
  if (v_count <> 0) then
    if (v_count = 1) then
      raise_application_error(-20003, bad_dmu_session_20003, true);
    else
      raise_application_error(-20022, bad_dmu_repository_20016_20023, true);
    end if;
  end if;


  
  sqlstmt :=
    'SELECT /*+ first_rows(2) */ count(*) FROM system.dum$columns
       WHERE (scan_status IS NULL OR scan_status <> 1)
       AND scheduled_no_conversion <> 1
       AND rownum < 2';
  EXECUTE IMMEDIATE sqlstmt INTO v_count;
  if (v_count > 0) then
    raise_application_error(-20004, bad_dmu_scan_20004, true);
  end if;


  
  
  sqlstmt := 'SELECT ddbcs_id, nls_charset_name(ddbcs_id) FROM system.dum$database';
  EXECUTE IMMEDIATE sqlstmt INTO assumed_dbcs_id, assumed_dbcs_name;
  if (assumed_dbcs_id < 1) then
    raise_application_error(-20005, bad_assumed_dbcs_20005, true);
  end if;

  csr$trace('The target DBCS is ' || assumed_dbcs_name);


  




  if (pdb_id > 0) then
    begin
      sqlstmt :=
        'SELECT v.ksppstvl FROM sys.x$ksppi i, sys.x$ksppcv v
           WHERE i.indx = v.indx
           AND   i.ksppinm = ''_multiple_char_set_cdb''';

      EXECUTE IMMEDIATE sqlstmt INTO heterogeneous_dbcs;
      csr$trace('Database parameter _multiple_char_set_cdb is set to ' ||
                heterogeneous_dbcs);
    exception
      when others then
        if (SQLCODE <> 100) then
          raise;
        else
          csr$trace('Database parameter _multiple_char_set_cdb is not set.');
        end if;
    end;

    
    root_dbcs_name := '&sqlplus_cdb_dbcs_name';
    csr$trace('The CDB DBCS is ' || root_dbcs_name);

    if (heterogeneous_dbcs = 'FALSE' or
        heterogeneous_dbcs is NULL or
        root_dbcs_name <> 'AL32UTF8') then
      
      if (assumed_dbcs_name <> root_dbcs_name) then
        raise_application_error(-20026, CDB_and_assumed_dbcs_20026, true);
      end if;
    end if;
  end if;

  
  SELECT nls_charset_id(value), value INTO current_dbcs_id, current_dbcs_name
    FROM nls_database_parameters
    WHERE parameter = 'NLS_CHARACTERSET';

  csr$trace('The current DBCS is ' || current_dbcs_name);

  if (assumed_dbcs_id = current_dbcs_id) then
    raise_application_error(-20006, same_dbcs_20006, true);
  end if;


  
  if (UTL_RAW.CONVERT(HEXTORAW('23405b5c5d5e5f607b7c7d7e'),
                       'AMERICAN_AMERICA.AL32UTF8',
                       'AMERICAN_AMERICA.'|| assumed_dbcs_name)
      <> HEXTORAW('23405b5c5d5e5f607b7c7d7e')) then
    raise_application_error(-20007, assumed_dbcs_super_ascii_20007, true);
  end if;

  


















  

  dbcs_charset_type := csr$get_charset_type(current_dbcs_name);
  assumed_charset_type := csr$get_charset_type(assumed_dbcs_name);

  if (dbcs_charset_type = 0) then
    raise_application_error(-20024, unsupported_dbcs_20024, true);
  end if;

  if (assumed_charset_type = 0) then
    raise_application_error(-20025, unsupported_assumed_cs_20025, true);
  end if;

  if (dbcs_charset_type <> assumed_charset_type) then
    if (assumed_charset_type = 1) then
      
      raise_application_error(-20008, not_multi_to_single_20008, true);
    else
      
      raise_application_error(-20009, not_single_to_multi_20009, true);
    end if;
  end if;


  

  sqlstmt :=
    'SELECT /*+ first_rows(2) */ count(*) FROM system.dum$columns
       WHERE dccs_id <> :1
       AND dccs_id != 0
       AND dccs_id IS NOT NULL
       AND rownum < 2';
  EXECUTE IMMEDIATE sqlstmt INTO v_count USING assumed_dbcs_id;
  if (v_count <> 0) then
    raise_application_error(-20010, bad_assumed_column_cs_20010, true);
  end if;


  
  sqlstmt :=
    'SELECT /*+ first_rows(2) */ count(*) FROM system.dum$columns
       WHERE invalid > 0
       AND scheduled_no_conversion = 0
       AND rownum < 2';
  EXECUTE IMMEDIATE sqlstmt INTO v_count;
  if (v_count <> 0) then
    raise_application_error(-20011, invalid_data_20011, true);
  end if;


  
  if (dbcs_charset_type = 1) then
    sqlstmt := 'begin SYS.DBMS_DUMA_SYS.REFRESH_REPOSITORY(:1, NULL, TRUE); end;';
  else
    sqlstmt := 'begin SYS.DBMS_DUMA_SYS.REFRESH_REPOSITORY(:1, NULL, FALSE); end;';
  end if;
  EXECUTE IMMEDIATE sqlstmt USING OUT v_count;
  if (v_count <> 0) then
    raise_application_error(-20012, altered_dmu_20012, true);
  end if;

 exception
  when others then
    csr$trace('Failing SQL is "' || sqlstmt || '"');
    if (pdb_id > 0) then
      raise_application_error(-20029, failing_PDB_feasibility_20029, true);
    else
      raise_application_error(-20014, failing_feasibility_20014, true);
    end if;
 end;







 declare
  returned_error   number;
  returned_message varchar2(240 byte);
                
  altered_dbcs_name varchar2(28 byte) := null;
 begin
  EXECUTE IMMEDIATE
    'ALTER DATABASE CHARACTER SET internal_use ' || assumed_dbcs_name;

  

  sqlstmt := 'SELECT value FROM nls_database_parameters WHERE parameter=''NLS_CHARACTERSET''';
  EXECUTE IMMEDIATE sqlstmt INTO altered_dbcs_name;

  if (altered_dbcs_name <> assumed_dbcs_name) then
    if (pdb_id = 0) then
      returned_message := 'The database character set';
    else
      returned_message := 'The database character set of ''' || pdb_name || '''';
    end if;

    returned_message := returned_message ||
      ' has been incorrectly changed to ' || altered_dbcs_name ||
      ' and not to the expected ' || assumed_dbcs_name ||
      '.';

    raise_application_error(-20027, returned_message, true);
  end if;

  
  if (pdb_id = 0) then
    dbms_output.put_line('The database character set has been successfully changed to ' ||
      assumed_dbcs_name || '. You must restart the database now.');
  else
    dbms_output.put_line('The database character set of ''' || pdb_name ||
      ''' has been successfully changed to ' || assumed_dbcs_name ||
      '. You must now close and reopen the pluggable database.');
  end if;

 exception
  when others then
    if ((SQLCODE = -1404) or                              
        (SQLCODE = -1429) or                                 
        (SQLCODE = -14061) or                         
        (SQLCODE = -14060) or                               
        (SQLCODE = -16684) or                             
        (SQLCODE = -16686) or                             
        (SQLCODE = -1447) or                                  
        (SQLCODE = -54031) or                         
        (SQLCODE = -38398) or                                     
        (SQLCODE = -14148)                                    
       ) then
      returned_error := -20030;
      returned_message := shutdown_abort_20030;
    elsif (SQLCODE = -12721) then                         
      returned_error := -20031;
      returned_message := concurrent_connections_20031;
    else
      begin
        if (pdb_id = 0) then
          returned_error := -20015;
          returned_message := shutdown_abort_20015;
        else
          returned_error := -20028;
          returned_message := shutdown_abort_20028;
       end if;
      end;
    end if;

    raise_application_error(returned_error, returned_message, true);
 end;
end;
/
exit;
