Rem
Rem $Header: duma/admin/after_drop_repository.sql /main/3 2015/12/07 02:09:43 xiaonili Exp $
Rem
Rem after_drop_repository.sql
Rem
Rem Copyright (c) 2008, 2015, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      after_drop_repository.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      This script drops DUMA auxiliary tables and packages
Rem
Rem    NOTES
Rem      Run as SYS user.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    xiaonili    11/29/15 - fix bug 22162405
Rem    qicheng     12/30/09 - Created
Rem
SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

 -- drop anydataset temporaries
 declare 
   cursor updateobj is select name from obj$ where name like 'DUM$CLS$%UPD' and type# = 7; 
   cursor queryobj is select name from obj$ where name like 'DUM$CLS$%QUE' and type# = 8; 
   cursor arrayobj is select name from obj$ where name like 'DUM$CLS$%ARR' and type# = 13;
   objname varchar2(40); 
 begin 
   open updateobj; 
   loop 
     fetch updateobj into objname;   
     exit when updateobj%NOTFOUND; 
     dbms_output.put_line('drop procedure sys.' || objname); 
     execute immediate 'drop procedure sys.' || objname;    
   end loop;   
   close updateobj;  
   open queryobj; 
   loop 
     fetch queryobj into objname;   
     exit when queryobj%NOTFOUND; 
     dbms_output.put_line('drop function sys.' || objname); 
     execute immediate 'drop function sys.' || objname;    
   end loop; 
   close queryobj; 
   open arrayobj; 
   loop 
     fetch arrayobj into objname;  
     exit when arrayobj%NOTFOUND; 
     dbms_output.put_line('drop type sys.' || objname);      
     execute immediate 'drop type sys.' || objname;        
   end loop; 
   close arrayobj; 
 end; 
/

-- 
drop package sys.dbms_duma_sys
/
