/* Copyright (c) 2005, 2016, Oracle and/or its affiliates. 
All rights reserved.*/

/*
   DESCRIPTION
    This defines all the Install Constants 

   MODIFIED    (MM/DD/YY)
   pkuruvad    07/25/16 - Bug 24348722 - default DG anmes for ASM on NAS
   davjimen    07/11/16 - add home name prefix for gi and db
   davjimen    07/06/16 - add cluster new nodes and vips arg constants
   davjimen    06/14/16 - add installer patch constants
   davjimen    06/10/16 - add the skip stack check arg
   davjimen    05/24/16 - add runall cmdline arg constant
   davjimen    05/24/16 - add force flag constant
   pvallam     05/19/16 - opatch binary name
   ambagraw    05/03/16 - Bug 23117589 - LNX64-12.2-INST: OUI TO REJECT 1 HUB +
                          1 LEAF CONFIGURATION
   lorajan     04/28/16 - Adding crs base warning as 10 GB for Non Domain Service cluster and 100 GB for Domain Service cluster. Fixing bug 23196658.
   pvallam     04/20/16 - adding target type for rac
   pkuruvad    04/11/16 - ASM on NAS feature
   davjimen    03/09/16 - add config tools feature property constant for root
                          script execution support
   pkuruvad    02/23/16 - Bug 22660043
   davjimen    02/03/16 - add create goldimage constant
   pvallam     01/31/16 - adding db target type
   lorajan     10/18/15 - Adding constants for crs base validation.
   davjimen    09/24/15 - change configtools name
   lorajan     09/14/15 - Adding CRS_BASE size, Fixing the bug 19710705.
   davjimen    08/24/15 - add auto save rsp file constants 
   davjimen    07/28/15 - rename update nodelist config tool feature property
   supalava    07/09/15 - Add targettype constants needed for patch job.
   davjimen    06/23/15 - add nodelist job feature properties
   lorajan     05/13/15 - Adding ignorePrereq,skipPrereq and
                          ignorePrereqFailure constants in the
                          InstallConstants. Fixing bug 20876188.
   davjimen    03/13/15 - add oracle home constant
   supalava    03/12/15 - Project 53590 - Standalone Remote copy job.
   lorajan     01/21/15 - Adding constant for Product Language.
    pkuruvad    01/06/15 - add install constant for 12.2
    pkuruvad    01/04/15 - bug 19784579 - add install constant for 12.2
    supalava    01/02/15 - Proj 53590 - Add RemoteCopy Job constants.
    haagrawa    12/04/14 - changing enablePE to visiblePE(Bug# 16922034)
    davjimen    09/04/14 - add setup wizard execution property
    haagrawa    07/18/14 - XbranchMerge
                           haagrawa_se_and_seone_disable_on_windows from
                           st_install_12.1
    davjimen    07/17/14 - add COMPONENT_GSM, COMPONENT_TG and COMPONENT_CLIENT 
                           constants
    haagrawa    06/24/14 - adding enablePE
    haagrawa    06/10/14 - adding enableEE,enableSE,enableSEONE
    davjimen    04/07/14 - add COMPONENT_SERVER constant
    supalava    09/19/13 - Project 47201 - SYSRAC Changes.
    pvallam     10/31/12 - adding exclamation and period in list of bad
                           chars
    xiaofwan    06/19/12 - Add FREE_SPACE_BUFFER_MULTIPLIER &
                           FREE_SPACE_BUFFER_MULTIPLIER_AIX
    pkuruvad    05/25/12 - Allow '!' for passwords
    jaikrish    03/19/12 - adding asmadmin and asmdba group for windows.
    pkuruvad    03/06/12 - making the namespaceURI variable to be version specific
    pvallam     02/28/12 - sizes with cdb
    jaikrish    01/29/12 - adding cman changes
    jaikrish    11/30/11 - add ntoramts entry
    wyou        11/28/11 - add TG_IVW_DLG_RB and TG_IVW_ERR_RB
    wyou        11/14/11 - add badchar list
    wyou        06/14/11 - add GSM_IVW_DLG_RB
    wyou        05/23/11 - add SoD related privilege
    rmallego    05/20/11 - adding NODE_LIVELINESS_CHECK_TIMEOUT constant
    pvallam     04/26/11 - XbranchMerge pvallam_bug-11770204_11203 from
                           st_install_11.2.0
    scravind    03/22/11 - XbranchMerge scravind_bug-11731701 from main
    scravind    03/13/11 - Fixing the bug 11731701
    pvallam     03/04/11 - adding flag fot MTS port
    rmallego    06/16/10 - adding CHECKSTORAGEFILESYSTEMTYPE_CONTROL_PROPERTY
                           constant
    rmallego    05/31/10 - removing '~' char from the bad character list
    svaggu      04/15/10 - Adding the "suppressRootMessage" string constant.
    dschrein    02/16/10 - windows port range constants from client to install
    svaggu      12/13/09 - Bad characters consolidation
    poosrini    09/27/09 - Project 31055: Config Wizard for GI
    rmallego    09/17/09 - adding VERSION_11_2 variable
    scravind    09/17/09 - Adding the constant for selecting all languages
    dchriste    01/26/09 - Add ASM OS group defaults for validation
    poosrini    03/24/08 - 
    dschrein    03/03/08 - add demos
    wyou        02/18/08 - add string[] supported language,
    dschrein    02/14/08 - more client things
    dschrein    02/04/08 - add client
    msubbann    01/22/08 - default names for Sys OS groups
    poosrini    01/17/08 - HA option transition to CRS shiphome
    ssampath    11/26/07 - XbranchMerge ssampath_dummy_tb_txn from
                           st_install_tb
    msubbann    10/17/07 - Add product version variable
    vtapadia    09/13/07 - Added Default Inventory Location directory
    aqazi       12/12/06 - 
    bktripat    10/11/06 - Creation
 */
package oracle.install.library.util;

import java.io.File;
import oracle.install.commons.util.Version;
import oracle.install.ivw.common.util.PreferenceHelper;


public interface InstallConstants 
{
	
	public static final String CRS_IVW_ERR_RB = "oracle.install.ivw.crs.resource.CRSErrorResID";
    public static final String CRS_IVW_DLG_RB = "oracle.install.ivw.crs.resource.CRSDialogLabelResID";
    public static final String DB_IVW_ERR_RB = "oracle.install.ivw.db.resource.DBErrorResID";
    public static final String DB_IVW_DLG_RB = "oracle.install.ivw.db.resource.DBDialogLabelResID";
    public static final String CLIENT_IVW_ERR_RB = "oracle.install.ivw.client.resource.ClientErrorResID";
    public static final String CLIENT_IVW_DLG_RB = "oracle.install.ivw.client.resource.ClientDialogLabelResID";
    public static final String GSM_IVW_ERR_RB = "oracle.install.ivw.gsm.resource.GSMErrorResID";
    public static final String GSM_IVW_DLG_RB = "oracle.install.ivw.gsm.resource.GSMDialogLabelResID";
    public static final String COMMON_IVW_ERR_RB = "oracle.install.ivw.common.resource.CommonErrorResID";
    public static final String COMMON_IVW_DLG_RB = "oracle.install.ivw.common.resource.CommonDialogLabelResID";
    public static final String DEMOS_IVW_ERR_RB = "oracle.install.ivw.demos.resource.DemosErrorResID";
    public static final String DEMOS_IVW_DLG_RB = "oracle.install.ivw.demos.resource.DemosDialogLabelResID";
    public static final String TG_IVW_ERR_RB = "oracle.install.ivw.tg.resource.TGErrorResID";
    public static final String TG_IVW_DLG_RB = "oracle.install.ivw.tg.resource.TGDialogLabelResID";
    
    public static final String COMMON_UTIL_ERR_RB = "oracle.install.library.resource.CommonErrorResID";
    public static final String OUI_LIBRARY_LOC  = "oracle.installer.library_loc";
    public static final String INVPTR_LOC     = "oracle.installer.invPtrLoc";
    public static final String SOURCE_LOC  = "oracle.installer.sourceLoc";
    public static final String SCRATCH_PATH  = "oracle.installer.scratchPath";
    /*public static final int MIN_FREE_DISK_SPACE_SWONLY = 2600;
    public static final int MIN_FREE_DISK_SPACE_CRS_SWONLY = 2200;
    public static final int MIN_FREE_DISK_SPACE_CLIENT = 1024;
    public static final int MIN_FREE_DISK_SPACE_DEMOS = 1024;*/
    public static final long ORADATA_DISK_SPACE_REQUIRED = 1800;
    public static final long ORADATA_WITH_CDB_DISK_SPACE_REQUIRED = 3800;
    
    public static final long MIN_FREE_DISK_SPACE_CRS_BASE = 1024 ; 
    // 10 GB as crs base warning for NON-Domain Service Cluster
    public static final long MIN_FREE_DISK_SPACE_FOR_NON_DC_CRS_BASE_WARNING = MIN_FREE_DISK_SPACE_CRS_BASE * 10 ;
    // 100 GB as crs base warning for Domain Service Cluster
    public static final long MIN_FREE_DISK_SPACE_FOR_DC_CRS_BASE_WARNING = MIN_FREE_DISK_SPACE_CRS_BASE * 100 ;
    
    public static final int MAX_ORACLE_HOME_NAME_LENGTH = 128;
    public static final String ORACLE_HOME_NAME_GI_PREFIX = "OraGI";
    public static final String ORACLE_HOME_NAME_DB_PREFIX = "OraDB";
    public static final String ORACLE_HOME_NAME_SUFFIX = "Home";
    
    public static final String INVENTORY_LOCATION= "oraInventory";
    public static final String ORACLE_HOME = "ORACLE_HOME";
    
    // response file constants
    public static final String RESPONSE_FILE_PATH = "install" + File.separator + "response";
    public static final String RESPONSE_GRID_PREFIX = "grid";
    public static final String RESPONSE_DB_PREFIX = "db";
    public static final String RESPONSE_CLIENT_PREFIX = "client";
    public static final String RESPONSE_TG_PREFIX = "tg";
    public static final String RESPONSE_DEMOS_PREFIX = "examples";
    public static final String RESPONSE_GSM_PREFIX = "gsm";
    public static final String RESPONSE_FILE_SUFFIX = ".rsp";
    
    public static final Version VERSION = Version.parseVersion("@<DB_VERSION>@");

    public static final String SYSDBA_DEFAULT_NAME = "dba";
    public static final String SYSOPER_DEFAULT_NAME = "oper";
    public static final String SYSBACKUP_DEFAULT_NAME = "backupdba";
    public static final String SYSDG_DEFAULT_NAME = "dgdba";
    public static final String SYSKM_DEFAULT_NAME = "kmdba";
    public static final String SYSASM_DEFAULT_NAME = "asmadmin";
    public static final String ASM_SYSDBA_DEFAULT_NAME = "asmdba";
    public static final String ASM_SYSOPER_DEFAULT_NAME = "asmoper";
    public static final String WIN_ASM_SYSDBA_DEFAULT_NAME = "ORA_ASMDBA";
    public static final String WIN_SYSASM_DEFAULT_NAME = "ORA_ASMADMIN";
    public static final String SYSRAC_DEFAULT_NAME = "racdba";
    public static final String [] OUI_SUPPORTED_LANGUAGES = {"en","fr","ar","bn","pt_BR","bg","fr_CA","ca","hr","cs","da","nl","ar_EG","en_GB","et","fi","de","el","iw","hu","is","in","it","ja","ko","es","lv","lt","ms","es_MX","no","pl","pt","ro","ru","zh_CN","sk","sl","es_ES","sv","th","zh_TW","tr","uk","vi"};
    public static final int PORT_NUMBER_LENGTH_CONSTANT=5;    
    public static final String  DEFAULT_LANGUAGE = "en";
    public static final String  CVUQDISK_RPM_NAME="cvuqdisk";
    public static final String  CVUQDISK_RPM_MIN_VERSION="0";
    public static final String GETSHAREDPARTITIONLISTCVU_CONTROL_PROPERTY="oracle.install.cvu.getSharedPartitionList";
    public static final String CHECKSTORAGEFILESYSTEMTYPE_CONTROL_PROPERTY="oracle.install.cvu.checkSharedStorageFileSystemType";
    public static final String SELECT_ALL_LANGUAGES="all_langs";	
    public static final Version VERSION_11_2=Version.parseVersion("11.2.0.0.0");
    public static final Version VERSION_12_1=Version.parseVersion("12.1.0.0.0");
    public static final Version VERSION_12_2=Version.parseVersion("12.2.0.0.0");

	//system property to identify config wizard execution - passed from config.pl
	public static final String CONFIGWIZARD_PROPERTY = "oracle.installer.configWizard";	
	
	//system property to identify setup wizard execution - passed from gridSetup.pl
	public static final String SETUPWIZARD_PROPERTY = "oracle.installer.setupWizard";
	public static final String TEMP_LOG_DIR = "oracle.installer.tempLogDir";
	public static final String GRIDCONFIG_PROPERTY = "oracle.installer.gridConfig";
	
	// system property to identify whether to use OUI Remote Copy mechanism
    public static final String PERFORM_REMOTE_COPY_API_MODE = "oracle.installer.performRemoteCopyInAPIMode";
	
	//Bad characters
	public static final String INSTALL_COMMON_BADCHARS="!.@%^&*()+=\\|`~[{]};:'\",<>/?";
	public static final String INSTALL_BADCHARS_INSTALL_LOCATION_WIN="!@%^&*()+=|/`[{]};'\",<>?";
	public static final String INSTALL_BADCHARS_INSTALL_LOCATION_UNIX="!@%^&*()+=|`~[{]};:'\",<>?\\";
	public static final String INSTALL_BADCHARS_OSGROUP="!@%^&*()-+=\\|`~[{]};:'\",<>/?.#$ ";

    // Constants used for determining the default OraMTS Port Number
    // These represent the user-available range of ports on Windows
    public static final Integer WIN_PORT_NUMBER_RANGE_MIN=new Integer(49152);
    public static final Integer WIN_PORT_NUMBER_RANGE_MAX=new Integer(65535);
    
    // Flag for supressing the root script(s) message window
    public static final String SUPRESS_ROOT_MESSAGE_FLAG = "-suppressRootMessage";
    //Property for CRSIntegrity check. This property can be used to disable/enable the check accordingly.
    public static final String CHECK_CRS_INTEGRITY_PROPERTY="oracle.install.cvu.checkCRSIntegrity";

    // MTS Port flag
    public static final String MTS_PORT_NUMBER_FLAG="MTS_PORT";
    public static final int NODE_LIVELINESS_CHECK_TIMEOUT = 10;
    public static final String COMPONENT_ASSISTANTS_NETCA_CLIENT = "oracle.assistants.netca.client";
    public static final String COMPONENT_CRS = "oracle.crs";
    public static final String COMPONENT_SERVER = "oracle.server";
    public static final String COMPONENT_GSM = "oracle.dslm";
    public static final String COMPONENT_TG = "oracle.tg";
    public static final String COMPONENT_CLIENT = "oracle.client";

    public static final String HOME_ORATAB_LOC="install"+File.separator+"oratab";
    public static final String COMPONENT_NTORAMTS = "oracle.ntoramts";

    public static final String COMPONENT_NETWORK_CMAN = "oracle.network.cman";
    public static final String COMPONENT_RDBMS_SCHEDULERAGENT = "oracle.rdbms.scheduler";
    
    public static final String DB_NAMESPACE_URI = "/oracle/install/rspfmt_dbinstall_response_schema_v" + "@<DB_VERSION_THREE_DIGITS>@";
    public static final String CRS_NAMESPACE_URI = "/oracle/install/rspfmt_crsinstall_response_schema_v" + "@<DB_VERSION_THREE_DIGITS>@";
    public static final String DEMOS_NAMESPACE_URI = "/oracle/install/rspfmt_demosinstall_response_schema_v" + "@<DB_VERSION_THREE_DIGITS>@";
    public static final String CLIENT_NAMESPACE_URI = "/oracle/install/rspfmt_clientinstall_response_schema_v" + "@<DB_VERSION_THREE_DIGITS>@";
    public static final String GSM_NAMESPACE_URI = "/oracle/install/rspfmt_gsminstall_response_schema_v" + "@<DB_VERSION_THREE_DIGITS>@";
    public static final String TG_NAMESPACE_URI = "/oracle/install/rspfmt_tginstall_response_schema_v" + "@<DB_VERSION_THREE_DIGITS>@";
    public static final String ROOT_MACROS_LOCATION = "install"+File.separator+"utl"+File.separator+"rootmacro.sh";    
    public static final String INSTALL_BADCHARS_HOSTNAME=" !@%^&*()+=\\|`~[{]};'\",<>/?#$:";
    public static final int FREE_SPACE_BUFFER_MULTIPLIER = 1;
    public static final int FREE_SPACE_BUFFER_MULTIPLIER_AIX = 5;
    public static final String MGMTDB_CREATE_AS_PDB="oracle.install.mgmtDB.CDB";

    public static final boolean enableEE = Boolean.parseBoolean(PreferenceHelper.getProperty("oracle.install.db.enableEE"));
    public static final boolean enableSE = Boolean.parseBoolean(PreferenceHelper.getProperty("oracle.install.db.enableSE"));
    public static final boolean enableSEONE = Boolean.parseBoolean(PreferenceHelper.getProperty("oracle.install.db.enableSEONE"));
    public static final boolean visiblePE = Boolean.parseBoolean(PreferenceHelper.getProperty("oracle.install.db.visiblePE")); 

    public static final String ENABLE_REMOTE_GIMR="oracle.install.crs.enableRemoteGIMR";
    public static final String SUPPORT_LEAF_NODES="oracle.install.crs.supportLeafNodes"; 
    public static final String SINGLE_HUB_MULTI_LEAF_NODE_SUPPORT="oracle.install.crs.oneHubMultiLeafNodeSupport"; 
    //Product Language 
    public static final String PRODUCT_LANGUAGE = "oracle.install.allowProductLanguageSelection";   
    
    public static final String EXCLUDE_FILE_NAME = "install.excl"; 
    
    // system property to identify whether to use standalone remote copy job
    public static final String ENABLE_STANDALONE_REMOTE_COPY = "oracle.installer.remotecopy.standalone";

    // command line argument constants 
    public static final String SKIP_PREREQ_ARG = "skipPrereqs";
    public static final String SKIP_PREREQ = "-skipPrereq";
    public static final String IGNORE_PREREQ = "ignorePrereq"; 
    public static final String IGNORE_PREREQ_FAILURE_ARG = "ignorePrereqFailure";
    public static final String IGNORE_PREREQ_FAILURE = "-ignorePrereqFailure";
    public static final String CONFIG_TOOLS = "executeConfigTools";
    public static final String CREATE_GOLD_IMAGE = "createGoldImage";
    public static final String SOURCE_HOME = "sourceHome";
    public static final String DESTINATION_LOCATION = "destinationLocation";
    public static final String EXCL_FILES = "exclFiles";
    public static final String FORCE = "force";
    public static final String ALL = "all";
    public static final String SKIP_STACK_CHECK = "skipStackCheck";
    public static final String CLUSTER_NEW_NODES = "CLUSTER_NEW_NODES";
    public static final String CLUSTER_NEW_VIRTUAL_HOSTNAMES = "CLUSTER_NEW_VIRTUAL_HOSTNAMES";
    public static final String SWITCH_GRID_HOME="switchGridHome";
    
    // feature properties constants
    public static final String FEATURE_GRID_ENABLE_NODELIST_JOB = "oracle.install.crs.enableNodelistJob";
    public static final String FEATURE_GRID_ENABLE_UPDATE_CRS_FLAG_IN_INVENTORY = "oracle.install.crs.updateCRSFlagInInventory";
    public static final String FEATURE_DB_ENABLE_NODELIST_JOB = "oracle.install.db.enableNodelistJob";
    public static final String FEATURE_GRID_CONFIGTOOLS_ENABLE_ROOTSCRIPT = "oracle.install.crs.configTools.rootScriptExecution";
    
    // target type constants needed for OPatchauto
    public static final String TARGET_TYPE_CLUSTER = "cluster";

	// target type constant for db shiphomed needed for OPatchauto
    public static final String TARGET_TYPE_DATABASE = "oracle_database";

    public static final String TARGET_TYPE_DATABASE_FOR_RAC= "rac_database";
    
	//system property for standalone addnode launcher
    public static final String ADDNODE_STANDALONE_PROPERTY = "oracle.installer.crs.standalone.addnode";

    public static final String ROOT_CONFIG_LOCATION = "crs"+File.separator+"config"+File.separator+"rootconfig.sh";
    
    public static final String FEATURE_ADDNODE_EXISTING_NODES_SSH_CHECK = "oracle.install.crs.addnode.doExistingNodesSSHCheck";

    public static final String FEATURE_GRID_ENABLE_RHP_SERVICE = "oracle.install.crs.enableRHPServer";
   
    public static final String OPATCH_COMMAND_UNIX = "opatch";
    
    public static final String OPATCH_COMMAND_WIN  = "opatch.bat";
    
    public static final String FEATURE_GRID_ASM_ON_NAS = "oracle.install.crs.ASMOnNASOption";

    public static final String FEATURE_GRID_SHOW_AFD = "oracle.install.crs.showAFDOption";

    public static final String FEATURE_GRID_ENABLE_EXTENDED_REDUNDANCY = "oracle.install.crs.enableExtendedRedundancy";

    public static final String ASM_ON_NAS_OCR_DISKGROUP_NAME = "ocrvfdg";

    public static final String ASM_ON_NAS_GIMR_DISKGROUP_NAME = "backupdg";
    
    // Installer Patch Constants
    public static final String TIMESTAMP_FLAG = "-timestamp";
    public static final String TEMPLOCATION_FLAG = "-tempLocation";
    public static final String DEBUG_FLAG = "-debug";
    public static final String STATUS_FLAG = "-status";
    public static final String REVERT_FLAG = "-revert";
    public static final String INSTALLER_PATCH_ACTIONS_LOG_PREFIX = "installerPatchActions";
    public static final String INSTALLER_PATCH_LOCK_FILE = "install" + File.separator + "patch";
    public static final String PATCH_ACTIONS_DIR_NAME = "PatchActions";
    public static final String TEMP_INVENTORY_DIR_NAME = "oraInventory";
    public static final String TEMP_BASE_DIR_NAME = "oraBase";
    public static final String INSTALLER_UPDATE_MARK_FILE_PREFIX = "inst";
}
