Rem
Rem $Header: rdbms/admin/xrdu121.sql /st_rdbms_12.2.0.1.0/2 2016/08/16 16:22:41 surman Exp $
Rem
Rem xrdu121.sql
Rem
Rem Copyright (c) 2014, 2016, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      xrdu121.sql - XDB RDBMS Dependents Upgrade from 12.1
Rem
Rem    DESCRIPTION
Rem      This script contains actions for upgrading from 12.1
Rem
Rem    NOTES
Rem     
Rem
Rem    BEGIN SQL_FILE_METADATA 
Rem    SQL_SOURCE_FILE: rdbms/admin/xrdu121.sql 
Rem    SQL_SHIPPED_FILE: rdbms/admin/xrdu121.sql 
Rem    SQL_PHASE: XRDU121
Rem    SQL_STARTUP_MODE: UPGRADE
Rem    SQL_IGNORABLE_ERRORS: NONE 
Rem    SQL_CALLING_FILE: rdbms/admin/xrdupgrd.sql
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    surman      07/20/16 - 23170620: Add patch_directory
Rem    surman      07/15/16 - 23705955: Change patch_descriptor to XMLType
Rem    surman      06/21/16 - 22694961: Add datapatch_role
Rem    surman      05/05/16 - 23025340: Add install_id
Rem    atomar      02/01/16 - bug 22642228 upgrade unsharded AQ views
Rem    surman      01/26/16 - 22582783: Use CreateXML
Rem    surman      01/20/16 - 22359063: Add patch descriptor
Rem    rpang       11/13/15 - Bug 22100322: increase epg$_auth.dad_name size
Rem    surman      08/21/15 - 20772435: SQL registry changes to XDB safe
Rem                           scripts
Rem    jorgrive    01/23/15 - Bug 20317551: exception 31000 for lcr xml schema
Rem    raeburns    12/12/14 - Bug 18747400: Annotate TSDP schema
Rem    jorgrive    12/04/14 - Upgrade Lcr xml schema
Rem    raeburns    11/21/14 - XRD release-specific script
Rem    raeburns    11/21/14 - Created
Rem

Rem ======================================================
Rem BEGIN XRD upgrade from 12.1
Rem ======================================================

-- Delete LCR xml schema, re-registered again when catxrd.sql runs catxlcr.sql
-- Bug 18734501

DECLARE
  schema_not_exists EXCEPTION;
  PRAGMA EXCEPTION_INIT(schema_not_exists,-31000);
BEGIN
  dbms_xmlschema.deleteSchema(
                  'http://xmlns.oracle.com/streams/schemas/lcr/streamslcr.xsd',
                  dbms_xmlschema.DELETE_CASCADE);
  EXCEPTION
  WHEN schema_not_exists THEN
    NULL;
 END;
/

Rem
Rem Delete TSDP schemas; re-created when catxrd.sql is run
Rem Do not exist for upgrade from 11.2
Rem Bug 18747400

DECLARE
  schema_not_exists EXCEPTION;
  PRAGMA EXCEPTION_INIT(schema_not_exists,-31000);
BEGIN
  DBMS_XMLSCHEMA.deleteSchema(
                 'http://xmlns.oracle.com/sdm/sensitivedata_12_1.xsd',
                 DBMS_XMLSCHEMA.DELETE_CASCADE);
EXCEPTION
  WHEN schema_not_exists THEN
    NULL;
END;
/

DECLARE
  schema_not_exists EXCEPTION;
  PRAGMA EXCEPTION_INIT(schema_not_exists,-31000);
BEGIN
  DBMS_XMLSCHEMA.deleteSchema(
                 'http://xmlns.oracle.com/sdm/sensitivetypes_12_1.xsd',
                 DBMS_XMLSCHEMA.DELETE_CASCADE);
EXCEPTION
  WHEN schema_not_exists THEN
    NULL;
END;
/

Rem *************************************************************************
Rem Begin registry$sqlpatch changes
Rem 17665117 & 17277459 : Add patch UID and bundle columns 
Rem 14563594: Add version 
Rem 19315691: Change bundle_data to CLOB
Rem 20772435: bundle_data back to XMLType
Rem 22359063: Add patch_descriptor
Rem 23025340: Add install_id
Rem 23170620: Add patch_directory
Rem *************************************************************************

Rem Since we are in upgrade mode when this script is run, certain errors
Rem including ORA-2443 (nonexistent constraint) and ORA-942 (table does not
Rem exist) are suppressed during alter table.  So we do not need to check for
Rem them.  Except for ORA-904 (invalid identifier), which can occur during
Rem alter table drop column.

alter table registry$sqlpatch drop constraint registry$sqlpatch_pk;

alter table registry$sqlpatch add (version varchar2(20));

alter table registry$sqlpatch add (patch_uid number);

alter table registry$sqlpatch add (flags varchar2(10));

alter table registry$sqlpatch add (bundle_series varchar2(30));

alter table registry$sqlpatch add (bundle_id number);

alter table registry$sqlpatch add (bundle_data XMLType)
  XMLType column bundle_data store as clob;

-- 18764751: Update new columns so they will not violate constraints
-- 19928926: Trap ORA-942 as this is not suppressed during upgrade
begin
  execute immediate 'update registry$sqlpatch set version = 0, patch_uid = 0';
exception
  when others then
    if sqlcode = -942 then
      null;
    else
      raise;
    end if;
end;
/

alter table registry$sqlpatch add (
  constraint registry$sqlpatch_pk PRIMARY KEY
    (patch_id, patch_uid, version, action, action_time));

Rem If we are upgrading from a 12.1.0.2 PSU, bundle_data could be CLOB.  If
Rem so we need to change it back to XMLType.
Rem 23705955: Ditto for patch_descriptor

set serveroutput on
begin
  -- We can't query a nice view like dba_tab_columns because it may be 
  -- invalid during the upgrade.  Sigh.
  for rec in (select name, type#
                from col$
                where obj# = (select obj# from obj$
                                where name = 'REGISTRY$SQLPATCH'
                                and owner# = 0)
                and name in ('BUNDLE_DATA', 'PATCH_DESCRIPTOR')) loop

    -- Type 112 is CLOB
    if rec.type# = 112 then
      -- We need to change to XMLType
      dbms_output.put_line('changing ' || rec.name || ' to XMLType');
      execute immediate 'alter table registry$sqlpatch add (temp XMLType)';
      dbms_output.put_line('updating temp');
      execute immediate
        'update registry$sqlpatch
           set temp = XMLType.CreateXML(' || rec.name || ')';
      begin
        execute immediate
         'alter table registry$sqlpatch drop column ' || rec.name;
      exception
        when others then
          if sqlcode = -904 then
            null;
          else
            raise;
          end if;
      end;
      execute immediate
        'alter table registry$sqlpatch rename column temp to ' || rec.name;
    end if;
  end loop;
exception
  when no_data_found then
    -- 19928926: Ignore ORA-1403 if registry$sqlpatch does not exist
    null;
end;
/

alter table registry$sqlpatch add (patch_descriptor XMLType)
  XMLType column patch_descriptor store as clob;

alter table registry$sqlpatch add (install_id number);

alter table registry$sqlpatch add (patch_directory blob);

Rem *************************************************************************
Rem End registry$sqlpatch changes
Rem *************************************************************************

Rem *************************************************************************
Rem 22694961: Create datapatch role
Rem *************************************************************************

DECLARE
  cnt NUMBER;
BEGIN
  SELECT COUNT(*)
    INTO cnt
    FROM dba_roles
    WHERE role = 'DATAPATCH_ROLE';

  IF cnt = 0 THEN
    EXECUTE IMMEDIATE 'CREATE ROLE datapatch_role';
  END IF;
END;
/

Rem *************************************************************************
Rem Bug 22100322: Increase epg$_auth.dadname size
Rem *************************************************************************

alter table epg$_auth modify dadname varchar2(128)
/

Rem *************************************************************************
Rem End Bug 22100322: Increase epg$_auth.dadname size
Rem *************************************************************************
Rem =========================================================================
Rem BEGIN upgrade unsharded Queue View
Rem =========================================================================

DECLARE
BEGIN

  FOR cur_rec IN (
                  SELECT t.schema, t.name, t.flags, q.eventid
                  FROM system.aq$_queue_tables t, system.aq$_queues q
                  WHERE t.objno = q.table_objno and NVL(q.sharded,0) =0
                 )
  LOOP
    BEGIN
      IF cur_rec.name != 'AQ$DEF$_AQCALL' and cur_rec.name != 'DEF$_AQERROR' THEN
        IF  bitand(cur_rec.flags, 1) = 1 THEN           -- multi-consumer queue
          sys.dbms_prvtaqim.create_base_view(cur_rec.schema, cur_rec.name, cur_rec.flags);
        ELSE                                            -- singleconsumer queue
          sys.dbms_aqadm_sys.create_base_view(cur_rec.schema, cur_rec.name, cur_rec.flags);
        END IF;
      END IF;
    END;
  END LOOP;
  EXCEPTION
    WHEN OTHERS THEN
      DBMS_SYSTEM.ksdwrt(DBMS_SYSTEM.trace_file,
                         'error in unsharded view creation' || sqlcode);
      RAISE;
END;
/

Rem =========================================================================
Rem END upgrade unsharded Queue View
Rem =========================================================================

Rem ======================================================
Rem END XRD upgrade from 12.1
Rem ======================================================

Rem ======================================================
Rem Upgrade from subsequent releases
Rem ======================================================

--uncomment for next release
--@@xrdu122.sql

