@@?/rdbms/admin/sqlsessstart.sql
create or replace view sys_uncompressed_segs_base
    (OWNER, SEGMENT_NAME,
     PARTITION_NAME,
     SEGMENT_TYPE, SEGMENT_TYPE_ID, HEADER_FILE, HEADER_BLOCK,
     TABLESPACE_ID, TABLESPACE_NAME, BLOCKSIZE,
     BUFFER_POOL_ID, EXTENTS, BLOCKS,
     RELATIVE_FNO, SEGMENT_FLAGS, SEGMENT_OBJD, segment_objn) 
as
select NVL(u.name, 'SYS'), o.name, o.subname,
       so.object_type, s.type#, s.file#, s.block#,
       ts.ts#, ts.name, ts.blocksize,
       bitand(s.cachehint, 3), s.extents, s.blocks,
       s.file#, NVL(s.spare1,0), 
       decode(bitand(s.spare1, 1), 1, s.hwmincr, o.dataobj#), o.obj#
from sys.user$ u, sys.obj$ o, sys.ts$ ts, sys.sys_objects so, sys.seg$ s
where s.file# = so.header_file
  and s.block# = so.header_block
  and s.ts# = so.ts_number
  and s.ts# = ts.ts#
  and ts.bitmapped <> 0
  and ts.name not in ('SYSTEM', 'SYSAUX') -- exclude admin tablespaces
  and o.obj# = so.object_id
  and bitand(o.flags, 128) != 128 -- exclude bin objects
  and o.owner# = u.user# (+)
  and u.name <> 'SYS' -- exclude sys owned objects
  and s.type# = so.segment_type_id
  and o.type# = so.object_type_id
  and so.object_type in ('TABLE', 'TABLE PARTITION')
  and bitand(s.spare1, 2048) != 2048 -- exclude compressed segments
/
grant select on sys_uncompressed_segs_base to select_catalog_role
/
create or replace view sys_uncompressed_segs (tabowner, tabname, partname, tsname, tbsid,
segsize, segobjd, segobjn, segment_type, total_indexes, has_lobs) as
select 
  uncmp.owner, uncmp.segment_name, uncmp.partition_name, 
  uncmp.tablespace_name, uncmp.tablespace_id, 
  decode(bitand(segment_flags, 131072), 131072, blocks,
         (decode(bitand(segment_flags,1),1,
         dbms_space_admin.segment_number_blocks(tablespace_id, header_file,
         header_block, segment_type_id, buffer_pool_id, segment_flags,
         segment_objd, blocks), blocks)))*blocksize,
  uncmp.segment_objd, uncmp.segment_objn, 
  uncmp.segment_type,
  count(i.obj#), 
  case when ((select count(*) from lob$ where obj# = uncmp.segment_objn)>0)
         then 'TRUE' 
       when ((select count(*) from LOBFRAG$ 
               where TABFRAGOBJ# = uncmp.segment_objn)>0)
         then 'TRUE' else 'FALSE' end
from sys_uncompressed_segs_base uncmp, ind$ i
where 
  uncmp.segment_objn = i.bo# 
group by 
  uncmp.owner, uncmp.segment_name, uncmp.partition_name, 
  uncmp.tablespacE_name, uncmp.tablespace_id, 
  decode(bitand(segment_flags, 131072), 131072, blocks,
         (decode(bitand(segment_flags,1),1,
         dbms_space_admin.segment_number_blocks(tablespace_id, header_file,
         header_block, segment_type_id, buffer_pool_id, segment_flags,
         segment_objd, blocks), blocks)))*blocksize,
  uncmp.segment_objd, uncmp.segment_objn, uncmp.segment_type
/
grant select on sys_uncompressed_segs to select_catalog_role
/
create or replace package body dbms_space wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
28ed4 8752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/
show errors;
create or replace package DBMS_HEAT_MAP_INTERNAL wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
6e9 223
vON+Px7kuVcpf22eeZ+wJ4uvRg8wg9eN7cDWfHTG2sE+ekCYh5bN7KG0ZlIGKP+FFBOatWIn
42tG1tt+gX34DJKhwl2rzpTchaImE7hgDg5ryyUvex0YNQMLCMMZuPE8SwmTP6QyfiAgOaT9
0CHYRMZyjz8iv4o93qUas2l8DlK3OLJKkcabfJAEZTeUMOlHMGMZAsRK4cSX9u/pLBkwTNTD
YZJL3Brh2PeO7R8HXZBC0U6xkwcJKjcOiQY/aACcq7t3lBEvtZoJndwvwb08/8COGe7n3+hT
X7Y7lN8quHQm6iaT1c6zTIqhTRoVw01WELWgx9IdYWKWZoBkY714Sb2hn7JLQXWmFSoqaHhN
awB5CKShcUczqP+o+uq/FP3PgPEY7BT/qPrqvxT9z4DTAc09se01OaG8Re+TaR9OzNCWvToV
dhr4+l2WsiAJYwhBJp7fhTw5IVgogpe0ggWRkmC8+lXPgo67FS5+F6i1bx0wwvui1YYYzfCY
JCng2QAxg0tjMnMQV9vlUfPVLDEIhh/Mzqn5

/
show errors;
create or replace package body DBMS_HEAT_MAP_INTERNAL wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
7a68 1c3b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=


/
show errors;
create or replace package body DBMS_HEAT_MAP wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
1939 73d
FtTW+4qPny9zKn3ivgNgLH9g800wg1VUVdATVy+dF/kYvgdeFfRtYRA0Fo12uJ/e9PBfMdBJ
oCwxxbDtzeUxK+21+dTUqS6pZ2MrsIQK3QZYOCKqQVLyFShdbhXsgHgvO8STUjX0VmEUAlcd
ZDSmCa+Eq0OsFWyhBuNao6WBEquXrRnOlIzhpRiI0W2lrOPEN1sdH2V/wmN89D7ZsSpPlV3v
Xm5CYNg0oQwtMS5hyqHgd0dvQ+1pHp0mT2OxhVZY1LjYKUJHetflqgayIRxnBy16oaltg2dO
l1tCNVgt3MhXjESh6xTL9F+t1U0vcUe1MBJA6qYDzjoezev5+0gkquSb/rk6gXxODHk+baVt
DE4QZDScxYgfszZcOQzH0oldjQsn/kg2mmHNOx9k0RbUviHeRA0yRukZzI49F6BrCoNdh3uM
y0cX8di2e16nwuOH1R50B8CwlMlDANHQALQgEbauDAc19km02hkGxS1WBtTYY6jiUSZPZITs
5XGlJ5AEg4dwY/fgascUMook94QdMiGGv6rNuQ/upcKYmiS5vyi4/q633qWl3r+pwa5kS/hh
JDSja7OrUsPmkaTldzq+oBhqYrZ0Z/PAGykNbnKbdBD/0VzLRr7dgJNN6oKaGKm6IcOLrDKN
N2yqa/tWlAgB8/GOiH1mjOMRFF44sZlONePelaN/ptgZr18U0w2Z6HwTRiPqJK4G0TjiXSty
l38JXfWsXubxsytDHsrsm8eMMIPWxT+MeuNG8UgNuyexOPBoZzpMLD9Mr5MKQUy6SoomIZYI
BsH2SLgn7Is9AxhqJQPhguAdV89Cz2iauy0U7kNO+R753v5Sv3w9VCtYsAI9qhNuAvKO2LYc
P014CL4xWGDNLYgAmuXyVi2/jgzyRl8NvXkb431AXaH0GYQsQ+Zm0RQ6p5X3092bzatcQRX/
6V2rKbj+gvgbn7gtYjyhK+c/RN5uJRTJIeXsGFnT9FhtrkCetfSMHuj9aaKETPfFBvmSxLqo
GqALUNdwxDWFj2AOFR7yKSTqabFgjbZEuYnDfPFWo75lq09fAOLCYi7UjJAT4TeUJZfssp/D
fcCU7nhtAi158wZhFoEjFUInIrAVWwTGvmvs708gDa4Y9d4fzExXU5Y+uvwzvwkpz+oIX9FP
qPOfy+vMrVm16q1ongVdFEHI6EnXq/OGT/clj3R+jYN5KClVVwyhWpk2GSeOgqW6MQdZVAeV
G9wR7Zoz894hKWzld91TgO2iBXWU6manw9TFKjDRNQGR7VniB6f6QzrKeJ4fTSe+gz7PcJO9
LAZg7v1YWD3c7h3Z8s4veJ7GFqqFXi6zbM9wk727VGGLyW4Yl+Ykqzc99vZx3J6Tb3ly2Nhv
pJugE2iQSkXoHuImYWj1VtQOAMkpiFBUtsODOY0cXtQPADCIs1Qc1UmqtU6CBf5ffkmPnZv8
dbIOwOQEingtJjWdLCn4qYrnR+H9YeFbQeFJSmGsy9I20Xe09cuFNstNNstAoFhW5TnV4f2I
g3ay8F61NQqPBX7XGJpVKXWgIpuMQg+AVQATHWSGL13jR2T67GEae2PMf3uzEyEatwW2DDrM
oSeGhXWiPbBpt6O3IiRqRsep1Bu6OF4GJKC3pkkX2OEKzS0ZDQXqmsde3WaktznRvqFEqcih
hljCebi22362g5s6uz8yGk1hRlDOFaw/MmiREElOftIgumH8wqqzUWW+a//viVHNjKy3Xp00
7RKDpIdIu7/rqRmtPoicWO9R3ka1hSINKcyh0UI1UdkEFyQ79yUzAA9ybK6TxmvdE4LSO9x2
1eRzi8sYxGcJc0pW1w/5RAezxO0=

/
show errors;
create or replace type body sys.wri$_adv_objspace_trend_t wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
e
15dea 45b4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/
create or replace package body dbms_space_alert wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
2afc 871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/
show errors; 
@?/rdbms/admin/sqlsessend.sql
