Rem
Rem $Header: rdbms/admin/execfcp.sql /st_rdbms_12.2.0.1.0/1 2016/08/09 22:28:47 shvmalik Exp $
Rem
Rem execfcp.sql
Rem
Rem Copyright (c) 2012, 2016, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      execfcp.sql -FCP initial data insertion
Rem
Rem    DESCRIPTION
Rem      FCP initial data insertion
Rem
Rem    NOTES
Rem      .
Rem
Rem BEGIN SQL_FILE_METADATA
Rem SQL_SOURCE_FILE: rdbms/admin/execfcp.sql
Rem SQL_SHIPPED_FILE: rdbms/admin/execfcp.sql
Rem SQL_PHASE: EXECFCP
Rem SQL_STARTUP_MODE: NORMAL
Rem SQL_IGNORABLE_ERRORS: NONE
Rem SQL_CALLING_FILE: rdbms/admin/catpexec.sql
Rem END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    shvmalik    06/30/16 - FCP initial data insertion
Rem    shvmalik    06/30/16 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql

DECLARE
  l_home    varchar2(255);
  admindir  varchar2(30) := 'ORA_DBMS_FCP_ADMINDIR';
  logdir    varchar2(30) := 'ORA_DBMS_FCP_LOGDIR';

BEGIN
    --Read ORACLE_HOME via the api get_env.
    SYS.dbms_system.get_env('ORACLE_HOME', l_home);

    --Create admin and log directories,by default created with sharing-metadata
    execute immediate 'create or replace directory ' || admindir ||
                      ' as '''|| l_home ||'/rdbms/admin''';

    execute immediate 'create or replace directory ' || logdir ||
                      ' as '''|| l_home ||'/cfgtoollogs''';
END;
/

BEGIN
    --insert initial data
    dbms_fix_control_persistence.insert_initial_data;
END;
/

@@?/rdbms/admin/sqlsessend.sql
