Rem
Rem $Header: rdbms/admin/dbmspdb_altshr.sql /main/4 2016/05/22 05:27:16 thbaby Exp $
Rem
Rem dbmspdb_altshr.sql
Rem
Rem Copyright (c) 2015, 2016, Oracle and/or its affiliates. 
Rem All rights reserved.
Rem
Rem    NAME
Rem      dbmspdb_altshr.sql - dbms_pdb_alter_sharing utility package
Rem
Rem    DESCRIPTION
Rem      This package contains procedures to alter sharing attribute of 
Rem      common objects
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    BEGIN SQL_FILE_METADATA 
Rem    SQL_SOURCE_FILE: rdbms/admin/dbmspdb_altshr.sql 
Rem    SQL_SHIPPED_FILE: rdbms/admin/dbmspdb_altshr.sql 
Rem    SQL_PHASE: DBMSPDB
Rem    SQL_STARTUP_MODE: NORMAL 
Rem    SQL_IGNORABLE_ERRORS: NONE 
Rem    SQL_CALLING_FILE: rdbms/admin/catpdbms.sql
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    thbaby      05/10/16 - Bug 23254735: add SET_USER_EXPLICIT()
Rem    jaeblee     02/05/16 - Bug 22524245: mark package as invoker's rights
Rem    akruglik    01/26/16 - (22132084) declare set_ext_data_linked procedure
Rem    akruglik    12/02/15 - Bug 21953121: define package
Rem                           DBMS_PDB_ALTER_SHARING
Rem    akruglik    12/02/15 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

@@?/rdbms/admin/sqlsessstart.sql

create or replace package dbms_pdb_alter_sharing authid current_user is

  procedure remove_link(schema_name  IN varchar2, 
                        object_name  IN varchar2,
                        namespace    IN number,
                        edition_name IN varchar2 DEFAULT NULL);
  -- This procedure should be used to remove Metadata/Data/Extended Data linked
  -- status on an object in an App Root. It is intended to be used in 
  -- migration cases where an application was already installed in a PDB or a 
  -- non-CDB, where there was no support for application containers.

  procedure set_metadata_linked(schema_name  IN varchar2, 
                                object_name  IN varchar2,
                                namespace    IN number,
                                edition_name IN varchar2 DEFAULT NULL);

  -- This procedure should be used to mark an object as Metadata linked in 
  -- an App Root. It is intended to be used in migration cases where an 
  -- application was already installed in a PDB or a non-CDB, where there was 
  -- no support for application containers.

  procedure set_data_linked(schema_name  IN varchar2, 
                            object_name  IN varchar2,
                            namespace    IN number,
                            edition_name IN varchar2 DEFAULT NULL);
  -- This procedure should be used to mark an object as Data linked in 
  -- an App Root. It is intended to be used in migration cases where an 
  -- application was already installed in a PDB or a non-CDB, where there was 
  -- no support for application containers.

  procedure set_ext_data_linked(schema_name  IN varchar2, 
                                object_name  IN varchar2,
                                namespace    IN number,
                                edition_name IN varchar2 DEFAULT NULL);
  -- This procedure should be used to mark an object as Extended Data linked in
  -- an App Root. It is intended to be used in migration cases where an 
  -- application was already installed in a PDB or a non-CDB, where there was 
  -- no support for Application Containers.

  procedure set_user_explicit(user_name IN varchar2);
  -- This procedure should be used to mark a user as an explicit 
  -- Application Common user. It is intended to be used in migration 
  -- cases where an application was already installed in a PDB or a 
  -- non-CDB, where there was no support for application containers.
  -- When such a PDB or non-CDB is converted into an Application Root
  -- via clone or plugin, the users would have been marked as implicit 
  -- Application Common users. This procedure should be invoked within
  -- an Application Begin/End block.

  procedure set_role_explicit(role_name IN varchar2);
  -- This procedure should be used to mark a role as an explicit 
  -- Application Common role. It is intended to be used in migration 
  -- cases where an application was already installed in a PDB or a 
  -- non-CDB, where there was no support for application containers.
  -- When such a PDB or non-CDB is converted into an Application Root
  -- via clone or plugin, the roles would have been marked as implicit 
  -- Application Common roles. This procedure should be invoked within
  -- an Application Begin/End block.

  procedure set_profile_explicit(profile_name IN varchar2);
  -- This procedure should be used to mark a profile as an explicit 
  -- Application Common profile. It is intended to be used in migration 
  -- cases where an application was already installed in a PDB or a 
  -- non-CDB, where there was no support for application containers.
  -- When such a PDB or non-CDB is converted into an Application Root
  -- via clone or plugin, the profiles would have been marked as implicit 
  -- Application Common profiles. This procedure should be invoked within
  -- an Application Begin/End block.
end;
/

grant execute on dbms_pdb_alter_sharing to execute_catalog_role
/

create or replace public synonym dbms_pdb_alter_sharing 
  for sys.dbms_pdb_alter_sharing
/

@?/rdbms/admin/sqlsessend.sql
