#!/usr/local/bin/perl
#
# dbms_registry_extended.pm.pp
#
# Copyright (c) 2005, 2015, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      dbms_registry_extended.pm.pp - file will be preporocessed by build to create dbms_registry_extended.pl
#
#    DESCRIPTION
#
#      This file contains common constants and low level definitions for use
#      by the Preupgrade, Upgrade, and Downgrade.
#      Since some of the low level definitions are constants which are defined
#      by groups outside of Upgrade, the .pm.pp source file will be preprocessed
#      by the build to generate a corresponding DERIVED_OBJECT .pm file by replacing
#      tags in the .pm.pp file with their actual values derived by the build.
#
#      The tags are **UPPER CASE** equivalents of the following strings:
#
#        ##bannerversion## - the server's version number,(high_version) i.e. 12.2.0.0.0
#        ##ltz_content_ver## - the timezone*.dat version number, i.e. 23
#        ##apex_version## - apex's version is not the same as the server's, i.e. 4.2.5.00.08
#
#      In order to keep all of the Upgrade common definitions synchronized
#      across the various languages used by our team, it is imperative that
#      the following files stay religiously in lock step with one another:
#
#          dbms_registry_extended.pm.pp
#          tkumregistry.tsc.pp
#          (dbms_registry_basic.sql.pp and dbms_registry_extended.sql.pp together*)
#
#      That means that any definition placed in one of the files should
#      appear in all of the files.  In as much as possible within the
#      conventions of each language, the object definitions should use the
#      exact same name, including case, as used in other files.  The
#      definitions should be made in the same order to facilitate debugging
#      and allow for quick visual comparison of the files.
#
#      * Note: due to the limitations of running sql under
#      "alter database open upgrade", the definitions made in SQL have to be
#      split into two files: dbms_registry_basic.sql.pp and dbms_registry_extended.sql.pp.
#      The former contains definitions which work when the database is open
#      in upgrade mode, and the latter file holds all of the other
#      definitions which can only be accessed when in NORMAL mode.  When it
#      comes to ordering definitions across all four of the files above, imagine
#      that dbms_registry_basic.sql.pp and dbms_registry_extended.sql.pp are logically
#      concatenated in that order.  A definition should appear only once in
#      one of those two files.  That means, if you are adding a definition
#      that belongs at the end of dbms_registry_basic.sql.pp, there will be no
#      definition in dbms_registry_extended.sql.pp, and the placement of the defintion
#      in dbms_registry_extended.pm.pp and dbms_registry_extended.tsc.pp will appear somewhere in
#      the middle of those files.
#
#    MODIFIED   (MM/DD/YY)
#    frealvar    09/18/15 - Added constants from catconst.pm and export support,
#                           changes done due to bug 21274752
#    ewittenb    10/29/14 - Creation
#

package dbms_registry_extended;

use strict;
use warnings;
require Exporter;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration       use dbms_registry_extended ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
#
#
our @EXPORT_OK = qw ();

our @EXPORT = qw( @AVAILABE_CIDS );

#
#    Server Version.  This is the HIGH numbered version in an upgrade/downgrade scenario
#                     and contains exactly 4 dots, i.e. 12.1.0.2.0
#                     If you need the version with fewer dots, look in package dbms_registry_extended.
#
our $C_ORACLE_HIGH_VERSION_4_DOTS = '12.2.0.1.0';

#
#    The version of APEX that ships with the 12.2.0.1.0 version of Oracle.
#
our $C_APEX_VERSION_4_DOTS = '5.0.4.00.12';

#
#    Latest oracore/zoneinfo/timezone_*.dat file shipped.
#
our $C_LTZ_CONTENT_VER = 26;

#
#    Note the format includes a leading and trailing comma and no spaces, thus making
#    checks for ',' || version || ',' easy and reliable.
#
our $C_UPGRADABLE_VERSIONS = '11.2.0.3,11.2.0.4,12.1.0.1,12.1.0.2';

#
#    Version specific default settings for PROCESSES initialization parameter
#
our $C_DEFAULT_PROCESSES = 300;

#
#    Minimum setting for COMPATIBLE initialization parameter
#
our $C_MINIMUM_COMPATIBLE = '11.0.0';

#
#    min value for upgrades to 12102 (needed for APEX)
#
our $C_MIN_OPEN_CURSORS = 150;

#
#    List of all the available cids that a database might have
#
#  APEX       - Oracle Application Express
#  APS        - OLAP Analytic Workspace
#  CATALOG    - Oracle Catalog Views
#  CATJAVA    - Oracle Java Packages
#  CATPROC    - Oracle Packages and Types
#  CONTEXT    - Oracle Text
#  DV         - Oracle Database Vault
#  JAVAVM     - JServer JAVA Virtual Machine
#  OLS        - Oracle Label Security
#  ORDIM      - Oracle Multimedia
#  OWM        - Oracle Workspace Manager
#  RAC        - Real Application Clusters
#  SDO        - Oracle Spatial
#  XDB        - Oracle XML Database
#  XML        - Oracle XDK for Java
#  XOQ        - Oracle OLAP API
#  ODM        - Data Mining
#  MGW        - Messaging Gateway
#  WK         - Oracle Ultra Search
#  EM         - Oracle Enterprise Manager Repository

our @AVAILABE_CIDS = qw(APEX APS CATALOG CATJAVA CATPROC CONTEXT DV JAVAVM OLS ORDIM OWM RAC SDO XDB XML XOQ ODM MGW WK EM);

1;
