Rem
Rem $Header: rdbms/admin/catendappupg.sql /main/1 2015/06/29 17:48:38 pyam Exp $
Rem
Rem catendappupg.sql
Rem
Rem Copyright (c) 2015, Oracle and/or its affiliates. All rights reserved.
Rem
Rem    NAME
Rem      catendappupg.sql - End App Upgrade
Rem
Rem    DESCRIPTION
Rem      Ends upgrade of APP$CDB$CATALOG
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    BEGIN SQL_FILE_METADATA 
Rem    SQL_SOURCE_FILE: rdbms/admin/catendappupg.sql 
Rem    SQL_SHIPPED_FILE: 
Rem    SQL_PHASE: 
Rem    SQL_STARTUP_MODE: NORMAL 
Rem    SQL_IGNORABLE_ERRORS: NONE 
Rem    SQL_CALLING_FILE: 
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pyam        05/20/15 - cdb upgrade optimizations
Rem    pyam        05/19/15 - Created
Rem

@@?/rdbms/admin/sqlsessstart.sql

alter system set events '10520 level 0';
alter system set "_upgrade_optim"=FALSE;
alter system set "_upgrade_capture_noops"=FALSE;

declare
  newvsn varchar2(30);
begin
  select tgtver into newvsn from fed$versions v, fed$apps a
    where a.app_status=2 and a.appid#=v.appid# and v.ver#=a.ver#+1
      and a.app_name='APP$CDB$CATALOG';
  execute immediate 'alter pluggable database application APP$CDB$CATALOG ' ||
                    'end upgrade to ''' || newvsn || '''';
exception
  when no_data_found then null;
  when others then
  if sqlcode in (-65090, -65212, -65214, -1403) then null;
  else raise;
  end if;
end;
/

@?/rdbms/admin/sqlsessend.sql
