/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.util.engine;

import java.io.IOException;
import java.util.Map;
import oracle.install.commons.base.util.job.JobApplicationException;
import oracle.install.commons.base.util.job.JobApplicationLogHandler;
import oracle.install.commons.base.util.job.JobVariableLoader;
import oracle.install.commons.base.util.job.bean.JobContext;
import oracle.install.commons.base.util.job.bean.JobSettings;
import oracle.install.commons.base.util.job.bean.VariableSettings;
import oracle.install.commons.base.util.job.engine.SQLExecutor;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.driver.util.engine.SQLEngine;
import oracle.install.driver.util.engine.SQLFatalErrorException;
import oracle.install.driver.util.resource.DriverErrorCode;

public class SQLExecutionEngine
implements SQLExecutor {
    @Override
    public int execute(JobContext jobContext, JobSettings jobsettings) throws JobApplicationException {
        if (jobsettings != null) {
            Map<String, VariableSettings> args = jobsettings.getArgs();
            Map<String, VariableSettings> genericArgs = jobContext.getJobIndependentVars();
            Map<String, VariableSettings> secreteArgs = jobsettings.getSecreteArgs();
            Map<String, VariableSettings> environmentVars = jobsettings.getEnvVariables();
            Map<String, VariableSettings> properties = jobsettings.getCmdProperties();
            VariableSettings oracleHomeVariable = null;
            VariableSettings oracleSIDVariable = null;
            VariableSettings sysPasswordVar = null;
            if (environmentVars != null && environmentVars.get("ORACLE_HOME") != null) {
                oracleHomeVariable = environmentVars.get("ORACLE_HOME");
            } else if (genericArgs != null && genericArgs.get("ORACLE_HOME") != null) {
                oracleHomeVariable = genericArgs.get("ORACLE_HOME");
            }
            if (environmentVars != null && environmentVars.get("ORACLE_SID") != null) {
                oracleSIDVariable = environmentVars.get("ORACLE_SID");
            } else if (genericArgs != null && genericArgs.get("ORACLE_SID") != null) {
                oracleSIDVariable = genericArgs.get("ORACLE_SID");
            }
            if (secreteArgs != null && secreteArgs.get("sysPassword") != null) {
                sysPasswordVar = secreteArgs.get("sysPassword");
            }
            if (oracleHomeVariable == null || oracleHomeVariable.getValue() == null || oracleHomeVariable.getValue().isEmpty()) {
                throw new JobApplicationException((ErrorCode)DriverErrorCode.ORACLE_HOME_NOT_FOUND_ERR, new Object[0]);
            }
            if (oracleSIDVariable == null || oracleSIDVariable.getValue() == null || oracleSIDVariable.getValue().isEmpty()) {
                throw new JobApplicationException((ErrorCode)DriverErrorCode.ORACLE_SID_NOT_FOUND_ERR, new Object[0]);
            }
            String oracleHome = JobVariableLoader.getInstance().replaceVariables(oracleHomeVariable.getValue(), genericArgs, args);
            String oracleSid = JobVariableLoader.getInstance().replaceVariables(oracleSIDVariable.getValue(), genericArgs, args);
            String script = JobVariableLoader.getInstance().replaceVariables(jobsettings.getCommand(), genericArgs, args);
            try {
                SQLEngine engine = SQLEngine.getSQLEngine(oracleHome, oracleSid);
                if (sysPasswordVar != null && sysPasswordVar.getValue() != null) {
                    engine.connect("sys", sysPasswordVar.getValue(), "SYSDBA");
                } else {
                    engine.connect(null, null, "sysdba");
                }
                StringBuffer buffer = new StringBuffer();
                if (args != null && !args.isEmpty()) {
                    for (VariableSettings arg : args.values()) {
                        if (arg == null) continue;
                        String name = arg.getName();
                        name = JobVariableLoader.getInstance().replaceVariables(name, jobContext.getJobIndependentVars(), jobsettings.getArgs());
                        if (arg.isValueExpected()) {
                            if (arg.getValue() == null || arg.getValue().trim().isEmpty()) continue;
                            buffer.append(" " + name);
                            String value = arg.getValue();
                            value = JobVariableLoader.getInstance().replaceVariables(value, jobContext.getJobIndependentVars(), jobsettings.getArgs());
                            buffer.append(" " + value);
                            continue;
                        }
                        buffer.append(" " + name);
                    }
                }
                if (properties != null && !properties.isEmpty()) {
                    for (VariableSettings property : properties.values()) {
                        if (property == null || property.getValue() == null || property.getValue().trim().isEmpty()) continue;
                        String value = property.getValue();
                        value = JobVariableLoader.getInstance().replaceVariables(value, jobContext.getJobIndependentVars(), jobsettings.getArgs());
                        buffer.append(" " + property.getName() + "=" + value);
                    }
                }
                script = script + buffer.toString();
                engine.executeScript(script);
                return 0;
            }
            catch (IOException e) {
                throw new JobApplicationException((Throwable)e, (ErrorCode)DriverErrorCode.SQL_SCRIPT_EXECUTION_ERR, script, JobApplicationLogHandler.getLogFile());
            }
            catch (SQLFatalErrorException e) {
                throw new JobApplicationException((Throwable)e, (ErrorCode)DriverErrorCode.SQL_SCRIPT_EXECUTION_ERR, script, JobApplicationLogHandler.getLogFile());
            }
            catch (InterruptedException e) {
                throw new JobApplicationException((Throwable)e, (ErrorCode)DriverErrorCode.SQL_SCRIPT_EXECUTION_ERR, script, JobApplicationLogHandler.getLogFile());
            }
        }
        return -1;
    }
}

