/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.util.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.driver.util.engine.Channel;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;

public class ChannelHelper {
    private static final Logger logger = Logger.getLogger(ChannelHelper.class.getName());

    public static List<String> constructCommand(String command, List<String> args, Map<String, String> envVars, Channel.ChannelMode channelMode, String channelModePath, CommandContext context) {
        ArrayList<Object> commandList = new ArrayList<Object>();
        StringBuffer commandBuf = new StringBuffer();
        if (PlatformInfo.getInstance().isWindows()) {
            Iterator<String> windowsCommandLinePrefix = null;
            String systemDir = "";
            try {
                systemDir = OiipwWin32NativeCalls.getWindowsSystemDirectory();
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Unable to get windows system directory - " + exception.getMessage());
            }
            windowsCommandLinePrefix = systemDir + "\\cmd.exe";
            commandList.add(windowsCommandLinePrefix);
            commandList.add("/c");
            commandList.add("call");
            String[] stringArray = command.split(" ");
            if (stringArray != null) {
                for (String token : stringArray) {
                    commandList.add(token);
                }
            }
            if (args != null && !args.isEmpty()) {
                for (String arg : args) {
                    String[] splittedArg = arg.split(" ");
                    if (splittedArg == null) continue;
                    for (String token : splittedArg) {
                        commandList.add(token);
                    }
                }
            }
        } else {
            if (args != null && !args.isEmpty()) {
                for (String arg : args) {
                    command = command + " " + arg;
                }
            }
            if (channelMode == Channel.ChannelMode.SUDO && channelModePath != null) {
                commandList.add(channelModePath);
                commandList.add(" -S ");
            }
            commandList.add("/bin/sh");
            commandList.add("-c");
            if (context == CommandContext.JSCH) {
                commandBuf.append(" '(");
            }
            if (envVars != null && !envVars.isEmpty()) {
                for (String envName : envVars.keySet()) {
                    if (envVars.get(envName) == null) continue;
                    logger.log(Level.INFO, "Setting the environment variable:" + envName + " value:" + envVars.get(envName));
                    commandBuf.append(envName + "=" + envVars.get(envName).trim() + "; ");
                }
            }
            commandBuf.append(command);
            if (context == CommandContext.JSCH) {
                commandBuf.append(" )'");
            }
            commandList.add(commandBuf.toString());
        }
        ArrayList<String> finalCommandList = new ArrayList<String>();
        if (context == CommandContext.JSCH) {
            commandBuf = new StringBuffer();
            for (String string : commandList) {
                commandBuf.append(string + " ");
            }
            finalCommandList.add(commandBuf.toString().trim());
        } else {
            finalCommandList.addAll(commandList);
        }
        return finalCommandList;
    }

    public static String getUserPasswordPrompt() {
        if (PlatformInfo.getInstance().isWindows()) {
            return ".*Enter the password for.*";
        }
        return ".*Password:.*";
    }

    public static String getRootUserName() {
        return "root";
    }

    public static enum CommandContext {
        BASIC,
        JSCH;

    }
}

