/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.util.engine;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.job.ExecutionResult;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.driver.util.engine.BasicChannel;
import oracle.install.driver.util.engine.Channel;
import oracle.install.driver.util.engine.ChannelException;
import oracle.install.driver.util.engine.ChannelHelper;
import oracle.install.driver.util.engine.JSChChannel;
import oracle.install.driver.util.resource.DriverErrorCode;

public class ChannelFactory {
    private static final Logger logger = Logger.getLogger(ChannelFactory.class.getName());
    private final String[] reqttyPatternArr = new String[]{"requiretty"};
    private Map<String, Boolean> requireTtyMap = new HashMap<String, Boolean>();
    private static ChannelFactory instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ChannelFactory getInstance() {
        if (instance != null) return instance;
        Class<ChannelFactory> clazz = ChannelFactory.class;
        synchronized (ChannelFactory.class) {
            if (instance != null) return instance;
            instance = new ChannelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Channel createChannel(String node, Channel.ChannelMode channelMode, String channelModePath, String asUser, String password) throws ChannelException {
        int timeout = 3600;
        if (System.getProperty("oracle.jobapplication.commandExecutionTimeoutValue") != null) {
            timeout = Integer.valueOf(System.getProperty("oracle.jobapplication.commandExecutionTimeoutValue"));
        }
        String user = System.getProperty("user.name");
        if (!this.needJSCHChannel(node, channelMode, asUser)) {
            return new BasicChannel(node, user, password, channelMode, channelModePath, timeout, false);
        }
        if (channelMode == Channel.ChannelMode.ROOT) {
            user = ChannelHelper.getRootUserName();
        } else if (asUser != null && !asUser.isEmpty()) {
            user = asUser;
        }
        if (node == null || node.isEmpty() || node.equalsIgnoreCase("localnode")) {
            node = null;
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces != null && interfaces.hasMoreElements()) {
                    NetworkInterface nic = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = nic.getInetAddresses();
                    while (node == null && addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (address.isLoopbackAddress()) continue;
                        node = address.getHostName();
                    }
                }
                logger.log(Level.INFO, "Local node name retrieved is:" + node);
            }
            catch (SocketException e) {
                throw new ChannelException((ErrorCode)DriverErrorCode.UNABLE_TO_CREATE_CHANNEL_ERR, new Object[0]);
            }
        }
        if (node == null || node.isEmpty()) {
            throw new ChannelException((ErrorCode)DriverErrorCode.UNABLE_TO_CREATE_CHANNEL_ERR, new Object[0]);
        }
        boolean requireTty = false;
        if (channelMode == Channel.ChannelMode.ROOT) {
            user = ChannelHelper.getRootUserName();
        } else if (channelMode == Channel.ChannelMode.SUDO || !user.equalsIgnoreCase(System.getProperty("user.name"))) {
            if (this.requireTtyMap.get(node.toLowerCase()) == null) {
                this.populateRequireTtyMap(node, channelModePath, user, password, timeout);
            }
            requireTty = this.requireTtyMap.get(node.toLowerCase()) == null ? false : this.requireTtyMap.get(node.toLowerCase());
        }
        return new JSChChannel(node, user, password, channelMode, channelModePath, timeout, requireTty, asUser);
    }

    private boolean needJSCHChannel(String node, Channel.ChannelMode channelMode, String asUser) {
        if (asUser != null && !asUser.isEmpty()) {
            return true;
        }
        if (channelMode != null) {
            return true;
        }
        return node != null && !node.equalsIgnoreCase("localnode");
    }

    private void populateRequireTtyMap(String node, String sudoLocation, String username, String password, int timeout) throws ChannelException {
        if (this.requireTtyMap.get(node.toLowerCase()) == null) {
            String command = " -l";
            logger.log(Level.INFO, "executing sudo list command");
            JSChChannel jschChannel = new JSChChannel(node, username, password, Channel.ChannelMode.SUDO, sudoLocation, timeout, false);
            ExecutionResult execResult = jschChannel.execCommand(command, null, null);
            if (execResult != null) {
                boolean ttyOptionSet = false;
                if (execResult.getExitCode() != 0 || !execResult.isSuccess()) {
                    logger.log(Level.INFO, "requiretty set to true for node " + node);
                    this.requireTtyMap.put(node.toLowerCase(), new Boolean(true));
                    return;
                }
                List<String> outputList = execResult.getOutput();
                if (outputList != null) {
                    String resultStr = outputList.toString();
                    logger.log(Level.INFO, "sudo options are " + resultStr);
                    if (resultStr != null) {
                        for (String reqttyOpt : this.reqttyPatternArr) {
                            if (-1 == resultStr.indexOf(reqttyOpt)) continue;
                            logger.log(Level.INFO, "terminal request option found " + reqttyOpt);
                            this.requireTtyMap.put(node.toLowerCase(), new Boolean(true));
                            ttyOptionSet = true;
                            break;
                        }
                    }
                    if (!ttyOptionSet) {
                        this.requireTtyMap.put(node.toLowerCase(), new Boolean(false));
                    }
                }
            }
        }
    }
}

