/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.util.engine;

import java.util.List;
import java.util.Map;
import oracle.install.commons.base.util.job.ExecutionResult;

public abstract class Channel {
    public static final String SH = "/bin/sh";
    public static final String SHELL_COMMAND_FLAG = "-c";
    public static final String SHELL_CMD_BEGIN = " '(";
    public static final String SHELL_CMD_END = " )'";
    public static final String USER_PASSWORD_PROMPT_UNIX = ".*Password:.*";
    public static final String USER_PASSWORD_PROMPT_WIN = ".*Enter the password for.*";
    public static final int SCRIPT_EXEC_TIMEOUT = Integer.MAX_VALUE;
    public static final String SUDO_LIST_COMMAND = " -l";
    public static final String LOCAL_NODE_STRING = "localnode";
    public static final String CHANNEL_TIMEOUT_VALUE_PROPERTY = "oracle.jobapplication.commandExecutionTimeoutValue";
    public static final String SU_ARGS_C = "-c";
    public static final String SUDO_INVALIDATE_CACHE_COMMAND = " -k";
    public static final String SU_CMD = "/bin/su";
    public static final String SUDO_S = " -S ";
    public static final String QUOTE = "\"";
    public static final String SINGLE_QUOTE = "'";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String ROOT_USER = "root";
    public static final int DEFAULT_TIMEOUT_VALUE = 3600;
    private String node;
    private String user;
    private String pwd;
    private int timeout = Integer.MAX_VALUE;
    private ChannelMode channelMode;
    private String sudoPbrunLocation;
    private boolean requireTty = false;
    private String asUser = null;

    Channel(String node, String user, String password, ChannelMode cm, String sudoPbrunLocation, int timeout, boolean requireTty) {
        this.node = node;
        this.user = user;
        this.pwd = password;
        this.channelMode = cm;
        this.timeout = timeout;
        this.sudoPbrunLocation = sudoPbrunLocation;
        this.requireTty = requireTty;
    }

    Channel(String node, String user, String password, ChannelMode cm, String sudoPbrunLocation, int timeout, boolean requireTty, String asUser) {
        this(node, user, password, cm, sudoPbrunLocation, timeout, requireTty);
        this.asUser = asUser;
    }

    public ExecutionResult execCommand(String command, List<String> args, Map<String, String> envVars) {
        return this.execCommand(command, args, envVars, null);
    }

    public ExecutionResult execCommand(String command, List<String> args, Map<String, String> envVars, Map<String, String> stdin) {
        return this.execCommandImpl(command, args, envVars, stdin);
    }

    protected abstract ExecutionResult execCommandImpl(String var1, List<String> var2, Map<String, String> var3, Map<String, String> var4);

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPwd() {
        return this.pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public ChannelMode getChannelMode() {
        return this.channelMode;
    }

    public void setChannelMode(ChannelMode channelMode) {
        this.channelMode = channelMode;
    }

    public String getSudoPbrunLocation() {
        return this.sudoPbrunLocation;
    }

    public void setSudoPbrunLocation(String sudoPbrunLocation) {
        this.sudoPbrunLocation = sudoPbrunLocation;
    }

    public boolean isRequireTty() {
        return this.requireTty;
    }

    public void setRequireTty(boolean requireTty) {
        this.requireTty = requireTty;
    }

    public String getAsUser() {
        return this.asUser;
    }

    public void setAsUser(String asUser) {
        this.asUser = asUser;
    }

    static enum ChannelMode {
        SUDO,
        ROOT,
        PBRUN,
        SHELL;

    }
}

