/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.util.engine;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.job.ExecutionResult;
import oracle.install.driver.util.engine.Channel;
import oracle.install.driver.util.engine.ChannelHelper;
import oracle.install.driver.util.engine.CommandExecutionEngine;
import oracle.install.driver.util.engine.ExecutionProcessHandler;

public class BasicChannel
extends Channel {
    private static final Logger logger = Logger.getLogger(CommandExecutionEngine.class.getName());
    private Process process;

    BasicChannel(String node, String user, String password, Channel.ChannelMode cm, String sudoPbrunLocation, int timeout, boolean requireTty) {
        super(node, user, password, cm, sudoPbrunLocation, timeout, requireTty);
    }

    BasicChannel(String node, String user, String password, Channel.ChannelMode cm, String sudoPbrunLocation, int timeout, boolean requireTty, String asUser) {
        super(node, user, password, cm, sudoPbrunLocation, timeout, requireTty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ExecutionResult execCommandImpl(String command, List<String> args, Map<String, String> envVars, Map<String, String> stdin) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        ExecutionResult executionResult = new ExecutionResult();
        Map<String, String> processEnv = processBuilder.environment();
        if (envVars != null && !envVars.isEmpty()) {
            for (String envName : envVars.keySet()) {
                if (envVars.get(envName) == null) continue;
                if (envVars.get(envName).trim().isEmpty()) {
                    logger.log(Level.INFO, "Resetting the environment variable:" + envName);
                    processEnv.remove(envName);
                    continue;
                }
                logger.log(Level.INFO, "Setting the environment variable:" + envName + " value:" + envVars.get(envName));
                processEnv.put(envName, envVars.get(envName));
            }
        }
        if ((this.getAsUser() == null || this.getAsUser().isEmpty()) && this.getChannelMode() == Channel.ChannelMode.ROOT) {
            this.setAsUser(ChannelHelper.getRootUserName());
        }
        List<String> commandList = ChannelHelper.constructCommand(command, args, envVars, this.getChannelMode(), this.getSudoPbrunLocation(), ChannelHelper.CommandContext.BASIC);
        executionResult.setCommands(commandList);
        logger.log(Level.INFO, "Command {0}", commandList);
        processBuilder.command().addAll(commandList);
        if (stdin == null || stdin.isEmpty()) {
            stdin = new HashMap<String, String>();
            stdin.put(ChannelHelper.getUserPasswordPrompt(), this.getPwd());
        } else if (stdin.get(ChannelHelper.getUserPasswordPrompt()) == null) {
            stdin.put(ChannelHelper.getUserPasswordPrompt(), this.getPwd());
        }
        try {
            this.process = Runtime.getRuntime().exec(commandList.toArray(new String[0]));
            new ExecutionProcessHandler().handleProcess(this.process, executionResult, stdin);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IOException occurred while running process:" + e.getLocalizedMessage());
            executionResult.addException(e);
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "InterruptedException occurred while running process:" + e.getLocalizedMessage());
            executionResult.addException(e);
        }
        catch (ExecutionException e) {
            logger.log(Level.WARNING, "ExecutionException occurred while running process:" + e.getLocalizedMessage());
            executionResult.addException(e);
        }
        finally {
            executionResult.setSuccess(true);
        }
        return executionResult;
    }
}

