/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui.ui;

import java.awt.Component;
import java.util.logging.Level;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.DefaultStatusMessage;
import oracle.install.commons.util.Option;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.ResourceURL;
import oracle.install.driver.oui.DriverConstants;
import oracle.install.driver.oui.OUIExitStatus;
import oracle.sysman.oii.oiic.OiicInstallCancelHandler;

public class DefaultInstallCancelHandler
implements OiicInstallCancelHandler {
    private static Resource resource = Application.getInstance().getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);
    private String title;
    private Component owner;

    public DefaultInstallCancelHandler() {
        this(null, null);
    }

    public DefaultInstallCancelHandler(Component owner) {
        this(owner, null);
    }

    public DefaultInstallCancelHandler(Component owner, String title) {
        this.title = title;
        this.owner = owner;
        if (this.title == null) {
            this.title = resource.getString("DefaultInstallCancelHandler.defaultTitle", "Component Installation Failed", new Object[0]);
        }
    }

    public void dispose() {
    }

    public int doCancelOperation() {
        return this.prompt(null, true);
    }

    public int doCancelOperation(boolean forceExit) {
        return this.prompt(null, forceExit);
    }

    public int doCancelOperation(String msg) {
        return this.prompt(msg, true);
    }

    private int prompt(String message, boolean forceExit) {
        boolean shutdown;
        if (message == null) {
            message = resource.getString("DefaultHandler.defaultMessage", "Unknown problem during installation.", new Object[0]);
        }
        Option cancelOption = StandardDialog.showMessage(this.owner, this.title, new DefaultStatusMessage(Level.SEVERE, message), CancelOption.STOP_THIS, CancelOption.STOP_ALL, CancelOption.STOP_THIS);
        Application application = Application.getInstance();
        boolean bl = shutdown = cancelOption == CancelOption.STOP_ALL;
        if (shutdown && !forceExit) {
            String quitPrompt = application.getString(ResourceURL.resURL("oracle.install.commons.util.resource.StringResourceBundle", "application.prompt.close.confirmation"), "Do you really want to exit ?", new Object[0]);
            shutdown = StandardDialog.promptQuestion(this.owner, quitPrompt);
        }
        if (shutdown) {
            application.shutdown(OUIExitStatus.STOP_INSTALL);
        }
        return cancelOption.toInt();
    }

    public static enum CancelOption implements Option
    {
        STOP_ALL(1),
        STOP_THIS(2);

        private int intValue;

        private CancelOption(int intValue) {
            this.intValue = intValue;
        }

        @Override
        public int toInt() {
            return this.intValue;
        }

        @Override
        public String toString() {
            return resource.getString(this, new Object[0]);
        }
    }
}

