/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.driver.oui.InventoryInfo;
import oracle.sysman.oii.oiii.OiiiClusterInstallInventory;
import oracle.sysman.oii.oiii.OiiiRemoteHome;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterInvSetup;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;

public class RemoteInventoryInfo {
    private List<String> remoteHomes;
    private String node;
    private String inventoryLocation;
    private List<String> homeNames;
    private static OiiiClusterInstallInventory oClusterInstInv = new OiiiClusterInstallInventory();
    private static OiipgClusterInvSetup oClusterInvSetup;
    private static Map<String, RemoteInventoryInfo> instances;
    private static final Logger logger;

    public static RemoteInventoryInfo getInstance(String node) {
        return RemoteInventoryInfo.getInstance(node, false);
    }

    public static RemoteInventoryInfo getInstance(String node, boolean reload) {
        if (instances == null) {
            instances = new HashMap<String, RemoteInventoryInfo>();
        }
        if (!reload) {
            for (Map.Entry<String, RemoteInventoryInfo> instance : instances.entrySet()) {
                if (!instance.getKey().equalsIgnoreCase(node)) continue;
                return instance.getValue();
            }
        }
        RemoteInventoryInfo newinstance = new RemoteInventoryInfo(node);
        if (instances.containsKey(node.toLowerCase())) {
            instances.remove(node);
        }
        instances.put(node.toLowerCase(), newinstance);
        return newinstance;
    }

    private RemoteInventoryInfo(String node) {
        if (!PlatformInfo.getInstance().isWindows()) {
            System.setProperty("oracle.installer.invPtrLoc", OiipgPropertyLoader.getUnixPtrFileLoc());
        }
        this.node = node;
        this.remoteHomes = oClusterInstInv.getHomes(node);
        this.inventoryLocation = OiipgClusterInvSetup.getInventoryLocationOnNode((String)node);
        this.homeNames = this.gatherHomeNames();
    }

    public String getInventoryLocation() {
        return this.inventoryLocation;
    }

    public boolean isHomeWithLocationExist(String home) {
        if (this.remoteHomes != null) {
            File file = new File(home);
            for (int i = 0; i < this.remoteHomes.size(); ++i) {
                File remoteHome = new File(this.remoteHomes.get(i));
                if (PlatformInfo.getInstance().isWindows()) {
                    try {
                        if (file.getCanonicalPath().equalsIgnoreCase(remoteHome.getCanonicalPath())) {
                            return true;
                        }
                    }
                    catch (IOException e) {
                        logger.log(Level.INFO, "Exception while determining canonical path", e);
                    }
                    continue;
                }
                try {
                    if (!file.getCanonicalPath().equals(remoteHome.getCanonicalPath())) continue;
                    return true;
                }
                catch (IOException e) {
                    logger.log(Level.INFO, "Exception while determining canonical path", e);
                }
            }
        }
        return false;
    }

    public OiiiRemoteHome getRemoteHomeInfoObj(String home) {
        if (this.isHomeWithLocationExist(home)) {
            return oClusterInstInv.getRemoteHome(this.node, home);
        }
        return null;
    }

    public StatusMessages<ValidationStatusMessage> compareToLocalHome(String homeLoc, String node) {
        return InventoryInfo.getInstance().findAndCompareToLocalHome(RemoteInventoryInfo.getInstance(node).getRemoteHomeInfoObj(homeLoc), node);
    }

    public List<String> getNodesWithSameHome(String[] nodes, String oracleHome) {
        ArrayList<String> nodesWithSameHome = new ArrayList<String>();
        if (this.remoteHomes.contains(oracleHome)) {
            for (String node : nodes) {
                if (!RemoteInventoryInfo.getInstance(node).isHomeWithLocationExist(oracleHome)) continue;
                nodesWithSameHome.add(node);
            }
        }
        return nodesWithSameHome;
    }

    public boolean isInventoryExists() {
        return this.inventoryLocation != null && !this.inventoryLocation.isEmpty();
    }

    private List<String> gatherHomeNames() {
        ArrayList<String> homeNamesUsed = new ArrayList<String>();
        List<String> homes = this.remoteHomes;
        if (homes != null && !homes.isEmpty()) {
            for (String home : homes) {
                OiiiRemoteHome remoteHome = oClusterInstInv.getRemoteHome(this.node, home);
                homeNamesUsed.add(remoteHome.getName());
            }
        }
        if (!homeNamesUsed.isEmpty()) {
            logger.log(Level.INFO, "Node " + this.node + " has following home names registered in the central inventory: " + ((Object)homeNamesUsed).toString());
        } else {
            logger.log(Level.INFO, "Node " + this.node + " has no homes registered in the central inventory.");
        }
        return homeNamesUsed;
    }

    public List<String> getHomeNames() {
        return this.homeNames;
    }

    static {
        logger = Logger.getLogger(RemoteInventoryInfo.class.getName());
    }
}

