/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.Installer;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.Version;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.driver.oui.DriverHelper;
import oracle.install.driver.oui.OUIMetadata;
import oracle.install.driver.oui.RemoteInventoryInfo;
import oracle.install.driver.oui.resource.InventoryErrorCode;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiii.OiiiOneoffInstallID;
import oracle.sysman.oii.oiii.OiiiOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiRemoteHome;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;

public class InventoryInfo {
    private static final Logger logger = Logger.getLogger(InventoryInfo.class.getName());
    private static InventoryInfo instance = null;
    private OiiiInstallInventory m_inventory = null;

    private InventoryInfo() {
        OiiiInstallAreaControl invAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        if (invAreaControl != null) {
            this.m_inventory = invAreaControl.getInstallInventory();
        }
    }

    public static InventoryInfo getInstance() {
        if (instance == null) {
            instance = new InventoryInfo();
        }
        return instance;
    }

    public boolean isInventoryExist() {
        return !OiiiInstallAreaControl.isCleanMachine();
    }

    public String getDefaultInventoryLoc() {
        String invLoc = null;
        if (this.isInventoryExist()) {
            try {
                new OiipgPropertyLoader();
                invLoc = OiipgPropertyLoader.getLocationFileLoc();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "An exception occured while trying to locate existing inventory on the local machine\n" + e);
                e.printStackTrace();
            }
        } else {
            invLoc = new OiipgBootstrap().getDefaultLocationFileLoc();
            logger.log(Level.FINEST, "default inventory location calculated");
        }
        logger.log(Level.INFO, "inventory location is" + invLoc);
        return invLoc;
    }

    public String getNameForLocation(String oraHome) {
        String name = "";
        if (this.m_inventory == null) {
            return name;
        }
        if (this.m_inventory.getHomeWithLocation(oraHome) != null) {
            name = this.m_inventory.getHomeWithLocation(oraHome).getName();
        }
        return name;
    }

    public String computeOracleHomeName(String oracleHome) {
        if (this.isHomeWithLocationExist(oracleHome)) {
            String val = this.getNameForLocation(oracleHome);
            logger.info("setting ORACLE_HOME_NAME=" + val);
            return val;
        }
        String presetHomeName = this.getPresetHomeName();
        if (presetHomeName != null && !this.isHomeWithNameExist(presetHomeName)) {
            logger.info("setting ORACLE_HOME_NAME=" + presetHomeName + ". Passed from command line");
            return presetHomeName;
        }
        String val = OiiiOracleHomeInfo.getDefHomeName(null, (int)0);
        PlatformInfo platInfo = PlatformInfo.getInstance();
        String suffix = "";
        if (platInfo.isWindows() && !platInfo.getWinArchitecture().equalsIgnoreCase("x86")) {
            File oracleHomePropFile = new File(oracleHome, OUIMetadata.ORACLE_HOME_METADATA_FILE_LOC);
            File shiphomePropFile = new File(OUIMetadata.METADATA_FILE_LOC);
            if (shiphomePropFile.exists() && OUIMetadata.is32BitShiphome(shiphomePropFile.getAbsolutePath()) || oracleHomePropFile.exists() && OUIMetadata.is32BitShiphome(oracleHomePropFile.getAbsolutePath())) {
                suffix = "_32bit";
            }
        }
        val = val + this.getNewHomeNameIndex(val, suffix) + suffix;
        logger.info("setting ORACLE_HOME_NAME=" + val + ". A default value was " + "calculated as per oraparam.ini");
        return val;
    }

    public String getPresetHomeName() {
        Properties props;
        Application app = Application.getInstance();
        String key = "ORACLE_HOME_NAME";
        if (app instanceof Installer && (props = ((Installer)app).getFlowDataDefaults()) != null && props.containsKey(key)) {
            return props.getProperty(key);
        }
        return null;
    }

    public int getNewHomeNameIndex(String sNewName, String suffix) {
        int idx = 1;
        boolean bNameExists = true;
        while (bNameExists) {
            String sName = sNewName + idx + suffix;
            bNameExists = this.isHomeWithNameExist(sName);
            if (!bNameExists) continue;
            ++idx;
        }
        return idx;
    }

    public boolean isHomeWithNameExist(String oracleHomename) {
        if (this.m_inventory == null) {
            return false;
        }
        return this.m_inventory.getHomeWithName(oracleHomename) != null;
    }

    private OiiiInstallInventory getOUIInventory() {
        OiiiInstallInventory inventory = null;
        OiicStandardInventorySession session = null;
        String compName = "oracle.install";
        String invLoc = this.getDefaultInventoryLoc();
        if (invLoc != null && new File(invLoc).exists()) {
            try {
                String version = new DriverHelper().getVersion();
                session = new OiicStandardInventorySession(compName, version == null ? "" : version);
                session.initSession(2);
                inventory = session.getInstallAreaControl().getInstallInventory();
            }
            catch (OiitTargetLockNotAvailableException oiitTargetLockNotAvailableException) {
            }
            catch (IOException iOException) {
            }
            catch (OiiiInventoryDoesNotExistException oiiiInventoryDoesNotExistException) {
                // empty catch block
            }
        }
        return inventory;
    }

    public StatusMessages<ValidationStatusMessage> compareHomeInfosSelectedAttribsOnly(OiiiOracleHomeInfo oHome1, OiiiRemoteHome oHome2, String remoteNode) {
        String home1name = oHome1.getName();
        String home1oracle_base = oHome1.getAdditionalOracleHomeProperty("ORACLE_BASE");
        String home1arch = oHome1.getAdditionalOracleHomeProperty("ARCHITECTURE");
        Vector home1_TL = this.getOUIInventory().getTopLevelComps(oHome1.getIndex());
        Vector home1_OneOffs = this.getOUIInventory().getAllOneoffInvEntries(oHome1);
        int home1_aruid = oHome1.getARUID();
        String home2name = oHome2.getName();
        String home2oracle_base = oHome2.getAdditionalOracleHomeProperty("ORACLE_BASE");
        String home2arch = oHome2.getAdditionalOracleHomeProperty("ARCHITECTURE");
        Vector home2_TL = new Vector(oHome2.getTopLevelComps());
        Vector home2_OneOffs = new Vector(oHome2.getAllOneOffs());
        int home2_aruid = oHome2.getARUID();
        StatusMessages<ValidationStatusMessage> errorMessages = new StatusMessages<ValidationStatusMessage>();
        boolean isWindows = PlatformInfo.getInstance().isWindows();
        if (isWindows && home1name != null && home2name != null && !home1name.equals(home2name)) {
            errorMessages.add(new ValidationStatusMessage((ErrorCode)InventoryErrorCode.ORACLE_HOME_NAME_INCONSISTENCY, remoteNode, home1name, home2name));
        }
        if (PlatformInfo.getInstance().isWindows()) {
            if (home1oracle_base != null && home2oracle_base != null && !home1oracle_base.equalsIgnoreCase(home2oracle_base)) {
                errorMessages.add(new ValidationStatusMessage((ErrorCode)InventoryErrorCode.ORACLE_BASE_WINDOWS_INCONSISTENCY, remoteNode, home1oracle_base, home2oracle_base));
            }
        } else if (home1oracle_base != null && home2oracle_base != null && !home1oracle_base.equals(home2oracle_base)) {
            errorMessages.add(new ValidationStatusMessage((ErrorCode)InventoryErrorCode.ORACLE_BASE_NON_WINDOWS_INCONSISTENCY, remoteNode, home1oracle_base, home2oracle_base));
        }
        if (home1arch != null && home2arch != null && !home1arch.equals(home2arch)) {
            errorMessages.add(new ValidationStatusMessage((ErrorCode)InventoryErrorCode.HOME_ARCHITECTURE_INCONSISTENCY, remoteNode, home1arch, home2arch));
        }
        if (home1_aruid != home2_aruid) {
            errorMessages.add(new ValidationStatusMessage((ErrorCode)InventoryErrorCode.ARU_ID_INCONSISTENCY, remoteNode, home1_aruid, home2_aruid));
        }
        if (home1_TL != null && home2_TL == null || home1_TL == null && home2_TL != null || home1_TL.size() != home2_TL.size()) {
            errorMessages.add(new ValidationStatusMessage((ErrorCode)InventoryErrorCode.ORACLE_HOME_INCONSISTENCY, remoteNode, home1_TL, home2_TL));
        } else if (home1_TL != null && home2_TL != null) {
            Iterator i = home1_TL.iterator();
            while (i.hasNext()) {
                Iterator j = home2_TL.iterator();
                OiiiCompInstallID home1_cmp = (OiiiCompInstallID)i.next();
                boolean compFound = false;
                while (j.hasNext()) {
                    OiiiInstallCompInvEntry home2_cmp = (OiiiInstallCompInvEntry)j.next();
                    if (!home2_cmp.equals(home1_cmp)) continue;
                    compFound = true;
                    break;
                }
                if (compFound) continue;
                errorMessages.add(new ValidationStatusMessage((ErrorCode)InventoryErrorCode.ORACLE_HOME_INVENTORY_INCONSISTENCY, remoteNode, home1_TL, home2_TL));
            }
        }
        if (home1_OneOffs != null && home2_OneOffs == null || home1_OneOffs == null && home2_OneOffs != null || home1_OneOffs.size() != home2_OneOffs.size()) {
            errorMessages.add(new ValidationStatusMessage((ErrorCode)InventoryErrorCode.ONE_OFFS_COUNT_INCONSISTENCY, remoteNode, home1_OneOffs, home2_OneOffs));
        } else if (home1_OneOffs != null && home2_OneOffs != null) {
            for (Object invObj : home1_OneOffs) {
                if (!(invObj instanceof OiiiOneoffInvEntry)) continue;
                Iterator j = home2_OneOffs.iterator();
                OiiiOneoffInstallID home1_oneoff = ((OiiiOneoffInvEntry)invObj).getID();
                boolean oneoffFound = false;
                while (j.hasNext()) {
                    OiiiOneoffInvEntry home2_oneoff = (OiiiOneoffInvEntry)j.next();
                    if (!home2_oneoff.getID().equals(home1_oneoff)) continue;
                    oneoffFound = true;
                    break;
                }
                if (oneoffFound) continue;
                errorMessages.add(new ValidationStatusMessage((ErrorCode)InventoryErrorCode.ONE_OFFS_INVENTORY_INCONSISTENCY, remoteNode, home1_OneOffs, home2_OneOffs));
            }
        }
        return errorMessages;
    }

    public StatusMessages<ValidationStatusMessage> findAndCompareToLocalHome(OiiiRemoteHome oHome, String node) {
        String homeLoc = oHome.getLocation();
        OiiiOracleHomeInfo localHomeObj = this.getOUIInventory().getHomeWithLocation(homeLoc);
        return this.compareHomeInfosSelectedAttribsOnly(localHomeObj, oHome, node);
    }

    public boolean isHomeWithLocationExist(String homeLoc) {
        OiiiInstallInventory installInventory = this.getOUIInventory();
        return installInventory != null && installInventory.getHomeWithLocation(homeLoc) != null;
    }

    public String getUnixGroupName() {
        File f;
        String invPtrLoc = OiipgPropertyLoader.getUnixPtrFileLoc();
        if (invPtrLoc == null || invPtrLoc.trim().equalsIgnoreCase("")) {
            logger.log(Level.INFO, "could not determine location of oraInst.loc. Will default to /etc/oraInst.loc");
            invPtrLoc = "/etc/oraInst.loc";
        }
        if (!(f = new File(invPtrLoc)).exists()) {
            logger.log(Level.INFO, "oraInst.loc does not exist");
            return "";
        }
        return this.getPropertyFromTextFile(f, "inst_group");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPropertyFromTextFile(File input, String key) {
        String val = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(input));
            String curLine = "";
            while ((curLine = br.readLine()) != null) {
                if ((curLine = curLine.replaceAll(" ", "")).startsWith("#") || curLine.indexOf(key) == -1) continue;
                val = curLine.substring(curLine.indexOf(key) + key.length() + 1);
                break;
            }
        }
        catch (Exception ex) {
            val = "";
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
        }
        return val;
    }

    public String getBaseForLocation(String oraHomeLoc) {
        OiiiInstallInventory inventory;
        String base = null;
        OiiiInstallAreaControl invAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        if (invAreaControl != null && (inventory = invAreaControl.getInstallInventory()) != null && inventory.getHomeWithLocation(oraHomeLoc) != null) {
            base = inventory.getHomeWithLocation(oraHomeLoc).getAdditionalOracleHomeProperty("ORACLE_BASE");
        }
        return base;
    }

    public Version getProductVersion(String oracleHome) {
        OiiiCompInstallID component;
        Vector compVector;
        OiiiOracleHomeInfo homeInfo;
        OiiiInstallInventory inventory;
        Version version = null;
        if (oracleHome != null && (inventory = this.getOUIInventory()) != null && (homeInfo = inventory.getHomeWithLocation(oracleHome)) != null && (compVector = inventory.getTopLevelComps(homeInfo.getIndex())) != null && compVector.size() > 0 && compVector.get(0) instanceof OiiiCompInstallID && compVector.get(0) instanceof OiiiCompInstallID && (component = (OiiiCompInstallID)compVector.get(0)) != null) {
            try {
                version = Version.parseVersion(component.getVersion().toString());
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.WARNING, "Unable to parse the oracle home version:" + e.getMessage());
            }
        }
        return version;
    }

    public String computeOracleHomeName(List<String> remoteNodes, String homeNamePrefix) {
        Vector homes;
        HashSet<String> existingHomeNames = new HashSet<String>();
        if (this.isInventoryExist() && this.m_inventory != null && (homes = this.m_inventory.getHomes()) != null && !homes.isEmpty()) {
            for (String home : homes) {
                OiiiOracleHomeInfo homeInfo;
                String homeName;
                if (!(home instanceof OiiiOracleHomeInfo) || (homeName = (homeInfo = (OiiiOracleHomeInfo)home).getName()) == null) continue;
                existingHomeNames.add(homeName);
            }
        }
        boolean isWindows = PlatformInfo.getInstance().isWindows();
        if (remoteNodes != null && !remoteNodes.isEmpty() && isWindows) {
            for (String node : remoteNodes) {
                RemoteInventoryInfo rii = RemoteInventoryInfo.getInstance(node);
                if (rii == null) continue;
                existingHomeNames.addAll(rii.getHomeNames());
            }
        }
        int homeIndex = 1;
        String oracleHomeName = homeNamePrefix + Integer.valueOf(homeIndex).toString();
        if (!existingHomeNames.isEmpty()) {
            boolean isHomeNameUnique = false;
            while (!isHomeNameUnique) {
                boolean homeNameAlreadyUsed = false;
                for (String homeName : existingHomeNames) {
                    if (!oracleHomeName.equalsIgnoreCase(homeName)) continue;
                    homeNameAlreadyUsed = true;
                    break;
                }
                if (homeNameAlreadyUsed) {
                    oracleHomeName = homeNamePrefix + Integer.valueOf(++homeIndex).toString();
                    continue;
                }
                isHomeNameUnique = true;
            }
        }
        return oracleHomeName;
    }
}

