/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class MultilineLabel
extends JTextPane {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_TEXT = "MultilineLabel.text";
    private StyledDocument doc;
    private SimpleAttributeSet attrs;
    private int alignment;
    public static int ALIGN_CENTER = 1;

    public MultilineLabel() {
        this((String)null);
    }

    public MultilineLabel(int alignment) {
        this(null, alignment);
    }

    public MultilineLabel(String text) {
        this(text, 0);
    }

    public MultilineLabel(String text, int alignment) {
        this.alignment = alignment;
        this.setFocusable(false);
        this.setOpaque(false);
        this.setEditable(false);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.attrs = new SimpleAttributeSet();
        if (this.alignment == ALIGN_CENTER) {
            StyleConstants.setAlignment(this.attrs, 1);
        }
        this.doc = (StyledDocument)this.getDocument();
        this.doc.setParagraphAttributes(0, this.doc.getLength() - 1, this.attrs, false);
        if (text != null) {
            this.setText(text);
        }
    }

    @Override
    public void setText(String text) {
        String oldText = this.getText();
        if (!oldText.equals(text)) {
            try {
                this.doc.remove(0, this.doc.getLength());
                this.doc.insertString(0, text, this.attrs);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            super.firePropertyChange(PROPERTY_TEXT, oldText, text);
        }
    }

    public void setRows(int rows) {
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
        if (this.alignment == ALIGN_CENTER) {
            StyleConstants.setAlignment(this.attrs, 1);
            this.setText(this.getText());
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMultilineLabel();
        }
        return this.accessibleContext;
    }

    protected class AccessibleMultilineLabel
    extends JTextComponent.AccessibleJTextComponent {
        private static final long serialVersionUID = 1L;

        public AccessibleMultilineLabel() {
            super(MultilineLabel.this);
        }

        @Override
        public String getAccessibleDescription() {
            return MultilineLabel.this.getText();
        }

        @Override
        public String getAccessibleName() {
            return MultilineLabel.this.getText();
        }

        @Override
        public String getToolTipText() {
            return MultilineLabel.this.getText();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }
}

