/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.net.support;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.net.support.SSHConnectivityDetails;
import oracle.install.commons.net.support.SSHConnectivitySetupInfo;
import oracle.install.commons.net.support.SSHSupportManager;
import oracle.install.commons.net.support.SSHSupportManagerException;

public class DefaultSSHSupportManager
extends SSHSupportManager {
    private static final Logger logger = Logger.getLogger(DefaultSSHSupportManager.class.getName());
    private static final String[] PRIVATE_KEY_FILES = new String[]{"identity", "id_rsa", "id_dsa"};
    private JSch jsch;

    public DefaultSSHSupportManager() {
        logger.info("Preparing Default SSH support manager");
        this.jsch = new JSch();
        String home = System.getProperty("user.home");
        for (String pvk : PRIVATE_KEY_FILES) {
            File identity = new File(home, ".ssh/" + pvk);
            if (!identity.exists()) continue;
            try {
                this.jsch.addIdentity(identity.getPath());
                logger.log(Level.INFO, "Added identity file {0}", identity);
            }
            catch (JSchException e) {
                logger.log(Level.WARNING, "Failed to add identity file {0}. Reason: {1}", new Object[]{pvk, e.getMessage()});
            }
        }
        File known_hosts = new File(home, ".ssh/known_hosts");
        if (known_hosts.exists()) {
            try {
                this.jsch.setKnownHosts(known_hosts.getPath());
                logger.log(Level.INFO, "Set known hosts file to {0}", known_hosts);
            }
            catch (JSchException e) {
                logger.log(Level.WARNING, "Known hosts not set. Reason: {0}", e.getMessage());
            }
        }
    }

    @Override
    public SSHConnectivityDetails establishSSHConnectivity(SSHConnectivitySetupInfo sshSetupInfo) throws SSHSupportManagerException {
        return null;
    }

    @Override
    public SSHConnectivityDetails getSSHConnectivityDetails(String[] nodes, String sharedUserName, char[] passphrase) throws SSHSupportManagerException {
        return null;
    }

    private static class PasswordLessUserInfo
    implements UserInfo {
        private boolean passwordExpected = false;

        public PasswordLessUserInfo(String sharedUserName) {
        }

        public boolean isPasswordExpected() {
            return this.passwordExpected;
        }

        public String getPassword() {
            return null;
        }

        public boolean promptYesNo(String message) {
            logger.log(Level.INFO, "PromptYesNo: {0}", message);
            return true;
        }

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(String message) {
            this.passwordExpected = true;
            logger.log(Level.INFO, "Passphrase/Password expected. Message: {0}", message);
            return false;
        }

        public boolean promptPassword(String message) {
            return this.promptPassphrase(message);
        }

        public void showMessage(String message) {
            logger.info(message);
        }
    }
}

