/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.Condition;
import oracle.install.commons.flow.ConditionContext;
import oracle.install.commons.flow.ConditionResult;
import oracle.install.commons.flow.FlowApplication;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowExecutionMode;
import oracle.install.commons.flow.FlowExecutorType;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.State;
import oracle.install.commons.flow.StateType;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Graph;

public class FlowHelper {
    private static final Logger logger = Logger.getLogger(FlowHelper.class.getName());
    private static final String STATE_CONDITION_RESULT = "state.condition.result";

    public static State findState(FlowContext flowContext, String stateId) {
        State state = null;
        Graph<Route, State> vertex = FlowHelper.findVertex(flowContext.getCurrentVertex(), stateId);
        if (vertex != null) {
            state = vertex.getValue();
        }
        return state;
    }

    public static Graph<Route, State> findVertex(Graph<Route, State> vertex, String stateId) {
        State currentState = vertex.getValue();
        if (stateId.equals(currentState.getId())) {
            return vertex;
        }
        Set<Route> edges = vertex.getEdges();
        for (Route edge : edges) {
            Graph<Route, State> siblingVertex = vertex.getGraph(edge);
            Graph<Route, State> expectedVertex = FlowHelper.findVertex(siblingVertex, stateId);
            if (expectedVertex == null) continue;
            return expectedVertex;
        }
        return null;
    }

    public static boolean isSilentMode(FlowContext flowContext) {
        return flowContext != null && flowContext.getFlowExecutionType() == FlowExecutorType.SILENT;
    }

    public static Graph<Route, State> findNextVertex(Graph<Route, State> sourceVertex) {
        return FlowHelper.findNextVertex(null, sourceVertex, null);
    }

    public static Graph<Route, State> findNextVertex(Graph<Route, State> sourceVertex, Route route) {
        return FlowHelper.findNextVertex(null, sourceVertex, route);
    }

    public static Graph<Route, State> findNextVertex(FlowContext flowContext, Graph<Route, State> sourceVertex) {
        return FlowHelper.findNextVertex(flowContext, sourceVertex, null, false);
    }

    public static Graph<Route, State> findNextVertex(FlowContext flowContext, Graph<Route, State> sourceVertex, Route route) {
        return FlowHelper.findNextVertex(flowContext, sourceVertex, route, false);
    }

    private static Graph<Route, State> findNextVertex(FlowContext flowContext, Graph<Route, State> sourceVertex, Route route, boolean conditionRoute) {
        State state;
        Condition condition;
        Map<Route, Graph<Route, State>> conditionTransitionMap;
        Graph<Route, State> destVertex = null;
        Application application = Application.getInstance();
        if (FlowApplication.class.isAssignableFrom(application.getClass()) && ((FlowApplication)application).getExecutionMode() == FlowExecutionMode.CHECKONLY && sourceVertex.getValue().getStateType() == StateType.summary) {
            return null;
        }
        destVertex = !conditionRoute ? (route == null ? sourceVertex.getGraph() : sourceVertex.getGraph(route)) : ((conditionTransitionMap = (condition = (state = sourceVertex.getValue()).getCondition()).getTransitionMap()) != null && !conditionTransitionMap.isEmpty() ? conditionTransitionMap.get(route) : condition.getDefaultTarget());
        if (destVertex == null) {
            return null;
        }
        state = destVertex.getValue();
        if (state != null && state.isConditional()) {
            Map<Route, Graph<Route, State>> conditionTransitionMap2;
            ConditionResult conditionResult = null;
            Object result = state.getAttribute(STATE_CONDITION_RESULT);
            if (result instanceof ConditionResult) {
                conditionResult = (ConditionResult)result;
                if (flowContext != null) {
                    if (!conditionResult.isPerpetual()) {
                        conditionResult = null;
                    } else {
                        logger.log(Level.INFO, "Identified cached perpetual condition at state <{0}>", state.getId());
                    }
                }
            }
            Condition condition2 = state.getCondition();
            if (conditionResult == null && condition2 != null && condition2.getConditionRoutine() != null) {
                try {
                    logger.log(Level.INFO, "Checking condition at state <{0}>", state.getId());
                    conditionResult = condition2.getConditionRoutine().check(new ConditionContext(condition2, flowContext, state));
                    logger.log(Level.INFO, "Successfully checked condition at state <{0}>", state.getId());
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, String.format("Unexpected error occured while checking condition at state <%s>. Ignoring the condition.", state.getId()), t);
                }
            }
            Map<Route, Graph<Route, State>> map = conditionTransitionMap2 = condition2 != null ? condition2.getTransitionMap() : null;
            if (conditionResult != null && (conditionResult.isConditionMatched() || conditionTransitionMap2 != null && conditionTransitionMap2.get(conditionResult.getRoute()) != null)) {
                Route newRoute = conditionResult.getRoute();
                logger.log(Level.INFO, "Condition matched at state <{0}>.", state.getId());
                if (newRoute != null) {
                    logger.log(Level.INFO, "Redirecting to route <{0}>.", newRoute.getId());
                    Graph<Route, State> newDestVertex = FlowHelper.findNextVertex(flowContext, destVertex, newRoute, true);
                    if (newDestVertex != null) {
                        destVertex = newDestVertex;
                    }
                } else {
                    logger.log(Level.INFO, "No route specified. Ignoring condition match at state <{0}>.", state.getId());
                }
            }
        }
        return destVertex;
    }

    public static boolean isLinkedToEx(FlowContext flowContext, Graph<Route, State> sourceVertex, Graph<Route, State> destVertex) {
        if (sourceVertex != null && destVertex != null) {
            Set<Route> edges = sourceVertex.getEdges();
            for (Route route : edges) {
                Graph<Route, State> intermediateVertex = FlowHelper.findNextVertex(flowContext, sourceVertex, route);
                if (intermediateVertex != destVertex) continue;
                return true;
            }
        }
        return false;
    }
}

