/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import oracle.install.commons.flow.AbstractFlowExecutor;
import oracle.install.commons.flow.ConsoleFlowExecutor;
import oracle.install.commons.flow.FlowExecutor;
import oracle.install.commons.flow.FlowExecutorType;
import oracle.install.commons.flow.SilentFlowExecutor;
import oracle.install.commons.flow.jewt.JewtFlowExecutor;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.UIType;

public class FlowExecutorFactory {
    public static FlowExecutor createFlowExecutor(FlowExecutorType flowExecutionType) {
        AbstractFlowExecutor flowExecutor = null;
        if (flowExecutionType == FlowExecutorType.INTERACTIVE) {
            UIType uiType = Application.getInstance().getUIType();
            if (uiType == UIType.GRAPHICAL) {
                flowExecutor = new JewtFlowExecutor();
            } else if (uiType == UIType.TEXTUAL) {
                flowExecutor = new ConsoleFlowExecutor();
            }
        } else if (flowExecutionType == FlowExecutorType.SILENT) {
            flowExecutor = new SilentFlowExecutor();
        }
        return flowExecutor;
    }
}

