/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.install.commons.bean.xml.XmlBeanStoreFormatRegistry;
import oracle.install.commons.util.XmlSupport;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XmlBeanStoreFormat {
    public static final XmlBeanStoreFormat DEFAULT = new XmlBeanStoreFormat();
    private static final Logger logger = Logger.getLogger(XmlBeanStoreFormat.class.getName());
    public static final String DEFAULT_NAMESPACE = "ins";
    private String namespace;
    private String namespaceURI;
    private URL raw2extTransformer;
    private URL ext2rawTransformer;
    private URL schema;
    private String beanStoreName;

    public XmlBeanStoreFormat() {
    }

    public XmlBeanStoreFormat(String namespaceURI, URL raw2extTransformer, URL ext2rawTransformer, URL schema) {
        this(null, null, namespaceURI, raw2extTransformer, ext2rawTransformer, schema);
    }

    public XmlBeanStoreFormat(String namespace, String namespaceURI, URL raw2extTransformer, URL ext2rawTransformer, URL schema) {
        this(null, null, namespaceURI, raw2extTransformer, ext2rawTransformer, schema);
    }

    public XmlBeanStoreFormat(String beanStoreName, String namespace, String namespaceURI, URL raw2extTransformer, URL ext2rawTransformer, URL schema) {
        this.namespace = namespace == null ? DEFAULT_NAMESPACE : namespace;
        this.namespaceURI = namespaceURI;
        this.raw2extTransformer = raw2extTransformer;
        this.ext2rawTransformer = ext2rawTransformer;
        this.schema = schema;
        this.beanStoreName = beanStoreName;
    }

    public String getBeanStoreName() {
        return this.beanStoreName;
    }

    public void setBeanStoreName(String beanStoreName) {
        this.beanStoreName = beanStoreName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public URL getExt2rawTransformer() {
        return this.ext2rawTransformer;
    }

    public void setExt2rawTransformer(URL ext2rawTransformer) {
        this.ext2rawTransformer = ext2rawTransformer;
    }

    public URL getRaw2extTransformer() {
        return this.raw2extTransformer;
    }

    public void setRaw2extTransformer(URL raw2extTransformer) {
        this.raw2extTransformer = raw2extTransformer;
    }

    public URL getSchema() {
        return this.schema;
    }

    public void setSchema(URL schema) {
        this.schema = schema;
    }

    public Document ext2raw(InputSource in) throws Exception {
        Document rawDoc = null;
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            EntityResolver entityResolver = this.getEntityResolver();
            if (entityResolver != null) {
                docBuilder.setEntityResolver(entityResolver);
            }
            rawDoc = docBuilder.parse(in);
            if (this.ext2rawTransformer != null) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                logger.info("Translating external format into raw format ");
                DOMSource xmlSource = new DOMSource(rawDoc);
                StreamSource xslSource = new StreamSource(this.ext2rawTransformer.toExternalForm());
                StreamResult rawResult = new StreamResult(buffer);
                XmlSupport.transform(xmlSource, rawResult, xslSource);
                rawDoc = docBuilder.parse(new ByteArrayInputStream(buffer.toByteArray()));
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while translating. Reason: ", e);
            throw new RuntimeException(e);
        }
        return rawDoc;
    }

    public void raw2ext(Document rawDoc, Result externalResult) throws Exception {
        DOMSource xmlSource = new DOMSource(rawDoc);
        if (logger.isLoggable(Level.FINEST)) {
            StringWriter buffer = new StringWriter();
            XmlSupport.transform(xmlSource, new StreamResult(buffer), null);
            logger.finest(buffer.toString());
        }
        StreamSource xslSource = null;
        if (this.raw2extTransformer != null) {
            xslSource = new StreamSource(this.raw2extTransformer.toExternalForm());
        }
        XmlSupport.transform(xmlSource, externalResult, xslSource);
    }

    public void validate(Source beanStore) throws Exception {
        if (this.schema != null) {
            XmlSupport.validate(beanStore, this.schema);
        }
    }

    protected EntityResolver getEntityResolver() {
        return null;
    }

    public boolean isCompatibleTo(InputSource in) throws Exception {
        return true;
    }

    public XmlBeanStoreFormat getCompatibleFormat(InputSource xmlSource) {
        XmlBeanStoreFormat compatibleFormat = this;
        try {
            XmlBeanStoreFormat format;
            String namespaceURI = XmlSupport.getNamespaceURI(xmlSource, this.getNamespace());
            if (namespaceURI != null && (format = XmlBeanStoreFormatRegistry.getInstance().getFormat(namespaceURI)) != null) {
                compatibleFormat = format;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to find the namespace URI. Reason: {0}", e.getMessage());
        }
        return compatibleFormat;
    }
}

