/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.bean.BeanDefinition;
import oracle.install.commons.bean.BeanStore;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreFactory;
import oracle.install.commons.bean.BeanStoreWriter;
import oracle.install.commons.bean.PropertyDefinition;
import oracle.install.commons.bean.annotation.PropertyDef;
import oracle.install.commons.bean.properties.PropertiesBeanStore;
import oracle.install.commons.bean.properties.PropertiesBeanStoreReader;
import oracle.install.commons.bean.properties.PropertiesBeanStoreWriter;
import oracle.install.commons.bean.xml.BeanStoreFileSource;
import oracle.install.commons.bean.xml.PropertyFileFormat;
import oracle.install.commons.bean.xml.XmlBeanStore;
import oracle.install.commons.bean.xml.XmlBeanStoreFactory;
import oracle.install.commons.bean.xml.XmlBeanStoreFormat;
import oracle.install.commons.bean.xml.XmlBeanStoreFormatRegistry;
import oracle.install.commons.bean.xml.XmlBeanStoreReader;
import oracle.install.commons.bean.xml.XmlBeanStoreSource;
import oracle.install.commons.bean.xml.XmlBeanStoreWriter;
import oracle.install.commons.util.message.Content;
import oracle.install.commons.util.message.grid.FixedGridContent;

public class BeanStoreUtils {
    public static final String SECURE_PROPERTY_MASK = "*Protected value, not to be logged*";
    private static final Logger logger = Logger.getLogger(BeanStoreUtils.class.getName());

    public static boolean isBean(Object object) {
        boolean status = false;
        if (object != null) {
            try {
                BeanDefinition beanDef = BeanDefinition.getBeanDefinition(object.getClass());
                status = beanDef != null;
            }
            catch (BeanStoreException beanStoreException) {
                // empty catch block
            }
        }
        return status;
    }

    public static void storeAsMap(Map<String, Object> map, Object bean) throws BeanStoreException {
        if (map != null && bean != null) {
            BeanDefinition beanDef = BeanDefinition.getBeanDefinition(bean.getClass());
            List<PropertyDefinition> propertyDefList = beanDef.getMemberDefinitions();
            for (PropertyDefinition propertyDef : propertyDefList) {
                String key = propertyDef.getName();
                Object value = propertyDef.getValue(bean);
                map.put(key, value);
            }
        }
    }

    public static void restoreFromMap(Map<String, Object> map, Object bean) throws BeanStoreException {
        if (map != null && bean != null) {
            BeanDefinition beanDef = BeanDefinition.getBeanDefinition(bean.getClass());
            List<PropertyDefinition> propertyDefList = beanDef.getMemberDefinitions();
            for (PropertyDefinition propertyDef : propertyDefList) {
                String key = propertyDef.getName();
                Object value = map.get(key);
                propertyDef.setValue(bean, value);
            }
        }
    }

    public static Map<String, Object> convertBeanToMap(Object bean) throws BeanStoreException {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        BeanDefinition beanDef = BeanDefinition.getBeanDefinition(bean.getClass());
        List<PropertyDefinition> propertyDefList = beanDef.getMemberDefinitions();
        for (PropertyDefinition propertyDef : propertyDefList) {
            String key = propertyDef.getName();
            Object value = propertyDef.getValue(bean);
            map.put(key, value);
        }
        return map;
    }

    public static Set<String> getSecurePropertySet(Object ... beans) throws BeanStoreException {
        TreeSet<String> securePropertySet = new TreeSet<String>();
        if (beans != null && beans.length >= 0) {
            ArrayList beanTypes = new ArrayList();
            for (int i = 0; i < beans.length; ++i) {
                if (beans[i] == null) continue;
                beanTypes.add(beans[i].getClass());
            }
            securePropertySet.addAll(BeanStoreUtils.getSecurePropertySet(beanTypes.toArray(new Class[0])));
        }
        return securePropertySet;
    }

    public static Set<String> getSecurePropertySet(Class<?> ... beanTypes) throws BeanStoreException {
        TreeSet<String> securePropertySet = new TreeSet<String>();
        if (beanTypes != null && beanTypes.length > 0) {
            for (Class<?> beanType : beanTypes) {
                BeanDefinition beanDef;
                if (beanType == null || (beanDef = BeanDefinition.getBeanDefinition(beanType)) == null) continue;
                securePropertySet.addAll(BeanStoreUtils.getSecurePropertySet(beanDef));
            }
        }
        return securePropertySet;
    }

    private static Set<String> getSecurePropertySet(BeanDefinition beanDef) throws BeanStoreException {
        TreeSet<String> securePropertySet = new TreeSet<String>();
        if (beanDef != null) {
            List<PropertyDefinition> propertyDefList = beanDef.getMemberDefinitions();
            for (PropertyDefinition propertyDefinition : propertyDefList) {
                PropertyDef def = propertyDefinition.getPropertyDef();
                if (def.secure()) {
                    String key = propertyDefinition.getName();
                    securePropertySet.add(key);
                }
                if (!(propertyDefinition instanceof BeanDefinition)) continue;
                securePropertySet.addAll(BeanStoreUtils.getSecurePropertySet((BeanDefinition)propertyDefinition));
            }
        }
        return securePropertySet;
    }

    public static void updateBeanFromStringMap(Map<String, Object> stringMap, Object ... beans) throws BeanStoreException {
        if (stringMap != null && beans != null) {
            for (Object bean : beans) {
                if (bean == null) continue;
                BeanDefinition beanDef = BeanDefinition.getBeanDefinition(bean.getClass());
                BeanStoreUtils.updateBeanFromStringMap(stringMap, beanDef, bean);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateBeanFromStringMap(Map<String, Object> stringMap, Object bean) throws BeanStoreException {
        if (bean != null) {
            Properties properties = new Properties();
            for (Map.Entry<String, Object> e : stringMap.entrySet()) {
                String key = e.getKey();
                Object value = e.getValue();
                if (value == null) continue;
                properties.put(key, value);
            }
            PropertiesBeanStore beanStore = new PropertiesBeanStore(properties);
            PropertiesBeanStoreReader beanStoreReader = null;
            try {
                beanStoreReader = beanStore.newBeanStoreReader();
                beanStoreReader.read(bean);
            }
            catch (BeanStoreException e) {
                logger.log(Level.WARNING, "restoreStringMap: Error while reading bean from the beanstore. Reason: {0}", e);
            }
            finally {
                if (beanStoreReader != null) {
                    try {
                        beanStoreReader.close();
                    }
                    catch (BeanStoreException e) {
                        logger.log(Level.WARNING, "restoreStringMap: Error while closing the the beanstore. Reason: {0}", e);
                    }
                }
            }
        }
    }

    public static void storeAsStringMap(Map<String, Object> stringMap, Object ... beans) throws BeanStoreException {
        if (stringMap != null && beans != null) {
            for (Object bean : beans) {
                if (bean == null) continue;
                BeanDefinition beanDef = BeanDefinition.getBeanDefinition(bean.getClass());
                BeanStoreUtils.storeAsStringMap(stringMap, beanDef, bean);
            }
        }
    }

    private static void storeAsStringMap(Map<String, Object> stringMap, BeanDefinition beanDef, Object bean) throws BeanStoreException {
        List<PropertyDefinition> propertyDefList = beanDef.getMemberDefinitions();
        for (PropertyDefinition propertyDef : propertyDefList) {
            String key = propertyDef.getName();
            Object value = propertyDef.getValue(bean);
            if (value == null) continue;
            if (value.getClass().isArray()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("{");
                int n = Array.getLength(value);
                for (int i = 0; i < n; ++i) {
                    Object v = Array.get(value, i);
                    buffer.append(",");
                    buffer.append("\"");
                    buffer.append(v != null ? v.toString() : "");
                    buffer.append("\"");
                }
                if (n > 0) {
                    buffer.deleteCharAt(1);
                }
                buffer.append("}");
                stringMap.put(key, buffer.toString());
                continue;
            }
            if (value instanceof List) {
                List arlValue = (List)value;
                StringBuffer buffer = new StringBuffer();
                buffer.append("{");
                int n = arlValue.size();
                for (int i = 0; i < n; ++i) {
                    Object v = arlValue.get(i);
                    buffer.append(",");
                    buffer.append("\"");
                    buffer.append(v != null ? v.toString() : "");
                    buffer.append("\"");
                }
                if (n > 0) {
                    buffer.deleteCharAt(1);
                }
                buffer.append("}");
                stringMap.put(key, buffer.toString());
                continue;
            }
            stringMap.put(key, value.toString());
            BeanDefinition def = BeanDefinition.getBeanDefinition(value.getClass());
            if (def == null) continue;
            BeanStoreUtils.storeAsStringMap(stringMap, def, value);
        }
    }

    public static void storeAsXML(File beanStoreFile, Object ... beans) throws BeanStoreException {
        BeanStoreUtils.storeAsXML(beanStoreFile, null, true, beans);
    }

    public static void storeAsXML(File beanStoreFile, boolean secure, Object ... beans) throws BeanStoreException {
        BeanStoreUtils.storeAsXML(beanStoreFile, null, secure, beans);
    }

    public static void storeAsXML(File beanStoreFile, String beanStoreName, boolean secure, Object ... beans) throws BeanStoreException {
        XmlBeanStoreFormatRegistry registry = XmlBeanStoreFormatRegistry.getInstance();
        XmlBeanStoreFormat format = null;
        try {
            format = registry.getFileFormat(beanStoreFile);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "storeAsXML: Error while finding bean store format. Reason: {0}", e);
        }
        BeanStoreUtils.storeAsXML(beanStoreFile, format, beanStoreName, secure, beans);
    }

    public static void storeAsXML(File beanStoreFile, XmlBeanStoreFormat format, String beanStoreName, boolean secure, Object ... beans) throws BeanStoreException {
        try {
            FileOutputStream outputStream = new FileOutputStream(beanStoreFile);
            BeanStoreUtils.storeAsXML((OutputStream)outputStream, format, beanStoreName, secure, beans);
            outputStream.close();
        }
        catch (IOException e) {
            logger.warning("storeAsXML: Error while writing: " + e.getMessage());
        }
    }

    public static void storeAsXML(File beanStoreFile, XmlBeanStoreFormat format, String beanStoreName, Object ... beans) throws BeanStoreException {
        BeanStoreUtils.storeAsXML(beanStoreFile, format, beanStoreName, true, beans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeAsXML(OutputStream beanStore, XmlBeanStoreFormat format, String beanStoreName, boolean secure, Object ... beans) throws BeanStoreException {
        if (beans != null) {
            XmlBeanStoreFactory xmlBeanStoreFactory = BeanStoreFactory.getInstance(XmlBeanStoreFactory.class);
            BeanStore xmlBeanStore = null;
            try {
                XmlBeanStoreSource source = new XmlBeanStoreSource(beanStoreName);
                source.setFormat(format);
                xmlBeanStore = xmlBeanStoreFactory.newBeanStore(source);
                xmlBeanStore.setSecure(secure);
                XmlBeanStoreWriter beanStoreWriter = ((XmlBeanStore)xmlBeanStore).newBeanStoreWriter();
                for (Object bean : beans) {
                    beanStoreWriter.write(bean);
                }
                try {
                    ((BeanStoreWriter)beanStoreWriter).close();
                }
                catch (BeanStoreException e) {
                    logger.warning("storeAsXML: Error while closing: " + e.getMessage());
                }
                ((XmlBeanStore)xmlBeanStore).save(beanStore);
            }
            catch (BeanStoreException e) {
                logger.warning("storeAsXML: Error while writing: " + e.getMessage());
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (xmlBeanStore != null) {
                    try {
                        xmlBeanStore.close();
                    }
                    catch (BeanStoreException e) {
                        logger.warning("storeAsXML: Error while closing: " + e.getMessage());
                    }
                }
            }
        }
    }

    public static void storeAsXML(OutputStream beanStore, String beanStoreName, boolean secure, Object ... beans) throws BeanStoreException {
        BeanStoreUtils.storeAsXML(beanStore, null, beanStoreName, secure, beans);
    }

    public static List<?> restoreAllFromXML(XmlBeanStoreSource beanStoreSource, Class<?> ... beanTypes) throws BeanStoreException {
        ArrayList beans = new ArrayList();
        XmlBeanStoreFactory xmlBeanStoreFactory = BeanStoreFactory.getInstance(XmlBeanStoreFactory.class);
        XmlBeanStore beanStore = null;
        XmlBeanStoreReader beanStoreReader = null;
        try {
            beanStore = xmlBeanStoreFactory.newBeanStore(beanStoreSource);
            beanStoreReader = beanStore.newBeanStoreReader();
            beanStoreReader.open(beanStore);
            for (Class<?> beanType : beanTypes) {
                Object bean = beanStoreReader.read(beanType);
                if (bean != null) {
                    beans.add(bean);
                    logger.log(Level.INFO, "Loaded bean of type {0}", beanType);
                    continue;
                }
                logger.log(Level.INFO, "Failed to load bean of type {0}", beanType);
            }
        }
        catch (BeanStoreException e) {
            logger.warning("restoreAllFromXML: Error while reading: " + e.getMessage());
            throw e;
        }
        finally {
            if (beanStoreReader != null) {
                try {
                    beanStoreReader.close();
                }
                catch (BeanStoreException e) {
                    logger.warning("restoreAllFromXML: Error while closing: " + e.getMessage());
                }
            }
            if (beanStore != null) {
                try {
                    beanStore.close();
                }
                catch (BeanStoreException e) {
                    logger.warning("restoreAllFromXML: Error while closing: " + e.getMessage());
                }
            }
        }
        return beans;
    }

    public static List<?> restoreAllFromXML(URL beanStoreURL, String beanStoreName, Class<?> ... beanTypes) throws BeanStoreException {
        return BeanStoreUtils.restoreAllFromXML(new XmlBeanStoreSource(beanStoreName, beanStoreURL), beanTypes);
    }

    public static List<?> restoreAllFromXML(URL beanStoreURL, Class<?> ... beanTypes) throws BeanStoreException {
        return BeanStoreUtils.restoreAllFromXML(beanStoreURL, null, beanTypes);
    }

    public static <B> B restoreFromXML(URL beanStoreURL, String beanStoreName, Class<B> beanType) {
        return BeanStoreUtils.restoreFromXML(new XmlBeanStoreSource(beanStoreName, beanStoreURL), beanType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <B> B restoreFromXML(XmlBeanStoreSource beanStoreSource, Class<B> beanType) {
        B bean = null;
        if (beanStoreSource == null) {
            return null;
        }
        if (beanStoreSource.getBeanStoreName() == null) {
            try {
                BeanDefinition beanDefinition = BeanDefinition.getBeanDefinition(beanType);
                if (beanDefinition.getBeanDef().beanStore()) {
                    beanStoreSource.setBeanStoreName(beanDefinition.getName());
                }
            }
            catch (BeanStoreException e) {
                logger.log(Level.WARNING, "Unable to get the bean definition for {0}", beanType);
                e.printStackTrace();
                return null;
            }
        }
        XmlBeanStoreFactory xmlBeanStoreFactory = BeanStoreFactory.getInstance(XmlBeanStoreFactory.class);
        XmlBeanStore beanStore = null;
        XmlBeanStoreReader beanStoreReader = null;
        try {
            beanStore = xmlBeanStoreFactory.newBeanStore(beanStoreSource);
            beanStoreReader = beanStore.newBeanStoreReader();
            beanStoreReader.open(beanStore);
            logger.info("Restoring " + beanType + " from " + beanStoreSource.getSourceURL());
            bean = beanStoreReader.read(beanType);
        }
        catch (BeanStoreException e) {
            logger.warning("restoreAllFromXML: Error while reading: " + e.getMessage());
        }
        finally {
            try {
                if (beanStoreReader != null) {
                    beanStoreReader.close();
                }
            }
            catch (BeanStoreException e) {
                logger.warning("restoreAllFromXML: Error while closing: " + e.getMessage());
            }
            try {
                if (beanStore != null) {
                    beanStore.close();
                }
            }
            catch (BeanStoreException e) {
                logger.warning("restoreAllFromXML: Error while closing: " + e.getMessage());
            }
        }
        return bean;
    }

    public static <B> B restoreFromXML(XmlBeanStoreFormat defaultFormat, File beanStoreFile, String beanStoreName, Class<B> beanType) {
        B bean = null;
        try {
            BeanStoreFileSource source = new BeanStoreFileSource(beanStoreName, beanStoreFile, defaultFormat);
            bean = BeanStoreUtils.restoreFromXML(source, beanType);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "restoreFromXML: Error while restoring: {0},", e);
        }
        return bean;
    }

    public static <B> B restoreFromXML(XmlBeanStoreFormat defaultFormat, File beanStoreFile, Class<B> beanType) {
        return BeanStoreUtils.restoreFromXML(defaultFormat, beanStoreFile, null, beanType);
    }

    public static <B> B restoreFromXML(File beanStoreFile, Class<B> beanType) {
        return BeanStoreUtils.restoreFromXML(XmlBeanStoreFormat.DEFAULT, beanStoreFile, beanType);
    }

    public static <B> B restoreFromXML(File beanStoreFile, String beanStoreName, Class<B> beanType) {
        return BeanStoreUtils.restoreFromXML(XmlBeanStoreFormat.DEFAULT, beanStoreFile, beanStoreName, beanType);
    }

    public static <B> B restoreFromXML(URL beanStoreURL, Class<B> beanType) {
        return BeanStoreUtils.restoreFromXML(beanStoreURL, null, beanType);
    }

    public static void storeAsProperties(Properties properties, Object ... beans) {
        BeanStoreUtils.storeAsProperties(properties, true, beans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeAsProperties(Properties properties, boolean secure, Object ... beans) {
        PropertiesBeanStore beanStore = new PropertiesBeanStore(properties);
        beanStore.setSecure(secure);
        PropertiesBeanStoreWriter beanStoreWriter = null;
        try {
            beanStoreWriter = beanStore.newBeanStoreWriter();
            for (Object bean : beans) {
                beanStoreWriter.write(bean);
            }
        }
        catch (BeanStoreException e) {
            logger.warning("storeAsProperties: Error while writing: " + e.getMessage());
        }
        finally {
            try {
                if (beanStoreWriter != null) {
                    ((BeanStoreWriter)beanStoreWriter).close();
                }
            }
            catch (BeanStoreException e) {
                logger.warning("storeAsProperties: Error while closing: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <B> B restoreFromProperties(Properties properties, Class<B> beanType) {
        B bean = null;
        PropertiesBeanStore beanStore = new PropertiesBeanStore(properties);
        PropertiesBeanStoreReader beanStoreReader = null;
        try {
            beanStoreReader = beanStore.newBeanStoreReader();
            bean = beanStoreReader.read(beanType);
        }
        catch (BeanStoreException e) {
            logger.warning("restoreFromProperties: Error while reading: " + e.getMessage());
        }
        finally {
            if (beanStoreReader != null) {
                try {
                    beanStoreReader.close();
                }
                catch (BeanStoreException e) {
                    logger.warning("restoreFromProperties: Error while closing: " + e.getMessage());
                }
            }
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<?> restoreAllFromProperties(Properties properties, Class<?> ... beanTypes) {
        ArrayList beans = new ArrayList();
        PropertiesBeanStore beanStore = new PropertiesBeanStore(properties);
        PropertiesBeanStoreReader beanStoreReader = null;
        try {
            beanStoreReader = beanStore.newBeanStoreReader();
            for (Class<?> beanType : beanTypes) {
                Object bean = beanStoreReader.read(beanType);
                if (bean == null) continue;
                beans.add(bean);
            }
        }
        catch (BeanStoreException e) {
            logger.warning("restoreAllFromProperties: Error while reading: " + e.getMessage());
        }
        finally {
            if (beanStoreReader != null) {
                try {
                    beanStoreReader.close();
                }
                catch (BeanStoreException e) {
                    logger.warning("restoreAllFromProperties: Error while closing: " + e.getMessage());
                }
            }
        }
        return beans;
    }

    public static void store(String beanStoreName, File beanStoreFile, Object ... beans) throws BeanStoreException {
        BeanStoreUtils.storeAsXML(beanStoreFile, beanStoreName, true, beans);
    }

    public static XmlBeanStore createXmlBeanStore(PropertyFileFormat format, Properties source) throws BeanStoreException {
        XmlBeanStore beanStore = new XmlBeanStore(new XmlBeanStoreSource(format));
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(buffer);
            for (Map.Entry<Object, Object> e : source.entrySet()) {
                writer.printf("%s=%s\n", e.getKey(), e.getValue());
            }
            writer.close();
            beanStore.load(new ByteArrayInputStream(buffer.toByteArray()));
        }
        catch (Exception e) {
            throw new BeanStoreException(e);
        }
        return beanStore;
    }

    public static void printBeans(PrintStream out, Object ... beans) throws BeanStoreException {
        BeanStoreUtils.printBeans(true, out, beans);
    }

    public static void printBeans(boolean secure, PrintStream out, Object ... beans) throws BeanStoreException {
        Content content = BeanStoreUtils.createBeanGridContent(secure, null, null, beans);
        out.println(content.getContent());
    }

    public static Content createBeanGridContent(Object ... beans) throws BeanStoreException {
        return BeanStoreUtils.createBeanGridContent(true, null, null, beans);
    }

    public static Content createBeanGridContent(boolean secure, Map<String, Object> propertyMap, Set<String> securePropertySet, Object ... beans) throws BeanStoreException {
        TreeMap<String, Object> buffer = new TreeMap<String, Object>();
        TreeSet<String> secureProps = new TreeSet<String>();
        if (secure) {
            secureProps.addAll(BeanStoreUtils.getSecurePropertySet(beans));
        }
        if (securePropertySet != null) {
            secureProps.addAll(securePropertySet);
        }
        BeanStoreUtils.storeAsStringMap(buffer, beans);
        if (propertyMap != null) {
            buffer.putAll(propertyMap);
        }
        FixedGridContent content = new FixedGridContent("PROPERTY", "VALUE");
        content.setMaxWidth(100);
        content.setWrappable(1, true);
        for (Map.Entry<String, Object> entry : buffer.entrySet()) {
            Object value;
            String key = entry.getKey();
            String valueString = null;
            valueString = secure && secureProps.contains(key) ? SECURE_PROPERTY_MASK : ((value = entry.getValue()) != null ? (value.getClass().isArray() ? Arrays.deepToString((String[])value) : value.toString()) : "-n/a-");
            content.addRow(key, valueString);
        }
        return content;
    }
}

