/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job.view;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import oracle.install.commons.base.util.job.bean.VariableSettings;

public class JobVariablesTableModel
extends AbstractTableModel {
    public static final int VARIABLE_NAME_COLUMN = 0;
    public static final int VARIABLE_VALUE_COLUMN = 1;
    public static final int VARIABLE_PASSWORD_COLUMN = 2;
    public static final int VARIABLE_PROMPT_STRING_COLUMN = 3;
    public static final int VARIABLE_VALUE_EXPECTED_COLUMN = 4;
    public static final int VARIABLE_OPTIONAL_COLUMN = 5;
    private List<VariableSettings> variables = new ArrayList<VariableSettings>();
    private String[] columnNames;
    private boolean canEdit;
    private static final Logger logger = Logger.getLogger(JobVariablesTableModel.class.getName());

    public JobVariablesTableModel(boolean canEdit) {
        this.canEdit = canEdit;
        this.columnNames = new String[6];
        if (this.canEdit) {
            this.variables.add(new VariableSettings());
        }
    }

    @Override
    public int getRowCount() {
        return this.variables.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.canEdit;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue != null) {
            VariableSettings var;
            if (columnIndex == 0 && aValue != null && !aValue.toString().trim().equals("")) {
                var = this.variables.get(rowIndex);
                var.setName(aValue.toString());
                this.cellEditing(rowIndex, columnIndex);
            } else if (rowIndex != this.variables.size() - 1 && columnIndex == 0 && (aValue == null || aValue.toString().trim().equals(""))) {
                this.variables.remove(rowIndex);
            }
            if (columnIndex == 1) {
                var = this.variables.get(rowIndex);
                var.setValue(aValue.toString());
            }
            if (columnIndex == 2) {
                var = this.variables.get(rowIndex);
                var.setValue(aValue.toString());
            }
            if (columnIndex == 3) {
                var = this.variables.get(rowIndex);
                var.setPromptString(aValue.toString());
            }
            if (columnIndex == 4) {
                var = this.variables.get(rowIndex);
                var.setValueExpected(Boolean.valueOf(aValue.toString()));
            }
            if (columnIndex == 5) {
                var = this.variables.get(rowIndex);
                var.setOptional(Boolean.valueOf(aValue.toString()));
            }
            this.fireTableDataChanged();
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object value = null;
        if (this.variables.size() > rowIndex) {
            switch (columnIndex) {
                case 0: {
                    value = this.variables.get(rowIndex).getName();
                    break;
                }
                case 1: {
                    value = this.variables.get(rowIndex).getValue();
                    break;
                }
                case 2: {
                    value = this.variables.get(rowIndex).getValue();
                    break;
                }
                case 3: {
                    value = this.variables.get(rowIndex).getPromptString();
                    break;
                }
                case 4: {
                    value = this.variables.get(rowIndex).isValueExpected();
                    break;
                }
                case 5: {
                    value = this.variables.get(rowIndex).isOptional();
                }
            }
        }
        return value;
    }

    public void setVariables(List<VariableSettings> variables) {
        if (variables != null) {
            this.variables = variables;
            if (this.canEdit) {
                VariableSettings newVariable = new VariableSettings();
                newVariable.setName("");
                newVariable.setValue("");
                this.variables.add(newVariable);
            }
            this.fireTableDataChanged();
        } else {
            logger.log(Level.INFO, "Empty paths object is specified");
        }
    }

    public List<VariableSettings> getVariables() {
        return this.variables;
    }

    public void cellEditing(int row, int col) {
        if (row > this.variables.size() - 1) {
            return;
        }
        if (row == this.variables.size() - 1) {
            if (col == 0) {
                VariableSettings variable = new VariableSettings();
                variable.setName("");
                variable.setValue("");
                this.variables.add(variable);
            }
        } else {
            for (int i = 0; i < this.variables.size() - 1; ++i) {
                VariableSettings var = this.variables.get(i);
                if (!var.getName().equals("")) continue;
                this.variables.remove(i);
            }
        }
        this.fireTableDataChanged();
    }
}

