/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job.view;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import oracle.install.commons.base.util.job.JobApplicationConstants;
import oracle.install.commons.base.util.job.bean.JobSettings;
import oracle.install.commons.base.util.job.view.JobArgsPane;
import oracle.install.commons.base.util.job.view.JobInfoPane;
import oracle.install.commons.base.util.job.view.JobPropertiesPane;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;

public class JobDetailsDialog
extends JDialog {
    private JobSettings jobSettings;
    private boolean canEdit;
    private JobInfoPane jobInfoPane;
    private JobArgsPane jobArgsPane;
    private JobPropertiesPane jobPropPane;
    private JButton btnSave;
    private JButton btnClose;
    private String jobInfoTabTitle;
    private String jobArgsTabTitle;
    private String jobPropTabTitle;
    Resource resource = Application.getInstance().getResource("oracle.install.commons.base.util.job.resource.JobApplicationDialogResID");

    public JobDetailsDialog(Frame parent, JobSettings jobSettings, String title, boolean canEdit) {
        super(parent, title);
        this.init(parent, jobSettings, canEdit);
    }

    public JobDetailsDialog(Dialog parent, JobSettings jobSettings, String title, boolean canEdit) {
        super(parent, title);
        this.init(parent, jobSettings, canEdit);
    }

    private void init(Window parent, JobSettings jobSettings, boolean canEdit) {
        this.jobSettings = jobSettings;
        this.canEdit = canEdit;
        this.setModal(true);
        this.setSize(JobApplicationConstants.JOB_DETAILS_DAILOG_SIZE);
        if (parent != null) {
            Point location = parent.getLocation();
            Dimension parentSize = parent.getSize();
            Dimension size = this.getSize();
            location.x += parentSize.width / 2 - size.width / 2;
            location.y += parentSize.height / 2 - size.height / 2;
            this.setLocation(location);
        }
        this.buildUI();
    }

    private void buildUI() {
        JTabbedPane tabbedPane = new JTabbedPane();
        this.jobInfoPane = new JobInfoPane(this.canEdit);
        this.jobArgsPane = new JobArgsPane(this.canEdit);
        this.jobPropPane = new JobPropertiesPane(this.canEdit);
        this.jobInfoTabTitle = this.resource.getString("jobInfoPane.title.text", "Job info*", new Object[0]);
        this.jobArgsTabTitle = this.resource.getString("jobArgsPane.title.text", "Arguments*", new Object[0]);
        this.jobPropTabTitle = this.resource.getString("JobPropertiesPane.title.text", "Properties*", new Object[0]);
        SwingUtils.addTab(tabbedPane, this.jobInfoTabTitle, this.jobInfoPane);
        SwingUtils.addTab(tabbedPane, this.jobArgsTabTitle, this.jobArgsPane);
        SwingUtils.addTab(tabbedPane, this.jobPropTabTitle, this.jobPropPane);
        this.btnClose = new JButton();
        this.btnSave = new JButton();
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent(tabbedPane, this, 0, 0, 3, 1, 1, 18, 1.0, 1.0);
        LayoutUtils.addComponent(Box.createGlue(), this, 0, 1, 1, 1, 2, 18, 1.0, 0.0);
        LayoutUtils.addComponent(this.btnSave, this, 1, 1, 1, 1, 13, 18, 0.0, 0.0);
        LayoutUtils.addComponent(this.btnClose, this, 2, 1, 1, 1, 13, 18, 0.0, 0.0);
        this.localize();
        this.jobInfoPane.setJobInfo(this.jobSettings);
        this.jobArgsPane.setJobArgsInfo(this.jobSettings);
        this.jobPropPane.setJobPropsInfo(this.jobSettings);
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JobDetailsDialog.this.jobSettings = null;
                JobDetailsDialog.this.dispose();
            }
        });
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JobDetailsDialog.this.jobInfoPane.saveJobInfo(JobDetailsDialog.this.jobSettings);
                JobDetailsDialog.this.jobArgsPane.saveJobDetails(JobDetailsDialog.this.jobSettings);
                JobDetailsDialog.this.jobPropPane.saveJobDetails(JobDetailsDialog.this.jobSettings);
                JobDetailsDialog.this.dispose();
            }
        });
        this.btnSave.setVisible(this.canEdit);
    }

    public JobSettings getJob() {
        return this.jobSettings;
    }

    public void localize() {
        String text = this.resource.getString("JobDetailsDialog.btnSave", "Save*", new Object[0]);
        SwingUtils.setText(this.btnSave, text);
        text = this.resource.getString("JobDetailsDialog.btnClose", "Close*", new Object[0]);
        SwingUtils.setText(this.btnClose, text);
    }
}

