/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job.view;

import java.awt.CardLayout;
import java.awt.Component;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.JPanel;
import oracle.install.commons.base.util.job.JobApplicationEvent;
import oracle.install.commons.base.util.job.JobApplicationListener;
import oracle.install.commons.base.util.job.JobApplicationLogHandler;
import oracle.install.commons.base.util.job.bean.JobContext;
import oracle.install.commons.base.util.job.bean.JobsOperationType;
import oracle.install.commons.base.util.job.view.FinishPane;
import oracle.install.commons.base.util.job.view.JobApplicationDetailsPane;
import oracle.install.commons.base.util.job.view.JobApplicationFrame;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.ProgressPane;
import oracle.install.commons.util.progress.Status;

public class JobApplicationPane
extends JPanel
implements JobApplicationListener {
    private static final Logger logger = Logger.getLogger(JobApplicationPane.class.getName());
    private JobApplicationDetailsPane interviewCard;
    private ProgressPane progressCard;
    private FinishPane resultCard;
    private CardLayout cardLayout;
    private Resource resource;
    private JobApplicationFrame.ViewMode viewMode;

    public JobApplicationPane() {
        Application application = Application.getInstance();
        this.resource = application.getResource("oracle.install.commons.base.util.job.resource.JobApplicationDialogResID");
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        this.interviewCard = new JobApplicationDetailsPane();
        this.progressCard = new ProgressPane();
        this.resultCard = new FinishPane();
        this.add((Component)this.interviewCard, "interview");
        this.add((Component)this.progressCard, "progress");
        this.add((Component)this.resultCard, "result");
        this.setViewMode(JobApplicationFrame.ViewMode.INTERVIEW_MODE);
    }

    private void setViewMode(JobApplicationFrame.ViewMode viewMode) {
        if (this.viewMode == viewMode) {
            return;
        }
        this.viewMode = viewMode;
        switch (viewMode) {
            case INTERVIEW_MODE: {
                this.cardLayout.show(this, "interview");
                this.firePropertyChange("jobApplicationPane.showing.interviewcard", true, false);
                break;
            }
            case PROGRESS_MODE: {
                this.cardLayout.show(this, "progress");
                this.firePropertyChange("jobApplicationPane.showing.progresscard", true, false);
                break;
            }
            case RESULT_MODE: {
                this.cardLayout.show(this, "result");
                this.firePropertyChange("jobApplicationPane.showing.resultcard", true, false);
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.interviewCard.disposeDetailsDialog();
    }

    @Override
    public void update(final JobApplicationEvent e) {
        JobApplicationEvent.Type type = (JobApplicationEvent.Type)e.getType();
        final JobContext jobContext = e.getJobContext();
        switch (type) {
            case JOBS_XML_LOAD_STARTED: {
                Application.showStatus(this.resource.getString("JobApplicationPane.jobsxmlload.started", "Loading jobs xml...", new Object[0]));
                break;
            }
            case JOBS_XML_LOADED: {
                SwingUtils.invokeTask(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        JobApplicationPane.this.interviewCard.updateJobApplicationDetails(jobContext);
                        JobApplicationPane.this.showInterview();
                        return null;
                    }
                });
                Application.hideStatus();
                break;
            }
            case VARIABLES_LOAD_STARTED: {
                Application.showStatus(this.resource.getString("prereqCheckerPane.jobsvariableload.started", "Loading jobs variables...", new Object[0]));
                break;
            }
            case VARIABLES_LOADED: {
                SwingUtils.invokeTask(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        JobApplicationPane.this.interviewCard.updateJobApplicationDetails(jobContext);
                        return null;
                    }
                });
                Application.hideStatus();
                break;
            }
            case CHECKPOINT_STARTED: {
                Application.showStatus(this.resource.getString("prereqCheckerPane.checkpoint.started", "Checkpointing current status...", new Object[0]));
                break;
            }
            case CHECKPOINT_COMPLETED: {
                Application.hideStatus();
                break;
            }
            case JOBS_EXECUTION_STARTED: {
                SwingUtils.invokeTask(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        CompositeJob compositeJob = new CompositeJob();
                        compositeJob.setJobs(jobContext.getRuntimeJobs().toArray(new Job[0]));
                        JobApplicationPane.this.progressCard.setCompositeJobs(compositeJob);
                        JobApplicationPane.this.showProgress();
                        return null;
                    }
                });
                break;
            }
            case JOBS_XML_GENERATED: {
                SwingUtils.invokeTask(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Object[] args = e.getArgs();
                        if (args != null && args.length >= 2) {
                            String xmlFile = (String)args[0];
                            boolean status = (Boolean)args[1];
                            if (status) {
                                JobApplicationPane.this.setResultMessage(JobApplicationPane.this.resource.getString("JobApplication.xmlgeneration.success.message", "Successfully created job xml at location:{0}", xmlFile));
                            } else {
                                JobApplicationPane.this.setResultMessage(JobApplicationPane.this.resource.getString("JobApplication.xmlgeneration.failure.message", "Failed to create job xml at location:{0}. Refer log file: {1} for more information.", xmlFile, JobApplicationLogHandler.getLogFile()));
                            }
                        }
                        JobApplicationPane.this.showResults();
                        JobApplicationPane.this.firePropertyChange("jobApplicationPane.jobs.execution.completed", false, true);
                        return null;
                    }
                });
                break;
            }
            case JOBS_EXECUTION_COMPLETED: {
                SwingUtils.invokeTask(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        boolean status = true;
                        for (Job job : jobContext.getRuntimeJobs()) {
                            Status jobStatus = job.getStatus();
                            if (jobStatus == Status.SUCCEEDED || jobStatus == Status.SUCCEEDED_PARTIALLY) continue;
                            status = false;
                            break;
                        }
                        if (status) {
                            JobApplicationPane.this.setResultMessage(JobApplicationPane.this.resource.getString("JobApplication.jobexecution.success.message", "Successfully executed jobs", new Object[0]));
                            JobApplicationPane.this.showResults();
                        }
                        JobApplicationPane.this.firePropertyChange("jobApplicationPane.jobs.execution.completed", false, true);
                        return null;
                    }
                });
                break;
            }
        }
    }

    public void showProgress() {
        this.setViewMode(JobApplicationFrame.ViewMode.PROGRESS_MODE);
    }

    public void showResults() {
        this.setViewMode(JobApplicationFrame.ViewMode.RESULT_MODE);
    }

    public void showInterview() {
        this.setViewMode(JobApplicationFrame.ViewMode.INTERVIEW_MODE);
    }

    public void setResultMessage(String text) {
        this.resultCard.setStatusMessage(text);
    }

    public JobContext getJobContext() {
        return this.interviewCard.getJobContext();
    }

    public JobsOperationType getSelectionOperationType() {
        return this.interviewCard.getSelectedOperationType();
    }

    public String geXMLFileLocation() {
        return this.interviewCard.geXMLFileLocation();
    }
}

