/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job.view;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import oracle.install.commons.base.util.job.bean.JobSettings;

public class ChildJobsTableModel
extends AbstractTableModel {
    public static final int JOB_NAME_COLUMN = 0;
    private List<JobSettings> childJobs = new ArrayList<JobSettings>();
    private String[] columnNames;
    private boolean canEdit;
    private static final Logger logger = Logger.getLogger(ChildJobsTableModel.class.getName());

    public ChildJobsTableModel(boolean canEdit) {
        this.canEdit = canEdit;
        this.columnNames = new String[1];
    }

    @Override
    public int getRowCount() {
        return this.childJobs.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.canEdit;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue != null) {
            if (columnIndex == 0 && aValue != null && !aValue.toString().trim().equals("")) {
                JobSettings job = this.childJobs.get(rowIndex);
                String jobId = aValue.toString();
                job.setId(jobId.replace(" ", "_"));
                this.cellEditing(rowIndex, columnIndex);
            } else if (rowIndex != this.childJobs.size() - 1 && columnIndex == 0 && (aValue == null || aValue.toString().trim().equals(""))) {
                this.childJobs.remove(rowIndex);
            }
            this.fireTableDataChanged();
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String value = null;
        if (this.childJobs.size() > rowIndex) {
            switch (columnIndex) {
                case 0: {
                    value = this.childJobs.get(rowIndex).getId();
                }
            }
        }
        return value;
    }

    public void setChildJobs(List<JobSettings> jobs) {
        if (jobs != null) {
            this.childJobs = jobs;
            if (this.canEdit) {
                JobSettings newJob = new JobSettings();
                newJob.setId("");
                this.childJobs.add(newJob);
            }
            this.fireTableDataChanged();
        } else {
            logger.log(Level.INFO, "Empty paths object is specified");
        }
    }

    public List<JobSettings> getChildJobs() {
        ArrayList<JobSettings> jobsList = new ArrayList<JobSettings>();
        if (this.childJobs != null) {
            for (JobSettings job : this.childJobs) {
                if (job.getId() != null && !job.getId().trim().isEmpty()) {
                    jobsList.add(job);
                    continue;
                }
                logger.log(Level.WARNING, "Child job id is null or empty. So not adding in to the child jobs list");
            }
        }
        return jobsList;
    }

    public void cellEditing(int row, int col) {
        if (row > this.childJobs.size() - 1) {
            return;
        }
        if (row == this.childJobs.size() - 1) {
            if (col == 0) {
                JobSettings newJob = new JobSettings();
                newJob.setId("");
                this.childJobs.add(newJob);
            }
        } else {
            for (int i = 0; i < this.childJobs.size() - 1; ++i) {
                JobSettings var = this.childJobs.get(i);
                if (!var.getId().equals("")) continue;
                this.childJobs.remove(i);
            }
        }
        this.fireTableDataChanged();
    }
}

