/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job.engine;

import oracle.install.commons.base.util.job.JobApplicationException;
import oracle.install.commons.base.util.job.engine.CommandExecutor;
import oracle.install.commons.base.util.job.engine.PerlExecutor;
import oracle.install.commons.base.util.job.engine.SQLExecutor;
import oracle.install.commons.base.util.job.resource.JobErrorCode;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.exception.ErrorCode;

public class ExecutionEngineFactory {
    private static ExecutionEngineFactory instance;

    public static ExecutionEngineFactory getInstance() {
        if (instance == null) {
            instance = new ExecutionEngineFactory();
        }
        return instance;
    }

    public SQLExecutor getSQLScriptExecutor() throws JobApplicationException {
        SQLExecutor instance = null;
        ProxyFactory proxyFactory = ProxyFactory.getInstance();
        instance = proxyFactory.createProxy(SQLExecutor.class);
        if (instance == null) {
            try {
                Class<?> sqlExecutorClass = Class.forName("oracle.install.driver.util.engine.SQLExecutionEngine");
                instance = (SQLExecutor)sqlExecutorClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_CREATE_SQL_EXECUTOR_OBJ_ERR, new Object[0]);
            }
            catch (InstantiationException e) {
                throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_CREATE_SQL_EXECUTOR_OBJ_ERR, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_CREATE_SQL_EXECUTOR_OBJ_ERR, new Object[0]);
            }
        }
        return instance;
    }

    public CommandExecutor getCommandExecutor() throws JobApplicationException {
        CommandExecutor instance = null;
        ProxyFactory proxyFactory = ProxyFactory.getInstance();
        instance = proxyFactory.createProxy(CommandExecutor.class);
        if (instance == null) {
            try {
                Class<?> sqlExecutorClass = Class.forName("oracle.install.driver.util.engine.CommandExecutionEngine");
                instance = (CommandExecutor)sqlExecutorClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_CREATE_COMMAND_EXECUTOR_OBJ_ERR, new Object[0]);
            }
            catch (InstantiationException e) {
                throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_CREATE_COMMAND_EXECUTOR_OBJ_ERR, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_CREATE_COMMAND_EXECUTOR_OBJ_ERR, new Object[0]);
            }
        }
        return instance;
    }

    public PerlExecutor getPerlScriptExecutor() throws JobApplicationException {
        PerlExecutor instance = null;
        ProxyFactory proxyFactory = ProxyFactory.getInstance();
        instance = proxyFactory.createProxy(PerlExecutor.class);
        if (instance == null) {
            try {
                Class<?> sqlExecutorClass = Class.forName("oracle.install.driver.util.engine.PerlExecutionEngine");
                instance = (PerlExecutor)sqlExecutorClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_CREATE_PERL_EXECUTOR_OBJ_ERR, new Object[0]);
            }
            catch (InstantiationException e) {
                throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_CREATE_PERL_EXECUTOR_OBJ_ERR, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new JobApplicationException((Throwable)e, (ErrorCode)JobErrorCode.UNABLE_TO_CREATE_PERL_EXECUTOR_OBJ_ERR, new Object[0]);
            }
        }
        return instance;
    }
}

