/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.job.CommandExecutionJob;
import oracle.install.commons.base.util.job.DataDrivenJob;
import oracle.install.commons.base.util.job.JobApplicationException;
import oracle.install.commons.base.util.job.bean.JobContext;
import oracle.install.commons.base.util.job.bean.JobSettings;
import oracle.install.commons.base.util.job.engine.ExecutionEngineFactory;
import oracle.install.commons.base.util.job.engine.SQLExecutor;
import oracle.install.commons.base.util.job.resource.JobErrorCode;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.progress.Retriable;
import oracle.install.commons.util.progress.Status;

public class SQLExecutionJob
extends DataDrivenJob
implements Callable<Boolean>,
Retriable<SQLExecutionJob> {
    private static final Logger logger = Logger.getLogger(CommandExecutionJob.class.getName());

    public SQLExecutionJob(JobContext jobContext, JobSettings jobSettings, String description) {
        super(jobContext, jobSettings, description);
        this.setRetryEnabled(true);
        this.setRetriable(this);
    }

    @Override
    public Callable<?> getWork() {
        return this;
    }

    @Override
    public List getRetriableJobs() {
        ArrayList<SQLExecutionJob> retriableJobs = new ArrayList<SQLExecutionJob>();
        Status status = this.getStatus();
        if (this.isRetryEnabled() && (status == Status.PENDING || status == Status.FAILED)) {
            retriableJobs.add(this);
        }
        return retriableJobs;
    }

    @Override
    public void retry() throws Exception {
        this.call();
    }

    @Override
    public Boolean call() throws Exception {
        this.setStatus(Status.INPROGRESS);
        JobSettings jobSettings = this.getJobSettings();
        try {
            SQLExecutor sqlExecutor = ExecutionEngineFactory.getInstance().getSQLScriptExecutor();
            if (sqlExecutor == null) {
                logger.log(Level.WARNING, "SQL executor object is null");
                throw new JobApplicationException((ErrorCode)JobErrorCode.UNABLE_TO_CREATE_SQL_EXECUTOR_OBJ_ERR, new Object[0]);
            }
            int exitCode = sqlExecutor.execute(this.getJobContext(), jobSettings);
            jobSettings.setExitCode(exitCode);
        }
        catch (Throwable e) {
            ExceptionManager.advise(new ValidationStatusMessage(e));
            jobSettings.setExitCode(-1);
        }
        if (jobSettings.getExitCode() == 0) {
            this.setStatus(Status.SUCCEEDED);
        } else if (jobSettings.getExitCode() > 0) {
            this.setStatus(Status.SUCCEEDED_PARTIALLY);
        } else {
            this.setStatus(Status.FAILED);
            return false;
        }
        return true;
    }
}

