/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import oracle.install.commons.flow.validation.UncheckedValidationException;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ApplicationEvent;
import oracle.install.commons.util.ApplicationListener;

public class JobApplicationLogHandler
extends Handler {
    private static File logFile;
    private static File loggingDir;
    private static String logFileName;
    private static PrintWriter logWriter;

    public JobApplicationLogHandler() {
        Application.getInstance().addApplicationListener(new ApplicationListener(){

            @Override
            public void update(ApplicationEvent e) {
                if (e.getType() == ApplicationEvent.Type.SHUTDOWN && logWriter != null) {
                    logWriter.flush();
                    logWriter.close();
                }
            }
        });
    }

    @Override
    public void close() throws SecurityException {
        if (logWriter != null) {
            logWriter.close();
            logWriter = null;
        }
    }

    @Override
    public void flush() {
        if (logWriter != null) {
            logWriter.flush();
        }
    }

    public static File getLogFile() {
        return logFile;
    }

    public static String getLogFileName() {
        return logFileName;
    }

    public static File getLoggingDir() {
        return loggingDir;
    }

    public static void setLogFileName(String logName) {
        logFileName = logName;
        if (logFileName != null) {
            try {
                if (logWriter != null) {
                    logWriter.close();
                }
                if ((loggingDir = (logFile = new File(logFileName)).getParentFile()) != null && !loggingDir.exists()) {
                    loggingDir.mkdirs();
                }
                logWriter = new PrintWriter(new BufferedWriter(new FileWriter(logFile, true)));
            }
            catch (IOException e) {
                System.err.println("Exception during setting LogFileName" + e);
            }
        }
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (super.isLoggable(record)) {
            Throwable throwable;
            String message = new SimpleFormatter().format(record);
            Level level = record.getLevel();
            if (logWriter != null) {
                logWriter.printf("%s: %s\n", level.getName(), message);
                this.flush();
            }
            if ((throwable = record.getThrown()) != null && !(throwable instanceof ValidationException) && !(throwable instanceof UncheckedValidationException)) {
                try {
                    StringWriter buffer = new StringWriter();
                    PrintWriter out = new PrintWriter(buffer);
                    throwable.printStackTrace(out);
                    out.close();
                    String stacktraceId = String.format("%s:%s", record.getLoggerName(), record.getSequenceNumber());
                    String stackTrace = String.format("---# Begin Stacktrace #---------------------------\nID: %s\n%s\n---# End Stacktrace #-----------------------------\n", stacktraceId, buffer.toString());
                    if (logWriter != null) {
                        logWriter.printf("\nRefer associated stacktrace #%s\n%s", stacktraceId, stackTrace);
                        this.flush();
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
        }
    }
}

