/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.util.job;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.cli.CommandLineArgumentHandler;
import oracle.install.commons.base.util.job.JobAppProgressMonitor;
import oracle.install.commons.base.util.job.JobApplicationConstants;
import oracle.install.commons.base.util.job.JobApplicationEvent;
import oracle.install.commons.base.util.job.JobApplicationException;
import oracle.install.commons.base.util.job.JobApplicationHandler;
import oracle.install.commons.base.util.job.JobApplicationListener;
import oracle.install.commons.base.util.job.JobApplicationLogHandler;
import oracle.install.commons.base.util.job.resource.JobErrorCode;
import oracle.install.commons.base.util.job.view.JobApplicationFrame;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.EventSupport;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;

public class JobApplication {
    private static JobApplication instance;
    private static final Logger logger;
    private EventSupport<JobApplicationEvent> eventSupport = new EventSupport();
    private Date sessoinTime = new Date();
    private JobApplicationHandler jobApplicationHandler = JobApplicationHandler.getInstance();

    public static JobApplication getInstance() {
        if (instance == null) {
            instance = new JobApplication();
        }
        return instance;
    }

    private JobApplication() {
        CommandLineArgumentHandler.registerSupportedCommandtArgsXML("/oracle/install/commons/base/util/job/resource/jobapplication_commandline_arguments.xml");
        System.setProperty("application.commandline.showCompleteHelpByDefault", "true");
    }

    public boolean executeJobs(URL jobsXML, Properties properties, String checkPointDir, boolean reconcile, Date checkPointSessionTime) throws JobApplicationException {
        this.sessoinTime = checkPointSessionTime;
        return this.jobApplicationHandler.executeJobs(jobsXML, properties, checkPointDir, reconcile);
    }

    public boolean executeJobs(File jobsXML, Properties properties, String checkPointDir, boolean reconcile, Date checkPointSessionTime) throws JobApplicationException {
        this.sessoinTime = checkPointSessionTime;
        return this.jobApplicationHandler.executeJobs(jobsXML, properties, checkPointDir, reconcile);
    }

    public void addJobApplicationListener(JobApplicationListener listener) {
        this.eventSupport.addEventListener(listener);
    }

    public void removeJobApplicationListener(JobApplicationListener listener) {
        this.eventSupport.removeEventListener(listener);
    }

    public void fireJobApplicationEvent(JobApplicationEvent e) {
        this.eventSupport.fireEvent(e);
    }

    protected void startup(List<String> args) {
        try {
            this.processArgs(args);
            if (CommandLineArgumentHandler.getInstance().isArgumentPassed("help")) {
                this.showUsage(args);
                return;
            }
            this.setupApplicationProperties();
            Properties properties = this.loadPorperties(args);
            this.execute(properties);
        }
        catch (JobApplicationException e) {
            ExceptionManager.handle(e);
        }
        catch (MalformedURLException e) {
            ExceptionManager.handle(e);
        }
    }

    private void execute(Properties properties) throws JobApplicationException, MalformedURLException {
        URL jobsXMLUrl = null;
        String jobAppFile = properties.getProperty("jobsDefFile");
        if (jobAppFile != null && !jobAppFile.isEmpty() && (jobsXMLUrl = JobApplication.class.getResource(jobAppFile)) == null) {
            jobsXMLUrl = new File(jobAppFile).toURI().toURL();
        }
        boolean reconcile = CommandLineArgumentHandler.getInstance().isArgumentPassed("resume");
        if (CommandLineArgumentHandler.getInstance().isArgumentPassed("silent")) {
            this.addJobApplicationListener(JobAppProgressMonitor.getInstance());
            if (jobsXMLUrl == null && !reconcile) {
                ExceptionManager.handle(new JobApplicationException((ErrorCode)JobErrorCode.JOB_DEFINITION_XML_NOT_SPECIFIED_ERR, new Object[0]));
            } else {
                this.executeJobs(jobsXMLUrl, properties, CommandLineArgumentHandler.getInstance().getArgumentValue("logDir"), reconcile, this.sessoinTime);
            }
        } else {
            JobApplicationFrame frame = new JobApplicationFrame(Application.getInstance().getResource("oracle.install.commons.base.util.job.resource.JobApplicationDialogResID").getString("JobApplicationFrame.bannerText.name", "Job Application Framework", new Object[0]));
            frame.setVisible(true);
            frame.setLocationRelativeTo(null);
            if (jobsXMLUrl != null || reconcile) {
                this.jobApplicationHandler.load(jobsXMLUrl, properties, CommandLineArgumentHandler.getInstance().getArgumentValue("logDir"), reconcile);
            }
        }
    }

    public Date getSessionTime() {
        return this.sessoinTime;
    }

    private void showUsage(List<String> args) {
        CommandLineArgumentHandler.getInstance().showHelp(args);
    }

    private void processArgs(List<String> args) {
        CommandLineArgumentHandler.getInstance().processCommandLineArguments(args);
    }

    private void setupApplicationProperties() {
        Application application = Application.getInstance();
        if (application.getClass().equals(Application.class)) {
            try {
                String logDir;
                application.startup(JobApplicationConstants.JOB_APPLICATION_CONFIG_XML, new String[0]);
                if (CommandLineArgumentHandler.getInstance().isArgumentPassed("silent")) {
                    application.setUIType(UIType.NONE);
                }
                if ((logDir = CommandLineArgumentHandler.getInstance().getArgumentValue("logDir")) == null || logDir.isEmpty()) {
                    logDir = System.getProperty("java.io.tmpdir");
                }
                new JobApplicationLogHandler();
                JobApplicationLogHandler.setLogFileName(new File(logDir, "jobExecutionTool_" + JobApplicationConstants.TIME_STAMP_FORMATER.format(this.sessoinTime)).getPath());
            }
            catch (Exception e) {
                ExceptionManager.handle(new JobApplicationException((ErrorCode)JobErrorCode.JOB_APPLICATION_CONFIG_XML_LOAD_ERR, new Object[0]));
            }
        }
    }

    private Properties loadPorperties(List<String> args) throws JobApplicationException {
        Properties properties = new Properties();
        String jobxtHome = null;
        CommandLineArgumentHandler cmdHandler = CommandLineArgumentHandler.getInstance();
        if (!cmdHandler.isArgumentPassed("JOBXT_HOME")) {
            throw new JobApplicationException((ErrorCode)JobErrorCode.JOBXT_HOME_NOT_SPECIFIED_ERR, "JOBXT_HOME");
        }
        jobxtHome = cmdHandler.getArgumentValue("JOBXT_HOME");
        String jobAppName = null;
        if (cmdHandler.isArgumentPassed("jobApp")) {
            jobAppName = cmdHandler.getArgumentValue("jobApp");
        }
        File jobAppHomeDir = null;
        if (!cmdHandler.isArgumentPassed("JOB_APP_HOME")) {
            jobAppHomeDir = jobAppName != null && !jobAppName.isEmpty() ? new File(jobxtHome + File.separator + "plugins/jobApplications" + File.separator + jobAppName) : new File(jobxtHome);
            properties.put("JOB_APP_HOME", jobAppHomeDir.getPath());
        } else {
            jobAppHomeDir = new File(cmdHandler.getArgumentValue("JOB_APP_HOME"));
            properties.put("JOB_APP_HOME", cmdHandler.getArgumentValue("JOB_APP_HOME"));
        }
        if (!cmdHandler.isArgumentPassed("responseFile")) {
            File jobRspfile = null;
            if (jobAppName != null && !jobAppName.isEmpty()) {
                jobRspfile = new File(jobAppHomeDir, jobAppName + JobApplicationConstants.JOB_APPLICAITON_RESPONSE_FILE_EXTENSION);
            } else {
                String[] rspFiles = jobAppHomeDir.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        if (name != null) {
                            return name.endsWith(JobApplicationConstants.JOB_APPLICAITON_RESPONSE_FILE_EXTENSION);
                        }
                        return false;
                    }
                });
                if (rspFiles != null && rspFiles.length == 1) {
                    jobRspfile = new File(jobAppHomeDir, rspFiles[0]);
                }
            }
            if (jobRspfile != null && jobRspfile.exists()) {
                properties.put("responseFile", jobRspfile.getPath());
            }
        } else {
            properties.put("responseFile", cmdHandler.getArgumentValue("responseFile"));
        }
        if (!cmdHandler.isArgumentPassed("jobsDefFile")) {
            File jobAppFile = null;
            if (jobAppName != null && !jobAppName.isEmpty()) {
                jobAppFile = new File(jobAppHomeDir, jobAppName + JobApplicationConstants.JOB_APPLICAITON_FILE_EXTENSION);
            } else {
                String[] jobAppFiles = jobAppHomeDir.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        if (name != null) {
                            return name.endsWith(JobApplicationConstants.JOB_APPLICAITON_FILE_EXTENSION);
                        }
                        return false;
                    }
                });
                if (jobAppFiles != null && jobAppFiles.length == 1) {
                    jobAppFile = new File(jobAppHomeDir, jobAppFiles[0]);
                }
            }
            if (jobAppFile != null && jobAppFile.exists()) {
                properties.put("jobsDefFile", jobAppFile.getPath());
            }
        } else {
            properties.put("jobsDefFile", cmdHandler.getArgumentValue("jobsDefFile"));
        }
        if (properties.get("responseFile") != null) {
            String argsFile = properties.get("responseFile").toString();
            if (argsFile != null && !argsFile.isEmpty()) {
                File file = new File(argsFile);
                Properties propsFromVarFile = this.loadVariablesFile(file);
                if (propsFromVarFile != null) {
                    properties.putAll((Map<?, ?>)propsFromVarFile);
                }
            } else {
                logger.log(Level.WARNING, "Response file name is not specified");
            }
        }
        properties.putAll(CommandLineArgumentHandler.getInstance().getPassedArgumentsAsMap());
        return properties;
    }

    private Properties loadVariablesFile(File variablesFile) throws JobApplicationException {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(variablesFile));
            Properties properties = new Properties();
            String line = null;
            if (reader != null) {
                while ((line = reader.readLine()) != null) {
                    if (line == null || line.trim().length() <= 0 || line.trim().startsWith("#")) continue;
                    String[] keyValuePair = line.split("=");
                    if (keyValuePair.length == 2) {
                        properties.put(keyValuePair[0].trim(), keyValuePair[1].trim());
                        continue;
                    }
                    properties.put(keyValuePair[0].trim(), "");
                }
            }
            reader.close();
            return properties;
        }
        catch (FileNotFoundException fnfe) {
            throw new JobApplicationException((ErrorCode)JobErrorCode.FILE_NOT_FOUND_ERR, variablesFile.getPath());
        }
        catch (IOException ioe) {
            throw new JobApplicationException((ErrorCode)JobErrorCode.UNABLE_TO_READ_FILE_ERR, variablesFile.getPath());
        }
    }

    public static void main(String[] args) {
        if (args != null) {
            JobApplication.getInstance().startup(new ArrayList<String>(Arrays.asList(args)));
        }
    }

    static {
        logger = Logger.getLogger(JobApplication.class.getName());
    }
}

